/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.bytes.MethodReaderInterceptor;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.Annotations;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.FieldNumberParselet;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.MethodFilterOnFirstArg;
import net.openhft.chronicle.wire.MethodWireKey;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireParselet;
import net.openhft.chronicle.wire.WireParser;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaMethodReader
implements MethodReader {
    static final Object[] NO_ARGS = new Object[0];
    static final Logger LOGGER = LoggerFactory.getLogger(VanillaMethodReader.class);
    static final Object IGNORED = new Object();
    private static final String[] metaIgnoreList = new String[]{"header", "index", "index2index", "roll"};
    private final MarshallableIn in;
    @NotNull
    private final WireParser wireParser;
    private final MessageHistory messageHistory = MessageHistory.get();
    private boolean closeIn = false;
    private boolean closed;
    private MethodReaderInterceptor methodReaderInterceptor;

    public VanillaMethodReader(MarshallableIn in, boolean ignoreDefault, WireParselet defaultParselet, MethodReaderInterceptor methodReaderInterceptor, Object ... objects) {
        this(in, ignoreDefault, defaultParselet, VanillaWireParser.SKIP_READABLE_BYTES, methodReaderInterceptor, objects);
    }

    public VanillaMethodReader(MarshallableIn in, boolean ignoreDefault, WireParselet defaultParselet, FieldNumberParselet fieldNumberParselet, MethodReaderInterceptor methodReaderInterceptor, Object ... objects) {
        this.in = in;
        this.methodReaderInterceptor = methodReaderInterceptor;
        if (objects[0] instanceof WireParselet) {
            defaultParselet = (WireParselet)objects[0];
        }
        this.wireParser = WireParser.wireParser(defaultParselet, fieldNumberParselet);
        HashSet<String> methodsHandled = new HashSet<String>();
        MethodFilterOnFirstArg methodFilterOnFirstArg = null;
        for (Object o : objects) {
            if (o instanceof MethodFilterOnFirstArg) {
                if (methodFilterOnFirstArg != null) {
                    Jvm.warn().on(this.getClass(), "Multiple filters on first arg not supported, only the first one is applied.");
                } else {
                    methodFilterOnFirstArg = (MethodFilterOnFirstArg)o;
                }
            }
            block7: for (Method m3 : o.getClass().getMethods()) {
                if (Modifier.isStatic(m3.getModifiers()) || ignoreDefault && m3.getDeclaringClass().isInterface() || "ignoreMethodBasedOnFirstArg".equals(m3.getName())) continue;
                try {
                    Object.class.getMethod(m3.getName(), m3.getParameterTypes());
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!methodsHandled.add(m3.getName())) {
                        Jvm.warn().on(this.getClass(), "Unable to support overloaded methods, ignoring one of " + m3.getName());
                        continue;
                    }
                    Class[] parameterTypes = m3.getParameterTypes();
                    switch (parameterTypes.length) {
                        case 0: {
                            this.addParseletForMethod(o, m3);
                            continue block7;
                        }
                        case 1: {
                            this.addParseletForMethod(o, m3, parameterTypes[0]);
                            continue block7;
                        }
                        default: {
                            if (methodFilterOnFirstArg == null) {
                                this.addParseletForMethod(o, m3, parameterTypes);
                                continue block7;
                            }
                            this.addParseletForMethod(o, m3, parameterTypes, methodFilterOnFirstArg);
                        }
                    }
                }
            }
        }
        if (this.wireParser.lookup("history") == null) {
            this.wireParser.registerOnce(() -> "history", (s2, v) -> v.marshallable(this.messageHistory));
        }
    }

    private static Object actualInvoke(Method method, Object o, Object[] objects) throws InvocationTargetException {
        try {
            return method.invoke(o, objects);
        }
        catch (IllegalAccessException iae) {
            throw Jvm.rethrow(iae);
        }
    }

    private static void invokeMethodWithOneLong(Object o, @NotNull Method m3, String name, MethodHandle mh, Object[] argArr, CharSequence s2, ValueIn v, MethodReaderInterceptor methodReaderInterceptor) {
        block7: {
            try {
                if (Jvm.isDebug()) {
                    VanillaMethodReader.logMessage(s2, v);
                }
                long arg = v.int64();
                try {
                    if (methodReaderInterceptor != null) {
                        argArr[0] = arg;
                        methodReaderInterceptor.intercept(m3, o, argArr, VanillaMethodReader::actualInvoke);
                        break block7;
                    }
                    mh.invokeExact(arg);
                }
                catch (Throwable e) {
                    Throwable cause = e.getCause();
                    String msg = "Failure to dispatch message: " + m3.getName() + " " + Arrays.asList(argArr);
                    if (cause instanceof IllegalArgumentException) {
                        Jvm.warn().on(o.getClass(), msg + " " + cause);
                        break block7;
                    }
                    Jvm.warn().on(o.getClass(), msg, cause);
                }
            }
            catch (Exception i) {
                Jvm.warn().on(o.getClass(), "Failure to dispatch message: " + name + " " + argArr[0], i);
            }
        }
    }

    static void logMessage(@NotNull CharSequence s2, @NotNull ValueIn v) {
        String rest;
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        String name = s2.toString();
        if (v.wireIn() instanceof BinaryWire) {
            Bytes<ByteBuffer> bytes = Bytes.elasticByteBuffer((int)(v.wireIn().bytes().readRemaining() * 3L / 2L + 64L));
            long pos = v.wireIn().bytes().readPosition();
            v.wireIn().copyTo(new TextWire(bytes));
            v.wireIn().bytes().readPosition(pos);
            rest = bytes.toString();
            bytes.release();
        } else {
            rest = v.toString();
        }
        if (rest.endsWith("\n")) {
            rest = rest.substring(0, rest.length() - 1);
        }
        LOGGER.debug("read " + name + " - " + rest);
    }

    @Override
    @NotNull
    public VanillaMethodReader closeIn(boolean closeIn) {
        this.closeIn = closeIn;
        return this;
    }

    public void addParseletForMethod(Object o, @NotNull Method m3, Class<?> parameterType) {
        Jvm.setAccessible(m3);
        String name = m3.getName();
        if (parameterType == Long.TYPE) {
            try {
                MethodHandle mh = MethodHandles.lookup().unreflect(m3).bindTo(o);
                Object[] argArr = new Object[]{null};
                MethodWireKey key = this.createWireKey(m3, name);
                this.wireParser.registerOnce(key, (s2, v) -> VanillaMethodReader.invokeMethodWithOneLong(o, m3, name, mh, argArr, s2, v, this.methodReaderInterceptor));
            }
            catch (IllegalAccessException e) {
                Jvm.warn().on(o.getClass(), "Unable to unreflect " + m3, e);
            }
        } else if (parameterType.isInterface() || !ReadMarshallable.class.isAssignableFrom(parameterType)) {
            Object[] argArr = new Object[]{null};
            MethodWireKey key = this.createWireKey(m3, name);
            this.wireParser.registerOnce(key, (s2, v) -> {
                try {
                    if (Jvm.isDebug()) {
                        VanillaMethodReader.logMessage(s2, v);
                    }
                    argArr[0] = v.object(this.checkRecycle(argArr[0]), parameterType);
                    this.invoke(o, m3, argArr);
                }
                catch (Exception i) {
                    Jvm.warn().on(o.getClass(), "Failure to dispatch message: " + name + " " + argArr[0], i);
                }
            });
        } else {
            ReadMarshallable arg;
            try {
                Constructor<?> constructor = parameterType.getDeclaredConstructor(new Class[0]);
                Jvm.setAccessible(constructor);
                arg = (ReadMarshallable)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                try {
                    arg = (ReadMarshallable)OS.memory().allocateInstance(parameterType);
                }
                catch (InstantiationException e1) {
                    throw Jvm.rethrow(e1);
                }
            }
            ReadMarshallable[] argArr = new ReadMarshallable[]{arg};
            MethodWireKey key = this.createWireKey(m3, name);
            this.wireParser.registerOnce(key, (s2, v) -> {
                try {
                    if (Jvm.isDebug()) {
                        VanillaMethodReader.logMessage(s2, v);
                    }
                    argArr[0] = v.object(this.checkRecycle(argArr[0]), parameterType);
                    this.invoke(o, m3, argArr);
                }
                catch (Throwable t) {
                    Jvm.warn().on(o.getClass(), "Failure to dispatch message: " + name + " " + argArr[0], t);
                }
            });
        }
    }

    public void addParseletForMethod(Object o, @NotNull Method m3) {
        Jvm.setAccessible(m3);
        String name = m3.getName();
        MethodWireKey key = this.createWireKey(m3, name);
        this.wireParser.registerOnce(key, (s2, v) -> {
            try {
                if (Jvm.isDebug()) {
                    VanillaMethodReader.logMessage(s2, v);
                }
                v.skipValue();
                this.invoke(o, m3, NO_ARGS);
            }
            catch (Exception i) {
                Jvm.warn().on(o.getClass(), "Failure to dispatch message: " + name + "()", i);
            }
        });
    }

    @NotNull
    private MethodWireKey createWireKey(@NotNull Method m3, String name) {
        MethodId annotation = Annotations.getAnnotation(m3, MethodId.class);
        return new MethodWireKey(name, annotation == null ? name.hashCode() : Maths.toInt32(annotation.value()));
    }

    public void addParseletForMethod(Object o, @NotNull Method m3, @NotNull Class[] parameterTypes) {
        Jvm.setAccessible(m3);
        Object[] args = new Object[parameterTypes.length];
        BiConsumer<Object[], ValueIn> sequenceReader = (a, v) -> {
            int i = 0;
            for (Class clazz : parameterTypes) {
                a[i] = v.object(this.checkRecycle(a[i]), clazz);
                ++i;
            }
        };
        String name = m3.getName();
        MethodWireKey key = this.createWireKey(m3, name);
        this.wireParser.registerOnce(key, (s2, v) -> {
            try {
                if (Jvm.isDebug()) {
                    VanillaMethodReader.logMessage(s2, v);
                }
                v.sequence(args, sequenceReader);
                this.invoke(o, m3, args);
            }
            catch (Exception i) {
                Jvm.warn().on(o.getClass(), "Failure to dispatch message: " + name + " " + Arrays.toString(args), i);
            }
        });
    }

    private <T> T checkRecycle(T o) {
        if (o instanceof Collection) {
            ((Collection)o).clear();
            return o;
        }
        return (T)(o instanceof Marshallable ? o : null);
    }

    public void addParseletForMethod(Object o, @NotNull Method m3, @NotNull Class[] parameterTypes, MethodFilterOnFirstArg methodFilterOnFirstArg) {
        Jvm.setAccessible(m3);
        Object[] args = new Object[parameterTypes.length];
        BiConsumer<Object[], ValueIn> sequenceReader = (a, v) -> {
            int i = 0;
            boolean ignored = false;
            for (Class clazz : parameterTypes) {
                if (ignored) {
                    v.skipValue();
                } else {
                    a[i] = v.object(this.checkRecycle(a[i]), clazz);
                }
                if (i == 0 && methodFilterOnFirstArg.ignoreMethodBasedOnFirstArg(m3.getName(), a[0])) {
                    a[0] = IGNORED;
                    ignored = true;
                }
                ++i;
            }
        };
        String name = m3.getName();
        MethodWireKey key = this.createWireKey(m3, name);
        this.wireParser.registerOnce(key, (s2, v) -> {
            try {
                if (Jvm.isDebug()) {
                    VanillaMethodReader.logMessage(s2, v);
                }
                v.sequence(args, sequenceReader);
                if (args[0] == IGNORED) {
                    args[0] = null;
                    return;
                }
                this.invoke(o, m3, args);
            }
            catch (Exception i) {
                Jvm.warn().on(o.getClass(), "Failure to dispatch message: " + name + " " + Arrays.toString(args), i);
            }
        });
    }

    private void invoke(Object o, @NotNull Method m3, Object[] args) throws IllegalAccessException {
        try {
            if (this.methodReaderInterceptor != null) {
                this.methodReaderInterceptor.intercept(m3, o, args, VanillaMethodReader::actualInvoke);
            } else {
                m3.invoke(o, args);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Throwable cause = e.getCause();
            String msg = "Failure to dispatch message: " + m3.getName() + " " + Arrays.asList(args);
            if (cause instanceof IllegalArgumentException) {
                Jvm.warn().on(o.getClass(), msg + " " + cause);
            }
            Jvm.warn().on(o.getClass(), msg, cause);
        }
    }

    @Override
    public boolean readOne() {
        try (DocumentContext context = this.in.readingDocument();){
            if (context.isData()) {
                this.messageHistory.reset(context.sourceId(), context.index());
                this.wireParser.accept(context.wire());
                boolean bl = true;
                return bl;
            }
            if (context.isPresent() && this.readOneMetaData(context)) {
                boolean bl = true;
                return bl;
            }
        }
        return this.readOneLoop();
    }

    private boolean readOneLoop() {
        while (true) {
            DocumentContext context = this.in.readingDocument();
            Throwable throwable = null;
            try {
                if (!context.isPresent()) {
                    boolean bl = false;
                    return bl;
                }
                if (context.isMetaData()) {
                    if (!this.readOneMetaData(context)) continue;
                    boolean bl = true;
                    return bl;
                }
                assert (context.isData());
                this.messageHistory.reset(context.sourceId(), context.index());
                this.wireParser.accept(context.wire());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (context == null) continue;
                if (throwable != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                context.close();
                continue;
            }
            break;
        }
        return true;
    }

    @Override
    public boolean lazyReadOne() {
        if (!this.in.peekDocument()) {
            return false;
        }
        return this.lazyReadOne0();
    }

    private boolean lazyReadOne0() {
        try (DocumentContext context = this.in.readingDocument();){
            if (!context.isPresent()) {
                boolean bl = false;
                return bl;
            }
            if (context.isMetaData()) {
                this.readOneMetaData(context);
                boolean bl = true;
                return bl;
            }
            assert (context.isData());
            this.messageHistory.reset(context.sourceId(), context.index());
            this.wireParser.accept(context.wire());
        }
        return true;
    }

    private boolean readOneMetaData(DocumentContext context) {
        StringBuilder sb = Wires.acquireStringBuilder();
        Wire wire = context.wire();
        Bytes<?> bytes = wire.bytes();
        long r = bytes.readPosition();
        wire.readEventName(sb);
        for (String s2 : metaIgnoreList) {
            if (!s2.contentEquals(sb)) continue;
            return false;
        }
        bytes.readPosition(r);
        this.wireParser.accept(wire);
        return true;
    }

    @Override
    public void close() {
        if (this.closeIn) {
            Closeable.closeQuietly((Object)this.in);
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public MethodReaderInterceptor methodReaderInterceptor() {
        return this.methodReaderInterceptor;
    }
}

