/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2SectionBitMap;
import ucar.nc2.grib.grib2.Grib2SectionData;
import ucar.nc2.grib.grib2.Grib2SectionDataRepresentation;
import ucar.nc2.grib.grib2.Grib2SectionGridDefinition;
import ucar.nc2.grib.grib2.Grib2SectionIdentification;
import ucar.nc2.grib.grib2.Grib2SectionIndicator;
import ucar.nc2.grib.grib2.Grib2SectionLocalUse;
import ucar.nc2.grib.grib2.Grib2SectionProductDefinition;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class Grib2RecordScanner {
    private static final Logger logger = LoggerFactory.getLogger(Grib2RecordScanner.class);
    private static final KMPMatch matcher = new KMPMatch(new byte[]{71, 82, 73, 66});
    private static final boolean debug = false;
    private static final boolean debugRepeat = false;
    private static final boolean debugEnding = false;
    private static final int maxScan = 16000;
    private final Map<Long, Grib2SectionGridDefinition> gdsMap = new HashMap<Long, Grib2SectionGridDefinition>();
    private final RandomAccessFile raf;
    private byte[] header;
    private int badEndings = 0;
    private long lastPos;
    private long repeatPos = -1L;
    private Grib2Record repeatRecord = null;
    private Grib2SectionBitMap repeatBms = null;

    public static boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.seek(0L);
            boolean found = raf.searchForward(matcher, 16000);
            if (!found) {
                return false;
            }
            raf.skipBytes(7);
            int edition = raf.read();
            if (edition != 2) {
                return false;
            }
            long len = GribNumbers.int8(raf);
            if (len > raf.length()) {
                return false;
            }
            raf.skipBytes(len - 20L);
            for (int i = 0; i < 4; ++i) {
                if (raf.read() == 55) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Nullable
    public static Grib2Record findRecordByDrspos(RandomAccessFile raf, long drsPos) throws IOException {
        long pos = Math.max(0L, drsPos - 20000L);
        Grib2RecordScanner scan = new Grib2RecordScanner(raf, pos);
        while (scan.hasNext()) {
            Grib2Record gr = scan.next();
            Grib2SectionDataRepresentation drs = gr.getDataRepresentationSection();
            if (drsPos == drs.getStartingPosition()) {
                return gr;
            }
            if (raf.getFilePointer() <= drsPos) continue;
            break;
        }
        return null;
    }

    public Grib2RecordScanner(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        raf.seek(0L);
        raf.order(0);
        this.lastPos = 0L;
    }

    private Grib2RecordScanner(RandomAccessFile raf, long startFrom) throws IOException {
        this.raf = raf;
        raf.seek(startFrom);
        raf.order(0);
        this.lastPos = startFrom;
    }

    public boolean hasNext() throws IOException {
        boolean more;
        if (this.lastPos >= this.raf.length()) {
            return false;
        }
        if (this.repeatPos > 0L) {
            if (this.nextRepeating()) {
                return true;
            }
        } else {
            this.repeatRecord = null;
            this.repeatBms = null;
        }
        long gribStart = 0L;
        while (true) {
            this.raf.seek(this.lastPos);
            more = this.raf.searchForward(matcher, -1);
            if (!more) break;
            gribStart = this.raf.getFilePointer();
            this.raf.skipBytes(7);
            int edition = this.raf.read();
            if (edition == 2) break;
            this.lastPos = this.raf.getFilePointer();
            logger.warn("GRIB message at pos=" + gribStart + " not GRIB2; skip");
        }
        if (more) {
            int sizeHeader = (int)(gribStart - this.lastPos);
            if (sizeHeader > 100) {
                sizeHeader = 100;
            }
            long goBack = gribStart - (long)sizeHeader;
            this.header = new byte[sizeHeader];
            this.raf.seek(goBack);
            this.raf.readFully(this.header);
            this.raf.seek(gribStart);
            this.lastPos = gribStart;
        }
        return more;
    }

    public Grib2Record next() throws IOException {
        block11: {
            if (this.repeatRecord != null) {
                return new Grib2Record(this.repeatRecord);
            }
            Grib2SectionIndicator is = null;
            try {
                is = new Grib2SectionIndicator(this.raf);
                Grib2SectionIdentification ids = new Grib2SectionIdentification(this.raf);
                Grib2SectionLocalUse lus = new Grib2SectionLocalUse(this.raf);
                Grib2SectionGridDefinition gds = new Grib2SectionGridDefinition(this.raf);
                Grib2SectionProductDefinition pds = new Grib2SectionProductDefinition(this.raf);
                Grib2SectionDataRepresentation drs = new Grib2SectionDataRepresentation(this.raf);
                Grib2SectionBitMap bms = new Grib2SectionBitMap(this.raf);
                Grib2SectionData dataSection = new Grib2SectionData(this.raf);
                if ((long)dataSection.getMsgLength() > is.getMessageLength()) {
                    throw new IllegalStateException("Illegal Grib2SectionData Message Length");
                }
                long crc = gds.calcCRC();
                Grib2SectionGridDefinition gdsCached = this.gdsMap.get(crc);
                if (gdsCached != null) {
                    gds = gdsCached;
                } else {
                    this.gdsMap.put(crc, gds);
                }
                long pos = this.raf.getFilePointer();
                long ending = is.getEndPos();
                if (pos + 34L < ending) {
                    this.repeatPos = pos;
                    this.repeatRecord = new Grib2Record(this.header, is, ids, lus, gds, pds, drs, bms, dataSection, false, 9999);
                    if (bms.getBitMapIndicator() == 0) {
                        this.repeatBms = bms;
                    }
                    return new Grib2Record(this.repeatRecord);
                }
                boolean foundEnding = true;
                this.raf.seek(ending - 4L);
                for (int i = 0; i < 4; ++i) {
                    if (this.raf.read() == 55) continue;
                    foundEnding = false;
                    ++this.badEndings;
                    logger.warn("Missing End of GRIB message {} starting at pos={} is.ending={} data.ending={} file={}", this.badEndings, is.getStartPos(), ending, dataSection.getEndingPosition(), this.raf.getLocation());
                    break;
                }
                if (foundEnding) {
                    this.lastPos = this.raf.getFilePointer();
                    return new Grib2Record(this.header, is, ids, lus, gds, pds, drs, bms, dataSection, false, 9999);
                }
                this.lastPos += 20L;
                if (this.hasNext()) {
                    return this.next();
                }
            }
            catch (Throwable t) {
                long pos = is == null ? -1L : is.getStartPos();
                logger.warn("Bad GRIB2 record in file {}, skipping pos={} cause={}", this.raf.getLocation(), pos, t.getMessage());
                this.lastPos += 20L;
                if (!this.hasNext()) break block11;
                return this.next();
            }
        }
        throw new IOException("last record was incomplete");
    }

    private boolean nextRepeating() throws IOException {
        long ending;
        long pos;
        this.raf.seek(this.repeatPos);
        GribNumbers.int4(this.raf);
        int section = this.raf.read();
        this.raf.seek(this.repeatPos);
        if (section == 2) {
            this.repeatRecord.setLus(new Grib2SectionLocalUse(this.raf));
            this.repeatRecord.setGdss(new Grib2SectionGridDefinition(this.raf));
            this.repeatRecord.setPdss(new Grib2SectionProductDefinition(this.raf));
            this.repeatRecord.setDrs(new Grib2SectionDataRepresentation(this.raf));
            this.repeatRecord.setBms(new Grib2SectionBitMap(this.raf), false);
            this.repeatRecord.setDataSection(new Grib2SectionData(this.raf));
            this.repeatRecord.repeat = section;
        } else if (section == 3) {
            this.repeatRecord.setGdss(new Grib2SectionGridDefinition(this.raf));
            this.repeatRecord.setPdss(new Grib2SectionProductDefinition(this.raf));
            this.repeatRecord.setDrs(new Grib2SectionDataRepresentation(this.raf));
            this.repeatRecord.setBms(new Grib2SectionBitMap(this.raf), false);
            this.repeatRecord.setDataSection(new Grib2SectionData(this.raf));
            this.repeatRecord.repeat = section;
        } else if (section == 4) {
            this.repeatRecord.setPdss(new Grib2SectionProductDefinition(this.raf));
            this.repeatRecord.setDrs(new Grib2SectionDataRepresentation(this.raf));
            this.repeatRecord.setBms(new Grib2SectionBitMap(this.raf), false);
            this.repeatRecord.setDataSection(new Grib2SectionData(this.raf));
            this.repeatRecord.repeat = section;
        } else {
            this.lastPos = this.repeatPos;
            this.repeatPos = -1L;
            this.repeatRecord = null;
            this.repeatBms = null;
            return false;
        }
        Grib2SectionBitMap bms = this.repeatRecord.getBitmapSection();
        if (bms.getBitMapIndicator() == 254) {
            if (this.repeatBms == null) {
                throw new IllegalStateException("No bms in repeating section");
            }
            this.repeatRecord.setBms(this.repeatBms, true);
            this.repeatRecord.repeat += 1000;
        } else if (bms.getBitMapIndicator() == 0) {
            this.repeatBms = this.repeatRecord.getBitmapSection();
        }
        if (section == 2 || section == 3) {
            Grib2SectionGridDefinition gds = this.repeatRecord.getGDSsection();
            long crc = gds.calcCRC();
            Grib2SectionGridDefinition gdsCached = this.gdsMap.get(crc);
            if (gdsCached != null) {
                this.repeatRecord.setGdss(gdsCached);
            } else {
                this.gdsMap.put(crc, gds);
            }
        }
        if ((pos = this.raf.getFilePointer()) + 34L < (ending = this.repeatRecord.getIs().getEndPos())) {
            this.repeatPos = pos;
            return true;
        }
        this.raf.seek(ending - 4L);
        for (int i = 0; i < 4; ++i) {
            if (this.raf.read() == 55) continue;
            String clean = StringUtil2.cleanup(this.header);
            if (clean.length() > 40) {
                clean = clean.substring(0, 40) + "...";
            }
            logger.warn("  REPEAT Missing End of GRIB message at pos=" + ending + " header= " + clean + " for=" + this.raf.getLocation());
            break;
        }
        this.lastPos = this.raf.getFilePointer();
        this.repeatPos = -1L;
        return true;
    }

    public static void main(String[] args) throws IOException {
        int count = 0;
        String file = args.length > 0 ? args[0] : "Q:/cdmUnitTest/formats/grib2/LMPEF_CLM_050518_1200.grb";
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        System.out.printf("Read %s%n", raf.getLocation());
        Grib2RecordScanner scan = new Grib2RecordScanner(raf);
        while (scan.hasNext()) {
            scan.next();
            ++count;
        }
        raf.close();
        System.out.printf("count=%d%n", count);
    }
}

