/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.ByteStringAppender;
import net.openhft.chronicle.bytes.ByteStringParser;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesPrepender;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.RandomDataOutput;
import net.openhft.chronicle.bytes.StopCharTester;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.pool.BytesPool;
import net.openhft.chronicle.bytes.util.StringInternerBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.UnsafeText;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.EnumInterner;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.util.ByteBuffers;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BytesInternal
extends Enum<BytesInternal> {
    static final char[] HEXADECIMAL;
    static final ThreadLocal<ByteBuffer> BYTE_BUFFER_TL;
    static final ThreadLocal<ByteBuffer> BYTE_BUFFER2_TL;
    private static final byte[] MIN_VALUE_TEXT;
    private static final StringBuilderPool SBP;
    private static final BytesPool BP;
    private static final StringInternerBytes SI;
    private static final byte[] Infinity;
    private static final byte[] NaN;
    private static final long MAX_VALUE_DIVIDE_5 = 0x1999999999999999L;
    private static final ThreadLocal<byte[]> NUMBER_BUFFER;
    private static final long MAX_VALUE_DIVIDE_10 = 0xCCCCCCCCCCCCCCCL;
    private static final ThreadLocal<DateCache> dateCacheTL;
    private static final int MAX_STRING_LEN;
    private static final /* synthetic */ BytesInternal[] $VALUES;

    public static BytesInternal[] values() {
        return (BytesInternal[])$VALUES.clone();
    }

    public static BytesInternal valueOf(String name) {
        return Enum.valueOf(BytesInternal.class, name);
    }

    public static boolean contentEqual(@Nullable BytesStore a, @Nullable BytesStore b) {
        long i;
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.readRemaining() != b.readRemaining()) {
            return false;
        }
        long aPos = a.readPosition();
        long bPos = b.readPosition();
        long length = a.readRemaining();
        for (i = 0L; i < length - 7L; i += 8L) {
            if (a.readLong(aPos + i) == b.readLong(bPos + i)) continue;
            return false;
        }
        while (i < length) {
            if (a.readByte(aPos + i) != b.readByte(bPos + i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean startsWith(@NotNull BytesStore a, @NotNull BytesStore b) {
        long i;
        if (a.readRemaining() < b.readRemaining()) {
            return false;
        }
        long aPos = a.readPosition();
        long bPos = b.readPosition();
        long length = b.readRemaining();
        for (i = 0L; i < length - 7L; i += 8L) {
            if (a.readLong(aPos + i) == b.readLong(bPos + i)) continue;
            return false;
        }
        if (i < length - 3L) {
            if (a.readInt(aPos + i) != b.readInt(bPos + i)) {
                return false;
            }
            i += 4L;
        }
        if (i < length - 1L) {
            if (a.readShort(aPos + i) != b.readShort(bPos + i)) {
                return false;
            }
            i += 2L;
        }
        if (i < length) {
            return a.readByte(aPos + i) == b.readByte(bPos + i);
        }
        return true;
    }

    public static void parseUtf8(@NotNull StreamingDataInput bytes, Appendable appendable, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        if (appendable instanceof StringBuilder && bytes.isDirectMemory() && utflen < 0x100000) {
            BytesInternal.parseUtf8_SB1((Bytes)bytes, (StringBuilder)appendable, utflen);
        } else {
            BytesInternal.parseUtf81(bytes, appendable, utflen);
        }
    }

    public static void parseUtf8(@NotNull RandomDataInput input, long offset, Appendable appendable, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        if (appendable instanceof StringBuilder) {
            if (input instanceof NativeBytesStore) {
                BytesInternal.parseUtf8_SB1((NativeBytesStore)input, offset, (StringBuilder)appendable, utflen);
                return;
            }
            if (input instanceof Bytes && ((Bytes)input).bytesStore() instanceof NativeBytesStore) {
                NativeBytesStore bs = (NativeBytesStore)((Bytes)input).bytesStore();
                BytesInternal.parseUtf8_SB1(bs, offset, (StringBuilder)appendable, utflen);
                return;
            }
        }
        BytesInternal.parseUtf81(input, offset, appendable, utflen);
    }

    public static boolean compareUtf8(@NotNull RandomDataInput input, long offset, @Nullable CharSequence other) throws IORuntimeException, BufferUnderflowException, IndexOutOfBoundsException {
        long utfLen;
        if ((utfLen = (long)input.readByte(offset++)) < 0L) {
            long b;
            utfLen &= 0x7FL;
            int count = 7;
            while ((b = (long)input.readByte(offset++)) < 0L) {
                utfLen |= (b & 0x7FL) << count;
                count += 7;
            }
            if (b != 0L) {
                if (count > 56) {
                    throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
                }
                utfLen |= b << count;
            } else {
                if (count > 63) {
                    throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
                }
                utfLen ^= 0xFFFFFFFFFFFFFFFFL;
            }
        }
        if (utfLen == -1L) {
            return other == null;
        }
        return other != null && BytesInternal.compareUtf8(input, offset, utfLen, other);
    }

    private static boolean compareUtf8(@NotNull RandomDataInput input, long offset, long utfLen, @NotNull CharSequence other) throws UTFDataFormatRuntimeException, BufferUnderflowException, IndexOutOfBoundsException {
        byte c;
        int i;
        if (offset + utfLen > input.realCapacity()) {
            throw new BufferUnderflowException();
        }
        for (i = 0; (long)i < utfLen && i < other.length() && (c = input.readByte(offset + (long)i)) >= 0; ++i) {
            if ((char)c == other.charAt(i)) continue;
            return false;
        }
        if ((long)i < utfLen && i < other.length()) {
            return BytesInternal.compareUtf82(input, offset + (long)i, i, utfLen, other);
        }
        return utfLen == (long)other.length();
    }

    private static boolean compareUtf82(@NotNull RandomDataInput input, long offset, int charI, long utfLen, @NotNull CharSequence other) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        long limit = offset + utfLen;
        while (offset < limit && charI < other.length()) {
            int c = input.readUnsignedByte(offset++);
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if ((char)c == other.charAt(charI)) break;
                    return false;
                }
                case 12: 
                case 13: {
                    int char2;
                    if (offset == limit) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    if (((char2 = input.readUnsignedByte(offset++)) & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + (offset - limit + utfLen) + " was " + char2);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if ((char)c2 == other.charAt(charI)) break;
                    return false;
                }
                case 14: {
                    if (offset + 2L > limit) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    int char2 = input.readUnsignedByte(offset++);
                    int char3 = input.readUnsignedByte(offset++);
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + (offset - limit + utfLen - 1L) + " was " + char2 + " " + char3);
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if ((char)c3 == other.charAt(charI)) break;
                    return false;
                }
                default: {
                    throw new UTFDataFormatRuntimeException("malformed input around byte " + (offset - limit + utfLen));
                }
            }
            ++charI;
        }
        return offset == limit && charI == other.length();
    }

    public static void parse8bit(long offset, @NotNull RandomDataInput bytesStore, Appendable appendable, int utflen) throws BufferUnderflowException, IOException {
        if (bytesStore instanceof NativeBytesStore && appendable instanceof StringBuilder) {
            BytesInternal.parse8bit_SB1(offset, (NativeBytesStore)bytesStore, (StringBuilder)appendable, utflen);
        } else {
            BytesInternal.parse8bit1(offset, bytesStore, appendable, utflen);
        }
    }

    public static void parseUtf81(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        try {
            int count;
            assert (bytes.readRemaining() >= (long)utflen);
            for (count = 0; count < utflen; ++count) {
                int c = bytes.readUnsignedByte();
                if (c >= 128) {
                    bytes.readSkip(-1L);
                    break;
                }
                if (c < 0) break;
                appendable.append((char)c);
            }
            if (utflen > count) {
                BytesInternal.parseUtf82(bytes, appendable, utflen, count);
            }
        }
        catch (IOException e) {
            throw Jvm.rethrow(e);
        }
    }

    public static void parseUtf81(@NotNull RandomDataInput input, long offset, @NotNull Appendable appendable, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        try {
            assert (input.realCapacity() >= offset + (long)utflen);
            long limit = offset + (long)utflen;
            while (offset < limit) {
                int c;
                if ((c = input.readUnsignedByte(offset++)) >= 128) {
                    --offset;
                    break;
                }
                if (c < 0) break;
                appendable.append((char)c);
            }
            if (limit > offset) {
                BytesInternal.parseUtf82(input, offset, limit, appendable, utflen);
            }
        }
        catch (IOException e) {
            throw Jvm.rethrow(e);
        }
    }

    public static void parse8bit1(@NotNull StreamingDataInput bytes, @NotNull StringBuilder sb, int utflen) {
        assert (bytes.readRemaining() >= (long)utflen);
        sb.ensureCapacity(utflen);
        if (Jvm.isJava9Plus()) {
            byte[] sbBytes = StringUtils.extractBytes(sb);
            for (int count = 0; count < utflen; ++count) {
                int c = bytes.readUnsignedByte();
                sbBytes[count] = (byte)c;
            }
        } else {
            char[] chars = StringUtils.extractChars(sb);
            for (int count = 0; count < utflen; ++count) {
                int c = bytes.readUnsignedByte();
                chars[count] = (char)c;
            }
        }
        StringUtils.setLength(sb, utflen);
    }

    public static void parse8bit1(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, int utflen) throws IOException {
        assert (bytes.readRemaining() >= (long)utflen);
        for (int count = 0; count < utflen; ++count) {
            int c = bytes.readUnsignedByte();
            appendable.append((char)c);
        }
    }

    public static void parse8bit1(long offset, @NotNull RandomDataInput bytes, @NotNull Appendable appendable, int utflen) throws BufferUnderflowException, IOException {
        assert (bytes.realCapacity() >= (long)utflen + offset);
        for (int count = 0; count < utflen; ++count) {
            int c = bytes.readUnsignedByte(offset + (long)count);
            appendable.append((char)c);
        }
    }

    public static void parseUtf8_SB1(@NotNull Bytes bytes, @NotNull StringBuilder sb, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        block9: {
            try {
                int count = 0;
                if ((long)utflen > bytes.readRemaining()) {
                    BufferUnderflowException bue = new BufferUnderflowException();
                    bue.initCause(new IllegalStateException("utflen: " + utflen + ", readRemaining: " + bytes.readRemaining()));
                    throw bue;
                }
                long readPosition = bytes.readPosition();
                sb.ensureCapacity(utflen);
                if (Jvm.isJava9Plus()) {
                    byte c;
                    sb.setLength(utflen);
                    while (count < utflen && (c = bytes.readByte(readPosition + (long)count)) >= 0) {
                        sb.setCharAt(count++, (char)c);
                    }
                } else {
                    byte c;
                    char[] chars = StringUtils.extractChars(sb);
                    while (count < utflen && (c = bytes.readByte(readPosition + (long)count)) >= 0) {
                        chars[count++] = (char)c;
                    }
                }
                bytes.readSkip(count);
                StringUtils.setCount(sb, count);
                if (count >= utflen) break block9;
                long rp0 = bytes.readPosition();
                try {
                    BytesInternal.parseUtf82(bytes, sb, utflen, count);
                }
                catch (UTFDataFormatRuntimeException e) {
                    long rp = Math.max(rp0 - 128L, 0L);
                    throw new UTFDataFormatRuntimeException(Long.toHexString(rp0) + "\n" + bytes.toHexString(rp, 200L));
                }
            }
            catch (IOException e) {
                throw Jvm.rethrow(e);
            }
        }
    }

    public static void parseUtf8_SB1(@NotNull NativeBytesStore bytes, long offset, @NotNull StringBuilder sb, int utflen) throws UTFDataFormatRuntimeException, BufferUnderflowException {
        try {
            if (offset + (long)utflen > bytes.realCapacity()) {
                throw new BufferUnderflowException();
            }
            long address = bytes.address + bytes.translate(offset);
            Memory memory = bytes.memory;
            sb.ensureCapacity(utflen);
            int count = 0;
            if (Jvm.isJava9Plus()) {
                byte c;
                sb.setLength(utflen);
                while (count < utflen && (c = memory.readByte(address + (long)count)) >= 0) {
                    sb.setCharAt(count++, (char)c);
                }
            } else {
                byte c;
                char[] chars = StringUtils.extractChars(sb);
                while (count < utflen && (c = memory.readByte(address + (long)count)) >= 0) {
                    chars[count++] = (char)c;
                }
            }
            StringUtils.setCount(sb, count);
            if (count < utflen) {
                BytesInternal.parseUtf82(bytes, offset + (long)count, offset + (long)utflen, sb, utflen);
            }
            assert (bytes.memory != null);
        }
        catch (IOException e) {
            throw Jvm.rethrow(e);
        }
    }

    public static int parse8bit_SB1(long offset, @NotNull NativeBytesStore nbs, @NotNull StringBuilder sb, int utflen) {
        long address = nbs.address + nbs.translate(offset);
        Memory memory = nbs.memory;
        sb.ensureCapacity(utflen);
        int count = 0;
        if (Jvm.isJava9Plus()) {
            byte coder = StringUtils.getStringCoder(sb);
            if (coder == 0) {
                byte[] bytes = StringUtils.extractBytes(sb);
                while (count < utflen) {
                    byte b = memory.readByte(address + (long)count);
                    bytes[count++] = b;
                }
            } else {
                assert (coder == 1);
                sb.setLength(utflen);
                while (count < utflen) {
                    byte b = memory.readByte(address + (long)count);
                    sb.setCharAt(count++, (char)b);
                }
            }
        } else {
            char[] chars = StringUtils.extractChars(sb);
            while (count < utflen) {
                int c = memory.readByte(address + (long)count) & 0xFF;
                chars[count++] = (char)c;
            }
        }
        StringUtils.setCount(sb, count);
        return count;
    }

    static void parseUtf82(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, int utflen, int count) throws IOException, UTFDataFormatRuntimeException {
        int c;
        block5: while (count < utflen && (c = bytes.readUnsignedByte()) >= 0) {
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + count + " was " + char2);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + (count - 1) + " was " + char2 + " " + char3);
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    appendable.append(c3);
                    continue block5;
                }
            }
            throw new UTFDataFormatRuntimeException("malformed input around byte " + count);
        }
    }

    static void parseUtf82(@NotNull RandomDataInput input, long offset, long limit, @NotNull Appendable appendable, int utflen) throws IOException, UTFDataFormatRuntimeException, BufferUnderflowException {
        block5: while (offset < limit) {
            int c = input.readUnsignedByte(offset++);
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2;
                    if (offset == limit) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    if (((char2 = input.readUnsignedByte(offset++)) & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + (offset - limit + (long)utflen) + " was " + char2);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    if (offset + 2L > limit) {
                        throw new UTFDataFormatRuntimeException("malformed input: partial character at end");
                    }
                    int char2 = input.readUnsignedByte(offset++);
                    int char3 = input.readUnsignedByte(offset++);
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatRuntimeException("malformed input around byte " + (offset - limit + (long)utflen - 1L) + " was " + char2 + " " + char3);
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    appendable.append(c3);
                    continue block5;
                }
            }
            throw new UTFDataFormatRuntimeException("malformed input around byte " + (offset - limit + (long)utflen));
        }
    }

    public static void writeUtf8(@NotNull StreamingDataOutput bytes, @Nullable String str) throws BufferOverflowException {
        if (str == null) {
            bytes.writeStopBit(-1L);
            return;
        }
        try {
            if (Jvm.isJava9Plus()) {
                byte[] strBytes = StringUtils.extractBytes(str);
                byte coder = StringUtils.getStringCoder(str);
                long utfLength = AppendableUtil.findUtf8Length(strBytes, coder);
                bytes.writeStopBit(utfLength);
                bytes.appendUtf8(strBytes, 0, str.length(), coder);
            } else {
                char[] chars = StringUtils.extractChars(str);
                long utfLength = AppendableUtil.findUtf8Length(chars);
                bytes.writeStopBit(utfLength);
                bytes.appendUtf8(chars, 0, chars.length);
            }
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @ForceInline
    public static void writeUtf8(@NotNull StreamingDataOutput bytes, @Nullable CharSequence str) throws BufferOverflowException {
        if (str instanceof String) {
            BytesInternal.writeUtf8(bytes, (String)str);
            return;
        }
        if (str == null) {
            bytes.writeStopBit(-1L);
        } else {
            try {
                long utfLength = AppendableUtil.findUtf8Length(str);
                bytes.writeStopBit(utfLength);
                BytesInternal.appendUtf8(bytes, str, 0, str.length());
            }
            catch (IndexOutOfBoundsException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @ForceInline
    public static long writeUtf8(@NotNull RandomDataOutput out, long offset, @Nullable CharSequence str) throws BufferOverflowException {
        if (str == null) {
            offset = BytesInternal.writeStopBit(out, offset, -1L);
        } else {
            try {
                int strLength = str.length();
                if (strLength < 32) {
                    long lenOffset = offset;
                    offset = BytesInternal.appendUtf8(out, offset + 1L, str, 0, strLength);
                    long utfLength = offset - lenOffset - 1L;
                    assert (utfLength <= 127L);
                    BytesInternal.writeStopBit(out, lenOffset, utfLength);
                } else {
                    long utfLength = AppendableUtil.findUtf8Length(str);
                    offset = BytesInternal.writeStopBit(out, offset, utfLength);
                    if (utfLength == (long)strLength) {
                        BytesInternal.append8bit(offset, out, str, 0, strLength);
                        offset += utfLength;
                    } else {
                        offset = BytesInternal.appendUtf8(out, offset, str, 0, strLength);
                    }
                }
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException | BufferUnderflowException e) {
                throw new AssertionError((Object)e);
            }
        }
        return offset;
    }

    @ForceInline
    public static long writeUtf8(@NotNull RandomDataOutput out, long offset, @Nullable CharSequence str, int maxUtf8Len) throws BufferOverflowException {
        if (str == null) {
            offset = BytesInternal.writeStopBit(out, offset, -1L);
        } else {
            try {
                int strLength = str.length();
                long utfLength = AppendableUtil.findUtf8Length(str);
                if (utfLength > (long)maxUtf8Len) {
                    throw new IllegalArgumentException("Attempted to write a char sequence of utf8 size " + utfLength + ": \"" + str + "\", when only " + maxUtf8Len + " allowed");
                }
                offset = BytesInternal.writeStopBit(out, offset, utfLength);
                if (utfLength == (long)strLength) {
                    BytesInternal.append8bit(offset, out, str, 0, strLength);
                    offset += utfLength;
                } else {
                    offset = BytesInternal.appendUtf8(out, offset, str, 0, strLength);
                }
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException | BufferUnderflowException e) {
                throw new AssertionError((Object)e);
            }
        }
        return offset;
    }

    @NotNull
    public static Bytes asBytes(@NotNull RandomDataOutput bytes, long position, long limit) throws IllegalStateException, BufferOverflowException, BufferUnderflowException {
        Bytes sbytes = bytes.bytesForWrite();
        sbytes.writeLimit(limit);
        sbytes.readLimit(limit);
        sbytes.readPosition(position);
        return sbytes;
    }

    public static void appendUtf8(@NotNull StreamingDataOutput bytes, @NotNull CharSequence str, int offset, int length) throws IndexOutOfBoundsException, BufferOverflowException {
        char c;
        int i;
        for (i = 0; i < length && (c = str.charAt(offset + i)) <= '\u007f'; ++i) {
            bytes.rawWriteByte((byte)c);
        }
        BytesInternal.appendUtf82(bytes, str, offset, length, i);
    }

    private static void appendUtf82(@NotNull StreamingDataOutput bytes, @NotNull CharSequence str, int offset, int length, int i) throws IndexOutOfBoundsException, BufferOverflowException {
        while (i < length) {
            char c = str.charAt(offset + i);
            BytesInternal.appendUtf8Char(bytes, c);
            ++i;
        }
    }

    public static long appendUtf8(@NotNull RandomDataOutput out, long outOffset, @NotNull CharSequence str, int strOffset, int length) throws IndexOutOfBoundsException, BufferOverflowException {
        char c;
        int i;
        for (i = 0; i < length && (c = str.charAt(strOffset + i)) <= '\u007f'; ++i) {
            out.writeByte(outOffset++, (byte)c);
        }
        return BytesInternal.appendUtf82(out, outOffset, str, strOffset, length, i);
    }

    private static long appendUtf82(@NotNull RandomDataOutput out, long outOffset, @NotNull CharSequence str, int strOffset, int length, int i) throws IndexOutOfBoundsException, BufferOverflowException {
        while (i < length) {
            char c = str.charAt(strOffset + i);
            outOffset = BytesInternal.appendUtf8Char(out, outOffset, c);
            ++i;
        }
        return outOffset;
    }

    public static void append8bit(long offsetInRDO, RandomDataOutput bytes, @NotNull CharSequence str, int offset, int length) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException {
        if (bytes instanceof VanillaBytes) {
            VanillaBytes vb = (VanillaBytes)bytes;
            if (str instanceof RandomDataInput) {
                vb.write(offsetInRDO, (RandomDataInput)((Object)str), (long)offset, (long)length);
                return;
            }
            if (str instanceof String) {
                vb.write(offsetInRDO, str, offset, length);
                return;
            }
        }
        for (int i = 0; i < length; ++i) {
            int c = str.charAt(offset + i);
            if (c > 255) {
                c = 63;
            }
            bytes.writeUnsignedByte(offsetInRDO + (long)i, c);
        }
    }

    public static void appendUtf8Char(@NotNull StreamingDataOutput bytes, int c) throws BufferOverflowException {
        if (c <= 127) {
            bytes.rawWriteByte((byte)c);
        } else if (c <= 2047) {
            bytes.rawWriteByte((byte)(0xC0 | c >> 6 & 0x1F));
            bytes.rawWriteByte((byte)(0x80 | c & 0x3F));
        } else if (c <= 65535) {
            bytes.rawWriteByte((byte)(0xE0 | c >> 12 & 0xF));
            bytes.rawWriteByte((byte)(0x80 | c >> 6 & 0x3F));
            bytes.rawWriteByte((byte)(0x80 | c & 0x3F));
        } else {
            bytes.rawWriteByte((byte)(0xF0 | c >> 18 & 7));
            bytes.rawWriteByte((byte)(0x80 | c >> 12 & 0x3F));
            bytes.rawWriteByte((byte)(0x80 | c >> 6 & 0x3F));
            bytes.rawWriteByte((byte)(0x80 | c & 0x3F));
        }
    }

    public static long appendUtf8Char(@NotNull RandomDataOutput out, long offset, int c) throws BufferOverflowException {
        if (c <= 127) {
            out.writeByte(offset++, (byte)c);
        } else if (c <= 2047) {
            out.writeByte(offset++, (byte)(0xC0 | c >> 6 & 0x1F));
            out.writeByte(offset++, (byte)(0x80 | c & 0x3F));
        } else if (c <= 65535) {
            out.writeByte(offset++, (byte)(0xE0 | c >> 12 & 0xF));
            out.writeByte(offset++, (byte)(0x80 | c >> 6 & 0x3F));
            out.writeByte(offset++, (byte)(0x80 | c & 0x3F));
        } else {
            out.writeByte(offset++, (byte)(0xF0 | c >> 18 & 7));
            out.writeByte(offset++, (byte)(0x80 | c >> 12 & 0x3F));
            out.writeByte(offset++, (byte)(0x80 | c >> 6 & 0x3F));
            out.writeByte(offset++, (byte)(0x80 | c & 0x3F));
        }
        return offset;
    }

    public static void writeStopBit(@NotNull StreamingDataOutput out, char n) throws BufferOverflowException {
        if ((n & 0xFFFFFF80) == 0) {
            out.rawWriteByte((byte)(n & 0x7F));
            return;
        }
        if ((n & 0xFFFFC000) == 0) {
            out.rawWriteByte((byte)(n & 0x7F | 0x80));
            out.rawWriteByte((byte)(n >> 7));
            return;
        }
        BytesInternal.writeStopBit0(out, n);
    }

    public static void writeStopBit(@NotNull StreamingDataOutput out, long n) throws BufferOverflowException {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            out.rawWriteByte((byte)(n & 0x7FL));
            return;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            out.rawWriteByte((byte)(n & 0x7FL | 0x80L));
            out.rawWriteByte((byte)(n >> 7));
            return;
        }
        BytesInternal.writeStopBit0(out, n);
    }

    public static long writeStopBit(@NotNull RandomDataOutput out, long offset, long n) throws BufferOverflowException {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            out.writeByte(offset++, (byte)(n & 0x7FL));
            return offset;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            out.writeByte(offset++, (byte)(n & 0x7FL | 0x80L));
            out.writeByte(offset++, (byte)(n >> 7));
            return offset;
        }
        return BytesInternal.writeStopBit0(out, offset, n);
    }

    public static void writeStopBit(@NotNull StreamingDataOutput out, double d) throws BufferOverflowException {
        long n = Double.doubleToRawLongBits(d);
        while ((n & 0x1FFFFFFFFFFFFFFL) != 0L) {
            out.rawWriteByte((byte)(n >>> -7 & 0x7FL | 0x80L));
            n <<= 7;
        }
        out.rawWriteByte((byte)(n >>> -7 & 0x7FL));
    }

    public static double readStopBitDouble(@NotNull StreamingDataInput in) {
        byte b;
        long n = 0L;
        int shift = 57;
        do {
            b = in.readByte();
            n |= shift > 0 ? (long)(b & 0x7F) << shift : (long)(b >> -shift);
            shift -= 7;
        } while (b < 0);
        return Double.longBitsToDouble(n);
    }

    static void writeStopBit0(@NotNull StreamingDataOutput out, long n) throws BufferOverflowException {
        long n2;
        boolean neg = false;
        if (n < 0L) {
            neg = true;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n2 = n >>> 7) != 0L) {
            out.rawWriteByte((byte)(0x80L | n));
            n = n2;
        }
        if (!neg) {
            out.rawWriteByte((byte)n);
        } else {
            out.rawWriteByte((byte)(0x80L | n));
            out.rawWriteByte((byte)0);
        }
    }

    static long writeStopBit0(@NotNull RandomDataOutput out, long offset, long n) throws BufferOverflowException {
        long n2;
        boolean neg = false;
        if (n < 0L) {
            neg = true;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n2 = n >>> 7) != 0L) {
            out.writeByte(offset++, (byte)(0x80L | n));
            n = n2;
        }
        if (!neg) {
            out.writeByte(offset++, (byte)n);
        } else {
            out.writeByte(offset++, (byte)(0x80L | n));
            out.writeByte(offset++, (byte)0);
        }
        return offset;
    }

    static int stopBitLength0(long n) {
        int len = 0;
        if (n < 0L) {
            len = 1;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n >>>= 7) != 0L) {
            ++len;
        }
        return len + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toDebugString(@NotNull RandomDataInput bytes, long maxLength) {
        if (bytes.refCount() < 1L) {
            return "<unknown>";
        }
        bytes.reserve();
        try {
            int len = Maths.toUInt31(maxLength + 40L);
            StringBuilder sb = new StringBuilder(len);
            long readPosition = bytes.readPosition();
            long readLimit = bytes.readLimit();
            sb.append("[").append("pos: ").append(readPosition).append(", rlim: ").append(readLimit).append(", wlim: ").append(BytesInternal.asSize(bytes.writeLimit())).append(", cap: ").append(BytesInternal.asSize(bytes.capacity())).append(" ] ");
            try {
                long start = Math.max(bytes.start(), readPosition - 64L);
                long end = Math.min(readLimit + 64L, start + maxLength);
                try {
                    for (end = Math.min(end, bytes.realCapacity()); end >= start + 16L && end >= readLimit + 16L && bytes.readLong(end - 8L) == 0L; end -= 8L) {
                    }
                }
                catch (UnsupportedOperationException | BufferUnderflowException runtimeException) {
                    // empty catch block
                }
                BytesInternal.toString(bytes, sb, start, readPosition, bytes.writePosition(), end);
                if (end < bytes.readLimit()) {
                    sb.append("...");
                }
            }
            catch (Exception e) {
                sb.append(' ').append(e);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            bytes.release();
        }
    }

    @NotNull
    public static Object asSize(long size) {
        return size == Long.MAX_VALUE ? "8EiB" : Long.valueOf(size);
    }

    public static String to8bitString(@NotNull BytesStore bytes) throws IllegalArgumentException {
        long pos = bytes.readPosition();
        int len = Maths.toInt32(bytes.readRemaining());
        char[] chars = new char[len];
        if (bytes instanceof VanillaBytes) {
            ((VanillaBytes)bytes).read8Bit(chars, len);
        } else {
            for (int i = 0; i < len; ++i) {
                try {
                    chars[i] = (char)bytes.readUnsignedByte(pos + (long)i);
                    continue;
                }
                catch (Exception e) {
                    return new String(chars, 0, len) + ' ' + e;
                }
            }
        }
        return StringUtils.newString(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String toString(@NotNull RandomDataInput bytes) throws IllegalStateException {
        int size = MAX_STRING_LEN;
        StringBuilder sb = new StringBuilder(size);
        if (bytes.readRemaining() > (long)size) {
            Bytes bytes1 = bytes.bytesForRead();
            try {
                bytes1.readLimit(bytes1.readPosition() + (long)size);
                BytesInternal.toString(bytes1, sb);
                String string = sb.toString() + "...";
                return string;
            }
            finally {
                bytes1.release();
            }
        }
        BytesInternal.toString(bytes, sb);
        return sb.toString();
    }

    private static void toString(@NotNull RandomDataInput bytes, @NotNull Appendable sb, long start, long readPosition, long writePosition, long end) throws BufferUnderflowException {
        try {
            long realCapacity;
            if (start < bytes.start()) {
                start = bytes.start();
            }
            if (end > (realCapacity = bytes.realCapacity())) {
                end = realCapacity;
            }
            if (readPosition >= start && bytes instanceof Bytes) {
                long last = Math.min(readPosition, end);
                BytesInternal.toString(bytes, sb, start, last);
                sb.append('\u01c1');
            }
            BytesInternal.toString(bytes, sb, Math.max(readPosition, start), Math.min(writePosition, end));
            if (writePosition <= end) {
                if (bytes instanceof Bytes) {
                    sb.append('\u2021');
                }
                BytesInternal.toString(bytes, sb, writePosition, end);
            }
        }
        catch (Exception e) {
            try {
                sb.append(' ').append(e.toString());
            }
            catch (IOException e1) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private static void toString(@NotNull RandomDataInput bytes, @NotNull Appendable sb, long start, long last) throws IOException {
        for (long i = start; i < last; ++i) {
            sb.append(bytes.printable(i));
        }
    }

    private static void toString(@NotNull RandomDataInput bytes, @NotNull StringBuilder sb) throws IllegalStateException {
        bytes.reserve();
        assert (bytes.start() <= bytes.readPosition());
        assert (bytes.readPosition() <= bytes.readLimit());
        assert (bytes.readLimit() <= bytes.realCapacity());
        try {
            for (long i = bytes.readPosition(); i < bytes.readLimit(); ++i) {
                sb.append((char)bytes.readUnsignedByte(i));
            }
        }
        catch (BufferUnderflowException e) {
            sb.append(' ').append(e);
        }
        bytes.release();
    }

    @ForceInline
    public static char readStopBitChar(@NotNull StreamingDataInput in) throws IORuntimeException {
        byte l = in.rawReadByte();
        if (l >= 0) {
            return (char)l;
        }
        return (char)BytesInternal.readStopBit0(in, l);
    }

    @ForceInline
    public static long readStopBit(@NotNull StreamingDataInput in) throws IORuntimeException {
        long l = in.rawReadByte();
        if (l >= 0L) {
            return l;
        }
        return BytesInternal.readStopBit0(in, l);
    }

    static long readStopBit0(@NotNull StreamingDataInput in, long l) throws IORuntimeException {
        long b;
        l &= 0x7FL;
        int count = 7;
        while ((b = (long)in.rawReadByte()) < 0L) {
            l |= (b & 0x7FL) << count;
            count += 7;
        }
        if (b != 0L) {
            if (count > 56) {
                throw new IORuntimeException("Cannot read more than 9 stop bits of positive value");
            }
            return l | b << count;
        }
        if (count > 63) {
            throw new IORuntimeException("Cannot read more than 10 stop bits of negative value");
        }
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void append(@NotNull ByteStringAppender out, long num, int base) throws IllegalArgumentException, BufferOverflowException {
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                if (base == 10) {
                    out.write(MIN_VALUE_TEXT);
                } else {
                    out.write(Long.toString(Long.MIN_VALUE, base));
                }
                return;
            }
            out.rawWriteByte((byte)45);
            num = -num;
        }
        if (num == 0L) {
            out.rawWriteByte((byte)48);
        } else {
            switch (base) {
                case 10: {
                    BytesInternal.appendBase10(out, num);
                    break;
                }
                case 16: {
                    BytesInternal.appendBase16(out, num, 1);
                    break;
                }
                default: {
                    out.write(Long.toString(num, base));
                }
            }
        }
    }

    public static void appendBase10(@NotNull ByteStringAppender out, int num) throws IllegalArgumentException, BufferOverflowException {
        BytesInternal.appendBase10(out, (long)num);
    }

    public static void appendBase10(@NotNull ByteStringAppender out, long num) throws IllegalArgumentException, BufferOverflowException {
        if (out.canWriteDirect(20L)) {
            long address = out.addressForWrite(out.writePosition());
            long address2 = UnsafeText.appendFixed(address, num);
            out.writeSkip(address2 - address);
        } else {
            BytesInternal.appendLong0(out, num);
        }
    }

    public static void appendBase16(@NotNull ByteStringAppender out, long num, int minDigits) throws IllegalArgumentException, BufferOverflowException {
        byte[] numberBuffer = NUMBER_BUFFER.get();
        int len = 0;
        do {
            int digit = (int)(num & 0xFL);
            numberBuffer[len++] = (byte)HEXADECIMAL[digit];
        } while (--minDigits > 0 | (num >>>= 4) > 0L);
        for (int i = len - 1; i >= 0; --i) {
            out.rawWriteByte(numberBuffer[i]);
        }
    }

    public static void appendDecimal(@NotNull ByteStringAppender out, long num, int decimalPlaces) throws IllegalArgumentException, BufferOverflowException {
        int endIndex;
        if (decimalPlaces == 0) {
            BytesInternal.appendBase10(out, num);
            return;
        }
        byte[] numberBuffer = NUMBER_BUFFER.get();
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                numberBuffer = MIN_VALUE_TEXT;
                endIndex = MIN_VALUE_TEXT.length;
            } else {
                out.rawWriteByte((byte)45);
                num = -num;
                endIndex = BytesInternal.appendLong1(numberBuffer, num);
            }
        } else {
            endIndex = BytesInternal.appendLong1(numberBuffer, num);
        }
        int digits = numberBuffer.length - endIndex;
        if (decimalPlaces >= digits) {
            out.writeUnsignedByte(48);
            out.writeUnsignedByte(46);
            while (decimalPlaces-- > digits) {
                out.writeUnsignedByte(48);
            }
            out.write(numberBuffer, endIndex, digits);
            return;
        }
        int decimalLength = numberBuffer.length - endIndex - decimalPlaces;
        out.write(numberBuffer, endIndex, decimalLength);
        out.writeUnsignedByte(46);
        out.write(numberBuffer, endIndex + decimalLength, digits - decimalLength);
    }

    public static void prepend(@NotNull BytesPrepender out, long num) throws IllegalArgumentException, BufferOverflowException {
        boolean neg = false;
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                out.prewrite(MIN_VALUE_TEXT);
                return;
            }
            neg = true;
            num = -num;
        }
        do {
            out.prewriteByte((byte)(num % 10L + 48L));
        } while ((num /= 10L) > 0L);
        if (neg) {
            out.prewriteByte((byte)45);
        }
    }

    public static void append(@NotNull RandomDataOutput out, long offset, long num, int digits) throws BufferOverflowException, IllegalArgumentException {
        boolean negative = num < 0L;
        num = Math.abs(num);
        for (int i = digits - 1; i > 0; --i) {
            out.writeByte(offset + (long)i, (byte)(num % 10L + 48L));
            num /= 10L;
        }
        if (negative) {
            if (num != 0L) {
                BytesInternal.numberTooLarge(digits);
            }
            out.writeByte(offset, 45);
        } else {
            if (num > 9L) {
                BytesInternal.numberTooLarge(digits);
            }
            out.writeByte(offset, (byte)(num % 10L + 48L));
        }
    }

    public static void appendDecimal(@NotNull RandomDataOutput out, long num, long offset, int decimalPlaces, int width) throws IORuntimeException, IllegalArgumentException, BufferOverflowException {
        int endIndex;
        if (decimalPlaces == 0) {
            BytesInternal.append(out, offset, num, width);
            return;
        }
        byte[] numberBuffer = NUMBER_BUFFER.get();
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                numberBuffer = MIN_VALUE_TEXT;
                endIndex = MIN_VALUE_TEXT.length;
            } else {
                out.writeByte(offset++, (byte)45);
                num = -num;
                endIndex = BytesInternal.appendLong1(numberBuffer, num);
            }
        } else {
            endIndex = BytesInternal.appendLong1(numberBuffer, num);
        }
        int digits = numberBuffer.length - endIndex;
        if (decimalPlaces >= digits) {
            int numDigitsRequired = 2 + decimalPlaces;
            if (numDigitsRequired > width) {
                throw new IllegalArgumentException("Value do not fit in " + width + " digits");
            }
            out.writeUnsignedByte(offset++, 48);
            out.writeUnsignedByte(offset++, 46);
            while (decimalPlaces-- > digits) {
                out.writeUnsignedByte(offset++, 48);
            }
            out.write(offset++, numberBuffer, endIndex, digits);
            return;
        }
        int numDigitsRequired = digits + 1;
        if (numDigitsRequired > width) {
            throw new IllegalArgumentException("Value do not fit in " + width + " digits");
        }
        while (width-- > digits + 1) {
            out.writeUnsignedByte(offset++, 48);
        }
        int decimalLength = numberBuffer.length - endIndex - decimalPlaces;
        out.write(offset, numberBuffer, endIndex, decimalLength);
        offset += (long)decimalLength;
        out.writeUnsignedByte(offset++, 46);
        out.write(offset++, numberBuffer, endIndex + decimalLength, digits - decimalLength);
    }

    private static void numberTooLarge(int digits) throws IllegalArgumentException {
        throw new IllegalArgumentException("Number too large for " + digits + "digits");
    }

    private static void appendInt0(@NotNull StreamingDataOutput out, int num) throws IllegalArgumentException, BufferOverflowException {
        if (num < 10) {
            out.rawWriteByte((byte)(48 + num));
        } else if (num < 100) {
            out.writeShort((short)(num / 10 + (num % 10 << 8) + 12336));
        } else {
            byte[] numberBuffer = NUMBER_BUFFER.get();
            int endIndex = BytesInternal.appendInt1(numberBuffer, num);
            out.write(numberBuffer, endIndex, numberBuffer.length - endIndex);
        }
    }

    private static void appendLong0(@NotNull StreamingDataOutput out, long num) throws IllegalArgumentException, BufferOverflowException {
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                out.write(MIN_VALUE_TEXT);
                return;
            }
            out.rawWriteByte((byte)45);
            num = -num;
        }
        if (num < 10L) {
            out.rawWriteByte((byte)(48L + num));
        } else if (num < 100L) {
            out.writeShort((short)(num / 10L + (num % 10L << 8) + 12336L));
        } else {
            byte[] numberBuffer = NUMBER_BUFFER.get();
            int endIndex = BytesInternal.appendLong1(numberBuffer, num);
            out.write(numberBuffer, endIndex, numberBuffer.length - endIndex);
        }
    }

    private static int appendInt1(byte[] numberBuffer, int num) {
        numberBuffer[19] = (byte)((long)num % 10L + 48L);
        if ((num /= 10) <= 0) {
            return 19;
        }
        numberBuffer[18] = (byte)((long)num % 10L + 48L);
        if ((num /= 10) <= 0) {
            return 18;
        }
        numberBuffer[17] = (byte)((long)num % 10L + 48L);
        if ((num /= 10) <= 0) {
            return 17;
        }
        numberBuffer[16] = (byte)((long)num % 10L + 48L);
        if ((num /= 10) <= 0) {
            return 16;
        }
        numberBuffer[15] = (byte)((long)num % 10L + 48L);
        if ((num /= 10) <= 0) {
            return 15;
        }
        numberBuffer[14] = (byte)((long)num % 10L + 48L);
        if ((num /= 10) <= 0) {
            return 14;
        }
        numberBuffer[13] = (byte)((long)num % 10L + 48L);
        if ((num /= 10) <= 0) {
            return 13;
        }
        numberBuffer[12] = (byte)((long)num % 10L + 48L);
        if ((num /= 10) <= 0) {
            return 12;
        }
        numberBuffer[11] = (byte)((long)num % 10L + 48L);
        if ((num /= 10) <= 0) {
            return 11;
        }
        numberBuffer[10] = (byte)((long)num % 10L + 48L);
        return 10;
    }

    private static int appendLong1(byte[] numberBuffer, long num) {
        numberBuffer[19] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 19;
        }
        numberBuffer[18] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 18;
        }
        numberBuffer[17] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 17;
        }
        numberBuffer[16] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 16;
        }
        numberBuffer[15] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 15;
        }
        numberBuffer[14] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 14;
        }
        numberBuffer[13] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 13;
        }
        numberBuffer[12] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 12;
        }
        numberBuffer[11] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 11;
        }
        numberBuffer[10] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 10;
        }
        numberBuffer[9] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 9;
        }
        numberBuffer[8] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 8;
        }
        numberBuffer[7] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 7;
        }
        numberBuffer[6] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 6;
        }
        numberBuffer[5] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 5;
        }
        numberBuffer[4] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 4;
        }
        numberBuffer[3] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 3;
        }
        numberBuffer[2] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 2;
        }
        numberBuffer[1] = (byte)(num % 10L + 48L);
        return 1;
    }

    public static void append(@NotNull StreamingDataOutput out, double d) throws BufferOverflowException, IllegalArgumentException {
        int shift;
        long val = Double.doubleToRawLongBits(d);
        int sign = (int)(val >>> 63);
        int exp = (int)(val >>> 52 & 0x7FFL);
        long mantissa = val & 0xFFFFFFFFFFFFFL;
        if (sign != 0) {
            out.rawWriteByte((byte)45);
        }
        if (exp == 0 && mantissa == 0L) {
            out.rawWriteByte((byte)48);
            out.rawWriteByte((byte)46);
            out.rawWriteByte((byte)48);
            return;
        }
        if (exp == 2047) {
            if (mantissa == 0L) {
                out.write(Infinity);
            } else {
                out.write(NaN);
            }
            return;
        }
        if (exp > 0) {
            mantissa += 0x10000000000000L;
        }
        if ((shift = 1075 - exp) > 0) {
            if (shift < 53) {
                long intValue = mantissa >> shift;
                BytesInternal.appendLong0(out, intValue);
                if ((mantissa -= intValue << shift) > 0L) {
                    long num;
                    out.rawWriteByte((byte)46);
                    mantissa <<= 1;
                    ++mantissa;
                    int precision = shift + 1;
                    long value = intValue;
                    int decimalPlaces = 0;
                    for (long error = 1L; mantissa > error; error *= 5L, mantissa -= num << precision) {
                        num = (mantissa *= 5L) >> --precision;
                        value = value * 10L + num;
                        out.rawWriteByte((byte)(48L + num));
                        double parsedValue = BytesInternal.asDouble(value, 0, sign != 0, ++decimalPlaces);
                        if (parsedValue != d) continue;
                        break;
                    }
                } else {
                    out.rawWriteByte((byte)46);
                    out.rawWriteByte((byte)48);
                }
                return;
            }
            out.rawWriteByte((byte)48);
            out.rawWriteByte((byte)46);
            mantissa <<= 6;
            mantissa += 32L;
            int precision = shift + 6;
            long value = 0L;
            int decimalPlaces = 0;
            for (long error = 32L; mantissa > error; error *= 5L) {
                while (mantissa > 0x1999999999999999L) {
                    mantissa >>>= 1;
                    error = error + 1L >>> 1;
                    --precision;
                }
                mantissa *= 5L;
                if (--precision >= 64) {
                    ++decimalPlaces;
                    out.rawWriteByte((byte)48);
                    continue;
                }
                long num = mantissa >>> precision;
                value = value * 10L + num;
                char c = (char)(48L + num);
                assert (c >= '0' && c <= '9');
                out.rawWriteByte((byte)c);
                mantissa -= num << precision;
                double parsedValue = BytesInternal.asDouble(value, 0, sign != 0, ++decimalPlaces);
                if (parsedValue != d) continue;
                break;
            }
            return;
        }
        mantissa <<= 10;
        int precision = -10 - shift;
        int digits = 0;
        while ((precision > 53 || mantissa > Long.MAX_VALUE >> precision) && precision > 0) {
            ++digits;
            --precision;
            long mod = mantissa % 5L;
            mantissa /= 5L;
            int modDiv = 1;
            while (mantissa < 0x1999999999999999L && precision > 1) {
                --precision;
                mantissa <<= 1;
                modDiv <<= 1;
            }
            mantissa += (long)modDiv * mod / 5L;
        }
        long val2 = precision > 0 ? mantissa << precision : mantissa >>> -precision;
        BytesInternal.appendLong0(out, val2);
        for (int i = 0; i < digits; ++i) {
            out.rawWriteByte((byte)48);
        }
    }

    private static double asDouble(long value, int exp, boolean negative, int deci) {
        double d;
        int leading = Long.numberOfLeadingZeros(value) - 1;
        if (leading > 9) {
            leading = 27 + leading >>> 2;
        }
        int scale2 = 0;
        if (leading > 0) {
            scale2 = leading;
            value <<= scale2;
        }
        if (deci > 0) {
            if (deci <= 29) {
                long fives = Maths.fives(deci);
                long whole = value / fives;
                long rem = value % fives;
                d = (double)whole + (double)rem / (double)fives;
            } else {
                d = (double)value / Math.pow(5.0, -deci);
            }
        } else if (deci < -29) {
            d = (double)value * Math.pow(5.0, -deci);
        } else if (deci < 0) {
            double fives = Maths.fives(-deci);
            d = (double)value * fives;
        } else {
            d = value;
        }
        double scalb = Math.scalb(d, exp - deci - scale2);
        return negative ? -scalb : scalb;
    }

    @ForceInline
    @Nullable
    public static String readUtf8(@NotNull StreamingDataInput in) throws BufferUnderflowException, IllegalArgumentException, IORuntimeException {
        StringBuilder sb = BytesInternal.acquireStringBuilder();
        return in.readUtf8(sb) ? SI.intern(sb) : null;
    }

    @ForceInline
    @Nullable
    public static String readUtf8(@NotNull RandomDataInput in, long offset, int maxUtf8Len) throws BufferUnderflowException, IllegalArgumentException, IllegalStateException, IORuntimeException {
        StringBuilder sb = BytesInternal.acquireStringBuilder();
        return in.readUtf8Limited(offset, sb, maxUtf8Len) > 0L ? SI.intern(sb) : null;
    }

    public static StringBuilder acquireStringBuilder() {
        return SBP.acquireStringBuilder();
    }

    public static Bytes acquireBytes() {
        return BP.acquireBytes();
    }

    @ForceInline
    @Nullable
    public static String read8bit(@NotNull StreamingDataInput in) throws BufferUnderflowException, IORuntimeException {
        Bytes bytes = BytesInternal.acquireBytes();
        return in.read8bit(bytes) ? SI.intern(bytes) : null;
    }

    @ForceInline
    @Nullable
    public static String parseUtf8(@NotNull StreamingDataInput bytes, @NotNull StopCharTester tester) throws BufferUnderflowException {
        StringBuilder utfReader = BytesInternal.acquireStringBuilder();
        BytesInternal.parseUtf8(bytes, (Appendable)utfReader, tester);
        return SI.intern(utfReader);
    }

    @ForceInline
    public static void parseUtf8(@NotNull StreamingDataInput bytes, @NotNull Appendable builder, @NotNull StopCharTester tester) throws BufferUnderflowException {
        try {
            if (builder instanceof StringBuilder && bytes.isDirectMemory()) {
                Bytes vb = (Bytes)bytes;
                StringBuilder sb = (StringBuilder)builder;
                sb.setLength(0);
                BytesInternal.readUtf8_SB1(vb, sb, tester);
            } else {
                AppendableUtil.setLength(builder, 0);
                BytesInternal.readUtf81(bytes, builder, tester);
            }
        }
        catch (UTFDataFormatException e) {
            UTFDataFormatRuntimeException e2 = new UTFDataFormatRuntimeException("Unable to parse invalid UTF-8 code");
            e2.initCause(e);
            throw e2;
        }
        catch (IOException e) {
            throw Jvm.rethrow(e);
        }
    }

    private static void readUtf8_SB1(@NotNull Bytes bytes, @NotNull StringBuilder appendable, @NotNull StopCharTester tester) throws IOException, BufferUnderflowException {
        int i;
        NativeBytesStore nb = (NativeBytesStore)bytes.bytesStore();
        int len = Maths.toInt32(bytes.readRemaining());
        long address = nb.address + nb.translate(bytes.readPosition());
        Memory memory = nb.memory;
        if (Jvm.isJava9Plus()) {
            byte c;
            int appendableLength = appendable.capacity();
            for (i = 0; i < len && i < appendableLength && (c = memory.readByte(address + (long)i)) >= 0; ++i) {
                if (tester.isStopChar(c)) {
                    bytes.readSkip(i + 1);
                    StringUtils.setCount(appendable, i);
                    return;
                }
                appendable.append((char)c);
            }
        } else {
            byte c;
            char[] chars = StringUtils.extractChars(appendable);
            while (i < len && i < chars.length && (c = memory.readByte(address + (long)i)) >= 0) {
                if (tester.isStopChar(c)) {
                    bytes.readSkip(i + 1);
                    StringUtils.setCount(appendable, i);
                    return;
                }
                chars[i] = (char)c;
                ++i;
            }
        }
        StringUtils.setCount(appendable, i);
        bytes.readSkip(i);
        if (i < len) {
            BytesInternal.readUtf8_SB2(bytes, appendable, tester);
        }
    }

    private static void readUtf8_SB2(@NotNull StreamingDataInput bytes, @NotNull StringBuilder appendable, @NotNull StopCharTester tester) throws UTFDataFormatException {
        block5: while (true) {
            int c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c)) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2)) {
                        return;
                    }
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte ");
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3)) {
                        return;
                    }
                    appendable.append(c3);
                    continue block5;
                }
            }
            break;
        }
        throw new UTFDataFormatException("malformed input around byte ");
    }

    private static void readUtf81(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharTester tester) throws IOException, BufferUnderflowException {
        int len = Maths.toInt32(bytes.readRemaining());
        while (len-- > 0) {
            int c = bytes.rawReadByte() & 0xFF;
            if (c >= 128) {
                bytes.readSkip(-1L);
                break;
            }
            if (tester.isStopChar(c)) {
                return;
            }
            appendable.append((char)c);
        }
        if (len <= 0) {
            return;
        }
        BytesInternal.readUtf82(bytes, appendable, tester);
    }

    private static void readUtf82(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharTester tester) throws IOException {
        block5: while (true) {
            int c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c)) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2)) {
                        return;
                    }
                    appendable.append(c2);
                    continue block5;
                }
                case 14: {
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte ");
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3)) {
                        return;
                    }
                    appendable.append(c3);
                    continue block5;
                }
            }
            break;
        }
        throw new UTFDataFormatException("malformed input around byte ");
    }

    @ForceInline
    public static void parseUtf8(@NotNull StreamingDataInput bytes, @NotNull Appendable builder, @NotNull StopCharsTester tester) throws IllegalArgumentException, BufferUnderflowException, IORuntimeException {
        AppendableUtil.setLength(builder, 0);
        try {
            AppendableUtil.readUtf8AndAppend(bytes, builder, tester);
        }
        catch (IOException e) {
            throw Jvm.rethrow(e);
        }
    }

    @ForceInline
    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull StringBuilder builder, @NotNull StopCharsTester tester) {
        builder.setLength(0);
        AppendableUtil.read8bitAndAppend(bytes, builder, tester);
    }

    @ForceInline
    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull Bytes builder, @NotNull StopCharsTester tester) throws BufferUnderflowException, BufferOverflowException {
        builder.readPosition(0L);
        BytesInternal.read8bitAndAppend(bytes, builder, tester);
    }

    @ForceInline
    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull StringBuilder builder, @NotNull StopCharTester tester) {
        builder.setLength(0);
        BytesInternal.read8bitAndAppend(bytes, builder, tester);
    }

    @ForceInline
    public static void parse8bit(@NotNull StreamingDataInput bytes, @NotNull Bytes builder, @NotNull StopCharTester tester) throws BufferUnderflowException, BufferOverflowException {
        builder.clear();
        BytesInternal.read8bitAndAppend(bytes, builder, tester);
    }

    private static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull StringBuilder appendable, @NotNull StopCharTester tester) {
        do {
            int c;
            if (tester.isStopChar(c = bytes.readUnsignedByte())) {
                return;
            }
            appendable.append((char)c);
        } while (bytes.readRemaining() != 0L);
    }

    private static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull Bytes bytes2, @NotNull StopCharTester tester) throws BufferUnderflowException, BufferOverflowException {
        try {
            do {
                int c;
                if (tester.isStopChar(c = bytes.readUnsignedByte())) {
                    return;
                }
                bytes2.writeUnsignedByte(c);
            } while (bytes.readRemaining() != 0L);
            return;
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull Bytes bytes2, @NotNull StopCharsTester tester) throws BufferUnderflowException, BufferOverflowException {
        try {
            int ch = bytes.readUnsignedByte();
            do {
                int next;
                if (tester.isStopChar(ch, next = bytes.readUnsignedByte())) {
                    bytes.readSkip(-1L);
                    return;
                }
                bytes2.writeUnsignedByte(ch);
                ch = next;
            } while (bytes.readRemaining() > 1L);
            if (tester.isStopChar(ch, -1)) {
                bytes.readSkip(-1L);
                return;
            }
            bytes2.writeUnsignedByte(ch);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double parseDouble(@NotNull StreamingDataInput in) throws BufferUnderflowException {
        int ch;
        long value = 0L;
        int exp = 0;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        while ((ch = in.rawReadByte() & 0xFF) == 32) {
        }
        try {
            switch (ch) {
                case 78: {
                    if (BytesInternal.compareRest(in, "aN")) {
                        double d = Double.NaN;
                        return d;
                    }
                    in.readSkip(-1L);
                    double d = Double.NaN;
                    return d;
                }
                case 73: {
                    if (BytesInternal.compareRest(in, "nfinity")) {
                        double d = Double.POSITIVE_INFINITY;
                        return d;
                    }
                    in.readSkip(-1L);
                    double d = Double.NaN;
                    return d;
                }
                case 45: {
                    if (BytesInternal.compareRest(in, "Infinity")) {
                        double d = Double.NEGATIVE_INFINITY;
                        return d;
                    }
                    negative = true;
                    ch = in.rawReadByte();
                }
            }
            int tens = 0;
            while (true) {
                if (ch >= 48 && ch <= 57) {
                    while (value >= 0xCCCCCCCCCCCCCCCL) {
                        value >>>= 1;
                        ++exp;
                    }
                    value = value * 10L + (long)(ch - 48);
                    ++decimalPlaces;
                } else if (ch == 46) {
                    decimalPlaces = 0;
                } else {
                    if (ch != 69 && ch != 101) break;
                    tens = (int)BytesInternal.parseLong(in);
                    break;
                }
                if (in.readRemaining() == 0L) break;
                ch = in.rawReadByte();
            }
            if (decimalPlaces < 0) {
                decimalPlaces = 0;
            }
            double d = BytesInternal.asDouble(value, exp, negative, decimalPlaces - tens);
            return d;
        }
        finally {
            ((ByteStringParser)in).lastDecimalPlaces(decimalPlaces);
        }
    }

    static boolean compareRest(@NotNull StreamingDataInput in, @NotNull String s2) throws BufferUnderflowException {
        if ((long)s2.length() > in.readRemaining()) {
            return false;
        }
        long position = in.readPosition();
        for (int i = 0; i < s2.length(); ++i) {
            if (in.readUnsignedByte() == s2.charAt(i)) continue;
            in.readPosition(position);
            return false;
        }
        int ch = in.readUnsignedByte();
        if (Character.isLetterOrDigit(ch)) {
            in.readPosition(position);
            return false;
        }
        while (Character.isWhitespace(ch) && ch >= 32) {
            ch = in.readUnsignedByte();
        }
        return true;
    }

    @ForceInline
    public static long parseLong(@NotNull StreamingDataInput in) throws BufferUnderflowException {
        long num = 0L;
        boolean negative = false;
        int b = in.peekUnsignedByte();
        if (b == 48) {
            in.readSkip(1L);
            b = in.peekUnsignedByte();
            if (b == 120 || b == 88) {
                in.readSkip(1L);
                return BytesInternal.parseLongHexaDecimal(in);
            }
        }
        while (in.readRemaining() > 0L) {
            b = in.rawReadByte();
            if (b - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b == 45) {
                negative = true;
                continue;
            }
            if (b == 93 || b == 125) {
                in.readSkip(-1L);
                break;
            }
            if (b == 46) {
                BytesInternal.consumeDecimals(in);
                break;
            }
            if (b == 95) continue;
        }
        return negative ? -num : num;
    }

    private static long parseLongHexaDecimal(@NotNull StreamingDataInput in) {
        long num = 0L;
        while (in.readRemaining() > 0L) {
            int b = in.readUnsignedByte();
            if (b - -2147483600 <= -2147483639) {
                num = (num << 4) + (long)b - 48L;
                continue;
            }
            if (b - -2147483583 < -2147483642) {
                num = (num << 4) + (long)b - 55L;
                continue;
            }
            if (b - -2147483551 < -2147483642) {
                num = (num << 4) + (long)b - 87L;
                continue;
            }
            if (b == 93 || b == 125) {
                in.readSkip(-1L);
                break;
            }
            if (b == 46) {
                BytesInternal.consumeDecimals(in);
                break;
            }
            if (b == 95) continue;
        }
        return num;
    }

    static void consumeDecimals(@NotNull StreamingDataInput in) {
        int b;
        while (in.readRemaining() > 0L && (b = in.readUnsignedByte()) >= 48 && b <= 57) {
        }
    }

    @ForceInline
    public static long parseLongDecimal(@NotNull StreamingDataInput in) throws BufferUnderflowException {
        long num = 0L;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        while (in.readRemaining() > 0L) {
            int b = in.readUnsignedByte();
            if (b - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                ++decimalPlaces;
                continue;
            }
            if (b == 46) {
                decimalPlaces = 0;
                continue;
            }
            if (b == 45) {
                negative = true;
                continue;
            }
            if (b == 93 || b == 125) {
                in.readSkip(-1L);
                break;
            }
            if (b == 95) continue;
        }
        ((ByteStringParser)in).lastDecimalPlaces(decimalPlaces);
        return negative ? -num : num;
    }

    @ForceInline
    public static long parseHexLong(@NotNull StreamingDataInput in) throws BufferUnderflowException {
        long num = 0L;
        while (in.readRemaining() > 0L) {
            int b = in.readUnsignedByte();
            if (b - -2147483600 <= -2147483639) {
                num = num * 16L + (long)b - 48L;
                continue;
            }
            if (b - -2147483583 <= -2147483642) {
                num = num * 16L + (long)b - 65L + 10L;
                continue;
            }
            if (b - -2147483551 <= -2147483642) {
                num = num * 16L + (long)b - 97L + 10L;
                continue;
            }
            if (b == 93 || b == 125) {
                in.readSkip(-1L);
                break;
            }
            if (b == 95) continue;
        }
        return num;
    }

    public static long parseLong(@NotNull RandomDataInput in, long offset) throws BufferUnderflowException {
        long num = 0L;
        boolean negative = false;
        while (true) {
            int b;
            if ((b = in.peekUnsignedByte(offset++)) - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b == 45) {
                negative = true;
                continue;
            }
            if (b != 95) break;
        }
        return negative ? -num : num;
    }

    public static boolean skipTo(@NotNull ByteStringParser parser, @NotNull StopCharTester tester) {
        while (parser.readRemaining() > 0L) {
            int ch = parser.readUnsignedByte();
            if (!tester.isStopChar(ch)) continue;
            return true;
        }
        return false;
    }

    public static float addAndGetFloat(@NotNull RandomDataInput in, long offset, float adding) throws BufferUnderflowException {
        try {
            float value1;
            int value2;
            int value;
            while (!in.compareAndSwapInt(offset, value = in.readVolatileInt(offset), value2 = Float.floatToRawIntBits(value1 = Float.intBitsToFloat(value) + adding))) {
            }
            return value1;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static double addAndGetDouble(@NotNull RandomDataInput in, long offset, double adding) throws BufferUnderflowException {
        try {
            double value1;
            long value2;
            long value;
            while (!in.compareAndSwapLong(offset, value = in.readVolatileLong(offset), value2 = Double.doubleToRawLongBits(value1 = Double.longBitsToDouble(value) + adding))) {
            }
            return value1;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static int addAndGetInt(@NotNull RandomDataInput in, long offset, int adding) throws BufferUnderflowException {
        try {
            int value2;
            int value;
            while (!in.compareAndSwapInt(offset, value = in.readVolatileInt(offset), value2 = value + adding)) {
            }
            return value2;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static long addAndGetLong(@NotNull RandomDataInput in, long offset, long adding) throws BufferUnderflowException {
        try {
            long value2;
            long value;
            while (!in.compareAndSwapLong(offset, value = in.readVolatileLong(offset), value2 = value + adding)) {
            }
            return value2;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toHexString(@NotNull Bytes bytes, long offset, long len) throws BufferUnderflowException {
        if (len == 0L) {
            return "";
        }
        int width = 16;
        int[] lastLine = new int[width];
        String sep = "";
        long position = bytes.readPosition();
        long limit = bytes.readLimit();
        try {
            bytes.readPositionRemaining(offset, len);
            StringBuilder builder = new StringBuilder();
            long start = offset / (long)width * (long)width;
            long end = (offset + len + (long)width - 1L) / (long)width * (long)width;
            for (long i = start; i < end; i += (long)width) {
                int ch;
                int j;
                if (i + (long)width < end) {
                    boolean same = true;
                    for (j = 0; j < width && i + (long)j < offset + len; ++j) {
                        ch = bytes.readUnsignedByte(i + (long)j);
                        same &= ch == lastLine[j];
                        lastLine[j] = ch;
                    }
                    if (i > start && same) {
                        sep = "........\n";
                        continue;
                    }
                }
                builder.append(sep);
                sep = "";
                String str = Long.toHexString(i);
                for (j = str.length(); j < 8; ++j) {
                    builder.append('0');
                }
                builder.append(str);
                for (j = 0; j < width; ++j) {
                    if (j == width / 2) {
                        builder.append(' ');
                    }
                    if (i + (long)j < offset || i + (long)j >= offset + len) {
                        builder.append("   ");
                        continue;
                    }
                    builder.append(' ');
                    ch = bytes.readUnsignedByte(i + (long)j);
                    builder.append(HEXADECIMAL[ch >> 4]);
                    builder.append(HEXADECIMAL[ch & 0xF]);
                }
                builder.append(' ');
                for (j = 0; j < width; ++j) {
                    if (j == width / 2) {
                        builder.append(' ');
                    }
                    if (i + (long)j < offset || i + (long)j >= offset + len) {
                        builder.append(' ');
                        continue;
                    }
                    ch = bytes.readUnsignedByte(i + (long)j);
                    if (ch < 32 || ch > 126) {
                        ch = 183;
                    }
                    builder.append((char)ch);
                }
                builder.append("\n");
            }
            String string = builder.toString();
            return string;
        }
        finally {
            bytes.readLimit(limit);
            bytes.readPosition(position);
        }
    }

    public static void appendTimeMillis(@NotNull ByteStringAppender b, long timeInMS) throws BufferOverflowException {
        int hours = (int)(timeInMS / 3600000L);
        if (hours > 99) {
            b.append(hours);
        } else {
            b.rawWriteByte((byte)(hours / 10 + 48));
            b.rawWriteByte((byte)(hours % 10 + 48));
        }
        b.rawWriteByte((byte)58);
        int minutes = (int)(timeInMS / 60000L % 60L);
        b.rawWriteByte((byte)(minutes / 10 + 48));
        b.rawWriteByte((byte)(minutes % 10 + 48));
        b.rawWriteByte((byte)58);
        int seconds = (int)(timeInMS / 1000L % 60L);
        b.rawWriteByte((byte)(seconds / 10 + 48));
        b.rawWriteByte((byte)(seconds % 10 + 48));
        b.rawWriteByte((byte)46);
        int millis = (int)(timeInMS % 1000L);
        b.rawWriteByte((byte)(millis / 100 + 48));
        b.rawWriteByte((byte)(millis / 10 % 10 + 48));
        b.rawWriteByte((byte)(millis % 10 + 48));
    }

    public static boolean equalBytesAny(@NotNull BytesStore b1, @NotNull BytesStore b2, long readRemaining) throws BufferUnderflowException {
        long i;
        BytesStore bs1 = b1;
        BytesStore bs2 = b2;
        if (bs1.readRemaining() < readRemaining) {
            return false;
        }
        for (i = 0L; i < readRemaining - 7L && BytesInternal.canReadBytesAt(bs1, b1.readPosition() + i, 8) && BytesInternal.canReadBytesAt(bs2, b2.readPosition() + i, 8); i += 8L) {
            long l2;
            long l1 = bs1.readLong(b1.readPosition() + i);
            if (l1 == (l2 = bs2.readLong(b2.readPosition() + i))) continue;
            return false;
        }
        while (i < readRemaining && BytesInternal.canReadBytesAt(bs1, b1.readPosition() + i, 1) && BytesInternal.canReadBytesAt(bs2, b2.readPosition() + i, 1)) {
            byte i2;
            byte i1 = bs1.readByte(b1.readPosition() + i);
            if (i1 != (i2 = bs2.readByte(b2.readPosition() + i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void appendDateMillis(@NotNull ByteStringAppender b, long timeInMS) throws BufferOverflowException {
        DateCache dateCache = dateCacheTL.get();
        if (dateCache == null) {
            dateCache = new DateCache();
            dateCacheTL.set(dateCache);
        }
        long date = timeInMS / 86400000L;
        if (dateCache.lastDay != date) {
            DateCache.access$102(dateCache, dateCache.dateFormat.format(new Date(timeInMS)).getBytes(StandardCharsets.ISO_8859_1));
            dateCache.lastDay = date;
        } else assert (dateCache.lastDateStr != null);
        b.write(dateCache.lastDateStr);
    }

    @NotNull
    public static <E extends Enum<E>, S extends StreamingDataInput<S>> E readEnum(@NotNull StreamingDataInput input, @NotNull Class<E> eClass) throws BufferUnderflowException, IORuntimeException {
        Bytes bytes = BytesInternal.acquireBytes();
        input.read8bit(bytes);
        return ((EnumInterner)EnumInterner.ENUM_INTERNER.get(eClass)).intern(bytes);
    }

    public static void writeFully(@NotNull RandomDataInput bytes, long offset, long length, @NotNull StreamingDataOutput sdo) throws BufferUnderflowException, BufferOverflowException {
        long i;
        for (i = 0L; i < length - 3L; i += 4L) {
            sdo.rawWriteInt(bytes.readInt(offset + i));
        }
        while (i < length) {
            sdo.rawWriteByte(bytes.readByte(offset + i));
            ++i;
        }
    }

    public static void copyMemory(long from, long to, int length) throws BufferUnderflowException, BufferOverflowException {
        long i;
        for (i = 0L; i < (long)(length - 7); i += 8L) {
            UnsafeMemory.UNSAFE.putLong(to, UnsafeMemory.UNSAFE.getLong(from));
            from += 8L;
            to += 8L;
        }
        while (i < (long)length) {
            UnsafeMemory.UNSAFE.putByte(to++, UnsafeMemory.UNSAFE.getByte(from++));
            ++i;
        }
    }

    @NotNull
    public static byte[] toByteArray(@NotNull RandomDataInput in) {
        int len = (int)Math.min(Integer.MAX_VALUE, in.readRemaining());
        byte[] bytes = new byte[len];
        in.read(in.readPosition(), bytes, 0, bytes.length);
        return bytes;
    }

    public static void copy(@NotNull RandomDataInput input, @NotNull OutputStream output) throws IOException {
        int len;
        byte[] bytes = new byte[512];
        long start = input.readPosition();
        int i = 0;
        while ((len = (int)input.read(start + (long)i, bytes, 0, bytes.length)) > 0) {
            output.write(bytes, 0, len);
            i += len;
        }
    }

    public static void copy(@NotNull InputStream input, @NotNull StreamingDataOutput output) throws IOException, BufferOverflowException, IllegalArgumentException {
        int len;
        byte[] bytes = new byte[512];
        while ((len = input.read(bytes)) > 0) {
            output.write(bytes, 0, len);
        }
    }

    public static Boolean parseBoolean(@NotNull ByteStringParser parser, @NotNull StopCharTester tester) throws BufferUnderflowException {
        Bytes sb = BytesInternal.acquireBytes();
        BytesInternal.parseUtf8((StreamingDataInput)parser, (Appendable)sb, tester);
        if (sb.length() == 0) {
            return null;
        }
        switch (sb.charAt(0)) {
            case 'T': 
            case 't': {
                return sb.length() == 1 || StringUtils.equalsCaseIgnore(sb, "true") ? Boolean.valueOf(true) : null;
            }
            case 'Y': 
            case 'y': {
                return sb.length() == 1 || StringUtils.equalsCaseIgnore(sb, "yes") ? Boolean.valueOf(true) : null;
            }
            case '0': {
                return sb.length() == 1 ? Boolean.valueOf(false) : null;
            }
            case '1': {
                return sb.length() == 1 ? Boolean.valueOf(true) : null;
            }
            case 'F': 
            case 'f': {
                return sb.length() == 1 || StringUtils.equalsCaseIgnore(sb, "false") ? Boolean.valueOf(false) : null;
            }
            case 'N': 
            case 'n': {
                return sb.length() == 1 || StringUtils.equalsCaseIgnore(sb, "no") ? Boolean.valueOf(false) : null;
            }
        }
        return null;
    }

    @NotNull
    public static BytesStore subBytes(RandomDataInput from, long start, long length) throws BufferUnderflowException {
        try {
            NativeBytesStore<Void> ret = NativeBytesStore.nativeStore(Math.max(0L, length));
            ret.write(0L, from, start, length);
            return ret;
        }
        catch (IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static long findByte(@NotNull RandomDataInput bytes, byte stopByte) {
        try {
            long start = bytes.readPosition();
            long remaining = bytes.readRemaining();
            for (long i = 0L; i < remaining; ++i) {
                if (bytes.readByte(start + i) != stopByte) continue;
                return i;
            }
            return -1L;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public static Bytes fromHexString(@NotNull String s2) {
        Bytes<?> in = Bytes.from(s2);
        try {
            Bytes<ByteBuffer> out = Bytes.elasticByteBuffer();
            block5: while (in.readRemaining() > 0L) {
                in.parseHexLong();
                for (int i = 0; i < 16; ++i) {
                    if (in.peekUnsignedByte() == 32) {
                        in.readSkip(1L);
                        if (in.peekUnsignedByte() == 32) break block5;
                    }
                    long value = in.parseHexLong();
                    out.rawWriteByte((byte)value);
                }
                if (in.readByte(in.readPosition() - 1L) <= 32) {
                    in.readSkip(-1L);
                }
                in.skipTo(StopCharTesters.CONTROL_STOP);
            }
            Bytes<ByteBuffer> bytes = out;
            return bytes;
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            in.release();
        }
    }

    public static void readHistogram(@NotNull StreamingDataInput in, @NotNull Histogram histogram) {
        try {
            int powersOf2 = Maths.toUInt31(in.readStopBit());
            int fractionBits = Maths.toUInt31(in.readStopBit());
            long overRange = in.readStopBit();
            long totalCount = in.readStopBit();
            long floor = in.readStopBit();
            histogram.init(powersOf2, fractionBits, overRange, totalCount, floor);
            int length = Maths.toUInt31(in.readStopBit());
            int[] ints = histogram.sampleCount();
            for (int i = 0; i < length; ++i) {
                ints[i] = Maths.toUInt31(in.readStopBit());
            }
        }
        catch (IllegalArgumentException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void writeHistogram(@NotNull StreamingDataOutput out, @NotNull Histogram histogram) throws BufferOverflowException {
        out.writeStopBit(histogram.powersOf2());
        out.writeStopBit(histogram.fractionBits());
        out.writeStopBit(histogram.overRange());
        out.writeStopBit(histogram.totalCount());
        out.writeStopBit(histogram.floor());
        int[] ints = histogram.sampleCount();
        out.writeStopBit(ints.length);
        for (int i : ints) {
            out.writeStopBit(i);
        }
    }

    public static ByteBuffer asByteBuffer(@NotNull BytesStore bytesStore) throws BufferUnderflowException {
        return BytesInternal.asByteBuffer(BYTE_BUFFER_TL, bytesStore);
    }

    public static ByteBuffer asByteBuffer2(@NotNull BytesStore bytesStore) throws BufferUnderflowException {
        return BytesInternal.asByteBuffer(BYTE_BUFFER2_TL, bytesStore);
    }

    private static ByteBuffer asByteBuffer(@NotNull ThreadLocal<ByteBuffer> byteBufferTL, @NotNull BytesStore bytesStore) throws BufferUnderflowException {
        ByteBuffer byteBuffer = byteBufferTL.get();
        BytesInternal.assignBytesStoreToByteBuffer(bytesStore, byteBuffer);
        return byteBuffer;
    }

    public static void assignBytesStoreToByteBuffer(@NotNull BytesStore bytesStore, @NotNull ByteBuffer byteBuffer) throws BufferUnderflowException {
        long address = bytesStore.addressForRead(bytesStore.readPosition());
        long capacity = bytesStore.readRemaining();
        ByteBuffers.setAddressCapacity(byteBuffer, address, capacity);
        byteBuffer.clear();
    }

    private static boolean canReadBytesAt(BytesStore bs, long offset, int length) {
        return bs.readLimit() - offset >= (long)length;
    }

    public static String parse8bit(ByteStringParser bsp, StopCharTester stopCharTester) {
        StringBuilder sb = BytesInternal.acquireStringBuilder();
        BytesInternal.parse8bit((StreamingDataInput)bsp, sb, stopCharTester);
        return SI.intern(sb);
    }

    static {
        $VALUES = new BytesInternal[0];
        HEXADECIMAL = "0123456789abcdef".toCharArray();
        BYTE_BUFFER_TL = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(0));
        BYTE_BUFFER2_TL = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(0));
        MIN_VALUE_TEXT = "-9223372036854775808".getBytes(StandardCharsets.ISO_8859_1);
        SBP = new StringBuilderPool();
        BP = new BytesPool();
        SI = new StringInternerBytes(4096);
        Infinity = "Infinity".getBytes(StandardCharsets.ISO_8859_1);
        NaN = "NaN".getBytes(StandardCharsets.ISO_8859_1);
        NUMBER_BUFFER = ThreadLocal.withInitial(() -> new byte[20]);
        dateCacheTL = new ThreadLocal();
        MAX_STRING_LEN = Integer.getInteger("bytes.max-string-len", 131072);
        try {
            ClassAliasPool.CLASS_ALIASES.addAlias(BytesStore.class, "!binary");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    static class DateCache {
        final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        private long lastDay = Long.MIN_VALUE;
        @Nullable
        private byte[] lastDateStr = null;

        DateCache() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        static /* synthetic */ byte[] access$102(DateCache x0, byte[] x1) {
            x0.lastDateStr = x1;
            return x1;
        }
    }
}

