/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.algo;

import java.nio.ByteOrder;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.bytes.algo.VanillaBytesStoreHash;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OptimisedBytesStoreHash implements BytesStoreHash<BytesStore>
{
    INSTANCE;

    @Nullable
    public static final Memory MEMORY;
    public static final boolean IS_LITTLE_ENDIAN;
    private static final int TOP_BYTES;

    static long applyAsLong1to7(@NotNull BytesStore store, int remaining) {
        long address = store.addressForRead(store.readPosition());
        return OptimisedBytesStoreHash.hash(OptimisedBytesStoreHash.readIncompleteLong(address, remaining));
    }

    static long applyAsLong8(@NotNull BytesStore store) {
        long address = store.addressForRead(store.readPosition());
        return OptimisedBytesStoreHash.hash0(MEMORY.readLong(address), MEMORY.readInt(address + (long)TOP_BYTES));
    }

    public static long hash(long l) {
        return OptimisedBytesStoreHash.hash0(l, l >> 32);
    }

    static long hash0(long l, long hi) {
        return VanillaBytesStoreHash.agitate(l * 1829709757L + hi * -1040990263L);
    }

    static long applyAsLong9to16(@NotNull BytesStore store, int remaining) {
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.addressForRead(store.readPosition());
        long h0 = (long)remaining * 1829709757L;
        int left = remaining;
        long addrI = address;
        long l0 = OptimisedBytesStoreHash.readIncompleteLong(addrI, left);
        int l0a = (int)(l0 >> 32);
        long l1 = OptimisedBytesStoreHash.readIncompleteLong(addrI + 8L, left - 8);
        int l1a = (int)(l1 >> 32);
        long l2 = 0L;
        boolean l2a = false;
        long l3 = 0L;
        boolean l3a = false;
        long h1 = (l1 + 0L - 0L) * -361396777L;
        long h2 = (0L - (long)l0a) * 2053402137L;
        long h3 = (0L + (long)l0a - (long)l1a) * -2057448229L;
        return VanillaBytesStoreHash.agitate(h0 += (l0 + (long)l1a - 0L) * 1539836845L) ^ VanillaBytesStoreHash.agitate(h1) ^ VanillaBytesStoreHash.agitate(h2) ^ VanillaBytesStoreHash.agitate(h3);
    }

    static long applyAsLong17to32(@NotNull BytesStore store, int remaining) {
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.addressForRead(store.readPosition());
        long h0 = (long)remaining * 1829709757L;
        int left = remaining;
        long addrI = address;
        long l0 = MEMORY.readLong(addrI);
        int l0a = MEMORY.readInt(addrI + (long)TOP_BYTES);
        long l1 = MEMORY.readLong(addrI + 8L);
        int l1a = MEMORY.readInt(addrI + 8L + (long)TOP_BYTES);
        long l2 = OptimisedBytesStoreHash.readIncompleteLong(addrI + 16L, left - 16);
        int l2a = (int)(l2 >> 32);
        long l3 = OptimisedBytesStoreHash.readIncompleteLong(addrI + 24L, left - 24);
        int l3a = (int)(l3 >> 32);
        long h1 = (l1 + (long)l2a - (long)l3a) * -361396777L;
        long h2 = (l2 + (long)l3a - (long)l0a) * 2053402137L;
        long h3 = (l3 + (long)l0a - (long)l1a) * -2057448229L;
        return VanillaBytesStoreHash.agitate(h0 += (l0 + (long)l1a - (long)l2a) * 1539836845L) ^ VanillaBytesStoreHash.agitate(h1) ^ VanillaBytesStoreHash.agitate(h2) ^ VanillaBytesStoreHash.agitate(h3);
    }

    public static long applyAsLong32bytesMultiple(@NotNull BytesStore store, int remaining) {
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.addressForRead(store.readPosition());
        long h0 = remaining * 1829709757;
        long h1 = 0L;
        long h2 = 0L;
        long h3 = 0L;
        for (int i = 0; i < remaining - 31; i += 32) {
            if (i > 0) {
                h0 *= 1829709757L;
                h1 *= -1040990263L;
                h2 *= 1796809623L;
                h3 *= 1804686935L;
            }
            long addrI = address + (long)i;
            long l0 = MEMORY.readLong(addrI);
            int l0a = MEMORY.readInt(addrI + (long)TOP_BYTES);
            long l1 = MEMORY.readLong(addrI + 8L);
            int l1a = MEMORY.readInt(addrI + 8L + (long)TOP_BYTES);
            long l2 = MEMORY.readLong(addrI + 16L);
            int l2a = MEMORY.readInt(addrI + 16L + (long)TOP_BYTES);
            long l3 = MEMORY.readLong(addrI + 24L);
            int l3a = MEMORY.readInt(addrI + 24L + (long)TOP_BYTES);
            h0 += (l0 + (long)l1a - (long)l2a) * 1539836845L;
            h1 += (l1 + (long)l2a - (long)l3a) * -361396777L;
            h2 += (l2 + (long)l3a - (long)l0a) * 2053402137L;
            h3 += (l3 + (long)l0a - (long)l1a) * -2057448229L;
        }
        return VanillaBytesStoreHash.agitate(h0) ^ VanillaBytesStoreHash.agitate(h1) ^ VanillaBytesStoreHash.agitate(h2) ^ VanillaBytesStoreHash.agitate(h3);
    }

    public static long applyAsLongAny(@NotNull BytesStore store, long remaining) {
        NativeBytesStore bytesStore = (NativeBytesStore)store.bytesStore();
        long address = bytesStore.addressForRead(store.readPosition());
        long h0 = remaining * 1829709757L;
        long h1 = 0L;
        long h2 = 0L;
        long h3 = 0L;
        int i = 0;
        while ((long)i < remaining - 31L) {
            if (i > 0) {
                h0 *= 1829709757L;
                h1 *= -1040990263L;
                h2 *= 1796809623L;
                h3 *= 1804686935L;
            }
            long addrI = address + (long)i;
            long l0 = MEMORY.readLong(addrI);
            int l0a = MEMORY.readInt(addrI + (long)TOP_BYTES);
            long l1 = MEMORY.readLong(addrI + 8L);
            int l1a = MEMORY.readInt(addrI + 8L + (long)TOP_BYTES);
            long l2 = MEMORY.readLong(addrI + 16L);
            int l2a = MEMORY.readInt(addrI + 16L + (long)TOP_BYTES);
            long l3 = MEMORY.readLong(addrI + 24L);
            int l3a = MEMORY.readInt(addrI + 24L + (long)TOP_BYTES);
            h0 += (l0 + (long)l1a - (long)l2a) * 1539836845L;
            h1 += (l1 + (long)l2a - (long)l3a) * -361396777L;
            h2 += (l2 + (long)l3a - (long)l0a) * 2053402137L;
            h3 += (l3 + (long)l0a - (long)l1a) * -2057448229L;
            i += 32;
        }
        long left = remaining - (long)i;
        if (left > 0L) {
            if (i > 0) {
                h0 *= 1829709757L;
                h1 *= -1040990263L;
                h2 *= 1796809623L;
                h3 *= 1804686935L;
            }
            long addrI = address + (long)i;
            if (left <= 16L) {
                long l0 = OptimisedBytesStoreHash.readIncompleteLong(addrI, (int)left);
                int l0a = (int)(l0 >> 32);
                long l1 = OptimisedBytesStoreHash.readIncompleteLong(addrI + 8L, (int)(left - 8L));
                int l1a = (int)(l1 >> 32);
                long l2 = 0L;
                boolean l2a = false;
                long l3 = 0L;
                boolean l3a = false;
                h0 += (l0 + (long)l1a - 0L) * 1539836845L;
                h1 += (l1 + 0L - 0L) * -361396777L;
                h2 += (0L - (long)l0a) * 2053402137L;
                h3 += (0L + (long)l0a - (long)l1a) * -2057448229L;
            } else {
                long l0 = MEMORY.readLong(addrI);
                int l0a = MEMORY.readInt(addrI + (long)TOP_BYTES);
                long l1 = MEMORY.readLong(addrI + 8L);
                int l1a = MEMORY.readInt(addrI + 8L + (long)TOP_BYTES);
                long l2 = OptimisedBytesStoreHash.readIncompleteLong(addrI + 16L, (int)(left - 16L));
                int l2a = (int)(l2 >> 32);
                long l3 = OptimisedBytesStoreHash.readIncompleteLong(addrI + 24L, (int)(left - 24L));
                int l3a = (int)(l3 >> 32);
                h0 += (l0 + (long)l1a - (long)l2a) * 1539836845L;
                h1 += (l1 + (long)l2a - (long)l3a) * -361396777L;
                h2 += (l2 + (long)l3a - (long)l0a) * 2053402137L;
                h3 += (l3 + (long)l0a - (long)l1a) * -2057448229L;
            }
        }
        return VanillaBytesStoreHash.agitate(h0) ^ VanillaBytesStoreHash.agitate(h1) ^ VanillaBytesStoreHash.agitate(h2) ^ VanillaBytesStoreHash.agitate(h3);
    }

    static long readIncompleteLong(long address, int len) {
        switch (len) {
            case 1: {
                return MEMORY.readByte(address);
            }
            case 2: {
                return MEMORY.readShort(address);
            }
            case 3: {
                return IS_LITTLE_ENDIAN ? (long)((MEMORY.readShort(address) & 0xFFFF) + ((MEMORY.readByte(address + 2L) & 0xFF) << 16)) : (long)(((MEMORY.readShort(address) & 0xFFFF) << 8) + (MEMORY.readByte(address + 2L) & 0xFF));
            }
            case 4: {
                return MEMORY.readInt(address);
            }
            case 5: {
                return IS_LITTLE_ENDIAN ? ((long)MEMORY.readInt(address) & 0xFFFFFFFFL) + ((long)(MEMORY.readByte(address + 4L) & 0xFF) << 32) : (((long)MEMORY.readInt(address) & 0xFFFFFFFFL) << 8) + (long)(MEMORY.readByte(address + 4L) & 0xFF);
            }
            case 6: {
                return IS_LITTLE_ENDIAN ? ((long)MEMORY.readInt(address) & 0xFFFFFFFFL) + ((long)(MEMORY.readShort(address + 4L) & 0xFFFF) << 32) : (((long)MEMORY.readInt(address) & 0xFFFFFFFFL) << 16) + (long)(MEMORY.readShort(address + 4L) & 0xFFFF);
            }
            case 7: {
                return IS_LITTLE_ENDIAN ? ((long)MEMORY.readInt(address) & 0xFFFFFFFFL) + ((long)(MEMORY.readShort(address + 4L) & 0xFFFF) << 32) + ((long)(MEMORY.readByte(address + 6L) & 0xFF) << 48) : (((long)MEMORY.readInt(address) & 0xFFFFFFFFL) << 24) + (long)((MEMORY.readShort(address + 4L) & 0xFFFF) << 8) + (long)(MEMORY.readByte(address + 6L) & 0xFF);
            }
        }
        return len >= 8 ? MEMORY.readLong(address) : 0L;
    }

    @Override
    public long applyAsLong(@NotNull BytesStore store) {
        int remaining = Maths.toInt32(store.readRemaining());
        return this.applyAsLong(store, remaining);
    }

    @Override
    public long applyAsLong(@NotNull BytesStore store, long remaining) {
        if (remaining <= 16L) {
            if (remaining == 0L) {
                return 0L;
            }
            if (remaining < 8L) {
                return OptimisedBytesStoreHash.applyAsLong1to7(store, (int)remaining);
            }
            if (remaining == 8L) {
                return OptimisedBytesStoreHash.applyAsLong8(store);
            }
            return OptimisedBytesStoreHash.applyAsLong9to16(store, (int)remaining);
        }
        if (remaining <= 32L) {
            return OptimisedBytesStoreHash.applyAsLong17to32(store, (int)remaining);
        }
        if ((remaining & 0x1FL) == 0L) {
            return OptimisedBytesStoreHash.applyAsLong32bytesMultiple(store, (int)remaining);
        }
        return OptimisedBytesStoreHash.applyAsLongAny(store, remaining);
    }

    static {
        MEMORY = OS.memory();
        IS_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
        TOP_BYTES = IS_LITTLE_ENDIAN ? 4 : 0;
    }
}

