/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.bytes.HeapBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.hash.AbstractData;
import net.openhft.chronicle.hash.Data;
import net.openhft.chronicle.hash.serialization.DataAccess;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ByteArrayDataAccess
extends AbstractData<byte[]>
implements DataAccess<byte[]> {
    private transient HeapBytesStore<byte[]> bs;
    private transient byte[] array;

    public ByteArrayDataAccess() {
        this.initTransients();
    }

    private void initTransients() {
        this.bs = null;
    }

    @Override
    public RandomDataInput bytes() {
        return this.bs;
    }

    @Override
    public long offset() {
        return this.bs.start();
    }

    @Override
    public long size() {
        return this.bs.capacity();
    }

    @Override
    public byte[] get() {
        return this.array;
    }

    @Override
    public byte[] getUsing(@Nullable byte[] using) {
        if (using == null || using.length != this.array.length) {
            using = new byte[this.array.length];
        }
        System.arraycopy(this.array, 0, using, 0, this.array.length);
        return using;
    }

    @Override
    public Data<byte[]> getData(@NotNull byte[] instance) {
        this.array = instance;
        this.bs = HeapBytesStore.wrap(this.array);
        return this;
    }

    @Override
    public void uninit() {
        this.array = null;
        this.bs = null;
    }

    @Override
    public DataAccess<byte[]> copy() {
        return new ByteArrayDataAccess();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wireOut) {
    }

    @Override
    public void readMarshallable(@NotNull WireIn wireIn) {
        this.initTransients();
    }

    @Override
    public String toString() {
        return new String(this.array, 0, 0, this.array.length);
    }
}

