/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.impl;

import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public abstract class InstanceCreatingMarshaller<T>
implements Marshallable {
    private Class<T> tClass;

    protected InstanceCreatingMarshaller(Class<T> tClass) {
        this.tClass = tClass;
    }

    protected Class<T> tClass() {
        return this.tClass;
    }

    protected T createInstance() {
        try {
            return ObjectUtils.newInstance(this.tClass);
        }
        catch (Exception e) {
            throw new IllegalStateException("Some of default marshallers, chosen for the type\n" + this.tClass + " by default, delegate to \n" + this.getClass().getName() + " which assumes the type has a public no-arg\nconstructor. If this is not true, you should either extend the marshaller,\noverriding createInstance() and copy() (if defined), and the extending\nclass shouldn't be inner, because such classes couldn't be Serializable\nthat is a requirement for marshaller classes, or write and configure your\nown marshaller for " + this.tClass + " type from scratch, and configure for the\nChronicle Map via keyMarshaller[s]() or valueMarshaller[s]() methods", e);
        }
    }

    @Override
    public void readMarshallable(@NotNull WireIn wireIn) {
        this.tClass = wireIn.read(() -> "tClass").typeLiteral();
    }

    @Override
    public void writeMarshallable(@NotNull WireOut wireOut) {
        wireOut.write(() -> "tClass").typeLiteral(this.tClass);
    }
}

