/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.math.BigInteger;
import java.util.Arrays;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.wire.Base85LongConverter;
import net.openhft.chronicle.wire.LongConverter;

public class Base40LongConverter
implements LongConverter {
    public static final Base40LongConverter INSTANCE = new Base40LongConverter();
    private static final String CHARS = ".ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_:+";
    private static final char[] DECODE = ".ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_:+".toCharArray();
    private static final byte[] ENCODE = new byte[128];
    private static final int BASE = 40;
    static final BigInteger BASE_BI = BigInteger.valueOf(40L);

    @Override
    public long parse(CharSequence text) {
        long v = 0L;
        for (int i = 0; i < text.length(); ++i) {
            byte b = ENCODE[text.charAt(i)];
            if (b < 0) continue;
            v = v * 40L + (long)b;
        }
        return v;
    }

    @Override
    public void append(StringBuilder text, long value) {
        int start = text.length();
        if (value < 0L) {
            BigInteger bi = BigInteger.valueOf(value).add(Base85LongConverter.TWO_TO_64);
            int v = bi.mod(BASE_BI).intValueExact();
            value = bi.divide(BASE_BI).longValueExact();
            text.append(DECODE[v]);
        }
        while (value != 0L) {
            int v = (int)(value % 40L);
            value /= 40L;
            text.append(DECODE[v]);
        }
        StringUtils.reverse(text, start);
    }

    static {
        assert (DECODE.length == 40);
        Arrays.fill(ENCODE, (byte)-1);
        for (int i = 0; i < DECODE.length; ++i) {
            char c = DECODE[i];
            Base40LongConverter.ENCODE[c] = (byte)i;
        }
    }
}

