/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import thredds.server.catalog.CatalogReader;
import thredds.server.catalog.ConfigCatalog;
import thredds.server.catalog.builder.ConfigCatalogBuilder;
import ucar.unidata.util.StringUtil2;

@Component
@DependsOn(value={"TdsContext"})
public class ConfigCatalogCache
implements CatalogReader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigCatalogCache.class);
    private static final String ERROR = "*** ERROR ";
    private String rootPath;
    private Cache<String, ConfigCatalog> cache;

    public ConfigCatalogCache() {
    }

    public ConfigCatalogCache(String rootPath, int maxSize) {
        this.rootPath = rootPath;
        this.cache = CacheBuilder.newBuilder().maximumSize(maxSize).recordStats().build();
    }

    public void init(String rootPath, int maxSize) {
        this.rootPath = rootPath;
        this.cache = CacheBuilder.newBuilder().maximumSize(maxSize).recordStats().build(new CacheLoader<String, ConfigCatalog>(){

            @Override
            public ConfigCatalog load(String key) throws IOException {
                return ConfigCatalogCache.readCatalog(key);
            }
        });
    }

    public void put(String catKey, ConfigCatalog cat) throws IOException {
        this.cache.put(catKey, cat);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public ConfigCatalog getFromAbsolutePath(String catalogFullPath) throws IOException {
        if ((catalogFullPath = catalogFullPath.replace("\\", "/")).startsWith(this.rootPath)) {
            String catKey = catalogFullPath.substring(this.rootPath.length());
            return this.get(catKey);
        }
        return ConfigCatalogCache.readCatalog(catalogFullPath);
    }

    public ConfigCatalog get(String catKey) throws IOException {
        try {
            return this.cache.get(catKey, () -> ConfigCatalogCache.readCatalog(this.rootPath + catKey));
        }
        catch (ExecutionException e) {
            Throwable c = e.getCause();
            if (c instanceof IOException) {
                throw (IOException)c;
            }
            throw new RuntimeException(e.getCause());
        }
    }

    public static ConfigCatalog readCatalog(String catalogFullPath) throws IOException {
        URI uri;
        File catFile = new File(catalogFullPath);
        if (!catFile.exists()) {
            int pos = catalogFullPath.indexOf("content/thredds/");
            String filename = pos > 0 ? catalogFullPath.substring(pos + 16) : catalogFullPath;
            throw new FileNotFoundException(filename);
        }
        try {
            uri = new URI("file:" + StringUtil2.escape(catalogFullPath, "/:-_."));
        }
        catch (URISyntaxException e) {
            logger.error("*** ERROR readCatalog(): URISyntaxException=" + e.getMessage());
            return null;
        }
        ConfigCatalogBuilder builder = new ConfigCatalogBuilder();
        ConfigCatalog cat = (ConfigCatalog)builder.buildFromURI(uri);
        if (builder.hasFatalError()) {
            throw new IOException("invalid catalog " + catalogFullPath);
        }
        return cat;
    }
}

