/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Optional;
import org.jdom2.Attribute;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import thredds.client.catalog.Catalog;
import thredds.server.catalog.DatasetScanConfig;
import ucar.nc2.util.AliasTranslator;
import ucar.unidata.util.StringUtil2;

public class DatasetScanConfigBuilder {
    Formatter errlog;
    boolean fatalError;

    public DatasetScanConfigBuilder(Formatter errlog) {
        this.errlog = errlog;
    }

    public boolean hasFatalError() {
        return this.fatalError;
    }

    public DatasetScanConfig readDatasetScanConfig(Element dsElem) {
        String scanDir;
        DatasetScanConfig result = new DatasetScanConfig();
        result.name = dsElem.getAttributeValue("name");
        result.path = StringUtil2.trim(dsElem.getAttributeValue("path"), 47);
        if (result.path == null) {
            this.errlog.format("ERROR: must specify path attribute.%n", new Object[0]);
            this.fatalError = true;
        }
        if ((scanDir = dsElem.getAttributeValue("location")) == null) {
            this.errlog.format("ERROR: must specify directory root in location attribute.%n", new Object[0]);
            this.fatalError = true;
        } else {
            result.scanDir = AliasTranslator.translateAlias(scanDir);
            File scanFile = new File(result.scanDir);
            if (!scanFile.exists()) {
                this.errlog.format("ERROR: directory %s does not exist%n", result.scanDir);
                this.fatalError = true;
            }
        }
        result.restrictAccess = dsElem.getAttributeValue("restrictAccess");
        Element ncmlElem = dsElem.getChild("netcdf", Catalog.defNS);
        if (ncmlElem != null) {
            ncmlElem.detach();
            result.ncmlElement = ncmlElem;
        }
        Element filterElem = dsElem.getChild("filter", Catalog.defNS);
        result.filters = this.readDatasetScanFilter(filterElem);
        Element namerElem = dsElem.getChild("namer", Catalog.defNS);
        result.namers = this.readDatasetScanNamer(namerElem);
        Element filesSortElem = dsElem.getChild("filesSort", Catalog.defNS);
        if (filesSortElem != null) {
            result.isSortIncreasing = this.readFilesSort(filesSortElem);
        }
        Element sorterElem = dsElem.getChild("sort", Catalog.defNS);
        if (!result.isSortIncreasing.isPresent() && sorterElem != null) {
            result.isSortIncreasing = this.readSort(sorterElem);
        }
        String addLatestAttribute = dsElem.getAttributeValue("addLatest");
        Element addLatestElem = dsElem.getChild("addLatest", Catalog.defNS);
        Element addProxiesElem = dsElem.getChild("addProxies", Catalog.defNS);
        result.addLatest = this.readDatasetScanAddProxies(addProxiesElem, addLatestElem, addLatestAttribute);
        Element addTimeCovElem = dsElem.getChild("addTimeCoverage", Catalog.defNS);
        if (addTimeCovElem != null) {
            result.addTimeCoverage = this.readDatasetScanAddTimeCoverage(addTimeCovElem);
        }
        return result;
    }

    private List<DatasetScanConfig.Filter> readDatasetScanFilter(Element filterElem) {
        ArrayList<DatasetScanConfig.Filter> filters = new ArrayList<DatasetScanConfig.Filter>();
        if (filterElem == null) {
            return null;
        }
        for (Element curElem : filterElem.getChildren()) {
            String regExpAttVal = curElem.getAttributeValue("regExp");
            String wildcardAttVal = curElem.getAttributeValue("wildcard");
            String lastModLimitAttValS = curElem.getAttributeValue("lastModLimitInMillis");
            if (regExpAttVal == null && wildcardAttVal == null && lastModLimitAttValS == null) {
                this.errlog.format("WARN: readDatasetScanFilter(): no regExp, wildcard, or lastModLimitInMillis attribute in filter child <%s>%n", curElem.getName());
                continue;
            }
            String atomicAttVal = curElem.getAttributeValue("atomic");
            boolean atomic = atomicAttVal == null || !atomicAttVal.equalsIgnoreCase("false");
            String collectionAttVal = curElem.getAttributeValue("collection");
            boolean notCollection = collectionAttVal == null || !collectionAttVal.equalsIgnoreCase("true");
            boolean includer = true;
            if (curElem.getName().equals("exclude")) {
                includer = false;
            } else if (!curElem.getName().equals("include")) {
                this.errlog.format("WARN: readDatasetScanFilter(): unhandled filter child <%s>.%n", curElem.getName());
                continue;
            }
            long lastModLimitAttVal = -1L;
            if (lastModLimitAttValS != null) {
                try {
                    lastModLimitAttVal = Long.parseLong(lastModLimitAttValS);
                }
                catch (NumberFormatException e) {
                    this.errlog.format("WARN: readDatasetScanFilter(): lastModLimitInMillis not valid <%s>.%n", curElem);
                }
            }
            filters.add(new DatasetScanConfig.Filter(regExpAttVal, wildcardAttVal, lastModLimitAttVal, atomic, !notCollection, includer));
        }
        return filters;
    }

    protected List<DatasetScanConfig.Namer> readDatasetScanNamer(Element namerElem) {
        ArrayList<DatasetScanConfig.Namer> result = new ArrayList<DatasetScanConfig.Namer>();
        if (namerElem == null) {
            return result;
        }
        for (Element curElem : namerElem.getChildren()) {
            String regExp = curElem.getAttributeValue("regExp");
            String replaceString = curElem.getAttributeValue("replaceString");
            boolean onName = curElem.getName().equals("regExpOnName");
            boolean onPath = curElem.getName().equals("regExpOnPath");
            if (!onName && !onPath) {
                this.errlog.format("WARN: readDatasetScanNamer(): namer child '%s'%n", curElem.getName());
                continue;
            }
            result.add(new DatasetScanConfig.Namer(onName, regExp, replaceString));
        }
        return result;
    }

    protected Optional<Boolean> readFilesSort(Element sorterElem) {
        String increasingString = sorterElem.getAttributeValue("increasing");
        if (increasingString != null) {
            if (increasingString.equalsIgnoreCase("true")) {
                return Optional.of(true);
            }
            if (increasingString.equalsIgnoreCase("false")) {
                return Optional.of(false);
            }
        }
        return Optional.empty();
    }

    protected Optional<Boolean> readSort(Element sorterElem) {
        String increasingString;
        Element lexSortElem = sorterElem.getChild("lexigraphicByName", Catalog.defNS);
        if (lexSortElem != null && (increasingString = lexSortElem.getAttributeValue("increasing")) != null) {
            if (increasingString.equalsIgnoreCase("true")) {
                return Optional.of(true);
            }
            if (increasingString.equalsIgnoreCase("false")) {
                return Optional.of(false);
            }
        }
        return Optional.empty();
    }

    protected DatasetScanConfig.AddLatest readDatasetScanAddProxies(Element addProxiesElem, Element addLatestElem, String addLatestAttribute) {
        if (addLatestAttribute != null && addLatestAttribute.equalsIgnoreCase("true")) {
            return new DatasetScanConfig.AddLatest();
        }
        if (addLatestElem != null) {
            return this.readDatasetScanAddLatest(addLatestElem);
        }
        if (addProxiesElem != null) {
            for (Element curChildElem : addProxiesElem.getChildren()) {
                if (curChildElem.getName().equals("simpleLatest")) {
                    return this.readDatasetScanAddLatest(curChildElem);
                }
                if (!curChildElem.getName().equals("latestComplete")) continue;
                return this.readDatasetScanAddLatest(curChildElem);
            }
        }
        return null;
    }

    private DatasetScanConfig.AddLatest readDatasetScanAddLatest(Element addLatestElem) {
        Attribute topAtt;
        String tmpserviceName;
        String latestName = "latest.xml";
        String serviceName = "Resolver";
        boolean latestOnTop = true;
        boolean isResolver = true;
        String tmpLatestName = addLatestElem.getAttributeValue("name");
        if (tmpLatestName != null) {
            latestName = tmpLatestName;
        }
        if ((tmpserviceName = addLatestElem.getAttributeValue("serviceName")) != null) {
            serviceName = tmpserviceName;
        }
        if ((topAtt = addLatestElem.getAttribute("top")) != null) {
            try {
                latestOnTop = topAtt.getBooleanValue();
            }
            catch (DataConversionException e) {
                latestOnTop = true;
            }
        }
        String lastModLimitVal = addLatestElem.getAttributeValue("lastModifiedLimit");
        long lastModLimit = -1L;
        if (lastModLimitVal != null) {
            lastModLimit = Long.parseLong(lastModLimitVal) * 60L * 1000L;
        }
        return new DatasetScanConfig.AddLatest(latestName, serviceName, latestOnTop, lastModLimit);
    }

    protected DatasetScanConfig.AddTimeCoverage readDatasetScanAddTimeCoverage(Element addTimeCovElem) {
        String matchName = addTimeCovElem.getAttributeValue("datasetNameMatchPattern");
        String matchPath = addTimeCovElem.getAttributeValue("datasetPathMatchPattern");
        String subst = addTimeCovElem.getAttributeValue("startTimeSubstitutionPattern");
        String duration = addTimeCovElem.getAttributeValue("duration");
        boolean err = false;
        if (subst == null) {
            this.errlog.format("WARN: readDatasetScanAddTimeCoverage(): must have startTimeSubstitutionPattern elem=<%s>%n", addTimeCovElem);
            err = true;
        } else if (duration == null) {
            this.errlog.format("WARN: readDatasetScanAddTimeCoverage(): must have duration elem=<%s>%n", addTimeCovElem);
            err = true;
        } else if (matchName == null && matchPath == null) {
            this.errlog.format("WARN: readDatasetScanAddTimeCoverage(): must have either datasetNameMatchPattern or datasetPathMatchPattern elem=<%s>%n", addTimeCovElem);
            err = true;
        }
        return err ? null : new DatasetScanConfig.AddTimeCoverage(matchName, matchPath, subst, duration);
    }
}

