/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.tracker;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import thredds.server.catalog.tracker.DataRootExt;
import thredds.server.catalog.tracker.DatasetTracker;

public class DataRootTracker {
    private static final String dbname = "/datarootTracker.dat";
    String filepath;
    Set<DataRootExt> dataRoots;
    boolean changed;
    DatasetTracker.Callback callback;

    public DataRootTracker(String pathname, boolean startOver, DatasetTracker.Callback callback) {
        this.filepath = pathname + dbname;
        this.callback = callback;
        File file = new File(this.filepath);
        if (startOver) {
            this.reinit();
        }
        if (!file.exists() || startOver || this.readDataRoots() <= 0) {
            this.dataRoots = new HashSet<DataRootExt>();
            this.changed = true;
        }
    }

    private void reinit() {
        boolean wasDeleted;
        File file = new File(this.filepath);
        if (file.exists() && !(wasDeleted = file.delete())) {
            throw new IllegalStateException("DatasetTrackerMapDB not able to delete " + this.filepath);
        }
        this.dataRoots = new HashSet<DataRootExt>();
        this.changed = true;
    }

    public boolean trackDataRoot(DataRootExt ds) {
        this.changed = true;
        if (this.callback != null) {
            this.callback.hasDataRoot(ds);
        }
        return this.dataRoots.add(ds);
    }

    boolean removeDataRoot(DataRootExt ds) {
        this.changed = true;
        return this.dataRoots.remove(ds);
    }

    public Iterable<? extends DataRootExt> getDataRoots() {
        return this.dataRoots;
    }

    private int readDataRoots() {
        this.dataRoots = new HashSet<DataRootExt>();
        int count = 0;
        try (DataInputStream in = new DataInputStream(new FileInputStream(this.filepath));){
            while (in.available() > 0) {
                DataRootExt ext = new DataRootExt();
                ext.readExternal(in);
                this.dataRoots.add(ext);
                ++count;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        return count;
    }

    public void save() throws IOException {
        if (!this.changed) {
            return;
        }
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.filepath));){
            for (DataRootExt ext : this.dataRoots) {
                ext.writeExternal(out);
            }
        }
        this.changed = false;
    }
}

