/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog.tracker;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Formatter;
import thredds.server.catalog.tracker.ConfigCatalogExtProto;

public class DatasetExt
implements Externalizable {
    public static int total_count = 0;
    public static long total_nbytes = 0L;
    private static final boolean showParsedXML = false;
    long catId;
    String ncml;
    String restrictedAccess;

    public String getNcml() {
        return this.ncml;
    }

    public String getRestrictAccess() {
        return this.restrictedAccess;
    }

    public DatasetExt() {
    }

    public DatasetExt(long catId, String restrictedAccess, String ncml) {
        this.catId = catId;
        this.restrictedAccess = restrictedAccess;
        this.ncml = ncml;
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("DatasetTrackerInfo{ catId=%d, restrict=%s", this.catId, this.restrictedAccess);
        if (this.ncml != null) {
            f.format("%n%s%n", this.ncml);
        }
        f.format("}", new Object[0]);
        return f.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ConfigCatalogExtProto.Dataset.Builder builder = ConfigCatalogExtProto.Dataset.newBuilder();
        builder.setCatId(this.catId);
        builder.setName("");
        if (this.restrictedAccess != null) {
            builder.setRestrict(this.restrictedAccess);
        }
        if (this.ncml != null) {
            builder.setNcml(this.ncml);
        }
        ConfigCatalogExtProto.Dataset index = builder.build();
        byte[] b = index.toByteArray();
        out.writeInt(b.length);
        out.write(b);
        ++total_count;
        total_nbytes += (long)(b.length + 4);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int avail = in.available();
        int len = in.readInt();
        byte[] b = new byte[len];
        int n = in.read(b);
        if (n != len) {
            throw new RuntimeException("barf with read size=" + len + " in.available=" + avail);
        }
        ConfigCatalogExtProto.Dataset pDataset = ConfigCatalogExtProto.Dataset.parseFrom(b);
        this.catId = pDataset.getCatId();
        if (pDataset.getRestrict().length() > 0) {
            this.restrictedAccess = pDataset.getRestrict();
        }
        if (pDataset.getNcml().length() > 0) {
            this.ncml = pDataset.getNcml();
        }
    }
}

