/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.EnhanceScaleMissingUnsigned;
import ucar.nc2.dataset.EnhanceScaleMissingUnsignedImpl;
import ucar.nc2.dataset.EnhancementsImpl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.internal.dataset.CoordinatesHelper;
import ucar.nc2.util.CancelTask;

public class VariableDS
extends Variable
implements VariableEnhanced,
EnhanceScaleMissingUnsigned {
    private EnhancementsImpl enhanceProxy;
    private List<String> coordSysNames;
    private EnhanceScaleMissingUnsignedImpl scaleMissingUnsignedProxy = new EnhanceScaleMissingUnsignedImpl();
    private Set<NetcdfDataset.Enhance> enhanceMode = EnumSet.noneOf(NetcdfDataset.Enhance.class);
    protected Variable orgVar;
    protected DataType orgDataType;
    protected String orgName;
    String orgFileTypeId;

    @Deprecated
    public VariableDS(NetcdfDataset ds, Group group, Structure parentStructure, String shortName, DataType dataType, String dims, String units, String desc) {
        super(ds, group, parentStructure, shortName);
        this.setDataType(dataType);
        this.setDimensions(dims);
        this.orgDataType = dataType;
        if (dataType == DataType.STRUCTURE) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + shortName);
        }
        if (units != null) {
            this.addAttribute(new Attribute("units", units.trim()));
        }
        if (desc != null) {
            this.addAttribute(new Attribute("long_name", desc));
        }
        this.enhanceProxy = new EnhancementsImpl(this, units, desc);
    }

    @Deprecated
    public VariableDS(Group group, Structure parent, String shortName, Variable orgVar) {
        super(null, group, parent, shortName);
        this.setDimensions(this.getDimensionsString());
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getFullName());
        }
        this.ncfile = null;
        this.spiObject = null;
        this.createNewCache();
        this.orgVar = orgVar;
        this.orgDataType = orgVar.getDataType();
        this.enhanceProxy = new EnhancementsImpl(this);
    }

    @Deprecated
    public VariableDS(Group g2, Variable orgVar, boolean enhance) {
        super(orgVar);
        String units;
        if (g2 != null) {
            this.setParentGroup(g2);
        }
        this.setDimensions(this.getDimensionsString());
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getFullName());
        }
        this.ncfile = null;
        this.spiObject = null;
        this.createNewCache();
        this.orgVar = orgVar;
        this.orgDataType = orgVar.getDataType();
        this.orgFileTypeId = orgVar.getFileTypeId();
        this.enhanceProxy = new EnhancementsImpl(this);
        if (enhance) {
            this.enhance(NetcdfDataset.getDefaultEnhanceMode());
        }
        if ((units = orgVar.getUnitsString()) != null) {
            this.setUnitsString(units.trim());
        }
    }

    @Deprecated
    protected VariableDS(VariableDS vds, boolean isCopy) {
        super(vds);
        this.orgVar = vds;
        this.orgDataType = vds.orgDataType;
        this.orgName = vds.orgName;
        this.enhanceProxy = new EnhancementsImpl(this);
        this.scaleMissingUnsignedProxy = vds.scaleMissingUnsignedProxy;
        String units = vds.getUnitsString();
        if (units != null) {
            this.setUnitsString(units.trim());
        }
        if (!isCopy) {
            this.createNewCache();
        }
    }

    @Override
    public NetcdfFile getNetcdfFile() {
        return this.group == null ? null : this.group.getNetcdfFile();
    }

    @Override
    protected VariableDS copy() {
        return new VariableDS(this, true);
    }

    @Override
    @Deprecated
    public void clearCoordinateSystems() {
        this.enhanceProxy = new EnhancementsImpl(this, this.getUnitsString(), this.getDescription());
    }

    @Override
    @Deprecated
    public void enhance(Set<NetcdfDataset.Enhance> enhancements) {
        this.enhanceMode = EnumSet.copyOf(enhancements);
        if (this.orgVar instanceof VariableDS) {
            for (NetcdfDataset.Enhance orgVarEnhancement : ((VariableDS)this.orgVar).getEnhanceMode()) {
                this.enhanceMode.remove((Object)orgVarEnhancement);
            }
        }
        this.setDataType(this.orgDataType);
        this.scaleMissingUnsignedProxy = new EnhanceScaleMissingUnsignedImpl(this, this.enhanceMode);
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertEnums) && this.dataType.isEnum()) {
            this.setDataType(DataType.STRING);
            return;
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned)) {
            this.setDataType(this.scaleMissingUnsignedProxy.getUnsignedConversionType());
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset) && (this.dataType.isNumeric() || this.dataType == DataType.CHAR) && this.scaleMissingUnsignedProxy.hasScaleOffset()) {
            this.setDataType(this.scaleMissingUnsignedProxy.getScaledOffsetType());
        }
    }

    boolean needConvert() {
        Set<NetcdfDataset.Enhance> enhancements = this.getEnhanceMode();
        return enhancements.contains((Object)NetcdfDataset.Enhance.ConvertEnums) || enhancements.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned) || enhancements.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset) || enhancements.contains((Object)NetcdfDataset.Enhance.ConvertMissing);
    }

    Array convert(Array data) {
        return this.convert(data, this.enhanceMode);
    }

    Array convert(Array data, Set<NetcdfDataset.Enhance> enhancements) {
        if (enhancements.contains((Object)NetcdfDataset.Enhance.ConvertEnums) && (this.dataType.isEnum() || this.orgDataType != null && this.orgDataType.isEnum())) {
            return this.convertEnums(data);
        }
        if (this.isVariableLength) {
            return data;
        }
        return this.scaleMissingUnsignedProxy.convert(data, enhancements.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned), enhancements.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset), enhancements.contains((Object)NetcdfDataset.Enhance.ConvertMissing));
    }

    private Array convertEnums(Array values) {
        if (!values.getDataType().isIntegral()) {
            return values;
        }
        Array result = Array.factory(DataType.STRING, values.getShape());
        IndexIterator ii = result.getIndexIterator();
        values.resetLocalIterator();
        while (values.hasNext()) {
            String sval = this.lookupEnumString(values.nextInt());
            ii.setObjectNext(sval);
        }
        return result;
    }

    public Set<NetcdfDataset.Enhance> getEnhanceMode() {
        if (!(this.orgVar instanceof VariableDS)) {
            return Collections.unmodifiableSet(this.enhanceMode);
        }
        VariableDS orgVarDS = (VariableDS)this.orgVar;
        return Sets.union(this.enhanceMode, orgVarDS.getEnhanceMode());
    }

    @Deprecated
    public boolean addEnhancement(NetcdfDataset.Enhance enhancement) {
        if (this.enhanceMode.add(enhancement)) {
            this.enhance(this.enhanceMode);
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean removeEnhancement(NetcdfDataset.Enhance enhancement) {
        if (this.enhanceMode.remove((Object)enhancement)) {
            this.enhance(this.enhanceMode);
            return true;
        }
        return false;
    }

    @Override
    public Variable getOriginalVariable() {
        return this.orgVar;
    }

    @Override
    @Deprecated
    public void setOriginalVariable(Variable orgVar) {
        if (orgVar instanceof Structure) {
            throw new IllegalArgumentException("VariableDS must not wrap a Structure; name=" + orgVar.getFullName());
        }
        this.orgVar = orgVar;
    }

    public DataType getOriginalDataType() {
        return this.orgDataType != null ? this.orgDataType : this.getDataType();
    }

    @Override
    public String getOriginalName() {
        return this.orgName;
    }

    @Override
    public String lookupEnumString(int val) {
        if (this.dataType.isEnum()) {
            return super.lookupEnumString(val);
        }
        return this.orgVar.lookupEnumString(val);
    }

    @Override
    @Deprecated
    public String setName(String newName) {
        this.orgName = this.getShortName();
        super.setShortName(newName);
        return newName;
    }

    @Override
    public String toStringDebug() {
        return this.orgVar != null ? this.orgVar.toStringDebug() : "";
    }

    @Override
    public String getDatasetLocation() {
        String result = super.getDatasetLocation();
        if (result != null) {
            return result;
        }
        if (this.orgVar != null) {
            return this.orgVar.getDatasetLocation();
        }
        return null;
    }

    public boolean hasCachedDataRecurse() {
        return super.hasCachedData() || this.orgVar != null && this.orgVar.hasCachedData();
    }

    @Override
    @Deprecated
    public void setCaching(boolean caching) {
        if (caching && this.orgVar != null) {
            this.orgVar.setCaching(true);
        }
    }

    @Override
    protected Array _read() throws IOException {
        Array result = this.hasCachedData() ? super._read() : this.proxyReader.reallyRead(this, null);
        return this.convert(result);
    }

    @Override
    protected Array _read(Section section) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this._read();
        }
        Array result = this.hasCachedData() ? super._read(section) : this.proxyReader.reallyRead(this, section, null);
        return this.convert(result);
    }

    @Override
    public Array reallyRead(Variable client, CancelTask cancelTask) throws IOException {
        if (this.orgVar == null) {
            return this.getMissingDataArray(this.shape);
        }
        return this.orgVar.read();
    }

    @Override
    public Array reallyRead(Variable client, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this.reallyRead(client, cancelTask);
        }
        if (this.orgVar == null) {
            return this.getMissingDataArray(section.getShape());
        }
        return this.orgVar.read(section);
    }

    @Override
    public long readToStream(Section section, OutputStream out) throws IOException, InvalidRangeException {
        if (this.orgVar == null) {
            return super.readToStream(section, out);
        }
        return this.orgVar.readToStream(section, out);
    }

    public Array getMissingDataArray(int[] shape) {
        Object[] storage;
        switch (this.getDataType()) {
            case BOOLEAN: {
                storage = new boolean[1];
                break;
            }
            case BYTE: 
            case UBYTE: 
            case ENUM1: {
                storage = new byte[1];
                break;
            }
            case CHAR: {
                storage = new char[1];
                break;
            }
            case SHORT: 
            case USHORT: 
            case ENUM2: {
                storage = new short[1];
                break;
            }
            case INT: 
            case UINT: 
            case ENUM4: {
                storage = new int[1];
                break;
            }
            case LONG: 
            case ULONG: {
                storage = new long[1];
                break;
            }
            case FLOAT: {
                storage = new float[1];
                break;
            }
            case DOUBLE: {
                storage = new double[1];
                break;
            }
            default: {
                storage = new Object[1];
            }
        }
        Array array = Array.factoryConstant(this.getDataType(), shape, storage);
        if (this.scaleMissingUnsignedProxy.hasFillValue()) {
            array.setObject(0, (Object)this.scaleMissingUnsignedProxy.getFillValue());
        }
        return array;
    }

    public void showScaleMissingProxy(Formatter f) {
        f.format("has missing = %s%n", this.scaleMissingUnsignedProxy.hasMissing());
        if (this.scaleMissingUnsignedProxy.hasMissing()) {
            if (this.scaleMissingUnsignedProxy.hasMissingValue()) {
                f.format("   missing value(s) = ", new Object[0]);
                for (double d : this.scaleMissingUnsignedProxy.getMissingValues()) {
                    f.format(" %f", d);
                }
                f.format("%n", new Object[0]);
            }
            if (this.scaleMissingUnsignedProxy.hasFillValue()) {
                f.format("   fillValue = %f%n", this.scaleMissingUnsignedProxy.getFillValue());
            }
            if (this.scaleMissingUnsignedProxy.hasValidData()) {
                f.format("   valid min/max = [%f,%f]%n", this.scaleMissingUnsignedProxy.getValidMin(), this.scaleMissingUnsignedProxy.getValidMax());
            }
        }
        f.format("FillValue or default = %s%n", this.scaleMissingUnsignedProxy.getFillValue());
        f.format("%nhas scale/offset = %s%n", this.scaleMissingUnsignedProxy.hasScaleOffset());
        if (this.scaleMissingUnsignedProxy.hasScaleOffset()) {
            double offset = this.scaleMissingUnsignedProxy.applyScaleOffset(0.0);
            double scale = this.scaleMissingUnsignedProxy.applyScaleOffset(1.0) - offset;
            f.format("   scale_factor = %f add_offset = %f%n", scale, offset);
        }
        f.format("original data type = %s%n", new Object[]{this.orgDataType});
        f.format("converted data type = %s%n", new Object[]{this.getDataType()});
    }

    @Override
    public String getDescription() {
        return this.enhanceProxy.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.enhanceProxy.getUnitsString();
    }

    @Override
    @Deprecated
    public void setUnitsString(String units) {
        this.enhanceProxy.setUnitsString(units);
    }

    public ImmutableList<CoordinateSystem> getCoordinateSystems() {
        return this.enhanceProxy.getCoordinateSystems();
    }

    @Override
    @Deprecated
    public void addCoordinateSystem(CoordinateSystem cs) {
        this.enhanceProxy.addCoordinateSystem(cs);
    }

    @Override
    @Deprecated
    public void removeCoordinateSystem(CoordinateSystem cs) {
        this.enhanceProxy.removeCoordinateSystem(cs);
    }

    @Override
    public boolean hasScaleOffset() {
        return this.scaleMissingUnsignedProxy.hasScaleOffset();
    }

    @Override
    public double getScaleFactor() {
        return this.scaleMissingUnsignedProxy.getScaleFactor();
    }

    @Override
    public double getOffset() {
        return this.scaleMissingUnsignedProxy.getOffset();
    }

    @Override
    public boolean hasMissing() {
        return this.scaleMissingUnsignedProxy.hasMissing();
    }

    @Override
    public boolean isMissing(double val) {
        return this.scaleMissingUnsignedProxy.isMissing(val);
    }

    @Override
    public boolean hasValidData() {
        return this.scaleMissingUnsignedProxy.hasValidData();
    }

    @Override
    public double getValidMin() {
        return this.scaleMissingUnsignedProxy.getValidMin();
    }

    @Override
    public double getValidMax() {
        return this.scaleMissingUnsignedProxy.getValidMax();
    }

    @Override
    public boolean isInvalidData(double val) {
        return this.scaleMissingUnsignedProxy.isInvalidData(val);
    }

    @Override
    public boolean hasFillValue() {
        return this.scaleMissingUnsignedProxy.hasFillValue();
    }

    @Override
    public double getFillValue() {
        return this.scaleMissingUnsignedProxy.getFillValue();
    }

    @Override
    public boolean isFillValue(double val) {
        return this.scaleMissingUnsignedProxy.isFillValue(val);
    }

    @Override
    public boolean hasMissingValue() {
        return this.scaleMissingUnsignedProxy.hasMissingValue();
    }

    @Override
    public double[] getMissingValues() {
        return this.scaleMissingUnsignedProxy.getMissingValues();
    }

    @Override
    public boolean isMissingValue(double val) {
        return this.scaleMissingUnsignedProxy.isMissingValue(val);
    }

    @Override
    @Deprecated
    public void setFillValueIsMissing(boolean b) {
        this.scaleMissingUnsignedProxy.setFillValueIsMissing(b);
    }

    @Override
    @Deprecated
    public void setInvalidDataIsMissing(boolean b) {
        this.scaleMissingUnsignedProxy.setInvalidDataIsMissing(b);
    }

    @Override
    @Deprecated
    public void setMissingDataIsMissing(boolean b) {
        this.scaleMissingUnsignedProxy.setMissingDataIsMissing(b);
    }

    @Override
    @Nullable
    public DataType getScaledOffsetType() {
        return this.scaleMissingUnsignedProxy.getScaledOffsetType();
    }

    @Override
    public DataType getUnsignedConversionType() {
        return this.scaleMissingUnsignedProxy.getUnsignedConversionType();
    }

    @Override
    public DataType.Signedness getSignedness() {
        return this.scaleMissingUnsignedProxy.getSignedness();
    }

    @Override
    public double applyScaleOffset(Number value) {
        return this.scaleMissingUnsignedProxy.applyScaleOffset(value);
    }

    @Override
    public Array applyScaleOffset(Array data) {
        return this.scaleMissingUnsignedProxy.applyScaleOffset(data);
    }

    @Override
    public Number convertUnsigned(Number value) {
        return this.scaleMissingUnsignedProxy.convertUnsigned(value);
    }

    @Override
    public Array convertUnsigned(Array in) {
        return this.scaleMissingUnsignedProxy.convertUnsigned(in);
    }

    @Override
    public Number convertMissing(Number value) {
        return this.scaleMissingUnsignedProxy.convertMissing(value);
    }

    @Override
    public Array convertMissing(Array in) {
        return this.scaleMissingUnsignedProxy.convertMissing(in);
    }

    @Override
    public Array convert(Array in, boolean convertUnsigned, boolean applyScaleOffset, boolean convertMissing) {
        return this.scaleMissingUnsignedProxy.convert(in, convertUnsigned, applyScaleOffset, convertMissing);
    }

    protected VariableDS(Builder<?> builder, Group parentGroup) {
        super(builder, parentGroup);
        this.enhanceMode = builder.enhanceMode;
        this.orgVar = builder.orgVar;
        this.orgDataType = builder.orgDataType;
        this.orgName = builder.orgName;
        Attribute units = builder.getAttributeContainer().findAttributeIgnoreCase("units");
        if (units != null && units.isString()) {
            builder.getAttributeContainer().addAttribute(Attribute.builder("units").setStringValue(units.getStringValue().trim()).build());
        }
        this.orgFileTypeId = builder.orgFileTypeId;
        this.enhanceProxy = new EnhancementsImpl(this, ((Builder)builder).units, builder.getDescription());
        this.scaleMissingUnsignedProxy = new EnhanceScaleMissingUnsignedImpl(this, this.enhanceMode);
        this.scaleMissingUnsignedProxy.setFillValueIsMissing(((Builder)builder).fillValueIsMissing);
        this.scaleMissingUnsignedProxy.setInvalidDataIsMissing(((Builder)builder).invalidDataIsMissing);
        this.scaleMissingUnsignedProxy.setMissingDataIsMissing(((Builder)builder).missingDataIsMissing);
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertEnums) && this.dataType.isEnum()) {
            this.dataType = DataType.STRING;
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ConvertUnsigned) && !this.dataType.isEnum()) {
            this.dataType = this.scaleMissingUnsignedProxy.getUnsignedConversionType();
        }
        if (this.enhanceMode.contains((Object)NetcdfDataset.Enhance.ApplyScaleOffset) && (this.dataType.isNumeric() || this.dataType == DataType.CHAR) && this.scaleMissingUnsignedProxy.hasScaleOffset()) {
            this.dataType = this.scaleMissingUnsignedProxy.getScaledOffsetType();
        }
        this.coordSysNames = builder.coordSysNames;
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(VariableDS.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> builder) {
        ((Builder)((Builder)((Builder)((Builder)((Builder)builder.setOriginalVariable(this.orgVar).setOriginalDataType(this.orgDataType)).setOriginalName(this.orgName)).setOriginalFileTypeId(this.orgFileTypeId)).setEnhanceMode(this.enhanceMode)).setUnits(this.enhanceProxy.units)).setDesc(this.enhanceProxy.desc);
        return (Builder)super.addLocalFieldsToBuilder(builder);
    }

    @Deprecated
    void setCoordinateSystems(CoordinatesHelper coords) {
        for (String name : this.coordSysNames) {
            coords.findCoordSystem(name).ifPresent(cs -> this.enhanceProxy.addCoordinateSystem((CoordinateSystem)cs));
        }
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Variable.Builder<T> {
        public Set<NetcdfDataset.Enhance> enhanceMode = EnumSet.noneOf(NetcdfDataset.Enhance.class);
        public Variable orgVar;
        public DataType orgDataType;
        public String orgFileTypeId;
        String orgName;
        private String units;
        private String desc;
        public List<String> coordSysNames = new ArrayList<String>();
        private boolean invalidDataIsMissing = NetcdfDataset.invalidDataIsMissing;
        private boolean fillValueIsMissing = NetcdfDataset.fillValueIsMissing;
        private boolean missingDataIsMissing = NetcdfDataset.missingDataIsMissing;
        private boolean built;

        @Override
        protected abstract T self();

        public T setEnhanceMode(Set<NetcdfDataset.Enhance> enhanceMode) {
            this.enhanceMode = enhanceMode;
            return (T)this.self();
        }

        public T addEnhanceMode(Set<NetcdfDataset.Enhance> enhanceMode) {
            this.enhanceMode.addAll(enhanceMode);
            return (T)this.self();
        }

        public T setOriginalVariable(Variable orgVar) {
            this.orgVar = orgVar;
            return (T)this.self();
        }

        public T setOriginalDataType(DataType orgDataType) {
            this.orgDataType = orgDataType;
            return (T)this.self();
        }

        public T setOriginalName(String orgName) {
            this.orgName = orgName;
            return (T)this.self();
        }

        public T setOriginalFileTypeId(String orgFileTypeId) {
            this.orgFileTypeId = orgFileTypeId;
            return (T)this.self();
        }

        public T setUnits(String units) {
            this.units = units;
            if (units != null) {
                this.units = units.trim();
                this.addAttribute(new Attribute("units", this.units));
            }
            return (T)this.self();
        }

        public T setDesc(String desc) {
            this.desc = desc;
            if (desc != null) {
                this.addAttribute(new Attribute("long_name", desc));
            }
            return (T)this.self();
        }

        public void addCoordinateSystemName(String coordSysName) {
            this.coordSysNames.add(coordSysName);
        }

        public void setFillValueIsMissing(boolean b) {
            this.fillValueIsMissing = b;
        }

        public void setInvalidDataIsMissing(boolean b) {
            this.invalidDataIsMissing = b;
        }

        public void setMissingDataIsMissing(boolean b) {
            this.missingDataIsMissing = b;
        }

        @Override
        public Variable.Builder<?> copy() {
            return new Builder2().copyFrom(this);
        }

        @Override
        public T copyFrom(Variable orgVar) {
            super.copyFrom(orgVar);
            this.setSPobject(null);
            this.setOriginalVariable(orgVar);
            this.setOriginalDataType(orgVar.getDataType());
            this.setOriginalName(orgVar.getShortName());
            this.orgFileTypeId = orgVar.getFileTypeId();
            return (T)this.self();
        }

        @Override
        public T copyFrom(Builder<?> builder) {
            super.copyFrom(builder);
            builder.coordSysNames.forEach(name -> this.addCoordinateSystemName((String)name));
            this.setDesc(builder.desc);
            this.setEnhanceMode(builder.enhanceMode);
            this.setFillValueIsMissing(builder.fillValueIsMissing);
            this.setInvalidDataIsMissing(builder.invalidDataIsMissing);
            this.setMissingDataIsMissing(builder.missingDataIsMissing);
            this.orgVar = builder.orgVar;
            this.orgDataType = builder.orgDataType;
            this.orgFileTypeId = builder.orgFileTypeId;
            this.orgName = builder.orgName;
            this.setUnits(builder.units);
            return (T)this.self();
        }

        public String getUnits() {
            String result = this.units;
            if (result == null) {
                result = this.getAttributeContainer().findAttributeString("units", null);
            }
            if (result == null && this.orgVar != null) {
                result = this.orgVar.attributes().findAttributeString("units", null);
            }
            return result == null ? null : result.trim();
        }

        public String getDescription() {
            String result = this.desc;
            if (result == null) {
                result = this.getAttributeContainer().findAttributeString("long_name", null);
            }
            if (result == null && this.orgVar != null) {
                result = this.orgVar.attributes().findAttributeString("long_name", null);
            }
            return result == null ? null : result.trim();
        }

        @Override
        public VariableDS build(Group parentGroup) {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new VariableDS(this, parentGroup);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }
}

