/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.ft.point.writer.CFPointWriterConfig;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.EarthLocation;

public class WriterCFTrajectoryCollection
extends CFPointWriter {
    private Structure featureStruct;
    private Map<String, Variable> featureVarMap = new HashMap<String, Variable>();
    private boolean headerDone;
    private int trajRecno;
    private int obsRecno;

    public WriterCFTrajectoryCollection(String fileOut, List<Attribute> globalAtts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, globalAtts, dataVars, timeUnit, altUnits, config);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.trajectory.name()));
        this.writer.addGroupAttribute(null, new Attribute("DSG_representation", "Contiguous ragged array representation of trajectories, H.4.3"));
    }

    public int writeTrajectory(TrajectoryFeature traj) throws IOException {
        int count = 0;
        for (PointFeature pf : traj) {
            if (!this.headerDone) {
                if (this.id_strlen == 0) {
                    this.id_strlen = traj.getName().length() * 2;
                }
                this.writeHeader(traj, pf);
                this.headerDone = true;
            }
            this.writeObsData(pf);
            ++count;
        }
        this.writeTrajectoryData(traj, count);
        return count;
    }

    private void writeHeader(TrajectoryFeature feature, PointFeature obs) throws IOException {
        ArrayList<VariableSimpleIF> coords = new ArrayList<VariableSimpleIF>();
        coords.add(VariableSimpleBuilder.makeScalar("time", "time of measurement", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
        coords.add(VariableSimpleBuilder.makeScalar("latitude", "latitude of measurement", "degrees_north", DataType.DOUBLE).build());
        coords.add(VariableSimpleBuilder.makeScalar("longitude", "longitude of measurement", "degrees_east", DataType.DOUBLE).build());
        Formatter coordNames = new Formatter().format("%s %s %s", "time", "latitude", "longitude");
        if (this.altUnits != null) {
            coords.add(VariableSimpleBuilder.makeScalar("altitude", "altitude of measurement", this.altUnits, DataType.DOUBLE).addAttribute("positive", CF1Convention.getZisPositive("altitude", this.altUnits)).build());
            coordNames.format(" %s", "altitude");
        }
        super.writeHeader(coords, feature.getFeatureData(), obs.getFeatureData(), coordNames.toString());
    }

    @Override
    protected void makeFeatureVariables(StructureData featureData, boolean isExtended) {
        Dimension profileDim = this.writer.addDimension(null, "traj", this.nfeatures);
        ArrayList<VariableSimpleIF> featureVars = new ArrayList<VariableSimpleIF>();
        featureVars.add(VariableSimpleBuilder.makeString("trajectoryId", "trajectory identifier", null, this.id_strlen).addAttribute("cf_role", "trajectory_id").build());
        featureVars.add(VariableSimpleBuilder.makeScalar("nobs", "number of obs for this profile", null, DataType.INT).addAttribute("sample_dimension", "obs").build());
        for (StructureMembers.Member m3 : featureData.getMembers()) {
            VariableSimpleIF dv = this.getDataVar(m3.getName());
            if (dv == null) continue;
            featureVars.add(dv);
        }
        if (isExtended) {
            this.featureStruct = (Structure)this.writer.addVariable(null, "trajectory", DataType.STRUCTURE, "traj");
            this.addCoordinatesExtended(this.featureStruct, featureVars);
        } else {
            this.addCoordinatesClassic(profileDim, featureVars, this.featureVarMap);
        }
    }

    public void writeTrajectoryData(TrajectoryFeature profile2, int nobs) throws IOException {
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberString("trajectoryId", null, null, profile2.getName().trim(), this.id_strlen);
        smb.addMemberScalar("nobs", null, null, DataType.INT, nobs);
        StructureDataFromMember profileCoords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(profileCoords, profile2.getFeatureData()));
        this.trajRecno = super.writeStructureData(this.trajRecno, this.featureStruct, sdall, this.featureVarMap);
    }

    public void writeObsData(PointFeature pf) throws IOException {
        EarthLocation loc = pf.getLocation();
        this.trackBB(loc.getLatLon(), this.timeUnit.makeCalendarDate(pf.getObservationTime()));
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar("time", null, null, DataType.DOUBLE, pf.getObservationTime());
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, loc.getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, loc.getLongitude());
        if (this.altUnits != null) {
            smb.addMemberScalar("altitude", null, null, DataType.DOUBLE, loc.getAltitude());
        }
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create(ImmutableList.of(coords, pf.getFeatureData()));
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }
}

