/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf4;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.NCheader;
import ucar.nc2.iosp.hdf4.H4type;
import ucar.nc2.iosp.hdf4.HdfEos;
import ucar.nc2.iosp.hdf4.TagEnum;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.write.Ncdump;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Format;

public class H4header
extends NCheader {
    private static Logger log = LoggerFactory.getLogger(H4header.class);
    private static final byte[] head = new byte[]{14, 3, 19, 1};
    private static final String shead = new String(head, StandardCharsets.UTF_8);
    private static final long maxHeaderPos = 500000L;
    private static boolean debugDD;
    private static boolean debugTag1;
    private static boolean debugTag2;
    private static boolean debugTagDetail;
    private static boolean debugConstruct;
    private static boolean debugAtt;
    private static boolean debugLinked;
    private static boolean debugChunkTable;
    private static boolean debugChunkDetail;
    private static boolean debugTracker;
    private static boolean warnings;
    private static boolean useHdfEos;
    private NetcdfFile ncfile;
    RandomAccessFile raf;
    private boolean isEos;
    private List<Tag> alltags;
    private Map<Integer, Tag> tagMap = new HashMap<Integer, Tag>();
    private Map<Short, Vinfo> refnoMap = new HashMap<Short, Vinfo>();
    private MemTracker memTracker;
    private PrintWriter debugOut = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));

    static boolean isValidFile(RandomAccessFile raf) throws IOException {
        return H4header.checkFileType(raf) == 28677;
    }

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugTag1 = debugFlag.isSet("H4header/tag1");
        debugTag2 = debugFlag.isSet("H4header/tag2");
        debugTagDetail = debugFlag.isSet("H4header/tagDetail");
        debugConstruct = debugFlag.isSet("H4header/construct");
        debugAtt = debugFlag.isSet("H4header/att");
        debugLinked = debugFlag.isSet("H4header/linked");
        debugChunkTable = debugFlag.isSet("H4header/chunkTable");
        debugChunkDetail = debugFlag.isSet("H4header/chunkDetail");
        debugTracker = debugFlag.isSet("H4header/memTracker");
        if (debugFlag.isSet("HdfEos/showWork")) {
            HdfEos.showWork = true;
        }
    }

    public static void useHdfEos(boolean val) {
        useHdfEos = val;
    }

    public boolean isEos() {
        return this.isEos;
    }

    void read(RandomAccessFile myRaf, NetcdfFile ncfile) throws IOException {
        this.raf = myRaf;
        this.ncfile = ncfile;
        long actualSize = this.raf.length();
        this.memTracker = new MemTracker(actualSize);
        if (!H4header.isValidFile(myRaf)) {
            throw new IOException("Not an HDF4 file ");
        }
        this.memTracker.add("header", 0L, this.raf.getFilePointer());
        this.raf.order(0);
        if (debugConstruct) {
            this.debugOut.println("H4header 0pened file to read:'" + this.raf.getLocation() + "', size=" + actualSize / 1000L + " Kb");
        }
        this.alltags = new ArrayList<Tag>();
        long link = this.raf.getFilePointer();
        while (link > 0L) {
            link = this.readDDH(this.alltags, link);
        }
        for (Tag tag : this.alltags) {
            tag.read();
            this.tagMap.put(H4header.tagid(tag.refno, tag.code), tag);
            if (!debugTag1) continue;
            System.out.println(debugTagDetail ? tag.detail() : tag);
        }
        ncfile.setLocation(myRaf.getLocation());
        this.construct(ncfile, this.alltags);
        if (useHdfEos) {
            this.isEos = HdfEos.amendFromODL(ncfile, ncfile.getRootGroup());
            if (this.isEos) {
                this.adjustDimensions();
                String history = ncfile.getRootGroup().findAttributeString("_History", "");
                ncfile.addAttribute(null, new Attribute("_History", history + "; HDF-EOS StructMetadata information was read"));
            }
        }
        if (debugTag2) {
            for (Tag tag : this.alltags) {
                this.debugOut.println(debugTagDetail ? tag.detail() : tag);
            }
        }
        if (debugTracker) {
            this.memTracker.report();
        }
    }

    public void getEosInfo(Formatter f) throws IOException {
        HdfEos.getEosInfo(this.ncfile, this.ncfile.getRootGroup(), f);
    }

    private static int tagid(short refno, short code) {
        int result = (code & 0x3FFF) << 16;
        int result2 = refno & 0xFFFF;
        return result += result2;
    }

    private void construct(NetcdfFile ncfile, List<Tag> alltags) throws IOException {
        Variable v;
        TagVGroup vgroup;
        Variable v22;
        ArrayList<Variable> vars = new ArrayList<Variable>();
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Tag t : alltags) {
            if (t.code == 306) {
                v22 = this.makeImage((TagGroup)t);
                if (v22 == null) continue;
                vars.add(v22);
                continue;
            }
            if (t.code != 1965) continue;
            vgroup = (TagVGroup)t;
            if (vgroup.className.startsWith("Dim") || vgroup.className.startsWith("UDim")) {
                this.makeDimension(vgroup);
                continue;
            }
            if (vgroup.className.startsWith("Var")) {
                v = this.makeVariable(vgroup);
                if (v == null) continue;
                vars.add(v);
                continue;
            }
            if (!vgroup.className.startsWith("CDF0.0")) continue;
            this.addGlobalAttributes(vgroup);
        }
        for (Tag t : alltags) {
            if (t.used) continue;
            if (t.code == 1962) {
                TagVH tagVH = (TagVH)t;
                if (!tagVH.className.startsWith("Data") || (v = this.makeVariable(tagVH)) == null) continue;
                vars.add(v);
                continue;
            }
            if (t.code != 720 || (v22 = this.makeVariable((TagGroup)t)) == null) continue;
            vars.add(v22);
        }
        for (Tag t : alltags) {
            if (t.used || t.code != 1962) continue;
            TagVH vh = (TagVH)t;
            if (vh.className.startsWith("Att") || vh.className.startsWith("_HDF_CHK_TBL") || (v = this.makeVariable(vh)) == null) continue;
            vars.add(v);
        }
        for (Tag t : alltags) {
            Group g2;
            if (t.used || t.code != 1965 || (g2 = this.makeGroup(vgroup = (TagVGroup)t, null)) == null) continue;
            groups.add(g2);
        }
        for (Group g3 : groups) {
            if (g3.getParentGroup() != ncfile.getRootGroup()) continue;
            ncfile.addGroup(null, g3);
        }
        Group root = ncfile.getRootGroup();
        for (Variable v22 : vars) {
            if (v22.getParentGroupOrRoot() != root || root.findVariableLocal(v22.getShortName()) != null) continue;
            root.addVariable(v22);
        }
        for (Tag t : alltags) {
            if (!(t instanceof TagAnnotate)) continue;
            TagAnnotate ta = (TagAnnotate)t;
            Vinfo vinfo = this.refnoMap.get(ta.obj_refno);
            if (vinfo == null) continue;
            vinfo.v.addAttribute(new Attribute(t.code == 105 ? "description" : "long_name", ta.text));
            t.used = true;
        }
        ncfile.addAttribute(null, new Attribute("_History", "Direct read of HDF4 file through CDM library"));
        for (Tag t : alltags) {
            if (t.code == 30) {
                ncfile.addAttribute(null, new Attribute("HDF4_Version", ((TagVersion)t).value()));
                t.used = true;
                continue;
            }
            if (t.code == 100) {
                ncfile.addAttribute(null, new Attribute("Title-" + t.refno, ((TagText)t).text));
                t.used = true;
                continue;
            }
            if (t.code != 101) continue;
            ncfile.addAttribute(null, new Attribute("Description-" + t.refno, ((TagText)t).text));
            t.used = true;
        }
    }

    private void adjustDimensions() {
        HashMap<Dimension, List<Variable>> dimUsedMap = new HashMap<Dimension, List<Variable>>();
        this.findUsedDimensions(this.ncfile.getRootGroup(), dimUsedMap);
        Set dimUsed = dimUsedMap.keySet();
        Iterator<Dimension> iter = this.ncfile.getRootGroup().getDimensions().iterator();
        while (iter.hasNext()) {
            Dimension dim = iter.next();
            if (dimUsed.contains(dim)) continue;
            iter.remove();
        }
        for (Dimension dim : dimUsed) {
            Group lowest = null;
            List vlist = (List)dimUsedMap.get(dim);
            for (Variable v : vlist) {
                if (lowest == null) {
                    lowest = v.getParentGroupOrRoot();
                    continue;
                }
                lowest = lowest.commonParent(v.getParentGroupOrRoot());
            }
            Group current = dim.getGroup();
            if (lowest == null || current == lowest) continue;
            lowest.addDimension(dim);
            current.remove(dim);
        }
    }

    private void findUsedDimensions(Group parent, Map<Dimension, List<Variable>> dimUsedMap) {
        for (Variable v : parent.getVariables()) {
            for (Dimension d : v.getDimensions()) {
                if (!d.isShared()) continue;
                List vlist = dimUsedMap.computeIfAbsent(d, k -> new ArrayList());
                vlist.add(v);
            }
        }
        for (Group g2 : parent.getGroups()) {
            this.findUsedDimensions(g2, dimUsedMap);
        }
    }

    private void makeDimension(TagVGroup group) throws IOException {
        ArrayList<TagVH> dims = new ArrayList<TagVH>();
        Tag data = null;
        for (int i = 0; i < group.nelems; ++i) {
            Tag tag = this.tagMap.get(H4header.tagid(group.elem_ref[i], group.elem_tag[i]));
            if (tag == null) {
                throw new IllegalStateException();
            }
            if (tag.code == 1962) {
                dims.add((TagVH)tag);
            }
            if (tag.code != 1963) continue;
            data = tag;
        }
        if (dims.isEmpty()) {
            throw new IllegalStateException();
        }
        int length = 0;
        if (data != null) {
            this.raf.seek(data.offset);
            length = this.raf.readInt();
            data.used = true;
        } else {
            for (TagVH vh : dims) {
                vh.used = true;
                data = this.tagMap.get(H4header.tagid(vh.refno, TagEnum.VS.getCode()));
                if (null == data) continue;
                data.used = true;
                this.raf.seek(data.offset);
                int length2 = this.raf.readInt();
                if (debugConstruct) {
                    System.out.println("dimension length=" + length2 + " for TagVGroup= " + group + " using data " + data.refno);
                }
                if (length2 <= 0) continue;
                length = length2;
                break;
            }
        }
        if (data == null) {
            log.error("**no data for dimension TagVGroup= " + group);
            return;
        }
        if (length <= 0) {
            log.warn("**dimension length=" + length + " for TagVGroup= " + group + " using data " + data.refno);
        }
        boolean isUnlimited = length == 0;
        Dimension dim = new Dimension(group.name, length, true, isUnlimited, false);
        this.ncfile.addDimension(null, dim);
    }

    private void addGlobalAttributes(TagVGroup group) throws IOException {
        for (int i = 0; i < group.nelems; ++i) {
            Tag tag = this.tagMap.get(H4header.tagid(group.elem_ref[i], group.elem_tag[i]));
            if (tag == null) {
                throw new IllegalStateException();
            }
            if (tag.code != 1962) continue;
            TagVH vh = (TagVH)tag;
            if (!vh.className.startsWith("Att")) continue;
            String lowername = vh.name.toLowerCase();
            if (vh.nfields == 1 && H4type.setDataType(vh.fld_type[0], null) == DataType.CHAR && (vh.fld_isize[0] > 4000 || lowername.startsWith("archivemetadata") || lowername.startsWith("coremetadata") || lowername.startsWith("productmetadata") || lowername.startsWith("structmetadata"))) {
                this.ncfile.addVariable(null, this.makeVariable(vh));
                continue;
            }
            Attribute att = this.makeAttribute(vh);
            if (null == att) continue;
            this.ncfile.addAttribute(null, att);
        }
        group.used = true;
    }

    private Attribute makeAttribute(TagVH vh) throws IOException {
        Tag data = this.tagMap.get(H4header.tagid(vh.refno, TagEnum.VS.getCode()));
        if (data == null) {
            throw new IllegalStateException();
        }
        if (vh.nfields != 1) {
            throw new IllegalStateException();
        }
        String name = vh.name;
        short type = vh.fld_type[0];
        int size = vh.fld_isize[0];
        int nelems = vh.nvert;
        vh.used = true;
        data.used = true;
        Attribute att = null;
        this.raf.seek(data.offset);
        switch (type) {
            case 3: 
            case 4: {
                if (nelems == 1) {
                    att = new Attribute(name, this.raf.readStringMax(size));
                    break;
                }
                String[] vals = new String[nelems];
                for (int i = 0; i < nelems; ++i) {
                    vals[i] = this.raf.readStringMax(size);
                }
                att = new Attribute(name, Array.factory(DataType.STRING, new int[]{nelems}, (Object)vals));
                break;
            }
            case 5: {
                if (nelems == 1) {
                    att = new Attribute(name, Float.valueOf(this.raf.readFloat()));
                    break;
                }
                float[] vals = new float[nelems];
                for (int i = 0; i < nelems; ++i) {
                    vals[i] = this.raf.readFloat();
                }
                att = new Attribute(name, Array.factory(DataType.FLOAT, new int[]{nelems}, (Object)vals));
                break;
            }
            case 6: {
                if (nelems == 1) {
                    att = new Attribute(name, this.raf.readDouble());
                    break;
                }
                double[] vals = new double[nelems];
                for (int i = 0; i < nelems; ++i) {
                    vals[i] = this.raf.readDouble();
                }
                att = new Attribute(name, Array.factory(DataType.DOUBLE, new int[]{nelems}, (Object)vals));
                break;
            }
            case 20: 
            case 21: {
                if (nelems == 1) {
                    att = new Attribute(name, this.raf.readByte());
                    break;
                }
                byte[] vals = new byte[nelems];
                for (int i = 0; i < nelems; ++i) {
                    vals[i] = this.raf.readByte();
                }
                att = new Attribute(name, Array.factory(DataType.BYTE, new int[]{nelems}, (Object)vals));
                break;
            }
            case 22: 
            case 23: {
                if (nelems == 1) {
                    att = new Attribute(name, this.raf.readShort());
                    break;
                }
                short[] vals = new short[nelems];
                for (int i = 0; i < nelems; ++i) {
                    vals[i] = this.raf.readShort();
                }
                att = new Attribute(name, Array.factory(DataType.SHORT, new int[]{nelems}, (Object)vals));
                break;
            }
            case 24: 
            case 25: {
                if (nelems == 1) {
                    att = new Attribute(name, this.raf.readInt());
                    break;
                }
                int[] vals = new int[nelems];
                for (int i = 0; i < nelems; ++i) {
                    vals[i] = this.raf.readInt();
                }
                att = new Attribute(name, Array.factory(DataType.INT, new int[]{nelems}, (Object)vals));
                break;
            }
            case 26: 
            case 27: {
                if (nelems == 1) {
                    att = new Attribute(name, this.raf.readLong());
                    break;
                }
                long[] vals = new long[nelems];
                for (int i = 0; i < nelems; ++i) {
                    vals[i] = this.raf.readLong();
                }
                att = new Attribute(name, Array.factory(DataType.LONG, new int[]{nelems}, (Object)vals));
            }
        }
        if (debugAtt) {
            System.out.println("added attribute " + att);
        }
        return att;
    }

    private Group makeGroup(TagVGroup tagGroup, Group parent) throws IOException {
        if (tagGroup.nelems < 1) {
            return null;
        }
        Group group = new Group(this.ncfile, parent, tagGroup.name);
        tagGroup.used = true;
        tagGroup.group = group;
        for (int i = 0; i < tagGroup.nelems; ++i) {
            Tag tag = this.tagMap.get(H4header.tagid(tagGroup.elem_ref[i], tagGroup.elem_tag[i]));
            if (tag == null) {
                log.error("Reference tag missing= " + tagGroup.elem_ref[i] + "/" + tagGroup.elem_tag[i] + " for group " + tagGroup.refno);
                continue;
            }
            if (tag.code == 720 && tag.vinfo != null) {
                Variable v = tag.vinfo.v;
                if (v != null) {
                    this.addVariableToGroup(group, v, tag);
                } else {
                    log.error("Missing variable " + tag.refno);
                }
            }
            if (tag.code == 1962) {
                TagVH vh = (TagVH)tag;
                if (vh.className.startsWith("Att")) {
                    Attribute att = this.makeAttribute(vh);
                    if (null != att) {
                        group.addAttribute(att);
                    }
                } else if (tag.vinfo != null) {
                    Variable v = tag.vinfo.v;
                    this.addVariableToGroup(group, v, tag);
                }
            }
            if (tag.code != 1965) continue;
            TagVGroup vg = (TagVGroup)tag;
            if (vg.group != null && vg.group.getParentGroup() == this.ncfile.getRootGroup()) {
                this.addGroupToGroup(group, vg.group, vg);
                vg.group.setParentGroup(group);
                continue;
            }
            Group nested = this.makeGroup(vg, group);
            if (nested == null) continue;
            this.addGroupToGroup(group, nested, vg);
        }
        if (debugConstruct) {
            System.out.println("added group " + group.getFullName() + " from VG " + tagGroup.refno);
        }
        return group;
    }

    private void addVariableToGroup(Group g2, Variable v, Tag tag) {
        Variable varExisting = g2.findVariableLocal(v.getShortName());
        if (varExisting != null) {
            v.setName(v.getShortName() + tag.refno);
        }
        g2.addVariable(v);
    }

    private void addGroupToGroup(Group parent, Group g2, Tag tag) {
        Group groupExisting = parent.findGroupLocal(g2.getShortName());
        if (groupExisting != null) {
            g2.setName(g2.getShortName() + tag.refno);
        }
        parent.addGroup(g2);
    }

    private Variable makeImage(TagGroup group) {
        TagRIDimension dimTag = null;
        Tag data = null;
        Vinfo vinfo = new Vinfo(group.refno);
        group.used = true;
        for (int i = 0; i < group.nelems; ++i) {
            Tag tag = this.tagMap.get(H4header.tagid(group.elem_ref[i], group.elem_tag[i]));
            if (tag == null) {
                log.warn("Image Group " + group.tag() + " has missing tag=" + group.elem_ref[i] + "/" + group.elem_tag[i]);
                return null;
            }
            vinfo.tags.add(tag);
            tag.vinfo = vinfo;
            tag.used = true;
            if (tag.code == 300) {
                dimTag = (TagRIDimension)tag;
            }
            if (tag.code == 302) {
                data = tag;
            }
            if (tag.code != 301) continue;
        }
        if (dimTag == null) {
            log.warn("Image Group " + group.tag() + " missing dimension tag");
            return null;
        }
        if (data == null) {
            log.warn("Image Group " + group.tag() + " missing data tag");
            return null;
        }
        Tag tag = this.tagMap.get(H4header.tagid(dimTag.nt_ref, TagEnum.NT.getCode()));
        if (tag == null) {
            log.warn("Image Group " + group.tag() + " missing NT tag");
            return null;
        }
        TagNumberType ntag = (TagNumberType)tag;
        if (debugConstruct) {
            System.out.println("construct image " + group.refno);
        }
        vinfo.start = data.offset;
        vinfo.tags.add(group);
        vinfo.tags.add(dimTag);
        vinfo.tags.add(data);
        vinfo.tags.add(ntag);
        if (dimTag.dims == null) {
            dimTag.dims = new ArrayList<Dimension>();
            dimTag.dims.add(this.makeDimensionUnshared("ydim", dimTag.ydim));
            dimTag.dims.add(this.makeDimensionUnshared("xdim", dimTag.xdim));
        }
        Variable v = new Variable(this.ncfile, null, null, "Image-" + group.refno);
        H4type.setDataType(ntag.type, v);
        v.setDimensions(dimTag.dims);
        vinfo.setVariable(v);
        return v;
    }

    private Dimension makeDimensionUnshared(String dimName, int len) {
        return new Dimension(dimName, len, false);
    }

    private Dimension makeDimensionShared(String dimName, int len) {
        Group root = this.ncfile.getRootGroup();
        Dimension d = root.findDimension(dimName);
        if (d != null && d.getLength() == len) {
            return d;
        }
        if (d != null && (d = root.findDimension(dimName = dimName + len)) != null && d.getLength() == len) {
            return d;
        }
        return this.ncfile.addDimension(null, new Dimension(dimName, len));
    }

    private Variable makeVariable(TagVH vh) {
        Variable v;
        Vinfo vinfo = new Vinfo(vh.refno);
        vinfo.tags.add(vh);
        vh.vinfo = vinfo;
        vh.used = true;
        TagData data = (TagData)this.tagMap.get(H4header.tagid(vh.refno, TagEnum.VS.getCode()));
        if (data == null) {
            log.error("Cant find tag " + vh.refno + "/" + TagEnum.VS.getCode() + " for TagVH=" + vh.detail());
            return null;
        }
        vinfo.tags.add(data);
        data.used = true;
        data.vinfo = vinfo;
        if (vh.nfields < 1) {
            throw new IllegalStateException();
        }
        if (vh.nfields == 1) {
            v = new Variable(this.ncfile, null, null, vh.name);
            vinfo.setVariable(v);
            H4type.setDataType(vh.fld_type[0], v);
            try {
                if (vh.nvert > 1) {
                    if (vh.fld_order[0] > 1) {
                        v.setDimensionsAnonymous(new int[]{vh.nvert, vh.fld_order[0]});
                    } else if (vh.fld_order[0] < 0) {
                        v.setDimensionsAnonymous(new int[]{vh.nvert, vh.fld_isize[0]});
                    } else {
                        v.setDimensionsAnonymous(new int[]{vh.nvert});
                    }
                } else if (vh.fld_order[0] > 1) {
                    v.setDimensionsAnonymous(new int[]{vh.fld_order[0]});
                } else if (vh.fld_order[0] < 0) {
                    v.setDimensionsAnonymous(new int[]{vh.fld_isize[0]});
                } else {
                    v.setIsScalar();
                }
            }
            catch (InvalidRangeException e) {
                throw new IllegalStateException();
            }
            vinfo.setData(data, v.getElementSize());
        } else {
            Structure s2;
            try {
                s2 = new Structure(this.ncfile, null, null, vh.name);
                vinfo.setVariable(s2);
                if (vh.nvert > 1) {
                    s2.setDimensionsAnonymous(new int[]{vh.nvert});
                } else {
                    s2.setIsScalar();
                }
                for (int fld = 0; fld < vh.nfields; ++fld) {
                    Variable m3 = new Variable(this.ncfile, null, s2, vh.fld_name[fld]);
                    short type = vh.fld_type[fld];
                    int nelems = vh.fld_order[fld];
                    H4type.setDataType(type, m3);
                    if (nelems > 1) {
                        m3.setDimensionsAnonymous(new int[]{nelems});
                    } else {
                        m3.setIsScalar();
                    }
                    m3.setSPobject(new Minfo(vh.fld_offset[fld]));
                    s2.addMemberVariable(m3);
                }
            }
            catch (InvalidRangeException e) {
                throw new IllegalStateException(e.getMessage());
            }
            vinfo.setData(data, vh.ivsize);
            v = s2;
        }
        if (debugConstruct) {
            System.out.println("added variable " + v.getNameAndDimensions() + " from VH " + vh);
        }
        return v;
    }

    private Variable makeVariable(TagVGroup group) throws IOException {
        Vinfo vinfo = new Vinfo(group.refno);
        vinfo.tags.add(group);
        group.used = true;
        TagSDDimension dim = null;
        TagNumberType ntag = null;
        TagData data = null;
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        for (int i = 0; i < group.nelems; ++i) {
            Tag tag = this.tagMap.get(H4header.tagid(group.elem_ref[i], group.elem_tag[i]));
            if (tag == null) {
                log.error("Reference tag missing= " + group.elem_ref[i] + "/" + group.elem_tag[i]);
                continue;
            }
            vinfo.tags.add(tag);
            tag.vinfo = vinfo;
            tag.used = true;
            if (tag.code == 106) {
                ntag = (TagNumberType)tag;
            }
            if (tag.code == 701) {
                dim = (TagSDDimension)tag;
            }
            if (tag.code == 702) {
                data = (TagData)tag;
            }
            if (tag.code != 1965) continue;
            TagVGroup vg = (TagVGroup)tag;
            if (!vg.className.startsWith("Dim") && !vg.className.startsWith("UDim")) continue;
            String dimName = NetcdfFile.makeValidCdmObjectName(vg.name);
            Dimension d = this.ncfile.getRootGroup().findDimension(dimName);
            if (d == null) {
                throw new IllegalStateException();
            }
            dims.add(d);
        }
        if (ntag == null) {
            log.error("ntype tag missing vgroup= " + group.refno);
            return null;
        }
        if (dim == null) {
            log.error("dim tag missing vgroup= " + group.refno);
            return null;
        }
        if (data == null) {
            log.warn("data tag missing vgroup= " + group.refno + " " + group.name);
        }
        Variable v = new Variable(this.ncfile, null, null, group.name);
        v.setDimensions(dims);
        H4type.setDataType(ntag.type, v);
        vinfo.setVariable(v);
        vinfo.setData(data, v.getElementSize());
        assert (dim.shape.length == v.getRank());
        boolean ok = true;
        for (int i = 0; i < dim.shape.length; ++i) {
            if (dim.shape[i] == v.getDimension(i).getLength()) continue;
            if (warnings) {
                log.info(dim.shape[i] + " != " + v.getDimension(i).getLength() + " for " + v.getFullName());
            }
            ok = false;
        }
        if (!ok) {
            try {
                v.setDimensionsAnonymous(dim.shape);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        }
        this.addVariableAttributes(group, vinfo);
        if (debugConstruct) {
            System.out.println("added variable " + v.getNameAndDimensions() + " from VG " + group.refno);
            System.out.println("  SDdim= " + dim.detail());
            System.out.print("  VGdim= ");
            for (Dimension vdim : dims) {
                System.out.print(vdim + " ");
            }
            System.out.println();
        }
        return v;
    }

    private Variable makeVariable(TagGroup group) throws IOException {
        Vinfo vinfo = new Vinfo(group.refno);
        vinfo.tags.add(group);
        group.used = true;
        TagSDDimension dim = null;
        TagData data = null;
        for (int i = 0; i < group.nelems; ++i) {
            Tag tag = this.tagMap.get(H4header.tagid(group.elem_ref[i], group.elem_tag[i]));
            if (tag == null) {
                log.error("Cant find tag " + group.elem_ref[i] + "/" + group.elem_tag[i] + " for group=" + group.refno);
                continue;
            }
            vinfo.tags.add(tag);
            tag.vinfo = vinfo;
            tag.used = true;
            if (tag.code == 701) {
                dim = (TagSDDimension)tag;
            }
            if (tag.code != 702) continue;
            data = (TagData)tag;
        }
        if (dim == null || data == null) {
            throw new IllegalStateException();
        }
        TagNumberType nt = (TagNumberType)this.tagMap.get(H4header.tagid(dim.nt_ref, TagEnum.NT.getCode()));
        if (null == nt) {
            throw new IllegalStateException();
        }
        Variable v = new Variable(this.ncfile, null, null, "SDS-" + group.refno);
        try {
            v.setDimensionsAnonymous(dim.shape);
        }
        catch (InvalidRangeException e) {
            throw new IllegalStateException();
        }
        DataType dataType = H4type.setDataType(nt.type, v);
        vinfo.setVariable(v);
        vinfo.setData(data, v.getElementSize());
        for (int i = 0; i < group.nelems; ++i) {
            Tag tag = this.tagMap.get(H4header.tagid(group.elem_ref[i], group.elem_tag[i]));
            if (tag == null) {
                throw new IllegalStateException();
            }
            if (tag.code == 704) {
                TagTextN labels = (TagTextN)tag;
                labels.read(dim.rank);
                tag.used = true;
                v.addAttribute(new Attribute("long_name", labels.getList(), false));
            }
            if (tag.code == 705) {
                TagTextN units = (TagTextN)tag;
                units.read(dim.rank);
                tag.used = true;
                v.addAttribute(new Attribute("units", units.getList(), false));
            }
            if (tag.code == 706) {
                TagTextN formats = (TagTextN)tag;
                formats.read(dim.rank);
                tag.used = true;
                v.addAttribute(new Attribute("formats", formats.getList(), false));
            }
            if (tag.code != 707) continue;
            TagSDminmax minmax = (TagSDminmax)tag;
            tag.used = true;
            v.addAttribute(new Attribute("min", minmax.getMin(dataType)));
            v.addAttribute(new Attribute("max", minmax.getMax(dataType)));
        }
        this.addVariableAttributes(group, vinfo);
        if (debugConstruct) {
            System.out.println("added variable " + v.getNameAndDimensions() + " from Group " + group);
            System.out.println("  SDdim= " + dim.detail());
        }
        return v;
    }

    private void addVariableAttributes(TagGroup group, Vinfo vinfo) throws IOException {
        for (int i = 0; i < group.nelems; ++i) {
            Attribute att;
            Tag tag = this.tagMap.get(H4header.tagid(group.elem_ref[i], group.elem_tag[i]));
            if (tag == null) {
                throw new IllegalStateException();
            }
            if (tag.code != 1962) continue;
            TagVH vh = (TagVH)tag;
            if (!vh.className.startsWith("Att") || null == (att = this.makeAttribute(vh))) continue;
            vinfo.v.addAttribute(att);
            if (!att.getShortName().equals("_FillValue")) continue;
            vinfo.setFillValue(att);
        }
    }

    private long readDDH(List<Tag> alltags, long start) throws IOException {
        this.raf.seek(start);
        int ndd = DataType.unsignedShortToInt(this.raf.readShort());
        long link = DataType.unsignedIntToLong(this.raf.readInt());
        if (debugDD) {
            System.out.println(" DDHeader ndd=" + ndd + " link=" + link);
        }
        long pos = this.raf.getFilePointer();
        for (int i = 0; i < ndd; ++i) {
            this.raf.seek(pos);
            Tag tag = this.factory();
            pos += 12L;
            if (tag.code <= 1) continue;
            alltags.add(tag);
        }
        this.memTracker.add("DD block", start, this.raf.getFilePointer());
        return link;
    }

    private Tag factory() throws IOException {
        short code = this.raf.readShort();
        int ccode = code & 0x3FFF;
        switch (ccode) {
            case 20: {
                return new TagLinkedBlock(code);
            }
            case 30: {
                return new TagVersion(code);
            }
            case 40: 
            case 61: 
            case 702: 
            case 1963: {
                return new TagData(code);
            }
            case 100: 
            case 101: 
            case 708: {
                return new TagText(code);
            }
            case 104: 
            case 105: {
                return new TagAnnotate(code);
            }
            case 106: {
                return new TagNumberType(code);
            }
            case 300: 
            case 307: 
            case 308: {
                return new TagRIDimension(code);
            }
            case 301: {
                return new TagRIPalette(code);
            }
            case 306: 
            case 720: {
                return new TagGroup(code);
            }
            case 701: {
                return new TagSDDimension(code);
            }
            case 704: 
            case 705: 
            case 706: {
                return new TagTextN(code);
            }
            case 707: {
                return new TagSDminmax(code);
            }
            case 1962: {
                return new TagVH(code);
            }
            case 1965: {
                return new TagVGroup(code);
            }
        }
        return new Tag(code);
    }

    public List<Tag> getTags() {
        return this.alltags;
    }

    static {
        useHdfEos = true;
    }

    private class MemTracker {
        private List<Mem> memList = new ArrayList<Mem>();
        private StringBuilder sbuff = new StringBuilder();
        private long fileSize;

        MemTracker(long fileSize) {
            this.fileSize = fileSize;
        }

        void add(String name, long start, long end) {
            this.memList.add(new Mem(name, start, end));
        }

        void addByLen(String name, long start, long size) {
            this.memList.add(new Mem(name, start, start + size));
        }

        void report() {
            H4header.this.debugOut.println("======================================");
            H4header.this.debugOut.println("Memory used file size= " + this.fileSize);
            H4header.this.debugOut.println("  start    end   size   name");
            Collections.sort(this.memList);
            Mem prev = null;
            for (Mem m3 : this.memList) {
                if (prev != null && m3.start > prev.end) {
                    this.doOne('+', prev.end, m3.start, m3.start - prev.end, "*hole*");
                }
                char c = prev != null && prev.end != m3.start ? (char)'*' : ' ';
                this.doOne(c, m3.start, m3.end, m3.end - m3.start, m3.name);
                prev = m3;
            }
            H4header.this.debugOut.println();
        }

        private void doOne(char c, long start, long end, long size, String name) {
            this.sbuff.setLength(0);
            this.sbuff.append(c);
            this.sbuff.append(Format.l(start, 6));
            this.sbuff.append(" ");
            this.sbuff.append(Format.l(end, 6));
            this.sbuff.append(" ");
            this.sbuff.append(Format.l(size, 6));
            this.sbuff.append(" ");
            this.sbuff.append(name);
            H4header.this.debugOut.println(this.sbuff);
        }

        class Mem
        implements Comparable<Mem> {
            public String name;
            public long start;
            public long end;

            Mem(String name, long start, long end) {
                this.name = name;
                this.start = start;
                this.end = end;
            }

            @Override
            public int compareTo(Mem m3) {
                return Long.compare(this.start, m3.start);
            }
        }
    }

    private class TagVH
    extends Tag {
        short interlace;
        short nfields;
        short extag;
        short exref;
        short version;
        int ivsize;
        short[] fld_type;
        short[] fld_order;
        int[] fld_isize;
        int[] fld_offset;
        String[] fld_name;
        int nvert;
        String name;
        String className;
        int tag_len;

        TagVH(short code) throws IOException {
            super(code);
        }

        @Override
        protected void read() throws IOException {
            int i;
            H4header.this.raf.seek(this.offset);
            this.interlace = H4header.this.raf.readShort();
            this.nvert = H4header.this.raf.readInt();
            this.ivsize = DataType.unsignedShortToInt(H4header.this.raf.readShort());
            this.nfields = H4header.this.raf.readShort();
            this.fld_type = new short[this.nfields];
            for (i = 0; i < this.nfields; ++i) {
                this.fld_type[i] = H4header.this.raf.readShort();
            }
            this.fld_isize = new int[this.nfields];
            for (i = 0; i < this.nfields; ++i) {
                this.fld_isize[i] = DataType.unsignedShortToInt(H4header.this.raf.readShort());
            }
            this.fld_offset = new int[this.nfields];
            for (i = 0; i < this.nfields; ++i) {
                this.fld_offset[i] = DataType.unsignedShortToInt(H4header.this.raf.readShort());
            }
            this.fld_order = new short[this.nfields];
            for (i = 0; i < this.nfields; ++i) {
                this.fld_order[i] = H4header.this.raf.readShort();
            }
            this.fld_name = new String[this.nfields];
            for (i = 0; i < this.nfields; ++i) {
                short len = H4header.this.raf.readShort();
                this.fld_name[i] = H4header.this.raf.readStringMax(len);
            }
            short len = H4header.this.raf.readShort();
            this.name = H4header.this.raf.readStringMax(len);
            len = H4header.this.raf.readShort();
            this.className = H4header.this.raf.readStringMax(len);
            this.extag = H4header.this.raf.readShort();
            this.exref = H4header.this.raf.readShort();
            this.version = H4header.this.raf.readShort();
            this.tag_len = (int)(H4header.this.raf.getFilePointer() - (long)this.offset);
        }

        @Override
        public String toString() {
            return super.toString() + " class= " + this.className + " name= " + this.name;
        }

        @Override
        public String detail() {
            StringBuilder sbuff = new StringBuilder(super.detail());
            sbuff.append(" class= ").append(this.className);
            sbuff.append(" interlace= ").append(this.interlace);
            sbuff.append(" nvert= ").append(this.nvert);
            sbuff.append(" ivsize= ").append(this.ivsize);
            sbuff.append(" extag= ").append(this.extag);
            sbuff.append(" exref= ").append(this.exref);
            sbuff.append(" version= ").append(this.version);
            sbuff.append(" tag_len= ").append(this.tag_len);
            sbuff.append("\n");
            sbuff.append(" name= ").append(this.name);
            sbuff.append("\n");
            sbuff.append("   name    type  isize  offset  order\n   ");
            for (int i = 0; i < this.nfields; ++i) {
                sbuff.append(this.fld_name[i]).append(" ");
                sbuff.append(this.fld_type[i]).append(" ");
                sbuff.append(this.fld_isize[i]).append(" ");
                sbuff.append(this.fld_offset[i]).append(" ");
                sbuff.append(this.fld_order[i]).append(" ");
                sbuff.append("\n   ");
            }
            return sbuff.toString();
        }
    }

    private class TagVGroup
    extends TagGroup {
        short extag;
        short exref;
        short version;
        String name;
        String className;
        Group group;

        TagVGroup(short code) throws IOException {
            super(code);
        }

        @Override
        protected void read() throws IOException {
            int i;
            H4header.this.raf.seek(this.offset);
            this.nelems = H4header.this.raf.readShort();
            this.elem_tag = new short[this.nelems];
            for (i = 0; i < this.nelems; ++i) {
                this.elem_tag[i] = H4header.this.raf.readShort();
            }
            this.elem_ref = new short[this.nelems];
            for (i = 0; i < this.nelems; ++i) {
                this.elem_ref[i] = H4header.this.raf.readShort();
            }
            short len = H4header.this.raf.readShort();
            this.name = H4header.this.raf.readStringMax(len);
            len = H4header.this.raf.readShort();
            this.className = H4header.this.raf.readStringMax(len);
            this.extag = H4header.this.raf.readShort();
            this.exref = H4header.this.raf.readShort();
            this.version = H4header.this.raf.readShort();
        }

        @Override
        public String toString() {
            return super.toString() + " class= " + this.className + " name= " + this.name;
        }

        @Override
        public String detail() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append(this.used ? " " : "*").append("refno=").append(this.refno).append(" tag= ").append(this.t).append(this.extended ? " EXTENDED" : "").append(" offset=").append(this.offset).append(" length=").append(this.length).append(this.vinfo != null && this.vinfo.v != null ? " VV=" + this.vinfo.v.getFullName() : "");
            sbuff.append(" class= ").append(this.className);
            sbuff.append(" extag= ").append(this.extag);
            sbuff.append(" exref= ").append(this.exref);
            sbuff.append(" version= ").append(this.version);
            sbuff.append("\n");
            sbuff.append(" name= ").append(this.name);
            sbuff.append("\n");
            sbuff.append("   tag ref\n   ");
            for (int i = 0; i < this.nelems; ++i) {
                sbuff.append(this.elem_tag[i]).append(" ");
                sbuff.append(this.elem_ref[i]).append(" ");
                sbuff.append("\n   ");
            }
            return sbuff.toString();
        }
    }

    private class TagGroup
    extends Tag {
        int nelems;
        short[] elem_tag;
        short[] elem_ref;

        TagGroup(short code) throws IOException {
            super(code);
        }

        @Override
        protected void read() throws IOException {
            H4header.this.raf.seek(this.offset);
            this.nelems = this.length / 4;
            this.elem_tag = new short[this.nelems];
            this.elem_ref = new short[this.nelems];
            for (int i = 0; i < this.nelems; ++i) {
                this.elem_tag[i] = H4header.this.raf.readShort();
                this.elem_ref[i] = H4header.this.raf.readShort();
            }
        }

        @Override
        public String detail() {
            StringBuilder sbuff = new StringBuilder(super.detail());
            sbuff.append("\n");
            sbuff.append("   tag ref\n   ");
            for (int i = 0; i < this.nelems; ++i) {
                sbuff.append(this.elem_tag[i]).append(" ");
                sbuff.append(this.elem_ref[i]).append(" ");
                sbuff.append("\n   ");
            }
            return sbuff.toString();
        }
    }

    private class TagSDminmax
    extends Tag {
        ByteBuffer bb;
        DataType dt;

        TagSDminmax(short code) throws IOException {
            super(code);
        }

        @Override
        protected void read() throws IOException {
            H4header.this.raf.seek(this.offset);
            byte[] buff = new byte[this.length];
            H4header.this.raf.readFully(buff);
            this.bb = ByteBuffer.wrap(buff);
        }

        Number getMin(DataType dataType) {
            this.dt = dataType;
            return this.get(dataType, 1);
        }

        Number getMax(DataType dataType) {
            this.dt = dataType;
            return this.get(dataType, 0);
        }

        Number get(DataType dataType, int index) {
            if (dataType == DataType.BYTE) {
                return this.bb.get(index);
            }
            if (dataType == DataType.SHORT) {
                return this.bb.asShortBuffer().get(index);
            }
            if (dataType == DataType.INT) {
                return this.bb.asIntBuffer().get(index);
            }
            if (dataType == DataType.LONG) {
                return this.bb.asLongBuffer().get(index);
            }
            if (dataType == DataType.FLOAT) {
                return Float.valueOf(this.bb.asFloatBuffer().get(index));
            }
            if (dataType == DataType.DOUBLE) {
                return this.bb.asDoubleBuffer().get(index);
            }
            return Double.NaN;
        }

        @Override
        public String detail() {
            String sbuff = super.detail() + "   min= " + this.getMin(this.dt) + "   max= " + this.getMax(this.dt);
            return sbuff;
        }
    }

    private class TagTextN
    extends Tag {
        String[] text;

        TagTextN(short code) throws IOException {
            super(code);
        }

        private List<String> getList() {
            ArrayList<String> result = new ArrayList<String>(this.text.length);
            for (String s2 : this.text) {
                if (s2.trim().isEmpty()) continue;
                result.add(s2.trim());
            }
            return result;
        }

        protected void read(int n) throws IOException {
            this.text = new String[n];
            H4header.this.raf.seek(this.offset);
            byte[] b = new byte[this.length];
            H4header.this.raf.readFully(b);
            int count = 0;
            int start = 0;
            for (int i = 0; i < this.length; ++i) {
                if (b[i] != 0) continue;
                this.text[count] = new String(b, start, i - start, StandardCharsets.UTF_8);
                if (++count == n) break;
                start = i + 1;
            }
        }
    }

    private class TagSDDimension
    extends Tag {
        short rank;
        short nt_ref;
        int[] shape;
        short[] nt_ref_scale;

        TagSDDimension(short code) throws IOException {
            super(code);
        }

        @Override
        protected void read() throws IOException {
            int i;
            H4header.this.raf.seek(this.offset);
            this.rank = H4header.this.raf.readShort();
            this.shape = new int[this.rank];
            for (i = 0; i < this.rank; ++i) {
                this.shape[i] = H4header.this.raf.readInt();
            }
            H4header.this.raf.skipBytes(2);
            this.nt_ref = H4header.this.raf.readShort();
            this.nt_ref_scale = new short[this.rank];
            for (i = 0; i < this.rank; ++i) {
                H4header.this.raf.skipBytes(2);
                this.nt_ref_scale[i] = H4header.this.raf.readShort();
            }
        }

        @Override
        public String detail() {
            int i;
            StringBuilder sbuff = new StringBuilder(super.detail());
            sbuff.append("   dims= ");
            for (i = 0; i < this.rank; ++i) {
                sbuff.append(this.shape[i]).append(" ");
            }
            sbuff.append("   nt= ").append(this.nt_ref).append(" nt_scale=");
            for (i = 0; i < this.rank; ++i) {
                sbuff.append(this.nt_ref_scale[i]).append(" ");
            }
            return sbuff.toString();
        }

        @Override
        public String toString() {
            int i;
            StringBuilder sbuff = new StringBuilder(super.toString());
            sbuff.append("   dims= ");
            for (i = 0; i < this.rank; ++i) {
                sbuff.append(this.shape[i]).append(" ");
            }
            sbuff.append("   nt= ").append(this.nt_ref).append(" nt_scale=");
            for (i = 0; i < this.rank; ++i) {
                sbuff.append(this.nt_ref_scale[i]).append(" ");
            }
            return sbuff.toString();
        }
    }

    private class TagRIPalette
    extends Tag {
        int[] table;

        TagRIPalette(short code) throws IOException {
            super(code);
        }

        protected void read(int nx, int ny) throws IOException {
            H4header.this.raf.seek(this.offset);
            this.table = new int[nx * ny];
            H4header.this.raf.readInt(this.table, 0, nx * ny);
        }
    }

    private class TagRIDimension
    extends Tag {
        int xdim;
        int ydim;
        short nt_ref;
        short nelems;
        short interlace;
        short compress;
        short compress_ref;
        List<Dimension> dims;

        TagRIDimension(short code) throws IOException {
            super(code);
        }

        @Override
        protected void read() throws IOException {
            H4header.this.raf.seek(this.offset);
            this.xdim = H4header.this.raf.readInt();
            this.ydim = H4header.this.raf.readInt();
            H4header.this.raf.skipBytes(2);
            this.nt_ref = H4header.this.raf.readShort();
            this.nelems = H4header.this.raf.readShort();
            this.interlace = H4header.this.raf.readShort();
            this.compress = H4header.this.raf.readShort();
            this.compress_ref = H4header.this.raf.readShort();
        }

        @Override
        public String detail() {
            return super.detail() + " xdim=" + this.xdim + " ydim=" + this.ydim + " nelems=" + this.nelems + " nt_ref=" + this.nt_ref + " interlace=" + this.interlace + " compress=" + this.compress + " compress_ref=" + this.compress_ref;
        }
    }

    private class TagNumberType
    extends Tag {
        byte version;
        byte type;
        byte nbits;
        byte type_class;

        TagNumberType(short code) throws IOException {
            super(code);
        }

        @Override
        protected void read() throws IOException {
            H4header.this.raf.seek(this.offset);
            this.version = H4header.this.raf.readByte();
            this.type = H4header.this.raf.readByte();
            this.nbits = H4header.this.raf.readByte();
            this.type_class = H4header.this.raf.readByte();
        }

        @Override
        public String detail() {
            return super.detail() + " version=" + this.version + " type=" + this.type + " nbits=" + this.nbits + " type_class=" + this.type_class;
        }

        @Override
        public String toString() {
            return super.toString() + " type=" + (Object)((Object)H4type.setDataType(this.type, null)) + " nbits=" + this.nbits;
        }
    }

    private class TagAnnotate
    extends Tag {
        String text;
        short obj_tagno;
        short obj_refno;

        TagAnnotate(short code) throws IOException {
            super(code);
        }

        @Override
        protected void read() throws IOException {
            H4header.this.raf.seek(this.offset);
            this.obj_tagno = H4header.this.raf.readShort();
            this.obj_refno = H4header.this.raf.readShort();
            this.text = H4header.this.raf.readStringMax(this.length - 4).trim();
        }

        @Override
        public String detail() {
            String t = this.text.length() < 60 ? this.text : this.text.substring(0, 59);
            return super.detail() + " for=" + this.obj_refno + "/" + this.obj_tagno + " text=" + t;
        }
    }

    private class TagText
    extends Tag {
        String text;

        TagText(short code) throws IOException {
            super(code);
        }

        @Override
        protected void read() throws IOException {
            H4header.this.raf.seek(this.offset);
            this.text = H4header.this.raf.readStringMax(this.length);
        }

        @Override
        public String detail() {
            String t = this.text.length() < 60 ? this.text : this.text.substring(0, 59);
            return super.detail() + " text= " + t;
        }
    }

    private class TagVersion
    extends Tag {
        int major;
        int minor;
        int release;
        String name;

        TagVersion(short code) throws IOException {
            super(code);
        }

        @Override
        protected void read() throws IOException {
            H4header.this.raf.seek(this.offset);
            this.major = H4header.this.raf.readInt();
            this.minor = H4header.this.raf.readInt();
            this.release = H4header.this.raf.readInt();
            this.name = H4header.this.raf.readStringMax(this.length - 12);
        }

        public String value() {
            return this.major + "." + this.minor + "." + this.release + " (" + this.name + ")";
        }

        @Override
        public String detail() {
            return super.detail() + " version= " + this.major + "." + this.minor + "." + this.release + " (" + this.name + ")";
        }
    }

    class TagLinkedBlock
    extends Tag {
        short next_ref;
        short[] block_ref;
        int n;

        TagLinkedBlock(short code) throws IOException {
            super(code);
        }

        private void read2(int nb, List<TagLinkedBlock> dataBlocks) throws IOException {
            int i;
            H4header.this.raf.seek(this.offset);
            this.next_ref = H4header.this.raf.readShort();
            this.block_ref = new short[nb];
            for (i = 0; i < nb; ++i) {
                this.block_ref[i] = H4header.this.raf.readShort();
                if (this.block_ref[i] == 0) break;
                ++this.n;
            }
            if (debugLinked) {
                System.out.println(" TagLinkedBlock read2 " + this.detail());
            }
            for (i = 0; i < this.n; ++i) {
                TagLinkedBlock tag = (TagLinkedBlock)H4header.this.tagMap.get(H4header.tagid(this.block_ref[i], TagEnum.LINKED.getCode()));
                tag.used = true;
                dataBlocks.add(tag);
                if (!debugLinked) continue;
                System.out.println("   Linked data= " + tag.detail());
            }
        }

        @Override
        public String detail() {
            if (this.block_ref == null) {
                return super.detail();
            }
            StringBuilder sbuff = new StringBuilder(super.detail());
            sbuff.append(" next_ref= ").append(this.next_ref);
            sbuff.append(" dataBlks= ");
            for (int i = 0; i < this.n; ++i) {
                short ref = this.block_ref[i];
                sbuff.append(ref).append(" ");
            }
            return sbuff.toString();
        }
    }

    class SpecialLinked {
        int length;
        int first_len;
        short blk_len;
        short num_blk;
        short link_ref;
        List<TagLinkedBlock> linkedDataBlocks;

        SpecialLinked() {
        }

        private void read() throws IOException {
            this.length = H4header.this.raf.readInt();
            this.first_len = H4header.this.raf.readInt();
            this.blk_len = H4header.this.raf.readShort();
            this.num_blk = H4header.this.raf.readShort();
            this.link_ref = H4header.this.raf.readShort();
        }

        List<TagLinkedBlock> getLinkedDataBlocks() throws IOException {
            if (this.linkedDataBlocks == null) {
                this.linkedDataBlocks = new ArrayList<TagLinkedBlock>();
                if (debugLinked) {
                    System.out.println(" TagData readLinkTags " + this.detail());
                }
                short next = this.link_ref;
                while (next != 0) {
                    TagLinkedBlock tag = (TagLinkedBlock)H4header.this.tagMap.get(H4header.tagid(next, TagEnum.LINKED.getCode()));
                    if (tag == null) {
                        throw new IllegalStateException("TagLinkedBlock not found for " + this.detail());
                    }
                    tag.used = true;
                    tag.read2(this.num_blk, this.linkedDataBlocks);
                    next = tag.next_ref;
                }
            }
            return this.linkedDataBlocks;
        }

        public String detail() {
            return "SPECIAL_LINKED length=" + this.length + " first_len=" + this.first_len + " blk_len=" + this.blk_len + " num_blk=" + this.num_blk + " link_ref=" + this.link_ref;
        }
    }

    class SpecialComp {
        short version;
        short model_type;
        short compress_type;
        short data_ref;
        int uncomp_length;
        TagData dataTag;
        short signFlag;
        short fillValue;
        int nt;
        int startBit;
        int bitLength;
        short deflateLevel;

        SpecialComp() {
        }

        private void read() throws IOException {
            this.version = H4header.this.raf.readShort();
            this.uncomp_length = H4header.this.raf.readInt();
            this.data_ref = H4header.this.raf.readShort();
            this.model_type = H4header.this.raf.readShort();
            this.compress_type = H4header.this.raf.readShort();
            if (this.compress_type == TagEnum.COMP_CODE_NBIT) {
                this.nt = H4header.this.raf.readInt();
                this.signFlag = H4header.this.raf.readShort();
                this.fillValue = H4header.this.raf.readShort();
                this.startBit = H4header.this.raf.readInt();
                this.bitLength = H4header.this.raf.readInt();
            } else if (this.compress_type == TagEnum.COMP_CODE_DEFLATE) {
                this.deflateLevel = H4header.this.raf.readShort();
            }
        }

        TagData getDataTag() {
            if (this.dataTag == null) {
                this.dataTag = (TagData)H4header.this.tagMap.get(H4header.tagid(this.data_ref, TagEnum.COMPRESSED.getCode()));
                if (this.dataTag == null) {
                    throw new IllegalStateException("TagCompress not found for " + this.detail());
                }
                this.dataTag.used = true;
            }
            return this.dataTag;
        }

        public String detail() {
            StringBuilder sbuff = new StringBuilder("SPECIAL_COMP ");
            sbuff.append(" version=").append(this.version).append(" uncompressed length =").append(this.uncomp_length).append(" link_ref=").append(this.data_ref);
            sbuff.append(" model_type=").append(this.model_type).append(" compress_type=").append(this.compress_type);
            if (this.compress_type == TagEnum.COMP_CODE_NBIT) {
                sbuff.append(" nt=").append(this.nt).append(" signFlag=").append(this.signFlag).append(" fillValue=").append(this.fillValue).append(" startBit=").append(this.startBit).append(" bitLength=").append(this.bitLength);
            } else if (this.compress_type == TagEnum.COMP_CODE_DEFLATE) {
                sbuff.append(" deflateLevel=").append(this.deflateLevel);
            }
            return sbuff.toString();
        }
    }

    static class DataChunk {
        int[] origin;
        TagData data;

        DataChunk(int[] origin, int[] chunk_length, TagData data) {
            assert (origin.length == chunk_length.length);
            for (int i = 0; i < origin.length; ++i) {
                int n = i;
                origin[n] = origin[n] * chunk_length[i];
            }
            this.origin = origin;
            this.data = data;
            if (debugChunkTable) {
                System.out.print(" Chunk origin=");
                for (int value : origin) {
                    System.out.print(value + " ");
                }
                System.out.println(" data=" + data.detail());
            }
        }
    }

    private class SpecialChunked {
        byte version;
        byte flag;
        short chunk_tbl_tag;
        short chunk_tbl_ref;
        int head_len;
        int elem_tot_length;
        int chunk_size;
        int nt_size;
        int ndims;
        int[] dim_length;
        int[] chunk_length;
        byte[][] dim_flag;
        boolean isCompressed;
        short sp_tag_desc;
        byte[] sp_tag_header;
        List<DataChunk> dataChunks;

        private SpecialChunked() {
        }

        private void read() throws IOException {
            this.head_len = H4header.this.raf.readInt();
            this.version = H4header.this.raf.readByte();
            H4header.this.raf.skipBytes(3);
            this.flag = H4header.this.raf.readByte();
            this.elem_tot_length = H4header.this.raf.readInt();
            this.chunk_size = H4header.this.raf.readInt();
            this.nt_size = H4header.this.raf.readInt();
            this.chunk_tbl_tag = H4header.this.raf.readShort();
            this.chunk_tbl_ref = H4header.this.raf.readShort();
            H4header.this.raf.skipBytes(4);
            this.ndims = H4header.this.raf.readInt();
            this.dim_flag = new byte[this.ndims][4];
            this.dim_length = new int[this.ndims];
            this.chunk_length = new int[this.ndims];
            for (int i = 0; i < this.ndims; ++i) {
                H4header.this.raf.readFully(this.dim_flag[i]);
                this.dim_length[i] = H4header.this.raf.readInt();
                this.chunk_length[i] = H4header.this.raf.readInt();
            }
            int fill_val_numtype = H4header.this.raf.readInt();
            byte[] fill_value = new byte[fill_val_numtype];
            H4header.this.raf.readFully(fill_value);
            this.sp_tag_desc = H4header.this.raf.readShort();
            int sp_header_len = H4header.this.raf.readInt();
            this.sp_tag_header = new byte[sp_header_len];
            H4header.this.raf.readFully(this.sp_tag_header);
        }

        List<DataChunk> getDataChunks() throws IOException {
            if (this.dataChunks == null) {
                TagVH chunkTableTag;
                Structure s2;
                this.dataChunks = new ArrayList<DataChunk>();
                if (debugChunkTable) {
                    System.out.println(" TagData getChunkedTable " + this.detail());
                }
                if ((s2 = (Structure)H4header.this.makeVariable(chunkTableTag = (TagVH)H4header.this.tagMap.get(H4header.tagid(this.chunk_tbl_ref, this.chunk_tbl_tag)))) == null) {
                    throw new IllegalStateException("cant parse " + chunkTableTag);
                }
                ArrayStructure sdata = (ArrayStructure)s2.read();
                if (debugChunkDetail) {
                    System.out.println(Ncdump.printArray(sdata, "getChunkedTable", null));
                }
                StructureMembers members = sdata.getStructureMembers();
                StructureMembers.Member originM = members.findMember("origin");
                StructureMembers.Member tagM = members.findMember("chk_tag");
                StructureMembers.Member refM = members.findMember("chk_ref");
                int n = (int)sdata.getSize();
                if (debugChunkTable) {
                    System.out.println(" Reading " + n + " DataChunk tags");
                }
                for (int i = 0; i < n; ++i) {
                    int[] origin = sdata.getJavaArrayInt(i, originM);
                    short tag = sdata.getScalarShort(i, tagM);
                    short ref = sdata.getScalarShort(i, refM);
                    TagData data = (TagData)H4header.this.tagMap.get(H4header.tagid(ref, tag));
                    this.dataChunks.add(new DataChunk(origin, this.chunk_length, data));
                    data.used = true;
                    if (data.compress == null) continue;
                    this.isCompressed = true;
                }
            }
            return this.dataChunks;
        }

        public String detail() {
            StringBuilder sbuff = new StringBuilder("SPECIAL_CHUNKED ");
            sbuff.append(" head_len=").append(this.head_len).append(" version=").append(this.version).append(" special =").append(this.flag).append(" elem_tot_length=").append(this.elem_tot_length);
            sbuff.append(" chunk_size=").append(this.chunk_size).append(" nt_size=").append(this.nt_size).append(" chunk_tbl_tag=").append(this.chunk_tbl_tag).append(" chunk_tbl_ref=").append(this.chunk_tbl_ref);
            sbuff.append("\n flag  dim  chunk\n");
            for (int i = 0; i < this.ndims; ++i) {
                sbuff.append(" ").append(this.dim_flag[i][2]).append(",").append(this.dim_flag[i][3]).append(" ").append(this.dim_length[i]).append(" ").append(this.chunk_length[i]).append("\n");
            }
            sbuff.append(" special=").append(this.sp_tag_desc).append(" val=");
            for (byte b : this.sp_tag_header) {
                sbuff.append(" ").append(b);
            }
            return sbuff.toString();
        }
    }

    class TagData
    extends Tag {
        short ext_type;
        SpecialLinked linked;
        SpecialComp compress;
        SpecialChunked chunked;
        int tag_len;

        TagData(short code) throws IOException {
            super(code);
        }

        @Override
        protected void read() throws IOException {
            if (this.extended) {
                H4header.this.raf.seek(this.offset);
                this.ext_type = H4header.this.raf.readShort();
                if (this.ext_type == TagEnum.SPECIAL_LINKED) {
                    this.linked = new SpecialLinked();
                    this.linked.read();
                } else if (this.ext_type == TagEnum.SPECIAL_COMP) {
                    this.compress = new SpecialComp();
                    this.compress.read();
                } else if (this.ext_type == TagEnum.SPECIAL_CHUNKED) {
                    this.chunked = new SpecialChunked();
                    this.chunked.read();
                }
                this.tag_len = (int)(H4header.this.raf.getFilePointer() - (long)this.offset);
            }
        }

        @Override
        public String detail() {
            if (this.linked != null) {
                return super.detail() + " ext_tag= " + this.ext_type + " tag_len= " + this.tag_len + " " + this.linked.detail();
            }
            if (this.compress != null) {
                return super.detail() + " ext_tag= " + this.ext_type + " tag_len= " + this.tag_len + " " + this.compress.detail();
            }
            if (this.chunked != null) {
                return super.detail() + " ext_tag= " + this.ext_type + " tag_len= " + this.tag_len + " " + this.chunked.detail();
            }
            return super.detail();
        }
    }

    public class Tag {
        short code;
        short refno;
        boolean extended;
        int offset;
        int length;
        TagEnum t;
        boolean used;
        Vinfo vinfo;

        private Tag(short code) throws IOException {
            this.extended = (code & 0x4000) != 0;
            this.code = (short)(code & 0x3FFF);
            this.refno = H4header.this.raf.readShort();
            this.offset = H4header.this.raf.readInt();
            this.length = H4header.this.raf.readInt();
            this.t = TagEnum.getTag(this.code);
            if (code > 1 && debugTracker) {
                H4header.this.memTracker.add(this.t.getName() + " " + this.refno, this.offset, this.offset + this.length);
            }
        }

        protected void read() throws IOException {
        }

        public String detail() {
            return (this.used ? " " : "*") + "refno=" + this.refno + " tag= " + this.t + (this.extended ? " EXTENDED" : "") + " offset=" + this.offset + " length=" + this.length + (this.vinfo != null && this.vinfo.v != null ? " VV=" + this.vinfo.v.getFullName() : "");
        }

        public String toString() {
            return (this.used ? " " : "*") + "refno=" + this.refno + " tag= " + this.t + (this.extended ? " EXTENDED" : " length=" + this.length);
        }

        public String tag() {
            return this.refno + "/" + this.code;
        }

        public short getCode() {
            return this.code;
        }

        public short getRefno() {
            return this.refno;
        }

        public boolean isExtended() {
            return this.extended;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String getType() {
            return this.t.toString();
        }

        public boolean isUsed() {
            return this.used;
        }

        public String getVinfo() {
            return this.vinfo == null ? "" : this.vinfo.toString();
        }

        public String getVClass() {
            if (this instanceof TagVGroup) {
                return ((TagVGroup)this).className;
            }
            if (this instanceof TagVH) {
                return ((TagVH)this).className;
            }
            return "";
        }
    }

    class Vinfo
    implements Comparable<Vinfo> {
        short refno;
        Variable v;
        List<Tag> tags = new ArrayList<Tag>();
        TagData data;
        int elemSize;
        Object fillValue;
        boolean isLinked;
        boolean isCompressed;
        boolean isChunked;
        boolean hasNoData;
        int start = -1;
        int length;
        long[] segPos;
        int[] segSize;
        List<DataChunk> chunks;
        int[] chunkSize;

        Vinfo(short refno) {
            this.refno = refno;
            H4header.this.refnoMap.put(refno, this);
        }

        void setVariable(Variable v) {
            this.v = v;
            v.setSPobject(this);
        }

        @Override
        public int compareTo(Vinfo o) {
            return Short.compare(this.refno, o.refno);
        }

        void setData(TagData data, int elemSize) {
            this.data = data;
            this.elemSize = elemSize;
            this.hasNoData = data == null;
        }

        void setFillValue(Attribute att) {
            this.fillValue = this.v.getDataType() == DataType.STRING ? att.getStringValue() : att.getNumericValue();
        }

        void setLayoutInfo() throws IOException {
            if (this.data == null) {
                return;
            }
            if (null != this.data.linked) {
                this.isLinked = true;
                this.setDataBlocks(this.data.linked.getLinkedDataBlocks(), this.elemSize);
            } else if (null != this.data.compress) {
                this.isCompressed = true;
                TagData compData = this.data.compress.getDataTag();
                this.tags.add(compData);
                boolean bl = this.isLinked = compData.linked != null;
                if (this.isLinked) {
                    this.setDataBlocks(compData.linked.getLinkedDataBlocks(), this.elemSize);
                } else {
                    this.start = compData.offset;
                    this.length = compData.length;
                    this.hasNoData = this.start < 0 || this.length < 0;
                }
            } else if (null != this.data.chunked) {
                this.isChunked = true;
                this.chunks = this.data.chunked.getDataChunks();
                this.chunkSize = this.data.chunked.chunk_length;
                this.isCompressed = this.data.chunked.isCompressed;
            } else {
                this.start = this.data.offset;
                this.hasNoData = this.start < 0;
            }
        }

        private void setDataBlocks(List<TagLinkedBlock> linkedBlocks, int elemSize) {
            int nsegs = linkedBlocks.size();
            this.segPos = new long[nsegs];
            this.segSize = new int[nsegs];
            int count = 0;
            for (TagLinkedBlock tag : linkedBlocks) {
                this.segPos[count] = tag.offset;
                this.segSize[count] = tag.length;
                ++count;
            }
        }

        public String toString() {
            Formatter sbuff = new Formatter();
            sbuff.format("refno=%d name=%s fillValue=%s %n", this.refno, this.v.getShortName(), this.fillValue);
            sbuff.format(" isChunked=%s isCompressed=%s isLinked=%s hasNoData=%s %n", this.isChunked, this.isCompressed, this.isLinked, this.hasNoData);
            sbuff.format(" elemSize=%d data start=%d length=%s %n%n", this.elemSize, this.start, this.length);
            for (Tag t : this.tags) {
                sbuff.format(" %s%n", t.detail());
            }
            return sbuff.toString();
        }
    }

    static class Minfo {
        int offset;

        Minfo(int offset) {
            this.offset = offset;
        }
    }
}

