/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamCompression;
import ucar.nc2.stream.NcStreamDataCol;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.write.ChunkingIndex;

public class NcStreamWriter {
    private static long maxChunk = 1000000L;
    private static final int sizeToCache = 100;
    private static final int currentVersion = 1;
    private NetcdfFile ncfile;
    private NcStreamProto.Header header;
    private boolean show;

    public NcStreamWriter(NetcdfFile ncfile, String location) throws IOException {
        this.ncfile = ncfile;
        NcStreamProto.Group.Builder rootBuilder = NcStream.encodeGroup(ncfile.getRootGroup(), 100);
        NcStreamProto.Header.Builder headerBuilder = NcStreamProto.Header.newBuilder();
        headerBuilder.setLocation(location == null ? ncfile.getLocation() : location);
        if (ncfile.getTitle() != null) {
            headerBuilder.setTitle(ncfile.getTitle());
        }
        if (ncfile.getId() != null) {
            headerBuilder.setId(ncfile.getId());
        }
        headerBuilder.setRoot(rootBuilder);
        headerBuilder.setVersion(1);
        this.header = headerBuilder.build();
    }

    public long sendStart(OutputStream out) throws IOException {
        return this.writeBytes(out, NcStream.MAGIC_START);
    }

    public long sendEnd(OutputStream out) throws IOException {
        return this.writeBytes(out, NcStream.MAGIC_END);
    }

    public long sendHeader(OutputStream out) throws IOException {
        long size = 0L;
        size += (long)this.writeBytes(out, NcStream.MAGIC_HEADER);
        byte[] b = this.header.toByteArray();
        size += (long)NcStream.writeVInt(out, b.length);
        if (this.show) {
            System.out.println("Write Header len=" + b.length);
        }
        size += (long)this.writeBytes(out, b);
        if (this.show) {
            System.out.println(" header size=" + size);
        }
        return size;
    }

    public long sendData(Variable v, Section section, OutputStream out, NcStreamCompression compress) throws IOException, InvalidRangeException {
        if (this.show) {
            System.out.printf(" %s section=%s%n", v.getFullName(), section);
        }
        long uncompressedLength = section.computeSize();
        if (v.getDataType() != DataType.STRING && v.getDataType() != DataType.OPAQUE && !v.isVariableLength()) {
            uncompressedLength *= (long)v.getElementSize();
        }
        ByteOrder bo = ByteOrder.nativeOrder();
        long size = 0L;
        size += (long)this.writeBytes(out, NcStream.MAGIC_DATA);
        NcStreamProto.Data dataProto = NcStream.encodeDataProto(v, section, compress.type, bo, (int)uncompressedLength);
        byte[] datab = dataProto.toByteArray();
        size += (long)NcStream.writeVInt(out, datab.length);
        size += (long)this.writeBytes(out, datab);
        if (v.getDataType() == DataType.SEQUENCE) {
            assert (v instanceof Structure);
            int count = 0;
            Structure seq = (Structure)v;
            try (StructureDataIterator iter = seq.getStructureIterator(-1);){
                while (iter.hasNext()) {
                    size += (long)this.writeBytes(out, NcStream.MAGIC_VDATA);
                    StructureData sdata = iter.next();
                    ArrayStructureW as = new ArrayStructureW(sdata);
                    size += NcStream.encodeArrayStructure(as, bo, out);
                    ++count;
                }
            }
            size += (long)this.writeBytes(out, NcStream.MAGIC_VEND);
            if (this.show) {
                System.out.printf(" NcStreamWriter sent %d seqData bytes = %d%n", count, size);
            }
            return size;
        }
        if (v.getDataType() == DataType.STRUCTURE) {
            ArrayStructure abb = (ArrayStructure)v.read();
            size += NcStream.encodeArrayStructure(abb, bo, out);
            if (this.show) {
                System.out.printf(" NcStreamWriter sent ArrayStructure bytes = %d%n", size);
            }
            return size;
        }
        out = compress.setupStream(out, (int)uncompressedLength);
        out.flush();
        return size += v.readToStream(section, out);
    }

    public long sendData2(Variable v, Section section, OutputStream out, NcStreamCompression compress) throws IOException, InvalidRangeException {
        boolean isVlen;
        if (this.show) {
            System.out.printf(" %s section=%s%n", v.getFullName(), section);
        }
        if (isVlen = v.isVariableLength()) {
            v.read(section);
        }
        NcStreamDataCol encoder = new NcStreamDataCol();
        NcStreamProto.DataCol dataProto = encoder.encodeData2(v.getFullName(), isVlen, section, v.read(section));
        long size = 0L;
        size += (long)this.writeBytes(out, NcStream.MAGIC_DATA2);
        byte[] datab = dataProto.toByteArray();
        size += (long)NcStream.writeVInt(out, datab.length);
        return size += (long)this.writeBytes(out, datab);
    }

    private int writeBytes(OutputStream out, byte[] b) throws IOException {
        out.write(b);
        return b.length;
    }

    public long streamAll(OutputStream out) throws IOException, InvalidRangeException {
        long size = this.writeBytes(out, NcStream.MAGIC_START);
        size += this.sendHeader(out);
        if (this.show) {
            System.out.printf(" data starts at= %d%n", size);
        }
        for (Variable v : this.ncfile.getVariables()) {
            NcStreamCompression compress;
            Attribute compressAtt = v.findAttribute("_Compress");
            if (compressAtt != null && compressAtt.isString()) {
                String compType = compressAtt.getStringValue();
                if (compType.equalsIgnoreCase("deflate")) {
                    compress = NcStreamCompression.deflate();
                } else {
                    if (this.show) {
                        System.out.printf(" Unknown compression type %s. Defaulting to none.%n", compType);
                    }
                    compress = NcStreamCompression.none();
                }
            } else {
                compress = NcStreamCompression.none();
            }
            long vsize = v.getSize() * (long)v.getElementSize();
            if (this.show) {
                System.out.printf(" var %s len=%d starts at= %d%n", v.getFullName(), vsize, size);
            }
            if (vsize > maxChunk) {
                size += this.copyChunks(out, v, maxChunk, compress);
                continue;
            }
            size += this.sendData(v, v.getShapeAsSection(), out, compress);
        }
        size += (long)this.writeBytes(out, NcStream.MAGIC_END);
        if (this.show) {
            System.out.printf("total size= %d%n", size);
        }
        return size;
    }

    private long copyChunks(OutputStream out, Variable oldVar, long maxChunkSize, NcStreamCompression compress) throws IOException {
        long maxChunkElems = maxChunkSize / (long)oldVar.getElementSize();
        ChunkingIndex index = new ChunkingIndex(oldVar.getShape());
        long size = 0L;
        while ((long)index.currentElement() < index.getSize()) {
            try {
                int[] chunkOrigin = index.getCurrentCounter();
                int[] chunkShape = index.computeChunkShape(maxChunkElems);
                size += this.sendData(oldVar, new Section(chunkOrigin, chunkShape), out, compress);
                index.setCurrentCounter(index.currentElement() + (int)Index.computeSize(chunkShape));
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
        return size;
    }
}

