/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Dimensions;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.internal.iosp.netcdf3.N3iospWriter;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.IOServiceProviderWriter;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.NetcdfFileFormat;
import ucar.unidata.io.RandomAccessFile;

public class NetcdfFormatWriter
implements Closeable {
    private static Logger log = LoggerFactory.getLogger(NetcdfFormatWriter.class);
    private static Set<DataType> validN3types = EnumSet.of(DataType.BYTE, new DataType[]{DataType.CHAR, DataType.SHORT, DataType.INT, DataType.DOUBLE, DataType.FLOAT});
    private final String location;
    private final NetcdfFileFormat format;
    private final boolean isNewFile;
    private final boolean fill;
    private final int extraHeaderBytes;
    private final long preallocateSize;
    private final Nc4Chunking chunker;
    private final boolean useJna;
    private final Group rootGroup;
    private final NetcdfFile ncout;
    private final IOServiceProviderWriter spiw;
    private final RandomAccessFile existingRaf;
    private boolean isClosed = false;

    public static Builder openExisting(String location) throws IOException {
        try (NetcdfFile ncfile = NetcdfFiles.open(location);){
            Group.Builder root = ncfile.getRootGroup().toBuilder();
            Builder builder = NetcdfFormatWriter.builder().setRootGroup(root).setLocation(location).setIosp(ncfile.getIosp());
            return builder;
        }
    }

    public static Builder createNewNetcdf3(String location) {
        return NetcdfFormatWriter.builder().setNewFile(true).setFormat(NetcdfFileFormat.NETCDF3).setLocation(location);
    }

    public static Builder createNewNetcdf4(NetcdfFileFormat format, String location, Nc4Chunking chunker) {
        return NetcdfFormatWriter.builder().setNewFile(true).setFormat(format).setLocation(location).setChunker(chunker);
    }

    public static Builder builder() {
        return new Builder();
    }

    private NetcdfFormatWriter(Builder builder) throws IOException {
        this.location = builder.location;
        this.format = builder.format;
        this.isNewFile = builder.isNewFile;
        this.fill = builder.fill;
        this.extraHeaderBytes = builder.extraHeaderBytes;
        this.preallocateSize = builder.preallocateSize;
        this.chunker = builder.chunker;
        this.useJna = builder.useJna || this.format.isNetdf4format();
        this.ncout = ((NetcdfFile.Builder)NetcdfFile.builder().setRootGroup(builder.rootGroup)).build();
        this.rootGroup = this.ncout.getRootGroup();
        if (!this.isNewFile) {
            this.existingRaf = new RandomAccessFile(this.location, "rw");
            NetcdfFileFormat existingVersion = NetcdfFileFormat.findNetcdfFormatType(this.existingRaf);
            if (this.format != null && this.format != existingVersion) {
                this.existingRaf.close();
                throw new IllegalArgumentException("Existing file at location" + this.location + " (" + (Object)((Object)existingVersion) + ") does not match requested version " + (Object)((Object)this.format));
            }
        } else {
            this.existingRaf = null;
        }
        if (this.useJna) {
            IOServiceProviderWriter spi;
            String className = "ucar.nc2.jni.netcdf.Nc4Iosp";
            try {
                Class<?> iospClass = this.getClass().getClassLoader().loadClass(className);
                NetcdfFileWriter.Version version = NetcdfFormatWriter.convertToNetcdfFileWriterVersion(this.format);
                Constructor<?> ctor = iospClass.getConstructor(((Object)((Object)version)).getClass());
                spi = (IOServiceProviderWriter)ctor.newInstance(new Object[]{version});
                Method method = iospClass.getMethod("setChunker", Nc4Chunking.class);
                method.invoke((Object)spi, this.chunker);
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(className + " cannot use JNI/C library err= " + e.getMessage());
            }
            this.spiw = spi;
        } else {
            this.spiw = new N3iospWriter(builder.getIosp());
        }
        try {
            if (!this.isNewFile) {
                this.spiw.openForWriting(this.existingRaf, this.ncout, null);
            } else {
                this.spiw.create(this.location, this.ncout, this.extraHeaderBytes, this.preallocateSize, this.testIfLargeFile());
            }
            this.spiw.setFill(this.fill);
        }
        catch (Throwable t) {
            this.spiw.close();
            throw t;
        }
    }

    public static NetcdfFileWriter.Version convertToNetcdfFileWriterVersion(NetcdfFileFormat format) {
        switch (format) {
            case NETCDF3: {
                return NetcdfFileWriter.Version.netcdf3;
            }
            case NETCDF4: {
                return NetcdfFileWriter.Version.netcdf4;
            }
            case NETCDF4_CLASSIC: {
                return NetcdfFileWriter.Version.netcdf4_classic;
            }
            case NETCDF3_64BIT_OFFSET: {
                return NetcdfFileWriter.Version.netcdf3c64;
            }
        }
        throw new IllegalStateException("Unsupported format: " + (Object)((Object)format));
    }

    public static NetcdfFileFormat convertToNetcdfFileFormat(NetcdfFileWriter.Version version) {
        switch (version) {
            case netcdf3: {
                return NetcdfFileFormat.NETCDF3;
            }
            case netcdf4: {
                return NetcdfFileFormat.NETCDF4;
            }
            case netcdf4_classic: {
                return NetcdfFileFormat.NETCDF4_CLASSIC;
            }
            case netcdf3c64: {
                return NetcdfFileFormat.NETCDF3_64BIT_OFFSET;
            }
        }
        throw new IllegalStateException("Unsupported version: " + (Object)((Object)version));
    }

    public NetcdfFile getOutputFile() {
        return this.ncout;
    }

    public NetcdfFileFormat getFormat() {
        return this.format;
    }

    @Nullable
    public Variable findVariable(String fullNameEscaped) {
        return this.ncout.findVariable(fullNameEscaped);
    }

    @Nullable
    public Dimension findDimension(String dimName) {
        return this.ncout.findDimension(dimName);
    }

    @Nullable
    public Attribute findGlobalAttribute(String attName) {
        return this.ncout.getRootGroup().findAttribute(attName);
    }

    private String makeValidObjectName(String name) {
        if (!this.isValidObjectName(name)) {
            String nname = this.createValidObjectName(name);
            log.warn("illegal object name= " + name + " change to " + name);
            return nname;
        }
        return name;
    }

    private boolean isValidObjectName(String name) {
        return NetcdfFileFormat.isValidNetcdfObjectName(name);
    }

    private String createValidObjectName(String name) {
        return NetcdfFileFormat.makeValidNetcdfObjectName(name);
    }

    private boolean testIfLargeFile() {
        long maxSize;
        long totalSizeOfVars;
        if (this.format == NetcdfFileFormat.NETCDF3_64BIT_OFFSET) {
            return true;
        }
        if (this.format == NetcdfFileFormat.NETCDF3 && (totalSizeOfVars = this.calcSize(this.ncout.getRootGroup())) > (maxSize = Integer.MAX_VALUE)) {
            log.debug("Request size = {} Mbytes", (Object)(totalSizeOfVars / 1000L / 1000L));
            return true;
        }
        return false;
    }

    public long calcSize() {
        return this.calcSize(this.ncout.getRootGroup());
    }

    private long calcSize(Group group) {
        long totalSizeOfVars = 0L;
        for (Variable var : group.getVariables()) {
            totalSizeOfVars += Dimensions.getSize(var.getDimensions()) * (long)var.getElementSize();
        }
        for (Group nested : group.getGroups()) {
            totalSizeOfVars += this.calcSize(nested);
        }
        return totalSizeOfVars;
    }

    public void write(Variable v, Array values) throws IOException, InvalidRangeException {
        this.write(v, new int[values.getRank()], values);
    }

    public void write(String varName, Array values) throws IOException, InvalidRangeException {
        Variable v = this.findVariable(varName);
        Preconditions.checkNotNull(v);
        this.write(v, values);
    }

    public void write(Variable v, int[] origin, Array values) throws IOException, InvalidRangeException {
        this.spiw.writeData(v, new Section(origin, values.getShape()), values);
    }

    public void write(String varName, int[] origin, Array values) throws IOException, InvalidRangeException {
        Variable v = this.findVariable(varName);
        Preconditions.checkNotNull(v);
        this.write(v, origin, values);
    }

    public void writeStringDataToChar(Variable v, Array values) throws IOException, InvalidRangeException {
        this.writeStringDataToChar(v, new int[values.getRank()], values);
    }

    public void writeStringDataToChar(Variable v, int[] origin, Array values) throws IOException, InvalidRangeException {
        if (values.getElementType() != String.class) {
            throw new IllegalArgumentException("values must be an ArrayObject of String ");
        }
        if (v.getDataType() != DataType.CHAR) {
            throw new IllegalArgumentException("variable " + v.getFullName() + " is not type CHAR");
        }
        int rank = v.getRank();
        int strlen = v.getShape(rank - 1);
        ArrayChar cvalues = ArrayChar.makeFromStringArray((ArrayObject)values, strlen);
        int[] corigin = new int[rank];
        System.arraycopy(origin, 0, corigin, 0, rank - 1);
        this.write(v, corigin, (Array)cvalues);
    }

    public int appendStructureData(Structure s2, StructureData sdata) throws IOException, InvalidRangeException {
        return this.spiw.appendStructureData(s2, sdata);
    }

    public void updateAttribute(Variable v2, Attribute att) throws IOException {
        this.spiw.updateAttribute(v2, att);
    }

    public void flush() throws IOException {
        this.spiw.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isClosed) {
            this.flush();
            this.spiw.close();
            this.isClosed = true;
        }
    }

    public void abort() throws IOException {
        if (!this.isClosed) {
            this.spiw.close();
            this.isClosed = true;
        }
    }

    public static class Result {
        private final long sizeToBeWritten;
        private final boolean wasWritten;
        @Nullable
        private final String errorMessage;

        private Result(long sizeToBeWritten, boolean wasWritten, @Nullable String errorMessage) {
            this.sizeToBeWritten = sizeToBeWritten;
            this.wasWritten = wasWritten;
            this.errorMessage = errorMessage;
        }

        public long sizeToBeWritten() {
            return this.sizeToBeWritten;
        }

        public boolean wasWritten() {
            return this.wasWritten;
        }

        @Nullable
        public String getErrorMessage() {
            return this.errorMessage;
        }

        public static Result create(long sizeToBeWritten, boolean wasWritten, @Nullable String errorMessage) {
            return new Result(sizeToBeWritten, wasWritten, errorMessage);
        }
    }

    public static class Builder {
        private String location;
        private NetcdfFileFormat format = NetcdfFileFormat.NETCDF3;
        private boolean isNewFile = true;
        private boolean fill = true;
        private int extraHeaderBytes;
        private long preallocateSize;
        private Nc4Chunking chunker;
        private boolean useJna;
        private IOServiceProvider iosp;
        private Group.Builder rootGroup = Group.builder().setName("");

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setIosp(IOServiceProvider iosp) {
            this.iosp = iosp;
            return this;
        }

        public IOServiceProvider getIosp() {
            return this.iosp;
        }

        public Builder setFormat(NetcdfFileFormat format) {
            this.format = format;
            return this;
        }

        public NetcdfFileFormat getFormat() {
            return this.format;
        }

        public Builder setNewFile(boolean newFile) {
            this.isNewFile = newFile;
            return this;
        }

        public Builder setFill(boolean fill) {
            this.fill = fill;
            return this;
        }

        public Builder setExtraHeader(int extraHeaderBytes) {
            this.extraHeaderBytes = extraHeaderBytes;
            return this;
        }

        public Builder setPreallocateSize(long preallocateSize) {
            this.preallocateSize = preallocateSize;
            return this;
        }

        public Builder setChunker(Nc4Chunking chunker) {
            this.chunker = chunker;
            return this;
        }

        public Builder setUseJna(boolean useJna) {
            this.useJna = useJna;
            return this;
        }

        public Builder addAttribute(Attribute att) {
            if (!this.isNewFile && !this.useJna) {
                throw new UnsupportedOperationException("Cant add attribute to existing netcdf-3 files");
            }
            this.rootGroup.addAttribute(att);
            return this;
        }

        public Dimension addDimension(String dimName, int length) {
            if (!this.isNewFile && !this.useJna) {
                throw new UnsupportedOperationException("Cant add dimension to existing netcdf-3 files");
            }
            Dimension dim = new Dimension(dimName, length);
            this.rootGroup.addDimension(dim);
            return dim;
        }

        public Dimension addDimension(Dimension dim) {
            if (!this.isNewFile && !this.useJna) {
                throw new UnsupportedOperationException("Cant add dimension to existing netcdf-3 files");
            }
            this.rootGroup.addDimension(dim);
            return dim;
        }

        public Dimension addUnlimitedDimension(String dimName) {
            return this.addDimension(Dimension.builder().setName(dimName).setIsUnlimited(true).build());
        }

        public Group.Builder getRootGroup() {
            return this.rootGroup;
        }

        public Builder setRootGroup(Group.Builder rootGroup) {
            this.rootGroup = rootGroup;
            return this;
        }

        public Variable.Builder addVariable(String shortName, DataType dataType, String dimString) {
            if (!this.isNewFile && !this.useJna) {
                throw new UnsupportedOperationException("Cant add variable to existing netcdf-3 files");
            }
            Object vb = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(shortName)).setDataType(dataType)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(dimString);
            this.rootGroup.addVariable((Variable.Builder<?>)vb);
            return vb;
        }

        public Variable.Builder addVariable(String shortName, DataType dataType, List<Dimension> dims) {
            if (!this.isNewFile && !this.useJna) {
                throw new UnsupportedOperationException("Cant add variable to existing netcdf-3 files");
            }
            Object vb = ((Variable.Builder)((Variable.Builder)((Variable.Builder)Variable.builder().setName(shortName)).setDataType(dataType)).setParentGroupBuilder(this.rootGroup)).setDimensions(dims);
            this.rootGroup.addVariable((Variable.Builder<?>)vb);
            return vb;
        }

        public Structure.Builder addStructure(String shortName, String dimString) {
            if (!this.isNewFile && !this.useJna) {
                throw new UnsupportedOperationException("Cant add structure to existing netcdf-3 files");
            }
            Structure.Builder vb = (Structure.Builder)((Structure.Builder)((Structure.Builder)Structure.builder().setName(shortName)).setParentGroupBuilder(this.rootGroup)).setDimensionsByName(dimString);
            this.rootGroup.addVariable(vb);
            return vb;
        }

        public NetcdfFormatWriter build() throws IOException {
            return new NetcdfFormatWriter(this);
        }
    }
}

