/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;

public class Stereographic
extends ProjectionImpl {
    private double falseEasting;
    private double falseNorthing;
    private double scale;
    private double earthRadius;
    private double latt;
    private double lont;
    private double sinlatt;
    private double coslatt;
    private double latts;
    private boolean isNorth;
    private boolean isPolar;

    public static Stereographic factory(double latt, double lont, double latTrue) {
        double scale = (1.0 + Math.sin(Math.toRadians(latTrue))) / 2.0;
        return new Stereographic(latt, lont, scale);
    }

    @Override
    public ProjectionImpl constructCopy() {
        Stereographic result = new Stereographic(this.getTangentLat(), this.getTangentLon(), this.getScale(), this.getFalseEasting(), this.getFalseNorthing(), this.getEarthRadius());
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }

    public Stereographic() {
        this(90.0, -105.0, 1.0);
    }

    public Stereographic(double latt, double lont, double scale) {
        this(latt, lont, scale, 0.0, 0.0, 6371.229);
    }

    public Stereographic(double latt, double lont, double scale, double false_easting, double false_northing) {
        this(latt, lont, scale, false_easting, false_northing, 6371.229);
    }

    public Stereographic(double latt, double lont, double scale, double false_easting, double false_northing, double radius) {
        super("Stereographic", false);
        this.latt = Math.toRadians(latt);
        this.lont = Math.toRadians(lont);
        this.earthRadius = radius;
        this.scale = scale * this.earthRadius;
        this.falseEasting = false_easting;
        this.falseNorthing = false_northing;
        this.precalculate();
        this.addParameter("grid_mapping_name", "stereographic");
        this.addParameter("longitude_of_projection_origin", lont);
        this.addParameter("latitude_of_projection_origin", latt);
        this.addParameter("scale_factor_at_projection_origin", scale);
        this.addParameter("earth_radius", this.earthRadius * 1000.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            this.addParameter("false_easting", false_easting);
            this.addParameter("false_northing", false_northing);
            this.addParameter("units", "km");
        }
    }

    public Stereographic(double lat_ts_deg, double latt_deg, double lont_deg, boolean north) {
        super("PolarStereographic", false);
        this.latts = Math.toRadians(lat_ts_deg);
        this.latt = Math.toRadians(latt_deg);
        this.lont = Math.toRadians(lont_deg);
        this.isPolar = true;
        this.isNorth = north;
        this.earthRadius = 6371.229;
        this.falseEasting = 0.0;
        this.falseNorthing = 0.0;
        this.precalculate();
        double scaleFactor = lat_ts_deg == 90.0 || lat_ts_deg == -90.0 ? 1.0 : this.getScaleFactor(this.latts, north);
        this.scale = scaleFactor * this.earthRadius;
        this.addParameter("grid_mapping_name", "polar_stereographic");
        this.addParameter("longitude_of_projection_origin", lont_deg);
        this.addParameter("latitude_of_projection_origin", latt_deg);
        this.addParameter("scale_factor_at_projection_origin", scaleFactor);
    }

    private double getScaleFactor(double lat_ts, boolean north) {
        double e = 0.081819191;
        double root = (1.0 + e * Math.sin(lat_ts)) / (1.0 - e * Math.sin(lat_ts));
        double power = e / 2.0;
        double tf = north ? Math.tan(0.7853981633974483 - lat_ts / 2.0) * Math.pow(root, power) : Math.tan(0.7853981633974483 + lat_ts / 2.0) / Math.pow(root, power);
        double mf = Math.cos(lat_ts) / Math.sqrt(1.0 - e * e * Math.pow(Math.sin(lat_ts), 2.0));
        double k0 = mf * Math.sqrt(Math.pow(1.0 + e, 1.0 + e) * Math.pow(1.0 - e, 1.0 - e)) / (2.0 * tf);
        return Double.isNaN(k0) ? 1.0 : k0;
    }

    private void precalculate() {
        this.sinlatt = Math.sin(this.latt);
        this.coslatt = Math.cos(this.latt);
    }

    public double getScale() {
        return this.scale / this.earthRadius;
    }

    public double getNaturalOriginLat() {
        return Math.toDegrees(this.latts);
    }

    public double getTangentLon() {
        return Math.toDegrees(this.lont);
    }

    public double getTangentLat() {
        return Math.toDegrees(this.latt);
    }

    public double getEarthRadius() {
        return this.earthRadius;
    }

    public boolean isNorth() {
        return this.isNorth;
    }

    public boolean isPolar() {
        return this.isPolar;
    }

    public void setScale(double scale) {
        this.scale = this.earthRadius * scale;
    }

    public void setTangentLat(double latt) {
        this.latt = Math.toRadians(latt);
        this.precalculate();
    }

    public void setTangentLon(double lont) {
        this.lont = Math.toRadians(lont);
        this.precalculate();
    }

    public void setCentralMeridian(double lont) {
        this.setTangentLon(lont);
    }

    public void setFalseEasting(double falseEasting) {
        this.falseEasting = falseEasting;
    }

    public void setFalseNorthing(double falseNorthing) {
        this.falseNorthing = falseNorthing;
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "Stereographic{falseEasting=" + this.falseEasting + ", falseNorthing=" + this.falseNorthing + ", scale=" + this.scale + ", earthRadius=" + this.earthRadius + ", latt=" + this.latt + ", lont=" + this.lont + '}';
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stereographic that = (Stereographic)o;
        if (Double.compare(that.earthRadius, this.earthRadius) != 0) {
            return false;
        }
        if (Double.compare(that.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        if (Double.compare(that.falseNorthing, this.falseNorthing) != 0) {
            return false;
        }
        if (Double.compare(that.latt, this.latt) != 0) {
            return false;
        }
        if (Double.compare(that.lont, this.lont) != 0) {
            return false;
        }
        if (Double.compare(that.scale, this.scale) != 0) {
            return false;
        }
        if (this.defaultMapArea == null != (that.defaultMapArea == null)) {
            return false;
        }
        return this.defaultMapArea == null || that.defaultMapArea.equals(this.defaultMapArea);
    }

    public int hashCode() {
        long temp = this.falseEasting != 0.0 ? Double.doubleToLongBits(this.falseEasting) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.falseNorthing != 0.0 ? Double.doubleToLongBits(this.falseNorthing) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.scale != 0.0 ? Double.doubleToLongBits(this.scale) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.earthRadius != 0.0 ? Double.doubleToLongBits(this.earthRadius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.latt != 0.0 ? Double.doubleToLongBits(this.latt) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.lont != 0.0 ? Double.doubleToLongBits(this.lont) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        double lat = Math.toRadians(fromLat);
        double lon = Math.toRadians(fromLon);
        if (Math.abs(lat + this.latt) <= 1.0E-6) {
            lat = -this.latt * 0.999999;
        }
        double sdlon = Math.sin(lon - this.lont);
        double cdlon = Math.cos(lon - this.lont);
        double sinlat = Math.sin(lat);
        double coslat = Math.cos(lat);
        double k = 2.0 * this.scale / (1.0 + this.sinlatt * sinlat + this.coslatt * coslat * cdlon);
        double toX = k * coslat * sdlon;
        double toY = k * (this.coslatt * sinlat - this.sinlatt * coslat * cdlon);
        result.setLocation(toX + this.falseEasting, toY + this.falseNorthing);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = world.getX() - this.falseEasting;
        double fromY = world.getY() - this.falseNorthing;
        double rho = Math.sqrt(fromX * fromX + fromY * fromY);
        double c = 2.0 * Math.atan2(rho, 2.0 * this.scale);
        double sinc = Math.sin(c);
        double cosc = Math.cos(c);
        double phi = Math.abs(rho) < 1.0E-6 ? this.latt : Math.asin(cosc * this.sinlatt + fromY * sinc * this.coslatt / rho);
        double toLat = Math.toDegrees(phi);
        double lam = Math.abs(fromX) < 1.0E-6 && Math.abs(fromY) < 1.0E-6 ? this.lont : (Math.abs(this.coslatt) < 1.0E-6 ? this.lont + Math.atan2(fromX, this.latt > 0.0 ? -fromY : fromY) : this.lont + Math.atan2(fromX * sinc, rho * this.coslatt * cosc - fromY * sinc * this.sinlatt));
        double toLon = Math.toDegrees(lam);
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    @Override
    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        float[] fromLatA = from[latIndex];
        float[] fromLonA = from[lonIndex];
        float[] resultXA = to[0];
        float[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            double lat = Math.toRadians(fromLat);
            double lon = Math.toRadians(fromLon);
            if (Math.abs(lat + this.latt) <= 1.0E-6) {
                lat = -this.latt * 0.999999;
            }
            double sdlon = Math.sin(lon - this.lont);
            double cdlon = Math.cos(lon - this.lont);
            double sinlat = Math.sin(lat);
            double coslat = Math.cos(lat);
            double k = 2.0 * this.scale / (1.0 + this.sinlatt * sinlat + this.coslatt * coslat * cdlon);
            double toX = k * coslat * sdlon;
            double toY = k * (this.coslatt * sinlat - this.sinlatt * coslat * cdlon);
            resultXA[i] = (float)(toX + this.falseEasting);
            resultYA[i] = (float)(toY + this.falseNorthing);
        }
        return to;
    }

    @Override
    public float[][] projToLatLon(float[][] from, float[][] to) {
        int cnt = from[0].length;
        float[] fromXA = from[0];
        float[] fromYA = from[1];
        float[] toLatA = to[0];
        float[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromX = (double)fromXA[i] - this.falseEasting;
            double fromY = (double)fromYA[i] - this.falseNorthing;
            double rho = Math.sqrt(fromX * fromX + fromY * fromY);
            double c = 2.0 * Math.atan2(rho, 2.0 * this.scale);
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            double phi = Math.abs(rho) < 1.0E-6 ? this.latt : Math.asin(cosc * this.sinlatt + fromY * sinc * this.coslatt / rho);
            double toLat = Math.toDegrees(phi);
            double lam = Math.abs(fromX) < 1.0E-6 && Math.abs(fromY) < 1.0E-6 ? this.lont : (Math.abs(this.coslatt) < 1.0E-6 ? this.lont + Math.atan2(fromX, this.latt > 0.0 ? -fromY : fromY) : this.lont + Math.atan2(fromX * sinc, rho * this.coslatt * cosc - fromY * sinc * this.sinlatt));
            double toLon = Math.toDegrees(lam);
            toLatA[i] = (float)toLat;
            toLonA[i] = (float)toLon;
        }
        return to;
    }

    @Override
    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        double[] fromLatA = from[latIndex];
        double[] fromLonA = from[lonIndex];
        double[] resultXA = to[0];
        double[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            double lat = Math.toRadians(fromLat);
            double lon = Math.toRadians(fromLon);
            if (Math.abs(lat + this.latt) <= 1.0E-6) {
                lat = -this.latt * 0.999999;
            }
            double sdlon = Math.sin(lon - this.lont);
            double cdlon = Math.cos(lon - this.lont);
            double sinlat = Math.sin(lat);
            double coslat = Math.cos(lat);
            double k = 2.0 * this.scale / (1.0 + this.sinlatt * sinlat + this.coslatt * coslat * cdlon);
            double toX = k * coslat * sdlon;
            double toY = k * (this.coslatt * sinlat - this.sinlatt * coslat * cdlon);
            resultXA[i] = toX + this.falseEasting;
            resultYA[i] = toY + this.falseNorthing;
        }
        return to;
    }

    @Override
    public double[][] projToLatLon(double[][] from, double[][] to) {
        int cnt = from[0].length;
        double[] fromXA = from[0];
        double[] fromYA = from[1];
        double[] toLatA = to[0];
        double[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromX = fromXA[i] - this.falseEasting;
            double fromY = fromYA[i] - this.falseNorthing;
            double rho = Math.sqrt(fromX * fromX + fromY * fromY);
            double c = 2.0 * Math.atan2(rho, 2.0 * this.scale);
            double sinc = Math.sin(c);
            double cosc = Math.cos(c);
            double phi = Math.abs(rho) < 1.0E-6 ? this.latt : Math.asin(cosc * this.sinlatt + fromY * sinc * this.coslatt / rho);
            double toLat = Math.toDegrees(phi);
            double lam = Math.abs(fromX) < 1.0E-6 && Math.abs(fromY) < 1.0E-6 ? this.lont : (Math.abs(this.coslatt) < 1.0E-6 ? this.lont + Math.atan2(fromX, this.latt > 0.0 ? -fromY : fromY) : this.lont + Math.atan2(fromX * sinc, rho * this.coslatt * cosc - fromY * sinc * this.sinlatt));
            double toLon = Math.toDegrees(lam);
            toLatA[i] = toLat;
            toLonA[i] = toLon;
        }
        return to;
    }
}

