/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization;

import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.IOTools;

public final class SizeMarshallers {
    private SizeMarshallers() {
    }

    public static SizeMarshaller stopBit() {
        return StopBit.INSTANCE;
    }

    public static SizeMarshaller constant(long size) {
        return new ConstantSizeMarshaller(size);
    }

    private static class ConstantSizeMarshaller
    implements SizeMarshaller {
        private static final long serialVersionUID = 0L;
        private final long size;

        private ConstantSizeMarshaller(long size) {
            this.size = size;
        }

        @Override
        public int sizeEncodingSize(long size) {
            return 0;
        }

        @Override
        public long minEncodableSize() {
            return this.size;
        }

        @Override
        public int minSizeEncodingSize() {
            return 0;
        }

        @Override
        public int maxSizeEncodingSize() {
            return 0;
        }

        @Override
        public void writeSize(Bytes bytes, long size) {
        }

        @Override
        public long readSize(Bytes bytes) {
            return this.size;
        }
    }

    private static enum StopBit implements SizeMarshaller
    {
        INSTANCE;


        @Override
        public int sizeEncodingSize(long size) {
            return IOTools.stopBitLength(size);
        }

        @Override
        public long minEncodableSize() {
            return 0L;
        }

        @Override
        public int minSizeEncodingSize() {
            return 1;
        }

        @Override
        public int maxSizeEncodingSize() {
            return 9;
        }

        @Override
        public void writeSize(Bytes bytes, long size) {
            bytes.writeStopBit(size);
        }

        @Override
        public long readSize(Bytes bytes) {
            return bytes.readStopBit();
        }
    }
}

