/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.serialization.internal;

import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshaller;

public final class BytesReaders {
    private BytesReaders() {
    }

    public static <E> BytesReader<E> fromBytesMarshaller(BytesMarshaller<? super E> marshaller) {
        return new SimpleBytesReader<E>(marshaller);
    }

    public static <E> BytesMarshaller<E> getBytesMarshaller(BytesReader<E> reader) {
        return reader instanceof SimpleBytesReader ? ((SimpleBytesReader)reader).marshaller : null;
    }

    private static class SimpleBytesReader<E>
    implements BytesReader<E> {
        private static final long serialVersionUID = 0L;
        private final BytesMarshaller<? super E> marshaller;

        public SimpleBytesReader(BytesMarshaller<? super E> marshaller) {
            this.marshaller = marshaller;
        }

        @Override
        public E read(Bytes bytes, long size) {
            return this.marshaller.read(bytes);
        }

        @Override
        public E read(Bytes bytes, long size, E toReuse) {
            return this.marshaller.read(bytes, toReuse);
        }
    }
}

