/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.map;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import net.openhft.chronicle.hash.serialization.BytesInterop;
import net.openhft.chronicle.hash.serialization.BytesReader;
import net.openhft.chronicle.hash.serialization.BytesWriter;
import net.openhft.chronicle.hash.serialization.DeserializationFactoryConfigurableBytesReader;
import net.openhft.chronicle.hash.serialization.SizeMarshaller;
import net.openhft.chronicle.hash.serialization.SizeMarshallers;
import net.openhft.chronicle.hash.serialization.internal.ByteArrayMarshaller;
import net.openhft.chronicle.hash.serialization.internal.ByteBufferMarshaller;
import net.openhft.chronicle.hash.serialization.internal.ByteableMarshaller;
import net.openhft.chronicle.hash.serialization.internal.BytesReaders;
import net.openhft.chronicle.hash.serialization.internal.CharArrayMarshaller;
import net.openhft.chronicle.hash.serialization.internal.CharSequenceReader;
import net.openhft.chronicle.hash.serialization.internal.CharSequenceWriter;
import net.openhft.chronicle.hash.serialization.internal.CopyingMetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.DataValueBytesMarshallers;
import net.openhft.chronicle.hash.serialization.internal.DataValueMetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.DelegatingMetaBytesInteropProvider;
import net.openhft.chronicle.hash.serialization.internal.DoubleMarshaller;
import net.openhft.chronicle.hash.serialization.internal.IntegerMarshaller;
import net.openhft.chronicle.hash.serialization.internal.LongMarshaller;
import net.openhft.chronicle.hash.serialization.internal.MetaBytesInterop;
import net.openhft.chronicle.hash.serialization.internal.MetaProvider;
import net.openhft.chronicle.hash.serialization.internal.VoidMarshaller;
import net.openhft.chronicle.map.Objects;
import net.openhft.lang.io.ByteBufferBytes;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.ObjectFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.AllocateInstanceObjectFactory;
import net.openhft.lang.io.serialization.impl.BytesMarshallableMarshaller;
import net.openhft.lang.io.serialization.impl.ExternalizableMarshaller;
import net.openhft.lang.io.serialization.impl.NewInstanceObjectFactory;
import net.openhft.lang.io.serialization.impl.NullObjectFactory;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.model.DataValueGenerator;
import net.openhft.lang.model.DataValueModel;
import net.openhft.lang.model.DataValueModels;
import net.openhft.lang.threadlocal.Provider;
import net.openhft.lang.threadlocal.ThreadLocalCopies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SerializationBuilder<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final Bytes EMPTY_BYTES = new ByteBufferBytes(ByteBuffer.allocate(0));
    private static final List<Class> knownJDKImmutableClasses = Arrays.asList(String.class, Byte.class, Short.class, Character.class, Integer.class, Float.class, Long.class, Double.class, BigDecimal.class, BigInteger.class, URL.class);
    final Class<E> eClass;
    final boolean sizeIsStaticallyKnown;
    private final Role role;
    boolean serializesGeneratedClasses = false;
    private boolean instancesAreMutable;
    private SizeMarshaller sizeMarshaller = SizeMarshallers.stopBit();
    private BytesReader<E> reader;
    private Object interop;
    private CopyingInterop copyingInterop = null;
    private MetaBytesInterop<E, ?> metaInterop;
    private MetaProvider<E, ?, ?> metaInteropProvider;
    private long maxSize;

    SerializationBuilder(Class<E> eClass, Role role) {
        this.role = role;
        this.eClass = eClass;
        this.configureByDefault(eClass, role);
        this.sizeIsStaticallyKnown = this.constantSizeMarshaller();
    }

    private static boolean concreteClass(Class c) {
        return !c.isInterface() && !Modifier.isAbstract(c.getModifiers());
    }

    private static boolean marshallerUseFactory(Class c) {
        return Byteable.class.isAssignableFrom(c) || BytesMarshallable.class.isAssignableFrom(c) || Externalizable.class.isAssignableFrom(c);
    }

    private static boolean instancesAreMutable(Class c) {
        return !knownJDKImmutableClasses.contains(c);
    }

    private void configureByDefault(Class<E> eClass, Role role) {
        BytesMarshaller<E> marshaller;
        NewInstanceObjectFactory<E> factory;
        this.instancesAreMutable = SerializationBuilder.instancesAreMutable(eClass);
        if (eClass.isInterface()) {
            try {
                BytesReader<E> reader = DataValueBytesMarshallers.acquireBytesReader(eClass);
                BytesWriter<E> writer = DataValueBytesMarshallers.acquireBytesWriter(eClass);
                DataValueModel<E> model = DataValueModels.acquireModel(eClass);
                int size = DataValueGenerator.computeNonScalarOffset(model, eClass);
                this.reader(reader);
                this.copyingInterop(null);
                this.setInterop(writer);
                this.metaInterop(DataValueMetaBytesInterop.forIdentity((Serializable)((Object)role)));
                this.metaInteropProvider(DataValueMetaBytesInterop.interopProvider(eClass));
                this.sizeMarshaller(SizeMarshallers.constant(size));
                this.serializesGeneratedClasses = true;
                return;
            }
            catch (Exception e) {
                try {
                    eClass = DataValueClasses.directClassFor(eClass);
                    this.serializesGeneratedClasses = true;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        NewInstanceObjectFactory<E> newInstanceObjectFactory = factory = SerializationBuilder.concreteClass(eClass) && SerializationBuilder.marshallerUseFactory(eClass) ? new NewInstanceObjectFactory<E>(eClass) : NullObjectFactory.of();
        if (SerializationBuilder.concreteClass(eClass) && Byteable.class.isAssignableFrom(eClass)) {
            ByteableMarshaller<E> byteableMarshaller = ByteableMarshaller.of(eClass);
            this.sizeMarshaller(byteableMarshaller);
            this.reader(byteableMarshaller);
            this.interop(byteableMarshaller);
        } else if (eClass == CharSequence.class || eClass == String.class) {
            this.reader(CharSequenceReader.of());
            this.writer(CharSequenceWriter.instance());
        } else if (eClass == StringBuilder.class) {
            this.reader(CharSequenceReader.ofStringBuilder());
            this.writer(CharSequenceWriter.instance());
        } else if (eClass == Void.class) {
            this.sizeMarshaller(VoidMarshaller.INSTANCE);
            this.reader(VoidMarshaller.INSTANCE);
            this.interop(VoidMarshaller.INSTANCE);
        } else if (eClass == Long.class) {
            this.sizeMarshaller(LongMarshaller.INSTANCE);
            this.reader(LongMarshaller.INSTANCE);
            this.interop(LongMarshaller.INSTANCE);
        } else if (eClass == Double.class) {
            this.sizeMarshaller(DoubleMarshaller.INSTANCE);
            this.reader(DoubleMarshaller.INSTANCE);
            this.interop(DoubleMarshaller.INSTANCE);
        } else if (eClass == Integer.class) {
            this.sizeMarshaller(IntegerMarshaller.INSTANCE);
            this.reader(IntegerMarshaller.INSTANCE);
            this.interop(IntegerMarshaller.INSTANCE);
        } else if (eClass == byte[].class) {
            this.reader(ByteArrayMarshaller.INSTANCE);
            this.interop(ByteArrayMarshaller.INSTANCE);
        } else if (eClass == char[].class) {
            this.reader(CharArrayMarshaller.INSTANCE);
            this.interop(CharArrayMarshaller.INSTANCE);
        } else if (eClass == ByteBuffer.class) {
            this.reader(ByteBufferMarshaller.INSTANCE);
            this.writer(ByteBufferMarshaller.INSTANCE);
        } else if (SerializationBuilder.concreteClass(eClass) && (marshaller = this.chooseMarshaller(eClass, eClass)) != null) {
            this.marshaller(marshaller);
        }
        if (SerializationBuilder.concreteClass(eClass) && SerializationBuilder.marshallerUseFactory(eClass)) {
            this.factory(factory);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.serializesGeneratedClasses);
        if (this.serializesGeneratedClasses) {
            out.writeObject(this.eClass);
            out.writeObject((Object)this.role);
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean generatedClassesSerialized = in.readBoolean();
        if (generatedClassesSerialized) {
            Class eClass = (Class)in.readObject();
            Role role = (Role)((Object)in.readObject());
            new SerializationBuilder<E>(eClass, role);
        }
        in.defaultReadObject();
    }

    boolean possibleOffHeapReferences() {
        if (this.reader instanceof CharSequenceReader) {
            return false;
        }
        if (this.reader instanceof VoidMarshaller) {
            return false;
        }
        if (!SerializationBuilder.instancesAreMutable(this.eClass)) {
            return false;
        }
        if (this.eClass.isArray() && (this.eClass.getComponentType().isPrimitive() || SerializationBuilder.instancesAreMutable(this.eClass.getComponentType()))) {
            return false;
        }
        BytesMarshaller<E> marshallerAsReader = BytesReaders.getBytesMarshaller(this.reader);
        return !(marshallerAsReader instanceof SerializableMarshaller) && !(marshallerAsReader instanceof ExternalizableMarshaller);
    }

    private BytesMarshaller<E> chooseMarshaller(Class<E> eClass, Class<E> classForMarshaller) {
        if (BytesMarshallable.class.isAssignableFrom(eClass)) {
            return new BytesMarshallableMarshaller<E>(classForMarshaller);
        }
        if (Externalizable.class.isAssignableFrom(eClass)) {
            return new ExternalizableMarshaller<E>(classForMarshaller);
        }
        return null;
    }

    private SerializationBuilder<E> copyingInterop(CopyingInterop copyingInterop) {
        this.copyingInterop = copyingInterop;
        return this;
    }

    public SerializationBuilder<E> interop(BytesInterop<E> interop) {
        return super.metaInteropProvider(DelegatingMetaBytesInteropProvider.instance());
    }

    public SerializationBuilder<E> writer(BytesWriter<E> writer) {
        if (writer instanceof BytesInterop) {
            return this.interop((BytesInterop)writer);
        }
        return super.metaInterop(CopyingMetaBytesInterop.forBytesWriter((Serializable)((Object)this.role)));
    }

    public SerializationBuilder<E> marshaller(BytesMarshaller<? super E> marshaller) {
        return super.metaInterop(CopyingMetaBytesInterop.forBytesMarshaller((Serializable)((Object)this.role)));
    }

    public SerializationBuilder<E> maxSize(long maxSize) {
        if (this.copyingInterop == CopyingInterop.FROM_MARSHALLER) {
            this.maxSize = maxSize;
            this.metaInteropProvider(CopyingMetaBytesInterop.providerForBytesMarshaller(this.instancesAreMutable, maxSize));
        } else if (this.copyingInterop == CopyingInterop.FROM_WRITER) {
            this.maxSize = maxSize;
            this.metaInteropProvider(CopyingMetaBytesInterop.providerForBytesWriter(this.instancesAreMutable));
        }
        return this;
    }

    public SerializationBuilder<E> constantSizeBySample(E sampleObject) {
        long expectedConstantSize;
        MetaBytesInterop<E, ?> metaInterop;
        Object interop;
        block5: {
            MetaProvider<E, ?, ?> metaInteropProvider;
            Object originalInterop = this.interop;
            Provider<?> interopProvider = Provider.of(originalInterop.getClass());
            ThreadLocalCopies copies = interopProvider.getCopies(null);
            interop = interopProvider.get(copies, originalInterop);
            copies = this.metaInteropProvider.getCopies(copies);
            if (this.maxSize > 0L) {
                while (true) {
                    metaInteropProvider = this.metaInteropProvider;
                    try {
                        metaInterop = metaInteropProvider.get(copies, this.metaInterop, interop, sampleObject);
                        break block5;
                    }
                    catch (Exception e) {
                        CopyingMetaBytesInterop.checkMaxSizeStillReasonable(this.maxSize, e);
                        this.maxSize(this.maxSize * 2L);
                        continue;
                    }
                    break;
                }
            }
            metaInteropProvider = this.metaInteropProvider;
            metaInterop = metaInteropProvider.get(copies, this.metaInterop, interop, sampleObject);
        }
        long constantSize = metaInterop.size(interop, sampleObject);
        if (this.sizeIsStaticallyKnown && constantSize != (expectedConstantSize = this.pseudoReadConstantSize())) {
            throw new IllegalStateException("Although configuring constant size by sample is not forbidden for types which size we already know statically, they should be the same. For " + this.eClass + " we know constant size is " + expectedConstantSize + " statically, configured sample is " + sampleObject + " which size in serialized form is " + constantSize);
        }
        this.maxSize(constantSize);
        this.sizeMarshaller(SizeMarshallers.constant(constantSize));
        return this;
    }

    public SerializationBuilder<E> objectSerializer(ObjectSerializer serializer) {
        if (this.reader == null || this.interop == null) {
            this.marshaller(new SerializableMarshaller(serializer, this.eClass));
        }
        return this;
    }

    public SerializationBuilder<E> instancesAreMutable(boolean mutable) {
        this.instancesAreMutable = mutable;
        return this;
    }

    public SizeMarshaller sizeMarshaller() {
        return this.sizeMarshaller;
    }

    boolean constantSizeMarshaller() {
        try {
            return this.sizeMarshaller().sizeEncodingSize(1L) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean constantSizeEncodingSizeMarshaller() {
        return this.sizeMarshaller().minSizeEncodingSize() == this.sizeMarshaller().maxSizeEncodingSize();
    }

    long pseudoReadConstantSize() {
        return this.sizeMarshaller().readSize(EMPTY_BYTES);
    }

    public SerializationBuilder<E> sizeMarshaller(SizeMarshaller sizeMarshaller) {
        this.sizeMarshaller = sizeMarshaller;
        return this;
    }

    public BytesReader<E> reader() {
        return this.reader;
    }

    public SerializationBuilder<E> reader(BytesReader<E> reader) {
        this.reader = reader;
        return this;
    }

    public Object interop() {
        return this.interop;
    }

    private SerializationBuilder<E> setInterop(Object interop) {
        this.interop = interop;
        return this;
    }

    public MetaBytesInterop<E, ?> metaInterop() {
        return this.metaInterop;
    }

    private SerializationBuilder<E> metaInterop(MetaBytesInterop<E, ?> metaInterop) {
        this.metaInterop = metaInterop;
        return this;
    }

    public MetaProvider<E, ?, MetaBytesInterop<E, ?>> metaInteropProvider() {
        return this.metaInteropProvider;
    }

    private SerializationBuilder<E> metaInteropProvider(MetaProvider<E, ?, ?> metaInteropProvider) {
        this.metaInteropProvider = metaInteropProvider;
        return this;
    }

    public SerializationBuilder<E> factory(ObjectFactory<E> factory) {
        if (this.reader instanceof DeserializationFactoryConfigurableBytesReader) {
            Object newReader = ((DeserializationFactoryConfigurableBytesReader)this.reader).withDeserializationFactory(factory);
            this.reader((BytesReader<E>)newReader);
            if (newReader instanceof BytesInterop) {
                this.interop((BytesInterop)newReader);
            }
            if (newReader instanceof SizeMarshaller) {
                this.sizeMarshaller((SizeMarshaller)newReader);
            }
            return this;
        }
        if (!SerializationBuilder.marshallerUseFactory(this.eClass)) {
            throw new IllegalStateException("Default marshaller for " + this.eClass + " value don't use object factory");
        }
        if (this.interop instanceof BytesMarshallableMarshaller) {
            this.interop = factory instanceof AllocateInstanceObjectFactory ? new BytesMarshallableMarshaller(((AllocateInstanceObjectFactory)factory).allocatedClass()) : new BytesMarshallableMarshallerWithCustomFactory(((BytesMarshallableMarshaller)this.interop).marshaledClass(), factory);
        } else if (this.interop instanceof ExternalizableMarshaller) {
            this.interop = factory instanceof AllocateInstanceObjectFactory ? new ExternalizableMarshaller(((AllocateInstanceObjectFactory)factory).allocatedClass()) : new ExternalizableMarshallerWithCustomFactory(((ExternalizableMarshaller)this.interop).marshaledClass(), factory);
        } else {
            String role = this.role.toString().toLowerCase();
            throw new IllegalStateException(role + "DeserializationFactory() should be called " + "only if the Map " + role + " type is Byteable, BytesMarshallable " + "or Externalizable subtype and no custom marshallers were configured.");
        }
        return this;
    }

    public SerializationBuilder<E> clone() {
        try {
            return (SerializationBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static class ExternalizableMarshallerWithCustomFactory<T extends Externalizable>
    extends ExternalizableMarshaller<T> {
        private static final long serialVersionUID = 0L;
        @NotNull
        private final ObjectFactory<T> factory;

        ExternalizableMarshallerWithCustomFactory(@NotNull Class<T> tClass, @NotNull ObjectFactory<T> factory) {
            super(tClass);
            this.factory = factory;
        }

        @Override
        @NotNull
        protected T getInstance() throws Exception {
            return (T)((Externalizable)this.factory.create());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ExternalizableMarshallerWithCustomFactory that = (ExternalizableMarshallerWithCustomFactory)obj;
            return that.marshaledClass() == this.marshaledClass() && that.factory.equals(this.factory);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.marshaledClass(), this.factory);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "{marshaledClass=" + this.marshaledClass() + ",factory=" + this.factory + "}";
        }
    }

    private static class BytesMarshallableMarshallerWithCustomFactory<T extends BytesMarshallable>
    extends BytesMarshallableMarshaller<T> {
        private static final long serialVersionUID = 0L;
        @NotNull
        private final ObjectFactory<T> factory;

        BytesMarshallableMarshallerWithCustomFactory(@NotNull Class<T> tClass, @NotNull ObjectFactory<T> factory) {
            super(tClass);
            this.factory = factory;
        }

        @Override
        @NotNull
        protected T getInstance() throws Exception {
            return (T)((BytesMarshallable)this.factory.create());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            BytesMarshallableMarshallerWithCustomFactory that = (BytesMarshallableMarshallerWithCustomFactory)obj;
            return that.marshaledClass() == this.marshaledClass() && that.factory.equals(this.factory);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.marshaledClass(), this.factory);
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "{marshaledClass=" + this.marshaledClass() + ",factory=" + this.factory + "}";
        }
    }

    private static class SerializableMarshaller
    implements BytesMarshaller {
        private static final long serialVersionUID = 0L;
        private final ObjectSerializer serializer;
        private final Class expectedClass;

        private SerializableMarshaller(ObjectSerializer serializer, Class expectedClass) {
            this.serializer = serializer;
            this.expectedClass = expectedClass;
        }

        public void write(Bytes bytes, Object obj) {
            try {
                this.serializer.writeSerializable(bytes, obj, this.expectedClass);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Nullable
        public Object read(Bytes bytes) {
            try {
                return this.serializer.readSerializable(bytes, null, null);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        @Nullable
        public Object read(Bytes bytes, @Nullable Object obj) {
            try {
                return this.serializer.readSerializable(bytes, null, obj);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static enum CopyingInterop {
        FROM_MARSHALLER,
        FROM_WRITER;

    }

    static enum Role {
        KEY,
        VALUE;

    }
}

