/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.Property;
import thredds.client.catalog.Service;
import thredds.client.catalog.ThreddsMetadata;
import thredds.client.catalog.ThreddsMetadataContainer;
import ucar.nc2.constants.CDM;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;

public class CatalogXmlWriter {
    private static boolean useBytesForDataSize = false;
    private static final String version = "1.2";
    private boolean raw = false;

    public static void useBytesForDataSize(boolean b) {
        useBytesForDataSize = b;
    }

    public void writeXML(Catalog catalog, OutputStream os, boolean raw) throws IOException {
        this.raw = raw;
        this.writeXML(catalog, os);
        this.raw = false;
    }

    public String writeXML(Catalog catalog) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(100000);
        this.writeXML(catalog, bos);
        this.raw = false;
        return new String(bos.toByteArray(), CDM.utf8Charset);
    }

    public void writeXML(Catalog catalog, OutputStream os) throws IOException {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        fmt.output(this.writeCatalog(catalog), os);
    }

    public Document writeCatalog(Catalog cat) {
        Element rootElem = new Element("catalog", Catalog.defNS);
        Document doc = new Document(rootElem);
        if (cat.getName() != null) {
            rootElem.setAttribute("name", cat.getName());
        }
        rootElem.setAttribute("version", version);
        rootElem.addNamespaceDeclaration(Catalog.xlinkNS);
        if (cat.getExpires() != null) {
            rootElem.setAttribute("expires", cat.getExpires().toString());
        }
        for (Service service : cat.getServices()) {
            rootElem.addContent(this.writeService(service));
        }
        for (Property p : cat.getProperties()) {
            rootElem.addContent(this.writeProperty(p));
        }
        for (Dataset ds : cat.getDatasetsLocal()) {
            if (ds instanceof CatalogRef) {
                rootElem.addContent(this.writeCatalogRef((CatalogRef)ds));
                continue;
            }
            rootElem.addContent(this.writeDataset(ds));
        }
        return doc;
    }

    private Element writeAccess(Access access) {
        Element accessElem = new Element("access", Catalog.defNS);
        accessElem.setAttribute("urlPath", access.getUrlPath());
        if (access.getService() != null) {
            accessElem.setAttribute("serviceName", access.getService().getName());
        }
        if (access.getDataFormatName() != null) {
            accessElem.setAttribute("dataFormat", access.getDataFormatName());
        }
        if (access.getDataSize() > 0L) {
            accessElem.addContent(this.writeDataSize(access.getDataSize()));
        }
        return accessElem;
    }

    private Element writeCatalogRef(CatalogRef catRef) {
        Element catrefElem = new Element("catalogRef", Catalog.defNS);
        catrefElem.setAttribute("href", catRef.getXlinkHref(), Catalog.xlinkNS);
        String name = catRef.getName() == null ? "" : catRef.getName();
        catrefElem.setAttribute("title", name, Catalog.xlinkNS);
        if (catRef.getId() != null) {
            catrefElem.setAttribute("ID", catRef.getId());
        }
        if (catRef.getRestrictAccess() != null) {
            catrefElem.setAttribute("restrictAccess", catRef.getRestrictAccess());
        }
        catrefElem.setAttribute("name", "");
        this.writeDatasetInfo(catRef, catrefElem, false, this.raw);
        return catrefElem;
    }

    protected Element writeContributor(ThreddsMetadata.Contributor c) {
        Element elem = new Element("contributor", Catalog.defNS);
        if (c.getRole() != null) {
            elem.setAttribute("role", c.getRole());
        }
        elem.setText(c.getName());
        return elem;
    }

    private Element writeControlledVocabulary(ThreddsMetadata.Vocab v, String name) {
        Element elem = new Element(name, Catalog.defNS);
        if (v.getVocabulary() != null) {
            elem.setAttribute("vocabulary", v.getVocabulary());
        }
        elem.addContent(v.getText());
        return elem;
    }

    private Element writeDataset(Dataset ds) {
        Element dsElem = new Element("dataset", Catalog.defNS);
        this.writeDatasetInfo(ds, dsElem, true, this.raw);
        return dsElem;
    }

    private void writeDatasetInfo(Dataset ds, Element dsElem, boolean doNestedDatasets, boolean showNcML) {
        String name = ds.getName();
        if (name == null) {
            name = "";
        }
        dsElem.setAttribute("name", name);
        if (ds.getCollectionType() != null) {
            dsElem.setAttribute("collectionType", ds.getCollectionType());
        }
        if (ds.isHarvest()) {
            dsElem.setAttribute("harvest", "true");
        }
        if (ds.getID() != null) {
            dsElem.setAttribute("ID", ds.getID());
        }
        if (ds.getUrlPath() != null) {
            dsElem.setAttribute("urlPath", ds.getUrlPath());
        }
        if (ds.getRestrictAccess() != null) {
            dsElem.setAttribute("restrictAccess", ds.getRestrictAccess());
        }
        this.writeThreddsMetadata(dsElem, ds);
        this.writeInheritedMetadata(dsElem, ds);
        List access = ds.getLocalFieldAsList("Access");
        for (Access a : access) {
            dsElem.addContent(this.writeAccess(a));
        }
        if (!doNestedDatasets) {
            return;
        }
        for (Dataset nested : ds.getDatasetsLocal()) {
            if (nested instanceof CatalogRef) {
                dsElem.addContent(this.writeCatalogRef((CatalogRef)nested));
                continue;
            }
            dsElem.addContent(this.writeDataset(nested));
        }
    }

    protected Element writeDate(String name, DateType date) {
        Element dateElem = new Element(name, Catalog.defNS);
        dateElem.addContent(date.getText());
        if (date.getType() != null) {
            dateElem.setAttribute("type", date.getType());
        }
        if (date.getFormat() != null) {
            dateElem.setAttribute("format", date.getFormat());
        }
        return dateElem;
    }

    private Element writeDocumentation(Documentation doc, String name) {
        String inline;
        Element docElem = new Element(name, Catalog.defNS);
        if (doc.getType() != null) {
            docElem.setAttribute("type", doc.getType());
        }
        if (doc.hasXlink()) {
            docElem.setAttribute("href", doc.getXlinkHref(), Catalog.xlinkNS);
            if (!doc.getXlinkTitle().equals(doc.getURI().toString())) {
                docElem.setAttribute("title", doc.getXlinkTitle(), Catalog.xlinkNS);
            }
        }
        if ((inline = doc.getInlineContent()) != null) {
            docElem.addContent(inline);
        }
        return docElem;
    }

    public Element writeGeospatialCoverage(ThreddsMetadata.GeospatialCoverage gc) {
        Element elem = new Element("geospatialCoverage", Catalog.defNS);
        if (gc.getZPositive() != null) {
            elem.setAttribute("zpositive", gc.getZPositive());
        }
        if (gc.getNorthSouthRange() != null) {
            this.writeGeospatialRange(elem, new Element("northsouth", Catalog.defNS), gc.getNorthSouthRange());
        }
        if (gc.getEastWestRange() != null) {
            this.writeGeospatialRange(elem, new Element("eastwest", Catalog.defNS), gc.getEastWestRange());
        }
        if (gc.getUpDownRange() != null) {
            this.writeGeospatialRange(elem, new Element("updown", Catalog.defNS), gc.getUpDownRange());
        }
        for (ThreddsMetadata.Vocab name : gc.getNames()) {
            elem.addContent(this.writeControlledVocabulary(name, "name"));
        }
        return elem;
    }

    private void writeGeospatialRange(Element parent, Element elem, ThreddsMetadata.GeospatialRange r) {
        if (r == null) {
            return;
        }
        elem.addContent(new Element("start", Catalog.defNS).setText(Double.toString(r.getStart())));
        elem.addContent(new Element("size", Catalog.defNS).setText(Double.toString(r.getSize())));
        if (r.hasResolution()) {
            elem.addContent(new Element("resolution", Catalog.defNS).setText(Double.toString(r.getResolution())));
        }
        if (r.getUnits() != null) {
            elem.addContent(new Element("units", Catalog.defNS).setText(r.getUnits()));
        }
        parent.addContent(elem);
    }

    private Element writeMetadata(ThreddsMetadata.MetadataOther mdata) {
        String ns;
        Element mdataElem = new Element("metadata", Catalog.defNS);
        if (mdata.getType() != null) {
            mdataElem.setAttribute("metadataType", mdata.getType());
        }
        if (mdata.isInherited()) {
            mdataElem.setAttribute("inherited", "true");
        }
        if ((ns = mdata.getNamespaceURI()) != null && !ns.equals("http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0")) {
            Namespace mdataNS = Namespace.getNamespace(mdata.getPrefix(), ns);
            mdataElem.addNamespaceDeclaration(mdataNS);
        }
        if (mdata.getXlinkHref() != null) {
            mdataElem.setAttribute("href", mdata.getXlinkHref(), Catalog.xlinkNS);
            if (mdata.getTitle() != null) {
                mdataElem.setAttribute("title", mdata.getTitle(), Catalog.xlinkNS);
            }
        } else if (mdata.getContentObject() != null && mdata.getContentObject() instanceof Element) {
            Element content = (Element)mdata.getContentObject();
            mdataElem.setContent(content);
        }
        return mdataElem;
    }

    private Element writeProperty(Property prop) {
        Element propElem = new Element("property", Catalog.defNS);
        propElem.setAttribute("name", prop.getName());
        propElem.setAttribute("value", prop.getValue());
        return propElem;
    }

    protected Element writeSource(String elementName, ThreddsMetadata.Source p) {
        Element elem = new Element(elementName, Catalog.defNS);
        elem.addContent(this.writeControlledVocabulary(p.getNameVocab(), "name"));
        Element contact = new Element("contact", Catalog.defNS);
        if (p.getUrl() != null) {
            contact.setAttribute("url", p.getUrl());
        }
        if (p.getEmail() != null) {
            contact.setAttribute("email", p.getEmail());
        }
        elem.addContent(contact);
        return elem;
    }

    private Element writeService(Service service) {
        Element serviceElem = new Element("service", Catalog.defNS);
        serviceElem.setAttribute("name", service.getName());
        String svctype = service.getServiceTypeName();
        serviceElem.setAttribute("serviceType", svctype);
        String base = service.getBase();
        if ("compound".equalsIgnoreCase(svctype) && base == null) {
            base = "";
        }
        serviceElem.setAttribute("base", base);
        if (service.getSuffix() != null && service.getSuffix().length() > 0) {
            serviceElem.setAttribute("suffix", service.getSuffix());
        }
        for (Property p : service.getProperties()) {
            serviceElem.addContent(this.writeProperty(p));
        }
        for (Service nested : service.getNestedServices()) {
            serviceElem.addContent(this.writeService(nested));
        }
        return serviceElem;
    }

    private Element writeDataSize(double size) {
        String unit;
        Element sizeElem = new Element("dataSize", Catalog.defNS);
        if (useBytesForDataSize) {
            sizeElem.setAttribute("units", "bytes");
            long bytes = (long)size;
            sizeElem.setText(Long.toString(bytes));
            return sizeElem;
        }
        if (size > 1.0E15) {
            unit = "Pbytes";
            size *= 1.0E-15;
        } else if (size > 1.0E12) {
            unit = "Tbytes";
            size *= 1.0E-12;
        } else if (size > 1.0E9) {
            unit = "Gbytes";
            size *= 1.0E-9;
        } else if (size > 1000000.0) {
            unit = "Mbytes";
            size *= 1.0E-6;
        } else if (size > 1000.0) {
            unit = "Kbytes";
            size *= 0.001;
        } else {
            unit = "bytes";
        }
        sizeElem.setAttribute("units", unit);
        sizeElem.setText(ucar.unidata.util.Format.d(size, 4));
        return sizeElem;
    }

    protected void writeInheritedMetadata(Element elem, Dataset ds) {
        Element mdataElem = new Element("metadata", Catalog.defNS);
        mdataElem.setAttribute("inherited", "true");
        ThreddsMetadata tmi = (ThreddsMetadata)ds.getLocalField("ThreddsMetadataInheritable");
        if (tmi == null) {
            return;
        }
        this.writeThreddsMetadata(mdataElem, tmi);
        if (mdataElem.getChildren().size() > 0) {
            elem.addContent(mdataElem);
        }
    }

    protected void writeThreddsMetadata(Element elem, ThreddsMetadataContainer ds) {
        DateRange tc;
        Long dataSize;
        String dataFormatName;
        String featureTypeName;
        String authority;
        String serviceName = (String)ds.getLocalField("ServiceName");
        if (serviceName != null) {
            Element serviceNameElem = new Element("serviceName", Catalog.defNS);
            serviceNameElem.setText(serviceName);
            elem.addContent(serviceNameElem);
        }
        if ((authority = (String)ds.getLocalField("Authority")) != null) {
            Element authElem = new Element("authority", Catalog.defNS);
            authElem.setText(authority);
            elem.addContent(authElem);
        }
        if ((featureTypeName = (String)ds.getLocalField("FeatureType")) != null) {
            Element dataTypeElem = new Element("dataType", Catalog.defNS);
            dataTypeElem.setText(featureTypeName);
            elem.addContent(dataTypeElem);
        }
        if ((dataFormatName = (String)ds.getLocalField("DataFormatType")) != null) {
            Element dataFormatElem = new Element("dataFormat", Catalog.defNS);
            dataFormatElem.setText(dataFormatName);
            elem.addContent(dataFormatElem);
        }
        if ((dataSize = (Long)ds.getLocalField("DataSize")) != null && dataSize > 0L) {
            elem.addContent(this.writeDataSize(dataSize.longValue()));
        }
        List docList = ds.getLocalFieldAsList("Documentation");
        for (Object doc : docList) {
            elem.addContent(this.writeDocumentation((Documentation)doc, "documentation"));
        }
        List contribList = ds.getLocalFieldAsList("Contributors");
        for (Object c : contribList) {
            elem.addContent(this.writeContributor((ThreddsMetadata.Contributor)c));
        }
        List creatorList = ds.getLocalFieldAsList("Creators");
        for (Object p : creatorList) {
            elem.addContent(this.writeSource("creator", (ThreddsMetadata.Source)p));
        }
        List kewordList = ds.getLocalFieldAsList("Keywords");
        for (Object v : kewordList) {
            elem.addContent(this.writeControlledVocabulary((ThreddsMetadata.Vocab)v, "keyword"));
        }
        List mdList = ds.getLocalFieldAsList("MetadataOther");
        for (Object m : mdList) {
            elem.addContent(this.writeMetadata((ThreddsMetadata.MetadataOther)m));
        }
        List projList = ds.getLocalFieldAsList("Projects");
        for (Object v : projList) {
            elem.addContent(this.writeControlledVocabulary((ThreddsMetadata.Vocab)v, "project"));
        }
        List propertyList = ds.getLocalFieldAsList("Properties");
        for (Object p : propertyList) {
            elem.addContent(this.writeProperty((Property)p));
        }
        List pubList = ds.getLocalFieldAsList("Publishers");
        for (Object p : pubList) {
            elem.addContent(this.writeSource("publisher", (ThreddsMetadata.Source)p));
        }
        List dateList = ds.getLocalFieldAsList("Dates");
        for (DateType d : dateList) {
            elem.addContent(this.writeDate("date", d));
        }
        ThreddsMetadata.GeospatialCoverage gc = (ThreddsMetadata.GeospatialCoverage)ds.getLocalField("GeospatialCoverage");
        if (gc != null) {
            elem.addContent(this.writeGeospatialCoverage(gc));
        }
        if ((tc = (DateRange)ds.getLocalField("TimeCoverage")) != null) {
            elem.addContent(this.writeTimeCoverage(tc));
        }
        List varList = ds.getLocalFieldAsList("VariableGroups");
        for (ThreddsMetadata.VariableGroup v : varList) {
            elem.addContent(this.writeVariables(v));
        }
        ThreddsMetadata.UriResolved varMapLink = (ThreddsMetadata.UriResolved)ds.getLocalField("VariableMapLinkURI");
        if (varMapLink != null) {
            Element velem = new Element("variableMap", Catalog.defNS);
            velem.setAttribute("title", "variables", Catalog.xlinkNS);
            velem.setAttribute("href", varMapLink.href, Catalog.xlinkNS);
            elem.addContent(velem);
        }
    }

    protected Element writeTimeCoverage(DateRange t) {
        Element telem;
        Element elem = new Element("timeCoverage", Catalog.defNS);
        DateType start = t.getStart();
        DateType end = t.getEnd();
        TimeDuration duration = t.getDuration();
        TimeDuration resolution = t.getResolution();
        if (t.useStart() && start != null && !start.isBlank()) {
            Element startElem = new Element("start", Catalog.defNS);
            startElem.setText(start.toString());
            elem.addContent(startElem);
        }
        if (t.useEnd() && end != null && !end.isBlank()) {
            telem = new Element("end", Catalog.defNS);
            telem.setText(end.toString());
            elem.addContent(telem);
        }
        if (t.useDuration() && duration != null && !duration.isBlank()) {
            telem = new Element("duration", Catalog.defNS);
            telem.setText(duration.toString());
            elem.addContent(telem);
        }
        if (t.useResolution() && resolution != null && !resolution.isBlank()) {
            telem = new Element("resolution", Catalog.defNS);
            telem.setText(t.getResolution().toString());
            elem.addContent(telem);
        }
        return elem;
    }

    protected Element writeVariable(ThreddsMetadata.Variable v) {
        String id;
        String desc;
        Element elem = new Element("variable", Catalog.defNS);
        if (v.getName() != null) {
            elem.setAttribute("name", v.getName());
        }
        if (v.getDescription() != null && (desc = v.getDescription().trim()).length() > 0) {
            elem.setText(v.getDescription());
        }
        if (v.getVocabularyName() != null) {
            elem.setAttribute("vocabulary_name", v.getVocabularyName());
        }
        if (v.getUnits() != null) {
            elem.setAttribute("units", v.getUnits());
        }
        if ((id = v.getVocabularyId()) != null) {
            elem.setAttribute("vocabulary_id", id);
        }
        return elem;
    }

    protected Element writeVariables(ThreddsMetadata.VariableGroup vs) {
        Element elem = new Element("variables", Catalog.defNS);
        if (vs.getVocabulary() != null) {
            elem.setAttribute("vocabulary", vs.getVocabulary());
        }
        if (vs.getVocabUri() != null) {
            elem.setAttribute("href", vs.getVocabUri().resolved.toString(), Catalog.xlinkNS);
        }
        if (vs.getVariableMap() != null) {
            Element mapElem = new Element("variableMap", Catalog.defNS);
            mapElem.setAttribute("href", vs.getVariableMap().resolved.toString(), Catalog.xlinkNS);
            elem.addContent(mapElem);
        } else {
            List<ThreddsMetadata.Variable> varList = vs.getVariableList();
            for (ThreddsMetadata.Variable v : varList) {
                elem.addContent(this.writeVariable(v));
            }
        }
        return elem;
    }
}

