/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.catalog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.DatasetNode;
import thredds.client.catalog.Property;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.builder.CatalogRefBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import thredds.server.catalog.CatalogReader;
import thredds.server.catalog.ConfigCatalog;

public class CatalogScan
extends CatalogRef {
    private static final Logger logger = LoggerFactory.getLogger(CatalogScan.class);
    public static final String CATSCAN = "catalogScan.xml";
    private final String path;
    private final String location;
    private final String watch;

    public String getPath() {
        return this.path;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWatch() {
        return this.watch;
    }

    public CatalogScan(DatasetNode parent, String name, String xlink, Map<String, Object> flds, String path, String location, String watch) {
        super(parent, name, xlink, flds, null, null);
        this.path = path;
        this.location = location;
        this.watch = watch;
    }

    public ConfigCatalog getCatalog(File baseDir, String matchRemaining, String filename, CatalogReader reader) throws IOException {
        String relLocation = matchRemaining.length() >= 1 ? this.location + "/" + matchRemaining : this.location;
        File absLocation = new File(baseDir, relLocation);
        ConfigCatalog cc = reader.getFromAbsolutePath(absLocation + "/" + filename);
        if (cc == null) {
            logger.warn("Cant find catalog from scan: " + absLocation + "/" + filename);
        }
        return cc;
    }

    public CatalogBuilder makeCatalogFromDirectory(File baseDir, String matchRemaining, URI baseURI) throws IOException {
        CatalogRefBuilder catref;
        String urlPath;
        String relLocation = matchRemaining.length() >= 1 ? this.location + "/" + matchRemaining : this.location;
        String name = matchRemaining.length() >= 1 ? this.getName() + "/" + matchRemaining : this.getName();
        File absLocation = new File(baseDir, relLocation);
        Path wantDir = absLocation.toPath();
        if (!Files.exists(wantDir, new LinkOption[0])) {
            throw new FileNotFoundException("Requested catalog does not exist =" + absLocation);
        }
        if (!Files.isDirectory(wantDir, new LinkOption[0])) {
            throw new FileNotFoundException("Not a directory =" + absLocation);
        }
        CatalogBuilder catBuilder = new CatalogBuilder();
        catBuilder.setBaseURI(baseURI);
        assert (this.getParentCatalog() != null);
        DatasetBuilder top = new DatasetBuilder(null);
        top.transferMetadata(this, true);
        top.setName(name);
        top.put("Id", null);
        catBuilder.addDataset(top);
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(wantDir, "*.xml");){
            for (Path p : ds) {
                String pfilename;
                if (Files.isDirectory(p, new LinkOption[0])) continue;
                urlPath = pfilename = p.getFileName().toString();
                catref = new CatalogRefBuilder(top);
                catref.setTitle(urlPath);
                catref.setHref(urlPath);
                top.addDataset(catref);
            }
        }
        ds = Files.newDirectoryStream(wantDir);
        var11_11 = null;
        try {
            for (Path dir : ds) {
                if (!Files.isDirectory(dir, new LinkOption[0])) continue;
                String dfilename = dir.getFileName().toString();
                urlPath = matchRemaining.length() >= 1 ? dfilename + "/" + matchRemaining : dfilename;
                catref = new CatalogRefBuilder(top);
                catref.setTitle(urlPath);
                catref.setHref(urlPath + "/" + CATSCAN);
                catref.addToList("Properties", new Property("CatalogScan", "true"));
                top.addDataset(catref);
            }
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var11_11 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var11_11.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return catBuilder;
    }
}

