/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerHelper;
import ucar.nc2.dataset.CoordTransBuilder;
import ucar.nc2.util.Indent;
import ucar.unidata.geoloc.ProjectionImpl;

@Immutable
public class CoverageTransform
implements AttributeContainer {
    private final String name;
    private final AttributeContainerHelper attributes;
    private final boolean isHoriz;
    private ProjectionImpl projection;

    public CoverageTransform(String name, AttributeContainerHelper attributes, boolean isHoriz) {
        this.name = name;
        this.attributes = attributes;
        this.isHoriz = isHoriz;
    }

    public boolean isHoriz() {
        return this.isHoriz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectionImpl getProjection() {
        if (this.projection == null && this.isHoriz) {
            CoverageTransform coverageTransform = this;
            synchronized (coverageTransform) {
                this.projection = CoordTransBuilder.makeProjection(this, new Formatter());
            }
        }
        return this.projection;
    }

    public String toString() {
        Formatter f = new Formatter();
        Indent indent = new Indent(2);
        this.toString(f, indent);
        return f.toString();
    }

    public void toString(Formatter f, Indent indent) {
        indent.incr();
        f.format("%s CoordTransform '%s'", indent, this.name);
        f.format(" isHoriz: %s%n", this.isHoriz());
        if (this.projection != null) {
            f.format(" projection: %s%n", this.projection);
        }
        for (Attribute att : this.attributes.getAttributes()) {
            f.format("%s     %s%n", indent, att);
        }
        f.format("%n", new Object[0]);
        indent.decr();
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes.getAttributes();
    }

    @Override
    public Attribute findAttribute(String name) {
        return this.attributes.findAttribute(name);
    }

    @Override
    public Attribute findAttributeIgnoreCase(String name) {
        return this.attributes.findAttributeIgnoreCase(name);
    }

    @Override
    public String findAttValueIgnoreCase(String attName, String defaultValue) {
        return this.attributes.findAttValueIgnoreCase(attName, defaultValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean remove(Attribute a) {
        return false;
    }

    @Override
    public boolean removeAttribute(String attName) {
        return false;
    }

    @Override
    public boolean removeAttributeIgnoreCase(String attName) {
        return false;
    }

    @Override
    public void addAll(Iterable<Attribute> atts) {
    }

    @Override
    public Attribute addAttribute(Attribute att) {
        return null;
    }
}

