/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.io.IOException;
import ucar.unidata.io.RandomAccessFile;

public class NCheader {
    private static final int MAGIC_NUMBER_LEN = 4;
    private static final long MAXHEADERPOS = 50000L;
    private static final byte[] H5HEAD = new byte[]{-119, 72, 68, 70};
    public static final int NC_FORMAT_NETCDF3 = 1;
    public static final int NC_FORMAT_64BIT_OFFSET = 2;
    public static final int NC_FORMAT_NETCDF4 = 3;
    public static final int NC_FORMAT_NETCDF4_CLASSIC = 4;
    public static final int NC_FORMAT_64BIT_DATA = 5;
    public static final int NC_FORMAT_HDF4 = 28677;
    public static final int NC_FORMAT_CLASSIC = 1;
    public static final int NC_FORMAT_64BIT = 2;
    public static final int NC_FORMAT_CDF5 = 5;
    public static final int NC_FORMAT_HDF5 = 3;

    public static int checkFileType(RandomAccessFile raf) throws IOException {
        byte[] magic = new byte[4];
        raf.seek(0L);
        if (raf.readBytes(magic, 0, 4) < 4) {
            return 0;
        }
        if (magic[0] == 67 && magic[1] == 68 && magic[2] == 70) {
            if (magic[3] == 1) {
                return 1;
            }
            if (magic[3] == 2) {
                return 2;
            }
            if (magic[3] == 5) {
                return 5;
            }
            return 0;
        }
        long filePos = 0L;
        long size = raf.length();
        while (filePos < size - 8L && filePos < 50000L) {
            raf.seek(filePos);
            if (raf.readBytes(magic, 0, 4) < 4) {
                return 0;
            }
            if (magic[0] == -119 && magic[1] == 72 && magic[2] == 68 && magic[3] == 70) {
                return 3;
            }
            if (magic[0] == 14 && magic[1] == 3 && magic[2] == 19 && magic[3] == 1) {
                return 28677;
            }
            filePos = filePos == 0L ? 512L : 2L * filePos;
        }
        return 0;
    }
}

