/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.utils;

import cern.colt.list.FloatArrayList;
import java.util.HashMap;

public class AsaMath {
    public static final double RAD_2_DEG = 57.29577951308232;
    public static final double DEG_2_RAD = Math.PI / 180;
    private final double ZERO_RAD = 0.0;
    private final double QUARTER_RAD_CIRCLE = 1.5707963267948966;
    private final double HALF_RAD_CIRCLE = Math.PI;
    private final double THREE_QUARTER_RAD_CIRCLE = 4.71238898038469;

    public static double calcSpeed(double u, double v) {
        return Math.sqrt(u * u + v * v);
    }

    public static double calcDirection(double u, double v) {
        double dir = Math.atan2(u, v) * 57.29577951308232;
        return u < 0.0 ? dir + 360.0 : dir;
    }

    public static double[] calcSpeedDirection(double u, double v) {
        return new double[]{AsaMath.calcSpeed(u, v), AsaMath.calcDirection(u, v)};
    }

    public static double[][] calcSpeedDirection(double[] us, double[] vs) {
        double[][] ret = null;
        if (us.length != vs.length) {
            return ret;
        }
        ret = new double[2][];
        double[] speeds = new double[us.length];
        double[] dirs = new double[us.length];
        for (int i = 0; i < us.length; ++i) {
            double u = us[i];
            double v = vs[i];
            double dir = Math.atan2(u, v) * 57.29577951308232;
            dirs[i] = u < 0.0 ? dir + 360.0 : dir;
            speeds[i] = Math.sqrt(u * u + v * v);
        }
        ret[0] = speeds;
        ret[1] = dirs;
        return ret;
    }

    public static double[] calcUVFromSpeedDir(double speed, double direction) {
        double u = speed * Math.sin(direction *= Math.PI / 180);
        double v = speed * Math.cos(direction);
        return new double[]{u, v};
    }

    public static double[][] calcUVFromSpeedDir(double[] speeds, double[] directions) {
        double[][] ret = null;
        if (speeds.length != directions.length) {
            return ret;
        }
        ret = new double[2][];
        double[] us = new double[speeds.length];
        double[] vs = new double[speeds.length];
        for (int i = 0; i < speeds.length; ++i) {
            double dir = directions[i] * (Math.PI / 180);
            us[i] = speeds[i] * Math.sin(dir);
            vs[i] = speeds[i] * Math.cos(dir);
        }
        ret[0] = us;
        ret[1] = vs;
        return ret;
    }

    public static long getTimeInMilliseconds(double time, String units) {
        long timeIncrement = 0L;
        if (units.contains("hour") || units.contains("hours") || units.contains("hrs") || units.contains("hr")) {
            timeIncrement = (long)(time * 60.0 * 60.0 * 1000.0);
        } else if (units.contains("minute") || units.contains("minutes") || units.contains("mins") || units.contains("min")) {
            timeIncrement = (long)(time * 60.0 * 1000.0);
        }
        return timeIncrement;
    }

    public static boolean isNumeric(Object value) {
        boolean result = false;
        try {
            Double.parseDouble((String)value);
            result = true;
        }
        catch (NumberFormatException ex) {
            result = false;
        }
        return result;
    }

    public static double roundDouble(double value, int precision) {
        double sign = value >= 0.0 ? 1.0 : -1.0;
        double factor = Math.pow(10.0, precision);
        double n = value * factor;
        n = sign * Math.abs(Math.floor(n + 0.5));
        return n / factor;
    }

    public static float roundFloat(float value, int precision) {
        float sign = value >= 0.0f ? 1.0f : -1.0f;
        float factor = (float)Math.pow(10.0, precision);
        float n = value * factor;
        n = (float)((double)sign * Math.abs(Math.floor((double)n + 0.5)));
        return n / factor;
    }

    public static double averageDouble(double[] vals) {
        double ret = Double.NaN;
        if (vals != null) {
            if (vals.length > 1) {
                double sum = 0.0;
                int count = 0;
                for (double d : vals) {
                    if (Double.isNaN(d)) continue;
                    sum += d;
                    ++count;
                }
                if (count > 0) {
                    ret = sum / (double)count;
                }
            } else {
                ret = vals[0];
            }
        }
        return ret;
    }

    public static double averageDouble(double[] vals, double ignoreVal) {
        double ret = Double.NaN;
        if (vals != null) {
            if (vals.length > 1) {
                double sum = 0.0;
                int count = 0;
                for (double d : vals) {
                    if (d == ignoreVal) continue;
                    sum += d;
                    ++count;
                }
                if (count > 0) {
                    ret = sum / (double)count;
                }
            } else {
                ret = vals[0];
            }
        }
        return ret;
    }

    public static float averageFloat(float[] vals) {
        float ret = Float.NaN;
        if (vals != null) {
            if (vals.length > 1) {
                float sum = 0.0f;
                int count = 0;
                for (float d : vals) {
                    if (Float.isNaN(d)) continue;
                    sum += d;
                    ++count;
                }
                if (count > 0) {
                    ret = sum / (float)count;
                }
            } else {
                ret = vals[0];
            }
        }
        return ret;
    }

    public static float averageFloat(float[] vals, float ignoreVal) {
        float ret = Float.NaN;
        if (vals != null) {
            if (vals.length > 1) {
                float sum = 0.0f;
                int count = 0;
                for (float d : vals) {
                    if (d == ignoreVal) continue;
                    sum += d;
                    ++count;
                }
                if (count > 0) {
                    ret = sum / (float)count;
                }
            } else {
                ret = vals[0];
            }
        }
        return ret;
    }

    public static float[] calculateModes(float[] numbers, Float fillVal) {
        HashMap<Float, Integer> table = new HashMap<Float, Integer>();
        FloatArrayList modes = new FloatArrayList();
        Integer max = 0;
        float[] fArray = numbers;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float n2 = Float.valueOf(fArray[i]);
            if (!Float.isNaN(fillVal.floatValue()) ? n2 == fillVal : Float.isNaN(n2.floatValue())) continue;
            Integer frequency = (Integer)table.remove(n2);
            if (frequency == null) {
                frequency = 0;
            }
            frequency = frequency + 1;
            table.put(n2, frequency);
            if (frequency > max) {
                max = frequency;
                modes = new FloatArrayList();
            }
            if (frequency < max) continue;
            modes.add(n2.floatValue());
        }
        modes.trimToSize();
        return modes.elements();
    }

    public static double roundToNearest(double value, double nearest, int roundDirection) {
        if (nearest == 0.0) {
            return value;
        }
        if (roundDirection < 0) {
            value -= nearest * 0.5;
        } else if (roundDirection > 0) {
            value += nearest * 0.5;
        }
        double ret = (double)Math.round(value / nearest) * nearest;
        return ret;
    }

    public static boolean almostEqual(double val1, double val2, double tolerance) {
        return Math.abs(val1 - val2) <= tolerance;
    }

    public static boolean almostEqual(float val1, float val2, float tolerance) {
        return Math.abs(val1 - val2) <= tolerance;
    }

    public static boolean sameSign(double val1, double val2) {
        return val1 >= 0.0 && val2 >= 0.0 || val1 <= 0.0 && val2 <= 0.0;
    }
}

