/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.utils;

public class AsaMemoryUtils {
    public static int BYTE = 0;
    public static int MEGABYTE = 1;
    public static int GIGABYTE = 2;

    public static double freeMemoryAs(int sizeType) {
        long freeMem = Runtime.getRuntime().freeMemory();
        switch (sizeType) {
            case 0: {
                break;
            }
            case 1: {
                return Convert.bytesToMegabytes(freeMem);
            }
            case 2: {
                return Convert.bytesToGigabytes(freeMem);
            }
        }
        return Double.NaN;
    }

    public static double totalMemoryAs(int sizeType) {
        long freeMem = Runtime.getRuntime().totalMemory();
        switch (sizeType) {
            case 0: {
                break;
            }
            case 1: {
                return Convert.bytesToMegabytes(freeMem);
            }
            case 2: {
                return Convert.bytesToGigabytes(freeMem);
            }
        }
        return Double.NaN;
    }

    public static class Convert {
        public static double bytesToMegabytes(long bytes) {
            return (double)bytes * 9.53674316E-7;
        }

        public static double megabytesToBytes(double megabytes) {
            return megabytes * 1048576.0;
        }

        public static double bytesToGigabytes(long bytes) {
            return (double)bytes * 9.31322575E-10;
        }

        public static double gigabytesToBytes(double gigabytes) {
            return gigabytes * 1.073741824E9;
        }

        public static double megabytesToGigabytes(double megabytes) {
            return megabytes * 9.765625E-4;
        }

        public static double gigabytesToMegabytes(double gigabytes) {
            return gigabytes * 1024.0;
        }
    }
}

