/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.utils;

public class AsaUnits {
    public static double convertSpeed(SpeedType fromUnits, SpeedType toUnits, double speed) {
        double meters = fromUnits.convertToMeters(speed);
        return toUnits.convertFromMeters(meters);
    }

    public static double[] convertSpeed(SpeedType fromUnits, SpeedType toUnits, double[] speed) {
        double[] ret = new double[speed.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = fromUnits.convertToMeters(speed[i]);
            ret[i] = toUnits.convertFromMeters(ret[i]);
        }
        return ret;
    }

    public static double convertDistance(DistanceType fromUnits, DistanceType toUnits, double distance) {
        double meters = fromUnits.convertToMeters(distance);
        return toUnits.convertFromMeters(meters);
    }

    public static double[] convertDistance(DistanceType fromUnits, DistanceType toUnits, double[] distance) {
        double[] ret = new double[distance.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = fromUnits.convertToMeters(distance[i]);
            ret[i] = toUnits.convertFromMeters(ret[i]);
        }
        return ret;
    }

    public static enum MassType {
        GRAM(1.0, 1.0, "g"),
        KILOGRAM(1000.0, 0.001, "kg"),
        USTON(907184.74, 1.102311310924E-6, "ton (US Short)"),
        LBS(453.59237, 0.002204622621849, "lbs");

        private double toMeters;
        private double fromMeters;
        private String dispName;

        private MassType(double toGramsMultiplier, double fromGramsMultiplier, String displayName) {
            this.toMeters = toGramsMultiplier;
            this.fromMeters = fromGramsMultiplier;
            this.dispName = displayName;
        }

        public double convertToGrams(double n) {
            return n * this.toMeters;
        }

        public double convertFromGrams(double n) {
            return n * this.fromMeters;
        }

        public String getDisplayName() {
            return this.dispName;
        }

        public String toString() {
            return this.dispName;
        }

        public static MassType getMassType(String string) {
            for (MassType mt : MassType.values()) {
                if (!mt.getDisplayName().equalsIgnoreCase(string)) continue;
                return mt;
            }
            return GRAM;
        }
    }

    public static enum DistanceType {
        UNKNOWN(1.0, 1.0, "unknown"),
        METERS(1.0, 1.0, "m"),
        KILOMETERS(1000.0, 0.001, "km"),
        MILES(1609.344, 6.21371192E-4, "mi"),
        FEET(0.3048, 3.2808399, "ft"),
        NAUTICAL_MILES(1852.0, 5.39E-4, "nm");

        private double toMeters;
        private double fromMeters;
        private String dispName;

        private DistanceType(double toMetersMultiplier, double fromMetersMultiplier, String displayName) {
            this.toMeters = toMetersMultiplier;
            this.fromMeters = fromMetersMultiplier;
            this.dispName = displayName;
        }

        public double convertToMeters(double n) {
            return n * this.toMeters;
        }

        public double convertFromMeters(double n) {
            return n * this.fromMeters;
        }

        public String getDisplayName() {
            return this.dispName;
        }

        public String toString() {
            return this.dispName;
        }

        public static DistanceType getDistanceType(String string) {
            for (DistanceType dt : DistanceType.values()) {
                if (!dt.getDisplayName().equalsIgnoreCase(string)) continue;
                return dt;
            }
            return UNKNOWN;
        }
    }

    public static enum SpeedType {
        UNKNOWN(1.0, 1.0, "unknown"),
        KNOTS(0.514444444, 1.94384449, "kt"),
        METERS_SEC(1.0, 1.0, "m/s"),
        MILLIMETERS_SEC(0.001, 1000.0, "mm/s"),
        CENTIMETERS_SEC(0.01, 100.0, "cm/s"),
        MILES_HOUR(0.44704, 2.23693629, "mph"),
        KILOMETERS_HOUR(0.277777778, 3.6, "km/h");

        private double toMeters;
        private double fromMeters;
        private String dispName;

        private SpeedType(double toMetersMultiplier, double fromMetersMultiplier, String displayName) {
            this.toMeters = toMetersMultiplier;
            this.fromMeters = fromMetersMultiplier;
            this.dispName = displayName;
        }

        public double convertToMeters(double n) {
            return n * this.toMeters;
        }

        public double convertFromMeters(double n) {
            return n * this.fromMeters;
        }

        public String getDisplayName() {
            return this.dispName;
        }

        public String toString() {
            return this.dispName;
        }

        public static SpeedType getSpeedType(String string) {
            for (SpeedType st : SpeedType.values()) {
                if (!st.getDisplayName().equalsIgnoreCase(string)) continue;
                return st;
            }
            return UNKNOWN;
        }
    }
}

