/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import ucar.nc2.dataset.NetcdfDataset;

public class NcdsFactory {
    static final String RESOURCE_PATH = "/netcdf/ncml/";

    public static NetcdfDataset getNcdsFromTemplate(NcdsTemplate ncdsTemp) throws URISyntaxException, FileNotFoundException, IOException {
        File temp = File.createTempFile("temp_ncml", ".ncml");
        temp.deleteOnExit();
        NcdsFactory.getSchemaTemplate(temp, ncdsTemp.getResourceName());
        return NetcdfDataset.openDataset((String)temp.getCanonicalPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getSchemaTemplate(File tempFile, String schemaName) throws URISyntaxException, FileNotFoundException, IOException {
        InputStream in = null;
        FileOutputStream fos = null;
        try {
            in = NcdsFactory.class.getResourceAsStream(RESOURCE_PATH + schemaName);
            fos = new FileOutputStream(tempFile);
            byte[] buff = new byte[1024];
            int len = 0;
            while ((len = in.read(buff)) > 0) {
                fos.write(buff, 0, len);
            }
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public static enum NcdsTemplate {
        UGRID("ugrid-template.xml");

        String resourceName = null;

        private NcdsTemplate(String resourceName) {
            if (null == resourceName || resourceName.isEmpty()) {
                throw new IllegalArgumentException("Argument resourceName cannot be NULL or empty");
            }
            this.resourceName = resourceName;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }
}

