/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.util.List;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.dataset.conv.CF1Convention;
import ucar.nc2.internal.dataset.spi.CFSubConventionProvider;

public class UGridConvention
extends CF1Convention {
    private static String CONVENTION_NAME_BASE = "UGRID";
    public static String CONVENTION_NAME = CONVENTION_NAME_BASE + "-1.X";

    public AxisType getAxisType(VariableDS.Builder vb) {
        AxisType at = super.getAxisType(vb);
        return at;
    }

    private UGridConvention(NetcdfDataset.Builder<?> datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    public static class Factory
    implements CFSubConventionProvider {
        public boolean isMine(NetcdfFile ncfile) {
            String conventionValue;
            boolean mine = false;
            Attribute conventionAttr = ncfile.findGlobalAttributeIgnoreCase("Conventions");
            if (conventionAttr != null && (conventionValue = conventionAttr.getStringValue()) != null) {
                mine = conventionValue.startsWith(CONVENTION_NAME_BASE);
            }
            return mine;
        }

        public boolean isMine(List<String> convs) {
            boolean mine = false;
            for (String conv : convs) {
                if (!conv.startsWith(CONVENTION_NAME_BASE)) continue;
                mine = true;
                break;
            }
            return mine;
        }

        public String getConventionName() {
            return CONVENTION_NAME;
        }

        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new UGridConvention(datasetBuilder);
        }
    }
}

