/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid;

import cern.colt.list.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.ugrid.Cell;
import ucar.nc2.dt.ugrid.Edge;
import ucar.nc2.dt.ugrid.Face;
import ucar.nc2.dt.ugrid.Node;
import ucar.nc2.dt.ugrid.geom.LatLonPoint2D;
import ucar.nc2.dt.ugrid.geom.LatLonPolygon2D;
import ucar.nc2.dt.ugrid.geom.LatLonRectangle2D;
import ucar.nc2.dt.ugrid.rtree.RTree;
import ucar.nc2.dt.ugrid.topology.Topology;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class Mesh {
    private static final Logger logger = LoggerFactory.getLogger(Mesh.class);
    private static final String DIMENSION = "topology_dimension";
    private static final String NODE_COORDINATES = "node_coordinates";
    private static final String FACE_COORDINATES = "face_coordinates";
    private static final String FACE_NODE_CONNECTIVITY = "face_node_connectivity";
    private String name;
    private RTree rtree;
    private List<Cell> cells = new ArrayList<Cell>();
    private Topology topology = new Topology();
    private List<CoordinateSystem> coordinate_systems = new ArrayList<CoordinateSystem>();

    public Mesh(NetcdfDataset ds, VariableEnhanced v) {
        this.name = v.getFullName();
        Properties props = new Properties();
        props.setProperty("MaxNodeEntries", "30");
        props.setProperty("MinNodeEntries", "15");
        this.rtree = new RTree(props);
        this.processTopologyVariable(ds, v);
    }

    private void processTopologyVariable(NetcdfDataset ncd, VariableEnhanced v) {
        ArrayList<Attribute> foundCoords = new ArrayList<Attribute>();
        ArrayList<String> locations = new ArrayList<String>();
        Object att = null;
        Attribute dims = ((VariableDS)v).attributes().findAttributeIgnoreCase(DIMENSION);
        if (dims == null) {
            logger.debug("No 'topology_dimension' attribute defined for the Mesh");
            return;
        }
        Attribute node_coord = ((VariableDS)v).attributes().findAttributeIgnoreCase(NODE_COORDINATES);
        if (node_coord == null) {
            logger.debug("No 'node_coordinates' attribute defined for the Mesh");
            return;
        }
        foundCoords.add(node_coord);
        locations.add("node");
        Attribute face_coord = ((VariableDS)v).attributes().findAttributeIgnoreCase(FACE_COORDINATES);
        if (face_coord == null) {
            logger.debug("No 'face_coordinates' attribute defined for the Mesh");
            return;
        }
        foundCoords.add(face_coord);
        locations.add("face");
        Attribute face_node_connect = ((VariableDS)v).attributes().findAttributeIgnoreCase(FACE_NODE_CONNECTIVITY);
        if (face_node_connect == null) {
            System.out.println("No 'face_node_connectivity' attribute defined for the Mesh. Only 2D and 3D supported.");
            return;
        }
        this.topology.setFaceNodeConnectivityVariable(ncd.findVariable(face_node_connect.getStringValue()));
        block2: for (Attribute attr : foundCoords) {
            List<String> elements = Arrays.asList(attr.getStringValue().toLowerCase().split(" "));
            for (CoordinateSystem coord : ncd.getCoordinateSystems()) {
                try {
                    if (!elements.contains(coord.getLatAxis().getShortName()) || !elements.contains(coord.getLonAxis().getShortName())) continue;
                    this.coordinate_systems.add(coord);
                    continue block2;
                }
                catch (Exception e) {
                }
            }
        }
        this.cells = this.topology.createCells(locations, this.coordinate_systems);
    }

    public void buildRTree() {
        for (int i = 0; i < this.cells.size(); ++i) {
            this.rtree.add(this.cells.get(i).getPolygon(), i);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.cells.size();
    }

    public int getTreeSize() {
        return this.rtree.size();
    }

    public int getNodeSize() {
        int i = 0;
        for (Cell c : this.cells) {
            if (!c.hasNodes()) continue;
            i += c.getNodes().size();
        }
        return i;
    }

    public double[][] getNodeLatLons() {
        double[][] ll = new double[this.getUniqueNodeSize()][2];
        double[] d = new double[2];
        for (Node n : this.getUniqueNodes()) {
            d[0] = n.getGeoPoint().getLatitude();
            d[1] = n.getGeoPoint().getLongitude();
            ll[ll.length - 1] = d;
        }
        return ll;
    }

    public int[] getNodeIndexes() {
        int[] in = new int[this.getUniqueNodeSize()];
        for (Node n : this.getUniqueNodes()) {
            in[in.length - 1] = n.getDataIndex();
        }
        return in;
    }

    public ArrayList<Node> getUniqueNodes() {
        ArrayList<Node> ents = new ArrayList<Node>();
        for (Cell c : this.cells) {
            if (!c.hasNodes()) continue;
            ents.addAll(c.getNodes());
        }
        HashSet set = new HashSet(ents);
        ArrayList<Node> unique = new ArrayList<Node>(set);
        return unique;
    }

    public int getUniqueNodeSize() {
        return this.getUniqueNodes().size();
    }

    public ArrayList<Edge> getUniqueEdges() {
        ArrayList<Edge> ents = new ArrayList<Edge>();
        for (Cell c : this.cells) {
            if (!c.hasEdges()) continue;
            ents.addAll(c.getEdges());
        }
        HashSet set = new HashSet(ents);
        ArrayList<Edge> unique = new ArrayList<Edge>(set);
        return unique;
    }

    public int getEdgeSize() {
        int i = 0;
        for (Cell c : this.cells) {
            if (!c.hasEdges()) continue;
            i += c.getEdges().size();
        }
        return i;
    }

    public ArrayList<Face> getUniqueFaces() {
        ArrayList<Face> ents = new ArrayList<Face>();
        for (Cell c : this.cells) {
            if (!c.hasFaces()) continue;
            ents.addAll(c.getFaces());
        }
        HashSet set = new HashSet(ents);
        ArrayList<Face> unique = new ArrayList<Face>(set);
        return unique;
    }

    public int getFaceSize() {
        int i = 0;
        for (Cell c : this.cells) {
            if (!c.hasFaces()) continue;
            i += c.getFaces().size();
        }
        return i;
    }

    public LatLonRect getLatLonBoundingBox() {
        LatLonRectangle2D bounds = this.rtree.getBounds();
        return new LatLonRect((LatLonPoint)new LatLonPointImpl(bounds.getLatMin(), bounds.getLonMin()), (LatLonPoint)new LatLonPointImpl(bounds.getLatMax(), bounds.getLonMax()));
    }

    public Cell getCellFromLatLon(double lat, double lon) {
        LatLonPoint2D.Double p = new LatLonPoint2D.Double(lat, lon);
        return this.cells.get(this.rtree.nearest(p));
    }

    public Cell getCellFromLatLon(LatLonPoint2D p) {
        return this.cells.get(this.rtree.nearest(p));
    }

    public ArrayList<Cell> getCellsInPolygon(LatLonPolygon2D p) {
        IntArrayList polys = this.rtree.intersects(p);
        ArrayList<Cell> containedCells = new ArrayList<Cell>(polys.size());
        for (int i : polys.elements()) {
            containedCells.add(this.cells.get(i));
        }
        return containedCells;
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public List<Cell> getPolygons() {
        return this.cells;
    }

    public Topology getTopology() {
        return this.topology;
    }

    public Mesh subset(LatLonRect bounds) {
        LatLonRectangle2D r = new LatLonRectangle2D(new LatLonPoint2D.Double(bounds.getUpperLeftPoint().getLatitude(), bounds.getUpperLeftPoint().getLongitude()), new LatLonPoint2D.Double(bounds.getLowerRightPoint().getLatitude(), bounds.getLowerRightPoint().getLongitude()));
        LatLonPolygon2D.Double p = new LatLonPolygon2D.Double(r);
        ArrayList<Cell> containedCells = this.getCellsInPolygon(p);
        return null;
    }

    public String toString() {
        ArrayList<Object> sb = new ArrayList<Object>();
        sb.add(this.getName());
        sb.add("Mesh contains: " + this.getSize() + " cells (polygons)");
        sb.add("Mesh contains: " + this.getNodeSize() + " nodes (" + this.getUniqueNodeSize() + " unique) ");
        if (this.getSize() != 0) {
            sb.add("Mesh contains: " + this.getNodeSize() / this.getSize() + " nodes per cell");
        }
        sb.add("Mesh contains: " + this.getEdgeSize() + " edges.");
        sb.add("Mesh contains: " + this.getFaceSize() + " faces.");
        return sb.toString().replace(",", "\n");
    }
}

