/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.UGridDataset;
import ucar.nc2.dt.UGridDatatype;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.dt.ugrid.Cell;
import ucar.nc2.dt.ugrid.Edge;
import ucar.nc2.dt.ugrid.Entity;
import ucar.nc2.dt.ugrid.Face;
import ucar.nc2.dt.ugrid.Node;
import ucar.nc2.dt.ugrid.UGridDataset;
import ucar.nc2.dt.ugrid.geom.LatLonPoint2D;
import ucar.nc2.dt.ugrid.geom.LatLonPolygon2D;
import ucar.nc2.dt.ugrid.geom.LatLonRectangle2D;
import ucar.nc2.dt.ugrid.topology.Topology;
import ucar.nc2.dt.ugrid.utils.NcdsFactory;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.util.Format;

public class MeshVariable
implements UGridDatatype {
    private static final Logger logger = LoggerFactory.getLogger(MeshVariable.class);
    private VariableDS vs;
    private UGridDataset dataset;
    private UGridDataset.Meshset meshset;
    private List<Dimension> mydims;
    private String cellLocation;

    public MeshVariable(UGridDataset dataset, VariableDS vs, UGridDataset.Meshset meshset) {
        this.vs = vs;
        this.meshset = meshset;
        this.dataset = dataset;
        this.mydims = vs.getDimensions();
        this.cellLocation = vs.findAttributeIgnoreCase("location").getStringValue();
    }

    public String getFullName() {
        return this.vs.getFullName();
    }

    public String getShortName() {
        return this.vs.getShortName();
    }

    @Override
    public String getName() {
        return this.vs.getFullName();
    }

    @Override
    public String getNameEscaped() {
        return this.vs.getFullNameEscaped();
    }

    public Topology getConnectivityVariable() {
        return this.meshset.getMesh().getTopology();
    }

    @Override
    public String getDescription() {
        return this.vs.getDescription();
    }

    @Override
    public String getUnitsString() {
        return this.vs.getUnitsString();
    }

    @Override
    public DataType getDataType() {
        return this.vs.getDataType();
    }

    @Override
    public int getRank() {
        return this.vs.getRank();
    }

    public String getCellLocation() {
        return this.cellLocation;
    }

    @Override
    public int[] getShape() {
        int[] shape = new int[this.mydims.size()];
        for (int i = 0; i < this.mydims.size(); ++i) {
            Dimension d = this.mydims.get(i);
            shape[i] = d.getLength();
        }
        return shape;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.vs.getAttributes();
    }

    @Override
    public Attribute findAttributeIgnoreCase(String name) {
        return this.vs.findAttributeIgnoreCase(name);
    }

    @Override
    public String findAttValueIgnoreCase(String attName, String defaultValue) {
        return this.dataset.getNetcdfDataset().findAttValueIgnoreCase((Variable)this.vs, attName, defaultValue);
    }

    @Override
    public List<Dimension> getDimensions() {
        return this.mydims;
    }

    @Override
    public Dimension getDimension(int i) {
        return this.mydims.get(i);
    }

    @Override
    public Dimension getTimeDimension() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Dimension getZDimension() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Dimension getYDimension() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Dimension getXDimension() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Dimension getEnsembleDimension() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Dimension getRunTimeDimension() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getTimeDimensionIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getZDimensionIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getYDimensionIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getXDimensionIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getEnsembleDimensionIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getRunTimeDimensionIndex() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public GridCoordSystem getCoordinateSystem() {
        ImmutableList coordSystems = this.vs.getCoordinateSystems();
        if (coordSystems.size() == 0) {
            logger.error("Mesh variable {} has no coordinate system.", (Object)this.vs.getFullName());
            return null;
        }
        if (coordSystems.size() > 1) {
            logger.warn("Mesh variable {} has more than one coordinate system. Using the first encountered.", (Object)this.vs.getFullName());
        }
        return new GridCoordSys((CoordinateSystem)coordSystems.get(0), null);
    }

    @Override
    public UGridDataset.Meshset getMeshset() {
        return this.meshset;
    }

    @Override
    public ProjectionImpl getProjection() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasMissingData() {
        return this.vs.hasMissing();
    }

    @Override
    public boolean isMissingData(double val) {
        return this.vs.isMissing(val);
    }

    @Override
    public MAMath.MinMax getMinMaxSkipMissingData(Array a) {
        if (!this.hasMissingData()) {
            return MAMath.getMinMax((Array)a);
        }
        IndexIterator iter = a.getIndexIterator();
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        while (iter.hasNext()) {
            double val = iter.getDoubleNext();
            if (this.isMissingData(val)) continue;
            if (val > max) {
                max = val;
            }
            if (!(val < min)) continue;
            min = val;
        }
        return new MAMath.MinMax(min, max);
    }

    @Override
    public float[] setMissingToNaN(float[] values) {
        if (!this.vs.hasMissing()) {
            return values;
        }
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            double value = values[i];
            if (!this.vs.isMissing(value)) continue;
            values[i] = Float.NaN;
        }
        return values;
    }

    @Override
    public Array readDataSlice(int rt_index, int e_index, int t_index, int z_index, int y_index, int x_index) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Array readSubset(List<Range> subset) throws InvalidRangeException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Array readDataSlice(int t_index, int z_index, int y_index, int x_index) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Array readVolumeData(int t_index) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public UGridDatatype makeSubset(Range rt_range, Range e_range, Range t_range, Range z_range, Range y_range, Range x_range) throws InvalidRangeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public UGridDatatype makeSubset(Range t_range, Range z_range, LatLonRect bbox, int z_stride, int y_stride, int x_stride) throws InvalidRangeException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void subsetToDataset(UGridDataset ugd, NetcdfDataset ncd, List<Cell> containedCells) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        if (this.cellLocation.equals("node")) {
            for (Cell c : containedCells) {
                for (Node node : c.getNodes()) {
                    list.add(node);
                }
            }
        } else if (this.cellLocation.equals("face")) {
            for (Cell c : containedCells) {
                for (Face face : c.getFaces()) {
                    list.add(face);
                }
            }
        } else if (this.cellLocation.equals("edge")) {
            for (Cell c : containedCells) {
                for (Edge edge : c.getEdges()) {
                    list.add(edge);
                }
            }
        }
        HashSet set = new HashSet(list);
        ArrayList unique_entities = new ArrayList(set);
        try {
            int n;
            int time_index = -1;
            int n2 = -1;
            int z_index = -1;
            int z_length = -1;
            int data_index = -1;
            for (Object cs : this.vs.getCoordinateSystems()) {
                if (cs.hasTimeAxis()) {
                    if (ncd.findCoordinateAxis(cs.getTaxis().getFullNameEscaped()) == null) {
                        ncd.addCoordinateSystem((CoordinateSystem)cs);
                        ncd.addCoordinateAxis((VariableDS)cs.getTaxis());
                        VariableDS t = new VariableDS(null, cs.getTaxis().getOriginalVariable(), true);
                        ncd.addVariable(null, (Variable)t);
                        t.setCachedData(cs.getTaxis().getOriginalVariable().read());
                        ncd.finish();
                    }
                    time_index = this.vs.findDimensionIndex(cs.getTaxis().getDimension(0).getFullName());
                    n = this.vs.getDimension(time_index).getLength();
                }
                if (cs.hasVerticalAxis()) {
                    CoordinateAxis pressureAxis;
                    CoordinateAxis heightAxis;
                    VariableDS z;
                    CoordinateAxis zAxis = cs.getZaxis();
                    if (zAxis != null) {
                        if (ncd.findCoordinateAxis(zAxis.getFullName()) == null) {
                            ncd.addCoordinateSystem((CoordinateSystem)cs);
                            ncd.addCoordinateAxis((VariableDS)zAxis);
                            z = new VariableDS(null, zAxis.getOriginalVariable(), true);
                            z.setCachedData(zAxis.getOriginalVariable().read());
                            ncd.addVariable(null, (Variable)z);
                        }
                        z_index = this.vs.findDimensionIndex(zAxis.getDimension(0).getFullName());
                        z_length = this.vs.getDimension(z_index).getLength();
                    }
                    if ((heightAxis = cs.getHeightAxis()) != null) {
                        if (ncd.findCoordinateAxis(heightAxis.getFullName()) == null) {
                            ncd.addCoordinateSystem((CoordinateSystem)cs);
                            ncd.addCoordinateAxis((VariableDS)heightAxis);
                            z = new VariableDS(null, heightAxis.getOriginalVariable(), true);
                            z.setCachedData(heightAxis.getOriginalVariable().read());
                            ncd.addVariable(null, (Variable)z);
                        }
                        z_index = this.vs.findDimensionIndex(heightAxis.getDimension(0).getFullName());
                        z_length = this.vs.getDimension(z_index).getLength();
                    }
                    if ((pressureAxis = cs.getPressureAxis()) != null) {
                        if (ncd.findCoordinateAxis(pressureAxis.getFullName()) == null) {
                            ncd.addCoordinateSystem((CoordinateSystem)cs);
                            ncd.addCoordinateAxis((VariableDS)pressureAxis);
                            z = new VariableDS(null, pressureAxis.getOriginalVariable(), true);
                            z.setCachedData(pressureAxis.getOriginalVariable().read());
                            ncd.addVariable(null, (Variable)z);
                        }
                        z_index = this.vs.findDimensionIndex(pressureAxis.getDimension(0).getFullName());
                        z_length = this.vs.getDimension(z_index).getLength();
                    }
                    ncd.finish();
                }
                if (!cs.isLatLon()) continue;
                CoordinateAxis latAxis = cs.getLatAxis();
                Dimension node_dim = ncd.findDimension(latAxis.getDimension(0).getFullName());
                if (node_dim == null) {
                    node_dim = ncd.addDimension(null, new Dimension(latAxis.getDimension(0).getFullName(), unique_entities.size()));
                }
                data_index = this.vs.findDimensionIndex(node_dim.getFullName());
                ncd.finish();
                Variable newLat = ncd.findVariable(latAxis.getFullNameEscaped());
                if (newLat == null) {
                    Object a22;
                    newLat = new VariableDS(ugd.getNetcdfDataset(), null, null, latAxis.getShortName(), latAxis.getOriginalDataType(), latAxis.getDimensionsString(), latAxis.getUnitsString(), latAxis.getDescription());
                    for (Object a22 : latAxis.getAttributes()) {
                        newLat.addAttribute((Attribute)a22);
                    }
                    newLat.setDimension(0, node_dim);
                    ncd.addVariable(null, newLat);
                    ncd.addCoordinateAxis(new VariableDS(null, newLat, true));
                    Array lats = Array.factory((DataType)latAxis.getOriginalDataType(), (int[])newLat.getShape());
                    int count = 0;
                    a22 = unique_entities.iterator();
                    while (a22.hasNext()) {
                        Entity k = (Entity)a22.next();
                        lats.setObject(count, (Object)k.getGeoPoint().getLatitude());
                        ++count;
                    }
                    newLat.setCachedData(lats);
                }
                ncd.finish();
                CoordinateAxis lonAxis = cs.getLonAxis();
                Variable newLon = ncd.findVariable(lonAxis.getFullNameEscaped());
                if (newLon == null) {
                    newLon = new VariableDS(ugd.getNetcdfDataset(), null, null, lonAxis.getShortName(), lonAxis.getOriginalDataType(), lonAxis.getDimensionsString(), lonAxis.getUnitsString(), lonAxis.getDescription());
                    for (Attribute a : lonAxis.getAttributes()) {
                        newLon.addAttribute(a);
                    }
                    newLon.setDimension(0, node_dim);
                    ncd.addVariable(null, newLon);
                    ncd.addCoordinateAxis(new VariableDS(null, newLon, true));
                    Array lons = Array.factory((DataType)lonAxis.getOriginalDataType(), (int[])newLon.getShape());
                    int count = 0;
                    for (Entity k : unique_entities) {
                        lons.setObject(count, (Object)k.getGeoPoint().getLongitude());
                        ++count;
                    }
                    newLon.setCachedData(lons);
                    ncd.finish();
                }
                ncd.finish();
            }
            Variable newVar = ncd.findVariable(this.vs.getFullNameEscaped());
            if (newVar == null) {
                newVar = new VariableDS(ugd.getNetcdfDataset(), null, null, this.vs.getShortName(), this.vs.getOriginalDataType(), this.vs.getDimensionsString(), this.vs.getUnitsString(), this.vs.getDescription());
                for (Attribute a : this.vs.getAttributes()) {
                    newVar.addAttribute(a);
                }
                ncd.addVariable(null, newVar);
                ncd.finish();
            }
            ArrayList<Range> r = new ArrayList<Range>();
            if (time_index != -1) {
                r.add(time_index, new Range(n));
            }
            if (z_index != -1) {
                r.add(z_index, new Range(z_length));
            }
            if (data_index != -1) {
                r.add(data_index, new Range(0, 10));
            }
            newVar.setCachedData(this.vs.read(r));
            ncd.finish();
        }
        catch (IOException iOException) {
        }
        catch (InvalidRangeException invalidRangeException) {
            // empty catch block
        }
    }

    public UGridDataset subsetToSelf(LatLonRect bounds) {
        LatLonRectangle2D r = new LatLonRectangle2D(new LatLonPoint2D.Double(bounds.getUpperLeftPoint().getLatitude(), bounds.getUpperLeftPoint().getLongitude()), new LatLonPoint2D.Double(bounds.getLowerRightPoint().getLatitude(), bounds.getLowerRightPoint().getLongitude()));
        LatLonPolygon2D.Double p = new LatLonPolygon2D.Double(r);
        ArrayList<Cell> containedCells = this.meshset.getMesh().getCellsInPolygon(p);
        NetcdfDataset ncd = null;
        try {
            ncd = NcdsFactory.getNcdsFromTemplate(NcdsFactory.NcdsTemplate.UGRID);
            for (Attribute a : this.dataset.getGlobalAttributes()) {
                ncd.addAttribute(null, a);
            }
            Dimension ds = new Dimension("nodes", containedCells.size());
            for (CoordinateSystem cs : this.dataset.getNetcdfDataset().getCoordinateSystems()) {
                for (Dimension d : cs.getDomain()) {
                    if (ncd.findDimension(d.getFullName()) == null) {
                        ncd.addDimension(null, d);
                        Variable vd = this.dataset.getNetcdfFile().findVariable(d.getFullName());
                        if (vd != null) {
                            ncd.addVariable(null, (Variable)new VariableDS(null, vd, true));
                        }
                    }
                    ncd.finish();
                }
                ncd.addCoordinateSystem(cs);
                ncd.finish();
            }
            for (CoordinateAxis ax : this.dataset.getNetcdfDataset().getCoordinateAxes()) {
                ncd.addCoordinateAxis((VariableDS)ax);
                ncd.finish();
            }
            ncd.addVariable(null, (Variable)this.meshset.getDescriptionVariable());
            ncd.addVariable(null, (Variable)this.getConnectivityVariable().subsetToVariable(containedCells));
            ncd.finish();
            return new UGridDataset(ncd);
        }
        catch (IOException | URISyntaxException e) {
            if (ncd == null) {
                logger.error("Unable to read NetcdfDataset UGRID template", (Throwable)e);
            } else {
                logger.error("Error creating UGridDataset", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public double readPointData(LatLonPoint point) throws IOException {
        final LatLonPoint2D.Double p = new LatLonPoint2D.Double(point.getLatitude(), point.getLongitude());
        Cell c = this.meshset.getMesh().getCellFromLatLon(p);
        double z = -1.0;
        ArrayList<Entity> e = this.cellLocation.equals("node") ? c.getNodes() : (this.cellLocation.equals("face") ? c.getFaces() : (this.cellLocation.equals("edge") ? c.getEdges() : null));
        if (e != null && e.size() > 0) {
            Collections.sort(e, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Entity e1 = (Entity)o1;
                    Entity e2 = (Entity)o2;
                    if (e1.getGeoPoint().distance(p) == e2.getGeoPoint().distance(p)) {
                        return 0;
                    }
                    if (e1.getGeoPoint().distance(p) > e2.getGeoPoint().distance(p)) {
                        return 1;
                    }
                    return -1;
                }
            });
            int in = ((Entity)e.get(0)).getDataIndex();
            try {
                ArrayList<Range> r = new ArrayList<Range>();
                r.add(new Range(0, 0));
                r.add(new Range(0, 0));
                r.add(new Range(in, in));
                float[] ret1D = (float[])this.vs.read(r).copyTo1DJavaArray();
                z = ret1D[0];
            }
            catch (InvalidRangeException ex) {
                logger.error("Error reading data point", (Throwable)ex);
            }
        }
        return z;
    }

    @Override
    public String getInfo() {
        StringBuilder buf = new StringBuilder(200);
        buf.setLength(0);
        buf.append(this.getName());
        Format.tab((StringBuilder)buf, (int)30, (boolean)true);
        buf.append(this.getUnitsString());
        Format.tab((StringBuilder)buf, (int)60, (boolean)true);
        buf.append(this.hasMissingData());
        Format.tab((StringBuilder)buf, (int)66, (boolean)true);
        buf.append(this.getDescription());
        return buf.toString();
    }

    @Override
    public VariableDS getVariable() {
        return this.vs;
    }

    public int compareTo(UGridDatatype g) {
        return this.getNameEscaped().compareTo(g.getNameEscaped());
    }

    public int compareTo(GridDatatype o) {
        return 0;
    }

    public boolean hasMissing() {
        return false;
    }

    public boolean isMissing(double val) {
        return false;
    }
}

