/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.geom;

import java.awt.geom.Point2D;
import java.io.Serializable;
import ucar.nc2.dt.ugrid.geom.LatLonPoint2D;
import ucar.nc2.dt.ugrid.geom.LatLonPolygon2D;
import ucar.nc2.dt.ugrid.utils.AsaArrayUtils;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class LatLonRectangle2D
implements Serializable {
    private static final long serialVersionUID = -3463384339436190519L;
    private LatLonPoint2D lowerLeft;
    private LatLonPoint2D upperRight;
    private boolean crossesDateline = false;
    private boolean coversAllLons = false;
    private double width;
    private double centLon;

    @Deprecated
    public LatLonRectangle2D(LatLonPoint2D leftPoint, double dLat, double dLon) {
        this(leftPoint.getLatitude(), leftPoint.getLongitude(), dLat + leftPoint.getLatitude(), LatLonPoint2D.normLon(dLon + leftPoint.getLongitude()));
    }

    public LatLonRectangle2D(double leftY, double leftX, double rightY, double rightX) {
        this.init(leftY, leftX, rightY, rightX);
    }

    private void init(double leftY, double leftX, double rightY, double rightX) {
        double dLon = LatLonPoint2D.normLon360(rightX - leftX);
        double[] latMM = AsaArrayUtils.minMax(new double[]{leftY, rightY});
        double[] lonMM = new double[]{0.0, 0.0};
        if (dLon > 0.0) {
            lonMM[0] = leftX;
            lonMM[1] = leftX + dLon;
            this.crossesDateline = lonMM[1] > 180.0;
        } else {
            lonMM[0] = leftX + dLon;
            lonMM[1] = leftX;
            this.crossesDateline = lonMM[1] < -180.0;
        }
        this.lowerLeft = new LatLonPoint2D.Double(latMM[0], lonMM[0]);
        this.upperRight = new LatLonPoint2D.Double(latMM[1], lonMM[1]);
        this.width = Math.abs(dLon);
        this.centLon = LatLonPoint2D.normLon(leftX + dLon * 0.5);
        this.coversAllLons = this.width >= 360.0;
    }

    public LatLonRectangle2D(LatLonPoint2D leftPoint, LatLonPoint2D rightPoint) {
        this(leftPoint.getLatitude(), leftPoint.getLongitude(), rightPoint.getLatitude(), rightPoint.getLongitude());
    }

    public LatLonRectangle2D(Point2D leftPoint, Point2D rightPoint) {
        this(leftPoint.getY(), leftPoint.getX(), rightPoint.getY(), rightPoint.getX());
    }

    public LatLonRectangle2D(LatLonRectangle2D rect) {
        this(rect.getLowerLeftPoint(), rect.getUpperRightPoint());
    }

    public double[] getBoundingLatLonValues() {
        double[] srcVals = new double[]{this.getLatMin(), this.getLonMin(), this.getLatMax(), this.getLonMax()};
        return srcVals;
    }

    public LatLonPoint2D getLowerLeftPoint() {
        return this.lowerLeft;
    }

    public LatLonPoint2D getUpperRightPoint() {
        return this.upperRight;
    }

    public LatLonPoint2D getLowerRightPoint() {
        return new LatLonPoint2D.Double(this.lowerLeft.getLatitude(), this.upperRight.getLongitude());
    }

    public LatLonPoint2D getUpperLeftPoint() {
        return new LatLonPoint2D.Double(this.upperRight.getLatitude(), this.lowerLeft.getLongitude());
    }

    public boolean crossesDateline() {
        return this.crossesDateline;
    }

    public boolean equals(LatLonRectangle2D rect) {
        return this.lowerLeft.equals(rect.getLowerLeftPoint()) && this.upperRight.equals(rect.getUpperRightPoint());
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.getLatMax() - this.getLatMin();
    }

    public double getCenterLatitude() {
        return this.lowerLeft.getLatitude() + this.getHeight() * 0.5;
    }

    public double getCenterLongitude() {
        return this.centLon;
    }

    public LatLonPoint2D getCentroid() {
        return new LatLonPoint2D.Double(this.getCenterLatitude(), this.centLon);
    }

    public double getLonMin() {
        return this.lowerLeft.getLongitude();
    }

    public double getLonMax() {
        return this.upperRight.getLongitude();
    }

    public double getLatMin() {
        return this.lowerLeft.getLatitude();
    }

    public double getLatMax() {
        return this.upperRight.getLatitude();
    }

    public double[] getLonCoords() {
        double l = this.lowerLeft.getLongitude();
        double r = this.upperRight.getLongitude();
        return new double[]{l, l, r, r};
    }

    public double[] getLatCoords() {
        double t = this.upperRight.getLatitude();
        double b = this.lowerLeft.getLatitude();
        return new double[]{t, b, b, t};
    }

    public boolean contains(Point2D point) {
        return this.contains(point.getY(), point.getX());
    }

    public boolean contains(LatLonPoint2D point) {
        return this.contains(point.getLatitude(), point.getLongitude());
    }

    public boolean contains(double lat, double lon) {
        if (lat + 1.0E-9 < this.lowerLeft.getLatitude() || lat - 1.0E-9 > this.upperRight.getLatitude()) {
            return false;
        }
        if (this.width >= 360.0) {
            return true;
        }
        if (this.crossesDateline) {
            return lon >= this.lowerLeft.getLongitude() || lon <= this.upperRight.getLongitude();
        }
        return (lon = LatLonPoint2D.normLon(lon)) >= this.lowerLeft.getLongitude() && lon <= this.upperRight.getLongitude();
    }

    public boolean contains(LatLonRectangle2D rect) {
        return this.width >= rect.getWidth() && this.contains(rect.getLowerLeftPoint()) && this.contains(rect.getUpperRightPoint());
    }

    public boolean contains(LatLonPolygon2D poly) {
        for (LatLonPoint2D p : poly.getVertices()) {
            if (this.contains(p.getLatitude(), p.getLongitude())) continue;
            return false;
        }
        return true;
    }

    public boolean containedBy(LatLonRectangle2D rect) {
        return rect.getWidth() >= this.width && rect.contains(this.lowerLeft) && rect.contains(this.upperRight);
    }

    public boolean intersects(LatLonRectangle2D rect) {
        return this.intersects(new LatLonPolygon2D.Double(rect));
    }

    public boolean intersects(LatLonPolygon2D poly) {
        LatLonPolygon2D.Double thisRect = new LatLonPolygon2D.Double(this);
        return ((LatLonPolygon2D)thisRect).intersects(poly);
    }

    public boolean intersects(LatLonPoint2D point) {
        LatLonPolygon2D.Double thisRect = new LatLonPolygon2D.Double(this);
        return thisRect.intersects(point);
    }

    public void extend(double pLat, double pLon) {
        if (this.contains(pLat, pLon)) {
            return;
        }
        if (pLat > this.upperRight.getLatitude()) {
            this.upperRight.setLatitude(pLat);
        }
        if (pLat < this.lowerLeft.getLatitude()) {
            this.lowerLeft.setLatitude(pLat);
        }
        if (!this.coversAllLons) {
            if (this.crossesDateline) {
                double d1 = pLon - this.upperRight.getLongitude();
                double d2 = this.lowerLeft.getLongitude() - pLon;
                if (d1 > 0.0 && d2 > 0.0) {
                    if (d1 > d2) {
                        this.lowerLeft.setLongitude(pLon);
                    } else {
                        this.upperRight.setLongitude(pLon);
                    }
                }
            } else if (pLon > this.upperRight.getLongitude()) {
                if (pLon - this.upperRight.getLongitude() > this.lowerLeft.getLongitude() - pLon + 360.0) {
                    this.crossesDateline = true;
                    this.lowerLeft.setLongitude(pLon);
                } else {
                    this.upperRight.setLongitude(pLon);
                }
            } else if (pLon < this.lowerLeft.getLongitude()) {
                if (this.lowerLeft.getLongitude() - pLon > pLon + 360.0 - this.upperRight.getLongitude()) {
                    this.crossesDateline = true;
                    this.upperRight.setLongitude(pLon);
                } else {
                    this.lowerLeft.setLongitude(pLon);
                }
            }
        }
        this.width = this.upperRight.getLongitude() - this.lowerLeft.getLongitude();
        this.centLon = (this.upperRight.getLongitude() + this.lowerLeft.getLongitude()) * 0.5;
        if (this.crossesDateline) {
            this.width += 360.0;
            this.centLon -= 180.0;
        }
    }

    public void extend(LatLonPoint2D point) {
        this.extend(point.getLatitude(), point.getLongitude());
    }

    public void extend(double[] bounds) {
        double latMax = bounds[2];
        double latMin = bounds[0];
        if (latMax > this.upperRight.getLatitude()) {
            this.upperRight.setLatitude(latMax);
        }
        if (latMin < this.lowerLeft.getLatitude()) {
            this.lowerLeft.setLatitude(latMin);
        }
        if (this.coversAllLons) {
            return;
        }
        double lonMin = this.getLonMin();
        double lonMax = this.getLonMax();
        double nLonMin = LatLonPoint2D.normLon(bounds[1], lonMin);
        double nLonMax = LatLonPoint2D.normLon(bounds[3], lonMax);
        lonMin = Math.min(lonMin, nLonMin);
        lonMax = Math.max(lonMax, nLonMax);
        this.width = LatLonPoint2D.normLon360(lonMax - lonMin);
        boolean bl = this.coversAllLons = this.width >= 360.0;
        if (this.coversAllLons) {
            this.width = 360.0;
            lonMin = -180.0;
        }
        this.lowerLeft.setLongitude(lonMin);
        this.upperRight.setLongitude(lonMin + this.width);
        this.centLon = lonMin + this.width * 0.5;
        this.crossesDateline = this.lowerLeft.getLongitude() > this.upperRight.getLongitude();
    }

    public void extend(LatLonRectangle2D rect) {
        double latMax = rect.getLatMax();
        double latMin = rect.getLatMin();
        if (latMax > this.upperRight.getLatitude()) {
            this.upperRight.setLatitude(latMax);
        }
        if (latMin < this.lowerLeft.getLatitude()) {
            this.lowerLeft.setLatitude(latMin);
        }
        if (this.coversAllLons) {
            return;
        }
        double lonMin = this.getLonMin();
        double lonMax = this.getLonMax();
        double nLonMin = LatLonPoint2D.normLon(rect.getLonMin(), lonMin);
        double nLonMax = LatLonPoint2D.normLon(rect.getLonMax(), lonMax);
        lonMin = Math.min(lonMin, nLonMin);
        lonMax = Math.max(lonMax, nLonMax);
        this.width = LatLonPoint2D.normLon360(lonMax - lonMin);
        boolean bl = this.coversAllLons = this.width >= 360.0;
        if (this.coversAllLons) {
            this.width = 360.0;
            lonMin = -180.0;
        }
        this.lowerLeft.setLongitude(lonMin);
        this.upperRight.setLongitude(lonMin + this.width);
        this.centLon = lonMin + this.width * 0.5;
        this.crossesDateline = this.lowerLeft.getLongitude() > this.upperRight.getLongitude();
    }

    public void extend(LatLonPolygon2D poly) {
        double[] pys = poly.getLatCoords();
        double[] mmy = AsaArrayUtils.minMax(pys);
        if (mmy[1] > this.upperRight.getLatitude()) {
            this.upperRight.setLatitude(mmy[1]);
        }
        if (mmy[0] < this.lowerLeft.getLatitude()) {
            this.lowerLeft.setLatitude(mmy[0]);
        }
        if (this.coversAllLons) {
            return;
        }
        double lonMin = this.getLonMin();
        double lonMax = this.getLonMax();
        double[] pxs = poly.getLonCoords();
        if (this.shouldCrossDateline(poly)) {
            for (int i = 0; i < pxs.length; ++i) {
                pxs[i] = LatLonPoint2D.normLon360(pxs[i]);
            }
            lonMin = LatLonPoint2D.normLon360(lonMin);
            lonMax = LatLonPoint2D.normLon360(lonMax);
        }
        double[] mmx = AsaArrayUtils.minMax(pxs);
        lonMin = Math.min(lonMin, mmx[0]);
        lonMax = Math.max(lonMax, mmx[1]);
        this.width = lonMax - lonMin;
        boolean bl = this.coversAllLons = this.width >= 360.0;
        if (this.coversAllLons) {
            this.width = 360.0;
            lonMin = -180.0;
        } else {
            lonMin = LatLonPoint2D.normLon(lonMin);
        }
        this.lowerLeft.setLongitude(lonMin);
        this.upperRight.setLongitude(lonMin + this.width);
        this.centLon = lonMin + this.width * 0.5;
        this.crossesDateline = this.lowerLeft.getLongitude() > this.upperRight.getLongitude();
    }

    public boolean shouldCrossDateline(LatLonPolygon2D poly) {
        double[] polyBounds = poly.getBoundingLatLonValues();
        double[] rectBounds = new double[]{this.getLatMin(), this.getLonMin(), this.getLatMax(), this.getLonMax()};
        if (polyBounds[3] < polyBounds[1] || rectBounds[3] < rectBounds[1]) {
            return true;
        }
        double polyNormMinLon = LatLonPoint2D.normLon(polyBounds[1], rectBounds[1]);
        double polyNormMaxLon = LatLonPoint2D.normLon(polyBounds[3], rectBounds[3]);
        double minLon = Math.min(rectBounds[1], polyNormMinLon);
        double maxLon = Math.max(rectBounds[3], polyNormMaxLon);
        return !((minLon = LatLonPoint2D.normLon(minLon)) <= (maxLon = LatLonPoint2D.normLon(maxLon)));
    }

    public double getArea() {
        return this.getWidth() * this.getHeight();
    }

    public LatLonRectangle2D copy() {
        return new LatLonRectangle2D(this);
    }

    public LatLonRectangle2D translate(double deltaLat, double deltaLon) {
        this.init(this.getLowerLeftPoint().getLatitude() + deltaLat, this.getLowerLeftPoint().getLongitude() + deltaLon, this.getUpperRightPoint().getLatitude() + deltaLat, this.getUpperRightPoint().getLongitude() + deltaLon);
        return this;
    }

    public LatLonRectangle2D recenter(LatLonRectangle2D referenceRectangle) {
        return this.recenter(referenceRectangle.getCentroid());
    }

    public LatLonRectangle2D recenter(Point2D newCenterPoint) {
        return this.recenter(newCenterPoint.getY(), newCenterPoint.getX());
    }

    public LatLonRectangle2D recenter(double centerLat, double centerLon) {
        LatLonPoint2D tcent = this.getCentroid();
        double dlat = centerLat - tcent.getLatitude();
        double dlon = centerLon - tcent.getLongitude();
        return this.translate(dlat, dlon);
    }

    public String toString() {
        return "ll: " + this.lowerLeft + " | ur: " + this.upperRight;
    }

    public LatLonRect toLatLonRect() {
        return new LatLonRect((LatLonPoint)new LatLonPointImpl(this.getUpperLeftPoint().getLatitude(), this.getUpperLeftPoint().getLongitude()), (LatLonPoint)new LatLonPointImpl(this.getCenterLatitude(), this.getCenterLongitude()));
    }
}

