/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.topology;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.ugrid.Cell;
import ucar.nc2.dt.ugrid.Face;
import ucar.nc2.dt.ugrid.Node;
import ucar.nc2.dt.ugrid.UGridDataset;
import ucar.nc2.dt.ugrid.geom.LatLonPoint2D;

public class Topology {
    private static final String CELL_TYPE = "cell_type";
    private static final String INDEX_ORIGIN = "start_index";
    private Type type;
    private String cellType = "none";
    private int startIndex = 0;
    private Variable face_node_connectivity_variable;

    public Topology() {
    }

    public Topology(Variable var) {
        this.face_node_connectivity_variable = var;
        this.parse();
    }

    public Topology(NetcdfDataset ds, String fullnameescaped) {
        this.face_node_connectivity_variable = ds.findVariable(fullnameescaped);
        this.parse();
    }

    public void setFaceNodeConnectivityVariable(Variable v) {
        this.face_node_connectivity_variable = v;
        this.parse();
    }

    private void parse() {
        Attribute cell_type = this.face_node_connectivity_variable.findAttributeIgnoreCase(CELL_TYPE);
        if (cell_type != null && !cell_type.getStringValue().isEmpty()) {
            this.cellType = cell_type.getStringValue();
        }
        if (this.face_node_connectivity_variable.findAttributeIgnoreCase(INDEX_ORIGIN) != null) {
            this.startIndex = this.face_node_connectivity_variable.findAttributeIgnoreCase(INDEX_ORIGIN).getNumericValue().intValue();
        }
        this.type = ((Dimension)this.face_node_connectivity_variable.getDimensions().get(0)).getLength() > ((Dimension)this.face_node_connectivity_variable.getDimensions().get(1)).getLength() ? Type.TALL : Type.WIDE;
    }

    public List<Cell> createCells(List<String> locations, List<CoordinateSystem> coords) {
        try {
            CoordinateSystem node_cs = null;
            CoordinateSystem face_cs = null;
            for (int i = 0; i < locations.size(); ++i) {
                if (locations.get(i).equalsIgnoreCase("node")) {
                    node_cs = coords.get(i);
                    continue;
                }
                if (!locations.get(i).equalsIgnoreCase("face")) continue;
                face_cs = coords.get(i);
            }
            ArrayList<Cell> cells = new ArrayList<Cell>();
            Array arr = this.face_node_connectivity_variable.read();
            Array arri = MAMath.convert((Array)arr, (DataType)DataType.INT);
            int[][] conn_data = (int[][])arri.copyToNDJavaArray();
            double[] face_lats = null;
            double[] face_lons = null;
            ArrayList<Face> unique_faces = null;
            if (face_cs != null) {
                face_lats = (double[])face_cs.getLatAxis().read().get1DJavaArray(Double.TYPE);
                face_lons = (double[])face_cs.getLonAxis().read().get1DJavaArray(Double.TYPE);
                unique_faces = new ArrayList<Face>(face_lats.length);
                for (int g = 0; g < face_lats.length; ++g) {
                    Face face = new Face();
                    face.setDataIndex(g);
                    face.setGeoPoint(new LatLonPoint2D.Double(face_lats[g], face_lons[g]));
                    unique_faces.add(face);
                }
            }
            double[] node_lats = (double[])node_cs.getLatAxis().read().get1DJavaArray(Double.TYPE);
            double[] node_lons = (double[])node_cs.getLonAxis().read().get1DJavaArray(Double.TYPE);
            ArrayList<Node> unique_nodes = new ArrayList<Node>(node_lats.length);
            for (int j = 0; j < node_lats.length; ++j) {
                Node node = new Node();
                node.setDataIndex(j);
                node.setGeoPoint(new LatLonPoint2D.Double(node_lats[j], node_lons[j]));
                unique_nodes.add(node);
            }
            ArrayList<Node> nodes = new ArrayList<Node>();
            ArrayList<Face> faces = new ArrayList<Face>();
            if (this.isTall()) {
                for (int i = 0; i < conn_data.length; ++i) {
                    Cell cell = new Cell();
                    nodes.clear();
                    faces.clear();
                    for (int k = 0; k < conn_data[i].length; ++k) {
                        int index = conn_data[i][k] - this.startIndex;
                        nodes.add((Node)unique_nodes.get(index));
                    }
                    if (!cell.hasFaces() && unique_faces != null) {
                        faces.add((Face)unique_faces.get(i));
                        cell.setFaces(faces);
                    }
                    cell.setNodes((ArrayList)nodes.clone());
                    cell.setConnectivityIndex(i);
                    cells.add(cell);
                }
            } else {
                for (int i = 0; i < conn_data[0].length; ++i) {
                    Cell cell = new Cell();
                    nodes.clear();
                    faces.clear();
                    for (int k = 0; k < conn_data.length; ++k) {
                        int index = conn_data[k][i] - this.startIndex;
                        nodes.add((Node)unique_nodes.get(index));
                    }
                    if (!cell.hasFaces() && unique_faces != null) {
                        faces.add((Face)unique_faces.get(i));
                        cell.setFaces(faces);
                    }
                    cell.setNodes((ArrayList)nodes.clone());
                    cell.setConnectivityIndex(i);
                    cells.add(cell);
                }
            }
            return cells;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void subsetToDataset(UGridDataset ugd, NetcdfDataset ncd, List<Cell> containedCells) {
        String cell_number_dimension_name;
        Dimension max_cell_size_dim;
        if (this.isTall()) {
            max_cell_size_dim = this.face_node_connectivity_variable.getDimension(1);
            cell_number_dimension_name = this.face_node_connectivity_variable.getDimension(0).getFullName();
        } else {
            max_cell_size_dim = this.face_node_connectivity_variable.getDimension(0);
            cell_number_dimension_name = this.face_node_connectivity_variable.getDimension(1).getFullName();
        }
        if (ncd.findDimension(max_cell_size_dim.getFullName()) == null) {
            max_cell_size_dim = ncd.addDimension(null, max_cell_size_dim);
        }
        ncd.finish();
        HashSet<Cell> set = new HashSet<Cell>(containedCells);
        ArrayList<Cell> unique_cells = new ArrayList<Cell>(set);
        Dimension cell_dim = ncd.findDimension(cell_number_dimension_name);
        if (cell_dim == null) {
            cell_dim = ncd.addDimension(null, new Dimension(cell_number_dimension_name, unique_cells.size()));
        }
        ncd.finish();
        VariableDS newConn = new VariableDS(ncd, null, null, this.face_node_connectivity_variable.getShortName(), DataType.INT, this.face_node_connectivity_variable.getDimensionsString(), null, null);
        for (Attribute a : this.face_node_connectivity_variable.getAttributes()) {
            newConn.addAttribute(a);
        }
        newConn.removeAttributeIgnoreCase(INDEX_ORIGIN);
        newConn.addAttribute(new Attribute(INDEX_ORIGIN, (Number)0));
        ncd.finish();
        int[] shape = new int[]{newConn.getDimension(0).getLength(), newConn.getDimension(1).getLength()};
        ArrayInt.D2 conn_data = new ArrayInt.D2(shape[0], shape[1], false);
        Index ima = conn_data.getIndex();
        for (int i = 0; i < unique_cells.size(); ++i) {
            for (int j = 0; j < unique_cells.get(i).getNodes().size(); ++j) {
                if (this.isTall()) {
                    conn_data.set(ima.set(j, i), unique_cells.get(i).getNodes().get(j).getDataIndex());
                    continue;
                }
                conn_data.set(ima.set(j, i), unique_cells.get(i).getNodes().get(j).getDataIndex());
            }
        }
        newConn.setCachedData((Array)conn_data);
        ncd.addVariable(null, (Variable)newConn);
        ncd.finish();
    }

    public VariableDS subsetToVariable(List<Cell> containedCells) {
        Variable newV = new Variable(this.face_node_connectivity_variable);
        int[] shape = new int[]{newV.getShape(0), newV.getShape(1)};
        int[][] conn = new int[shape[0]][shape[1]];
        int count = 0;
        for (Cell c : containedCells) {
            for (int i = 0; i < c.getNodes().size(); ++i) {
                if (this.isTall()) {
                    conn[count][i] = c.getNodes().get(i).getDataIndex();
                    continue;
                }
                conn[i][count] = c.getNodes().get(i).getDataIndex();
            }
            ++count;
        }
        newV.removeAttributeIgnoreCase(INDEX_ORIGIN);
        newV.addAttribute(new Attribute(INDEX_ORIGIN, (Number)0));
        newV.setCachedData(Array.factory((DataType)DataType.INT, (int[])shape, (Object)conn));
        return new VariableDS(null, newV, false);
    }

    public Variable getFaceNodeConnectivityVariable() {
        return this.face_node_connectivity_variable;
    }

    public boolean isTall() {
        return this.type.equals((Object)Type.TALL);
    }

    private static enum Type {
        WIDE,
        TALL;

    }
}

