/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;

public class StreamGobbler
extends Thread {
    private Logger logger;
    private InputStream inStream;
    private String procID;
    private transient boolean terminate = false;
    private String newLine;
    private int outType = -1;

    public StreamGobbler(InputStream inStream, String procID) {
        this(inStream, procID, null);
    }

    public StreamGobbler(InputStream inStream, String procID, Logger outLog) {
        this.inStream = inStream;
        this.procID = procID;
        this.logger = outLog;
        if (this.logger != null) {
            this.outType = 0;
        }
        this.newLine = System.getProperty("line.separator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamReader isr = new InputStreamReader(this.inStream);
        BufferedReader br = new BufferedReader(isr);
        try {
            String line = null;
            block20: while (!this.terminate) {
                line = br.readLine();
                if (line == null) continue;
                switch (this.outType) {
                    case 0: {
                        this.logger.info(this.newLine + this.procID + " > " + line);
                        continue block20;
                    }
                }
                this.logger.debug(this.procID + " > " + line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                this.logger.warn("Could not properly close the gobbler's buffered reader", (Throwable)e);
            }
            try {
                isr.close();
            }
            catch (IOException e) {
                this.logger.warn("Could not properly close the gobbler's input stream", (Throwable)e);
            }
            br = null;
            isr = null;
            this.logger = null;
        }
    }

    public void terminate() {
        this.terminate = true;
    }
}

