/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasetInfo;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.conv.UGridConvention;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.UGridDataset;
import ucar.nc2.dt.UGridDatatype;
import ucar.nc2.dt.grid.internal.spi.GridDatasetProvider;
import ucar.nc2.dt.ugrid.Cell;
import ucar.nc2.dt.ugrid.Mesh;
import ucar.nc2.dt.ugrid.MeshVariable;
import ucar.nc2.dt.ugrid.geom.LatLonPoint2D;
import ucar.nc2.dt.ugrid.geom.LatLonPolygon2D;
import ucar.nc2.dt.ugrid.geom.LatLonRectangle2D;
import ucar.nc2.dt.ugrid.utils.NcdsFactory;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.DateRange;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileCacheable;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;

public class UGridDataset
implements ucar.nc2.dt.UGridDataset,
FeatureDataset {
    private static final Logger logger = LoggerFactory.getLogger(UGridDataset.class);
    private static final String TOPOLOGY_VARIABLE = "mesh_topology";
    private NetcdfDataset ds;
    private ArrayList<MeshVariable> meshVariables = new ArrayList();
    private Map<String, Meshset> meshsetHash = new HashMap<String, Meshset>();
    private DateRange dateRangeMax = null;
    private LatLonRect llbbMax = null;
    protected FileCache fileCache;

    public static UGridDataset open(String location) throws IOException {
        return UGridDataset.open(location, NetcdfDataset.getDefaultEnhanceMode());
    }

    public static UGridDataset open(String location, Set<NetcdfDataset.Enhance> enhanceMode) throws IOException {
        DatasetUrl durl = DatasetUrl.findDatasetUrl((String)location);
        NetcdfDataset ds = NetcdfDatasets.acquireDataset(null, (DatasetUrl)durl, enhanceMode, (int)-1, null, null);
        return new UGridDataset(ds);
    }

    public UGridDataset(NetcdfDataset ds) throws IOException {
        this(ds, null);
    }

    public UGridDataset(NetcdfDataset ds, Formatter parseInfo) throws IOException {
        this.ds = ds;
        NetcdfDatasets.enhance((NetcdfFile)ds, (Set)NetcdfDataset.getDefaultEnhanceMode(), null);
        if (parseInfo != null) {
            parseInfo.format("UGridDataset looking for MeshVariables\n", new Object[0]);
        }
        ImmutableList vars = ds.getVariables();
        for (Variable var : vars) {
            if (var.attributes().findAttributeIgnoreCase("cf_role") == null || !var.attributes().findAttributeIgnoreCase("cf_role").getStringValue().equals(TOPOLOGY_VARIABLE)) continue;
            VariableEnhanced varDS = (VariableEnhanced)var;
            this.constructMeshVariable(ds, varDS, parseInfo);
        }
    }

    private void constructMeshVariable(NetcdfDataset ds, VariableEnhanced v, Formatter parseInfo) {
        if (v instanceof StructureDS) {
            StructureDS s = (StructureDS)v;
            ImmutableList members = s.getVariables();
            for (Variable nested : members) {
                this.constructMeshVariable(ds, (VariableEnhanced)nested, parseInfo);
            }
        } else {
            Mesh m = new Mesh(ds, v);
            this.addMesh((VariableDS)v, m, parseInfo);
        }
    }

    private void addMesh(VariableDS varDS, Mesh m, Formatter parseInfo) {
        Meshset meshset = this.meshsetHash.get(m.getName());
        if (null == meshset) {
            meshset = new Meshset(m, varDS);
            this.meshsetHash.put(m.getName(), meshset);
            if (parseInfo != null) {
                parseInfo.format(" -make new Mesh= %s\n", m.getName());
            }
            this.setVariables(meshset);
        }
    }

    private void setVariables(Meshset meshset) {
        for (Variable v : this.ds.getVariables()) {
            MeshVariable mv;
            if (v.attributes().findAttributeIgnoreCase("mesh") == null || !v.attributes().findAttributeIgnoreCase("mesh").getStringValue().toLowerCase().contains(meshset.getMesh().getName().toLowerCase()) || this.meshVariables.contains(mv = new MeshVariable(this, (VariableDS)v, meshset))) continue;
            this.meshVariables.add(mv);
            meshset.add(mv);
        }
    }

    @Override
    @Nullable
    public UGridDatatype getMeshVariableByName(String name) {
        UGridDatatype z = null;
        for (UGridDatatype uGridDatatype : this.meshVariables) {
            if (!uGridDatatype.getName().equals(name)) continue;
            z = uGridDatatype;
            break;
        }
        return z;
    }

    @Override
    public List<UGridDatatype> getMeshVariables() {
        return new ArrayList<UGridDatatype>(this.meshVariables);
    }

    public void calcBounds() throws IOException {
    }

    public List<Attribute> getGlobalAttributes() {
        return this.ds.getGlobalAttributes();
    }

    public String getTitle() {
        Attribute titleAttr = this.ds.findGlobalAttributeIgnoreCase("title");
        String title = titleAttr != null ? titleAttr.getStringValue() : null;
        return title == null ? this.getName() : title;
    }

    public String getDescription() {
        String desc;
        Attribute descAttr = this.ds.findGlobalAttributeIgnoreCase("description");
        String string = desc = descAttr != null ? descAttr.getStringValue() : null;
        if (desc == null) {
            Attribute histAttr = this.ds.findGlobalAttributeIgnoreCase("history");
            desc = histAttr != null ? histAttr.getStringValue() : null;
        }
        return desc == null ? this.getName() : desc;
    }

    public String getName() {
        return this.ds.getLocation();
    }

    public String getLocation() {
        return this.ds.getLocation();
    }

    public String getLocationURI() {
        return this.ds.getLocation();
    }

    private void makeRanges() {
        for (UGridDataset.Meshset ms : this.getMeshsets()) {
            Mesh m = ms.getMesh();
            LatLonRect llbb = m.getLatLonBoundingBox();
            if (this.llbbMax == null) {
                this.llbbMax = llbb;
                continue;
            }
            this.llbbMax.extend(llbb);
        }
    }

    public Date getStartDate() {
        if (this.dateRangeMax == null) {
            this.makeRanges();
        }
        return this.dateRangeMax == null ? null : this.dateRangeMax.getStart().getCalendarDate().toDate();
    }

    public Date getEndDate() {
        if (this.dateRangeMax == null) {
            this.makeRanges();
        }
        return this.dateRangeMax == null ? null : this.dateRangeMax.getEnd().getCalendarDate().toDate();
    }

    public LatLonRect getBoundingBox() {
        if (this.llbbMax == null) {
            this.makeRanges();
        }
        return this.llbbMax;
    }

    public AttributeContainer attributes() {
        return null;
    }

    public Attribute findGlobalAttributeIgnoreCase(String name) {
        return this.ds.findGlobalAttributeIgnoreCase(name);
    }

    public List<VariableSimpleIF> getDataVariables() {
        ArrayList<VariableSimpleIF> result = new ArrayList<VariableSimpleIF>(this.meshVariables.size());
        for (UGridDatatype mv : this.getMeshVariables()) {
            if (mv.getVariable() == null) continue;
            result.add((VariableSimpleIF)mv.getVariable());
        }
        return result;
    }

    public VariableSimpleIF getDataVariable(String shortName) {
        return this.ds.findVariable(shortName);
    }

    public NetcdfFile getNetcdfFile() {
        return this.ds;
    }

    public FeatureType getFeatureType() {
        return FeatureType.UGRID;
    }

    public DateRange getDateRange() {
        if (this.dateRangeMax == null) {
            this.makeRanges();
        }
        return this.dateRangeMax;
    }

    public String getImplementationName() {
        return this.ds.getConventionUsed();
    }

    public synchronized void close() throws IOException {
        if (this.fileCache != null) {
            this.fileCache.release((FileCacheable)this);
        } else {
            try {
                if (this.ds != null) {
                    this.ds.close();
                }
            }
            finally {
                this.ds = null;
            }
        }
    }

    public boolean syncExtend() throws IOException {
        return false;
    }

    public void setFileCache(FileCache fileCache) {
        this.fileCache = fileCache;
    }

    private void getInfo(Formatter buf) {
    }

    public String getDetailInfo() {
        Formatter buff = new Formatter();
        this.getDetailInfo(buff);
        return buff.toString();
    }

    public NetcdfDataset getNetcdfDataset() {
        return this.ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDetailInfo(Formatter buff) {
        this.getInfo(buff);
        buff.format("\n\n----------------------------------------------------\n", new Object[0]);
        NetcdfDatasetInfo info = null;
        try {
            info = new NetcdfDatasetInfo(this.ds.getLocation());
            buff.format("%s", info.getParseInfo());
        }
        catch (IOException e) {
            buff.format("NetcdfDatasetInfo failed", new Object[0]);
        }
        finally {
            if (info != null) {
                try {
                    info.close();
                }
                catch (IOException iOException) {}
            }
        }
        buff.format("\n\n----------------------------------------------------\n", new Object[0]);
        buff.format("%s", this.ds.toString());
        buff.format("\n\n----------------------------------------------------\n", new Object[0]);
    }

    @Override
    public List<UGridDataset.Meshset> getMeshsets() {
        return new ArrayList<UGridDataset.Meshset>(this.meshsetHash.values());
    }

    @Override
    public UGridDataset subset(LatLonRect bounds) {
        NetcdfDataset ncd = null;
        try {
            ncd = NcdsFactory.getNcdsFromTemplate(NcdsFactory.NcdsTemplate.UGRID);
            for (Attribute a : this.getGlobalAttributes()) {
                ncd.addAttribute(null, a);
            }
            ncd.addAttribute(null, new Attribute("History", "Subset by NetCDF-Java UGRID Library; Translation date = " + String.valueOf(new Date()) + ";"));
            LatLonRectangle2D r = new LatLonRectangle2D(new LatLonPoint2D.Double(bounds.getUpperLeftPoint().getLatitude(), bounds.getUpperLeftPoint().getLongitude()), new LatLonPoint2D.Double(bounds.getLowerRightPoint().getLatitude(), bounds.getLowerRightPoint().getLongitude()));
            LatLonPolygon2D.Double p = new LatLonPolygon2D.Double(r);
            for (UGridDataset.Meshset ms3 : this.getMeshsets()) {
                ncd.addVariable(null, (Variable)ms3.getDescriptionVariable());
                Mesh m4 = ms3.getMesh();
                m4.buildRTree();
                ArrayList<Cell> containedCells = m4.getCellsInPolygon(p);
                m4.getTopology().subsetToDataset(this, ncd, containedCells);
                List<UGridDatatype> mvs = ms3.getMeshVariables();
                for (UGridDatatype mv : mvs) {
                    ((MeshVariable)mv).subsetToDataset(this, ncd, containedCells);
                }
            }
            ncd.finish();
            for (CoordinateSystem cs : this.getNetcdfDataset().getCoordinateSystems()) {
                for (Dimension d : cs.getDomain()) {
                    if (ncd.findDimension(d.getFullName()) == null) {
                        ncd.addDimension(null, d);
                        Variable vd = this.getNetcdfDataset().findVariable(d.getFullName());
                        if (vd == null) {
                            ncd.addVariable(null, (Variable)new VariableDS(null, vd, true));
                        }
                    }
                    ncd.finish();
                }
                ncd.addCoordinateSystem(cs);
                ncd.finish();
            }
            for (CoordinateAxis ax : this.getNetcdfDataset().getCoordinateAxes()) {
                if (ncd.findCoordinateAxis(ax.getFullNameEscaped()) != null) continue;
                ncd.addCoordinateAxis((VariableDS)ax);
                ncd.finish();
            }
            return new UGridDataset(ncd);
        }
        catch (IOException | URISyntaxException e) {
            if (ncd == null) {
                logger.error("Unable to read NetcdfDataset UGRID template", (Throwable)e);
            } else {
                logger.error("Error creating UGridDataset", (Throwable)e);
            }
            return null;
        }
    }

    public CalendarDateRange getCalendarDateRange() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CalendarDate getCalendarDateStart() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CalendarDate getCalendarDateEnd() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long getLastModified() {
        return this.ds == null ? 0L : this.ds.getLastModified();
    }

    public void setFileCache(FileCacheIF fileCache) {
    }

    public void release() throws IOException {
    }

    public void reacquire() throws IOException {
    }

    public List<GridDatatype> getGrids() {
        return new ArrayList<GridDatatype>(this.meshVariables);
    }

    public GridDatatype findGridDatatype(String name) {
        return null;
    }

    public GridDatatype findGridByShortName(String shortName) {
        return null;
    }

    public ProjectionRect getProjBoundingBox() {
        return null;
    }

    public List<GridDataset.Gridset> getGridsets() {
        return null;
    }

    public class Meshset
    implements UGridDataset.Meshset {
        private Mesh mesh;
        private VariableDS description_variable;
        private List<UGridDatatype> meshVariables = new ArrayList<UGridDatatype>();

        public Meshset(Mesh m, VariableDS conn) {
            this.mesh = m;
            this.description_variable = conn;
        }

        private void add(MeshVariable mv) {
            this.meshVariables.add(mv);
        }

        @Override
        public List<UGridDatatype> getMeshVariables() {
            return this.meshVariables;
        }

        @Override
        public UGridDatatype getMeshVariableByName(String name) {
            UGridDatatype z = null;
            for (UGridDatatype m : this.meshVariables) {
                if (!m.getName().equals(name)) continue;
                z = m;
                break;
            }
            return z;
        }

        @Override
        public Mesh getMesh() {
            return this.mesh;
        }

        @Override
        public VariableDS getDescriptionVariable() {
            return this.description_variable;
        }
    }

    public static class Factory
    implements GridDatasetProvider {
        public boolean isMine(NetcdfDataset ncd) {
            String csb;
            Attribute csbAttr;
            boolean mine = false;
            if (ncd != null && (csbAttr = ncd.findGlobalAttribute("_CoordSysBuilder")) != null && (csb = csbAttr.getStringValue()) != null) {
                mine = csb == UGridConvention.class.getCanonicalName();
            }
            return mine;
        }

        public boolean isMine(String location, Set<NetcdfDataset.Enhance> enhanceMode) {
            boolean mine = false;
            try (NetcdfDataset ncd = NetcdfDatasets.acquireDataset(null, (DatasetUrl)DatasetUrl.findDatasetUrl((String)location), enhanceMode, (int)-1, null, null);){
                mine = this.isMine(ncd);
            }
            catch (IOException e) {
                logger.warn("Could not test if {} is a GridDatasetProvider", (Object)location, (Object)e);
            }
            return mine;
        }

        @Nullable
        public GridDataset open(String location, Set<NetcdfDataset.Enhance> enhanceMode) throws IOException {
            return UGridDataset.open(location, enhanceMode);
        }

        @Nullable
        public GridDataset open(NetcdfDataset ncd, Formatter parseInfo) throws IOException {
            return new UGridDataset(ncd, parseInfo);
        }
    }
}

