/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.geom;

import java.awt.geom.Point2D;
import java.io.Serializable;
import ucar.nc2.dt.ugrid.utils.AsaMath;

public abstract class LatLonPoint2D
extends Point2D
implements Serializable {
    private static final long serialVersionUID = 4807208704519349333L;
    public static final double EQUIVALENT_TOLERANCE = 1.0E-9;

    protected LatLonPoint2D() {
    }

    public static LatLonPoint2D getFloat(Point2D pt2D) {
        if (pt2D instanceof Float) {
            return (Float)pt2D;
        }
        return new Float(pt2D);
    }

    public static LatLonPoint2D getDouble(Point2D pt2D) {
        if (pt2D instanceof Double) {
            return (Double)pt2D;
        }
        return new Double(pt2D);
    }

    public abstract void setLatLon(double var1, double var3);

    public abstract void setLatLon(double var1, double var3, boolean var5);

    public abstract double getLongitude();

    public abstract double getLatitude();

    public abstract double getRadLon();

    public abstract double getRadLat();

    public abstract void setLatitude(double var1);

    public abstract void setLongitude(double var1);

    public void setLatLon(LatLonPoint2D llp) {
        this.setLatLon(llp.getY(), llp.getX(), false);
    }

    @Override
    public double distance(double px, double py) {
        return Math.sqrt(this.distanceSq(px, py));
    }

    @Override
    public double distance(Point2D pt) {
        return this.distance(pt.getX(), pt.getY());
    }

    @Override
    public double distanceSq(double px, double py) {
        px = Math.abs(px -= this.getX()) > 180.0 ? 360.0 - Math.abs(px) : px;
        return px * px + (py -= this.getY()) * py;
    }

    @Override
    public double distanceSq(Point2D pt) {
        return this.distanceSq(pt.getX(), pt.getY());
    }

    public static double range180(double lon) {
        return LatLonPoint2D.normLon(lon);
    }

    public static double normLon360(double lon) {
        return LatLonPoint2D.normLon(lon, 180.0);
    }

    public static double normLon(double lon, double center) {
        return center + Math.IEEEremainder(lon - center, 360.0);
    }

    public static double normLon(double lon) {
        if (lon < -180.0 || lon > 180.0) {
            return Math.IEEEremainder(lon, 360.0);
        }
        return lon;
    }

    public static double normLat(double lat) {
        if (lat < -90.0) {
            return -90.0;
        }
        if (lat > 90.0) {
            return 90.0;
        }
        return lat;
    }

    public static boolean isInvalidLatitude(double lat) {
        return lat > 90.0 || lat < -90.0;
    }

    public static boolean isInvalidLongitude(double lon) {
        return lon < -180.0 || lon > 180.0;
    }

    public static LatLonPoint2D calculateGeographicCenter(LatLonPoint2D[] points) {
        Double ret = null;
        if (points.length > 0) {
            double x = Math.cos(points[0].getRadLat()) * Math.cos(points[0].getRadLon());
            double y = Math.cos(points[0].getRadLat()) * Math.sin(points[0].getRadLon());
            double z = Math.sin(points[0].getRadLat());
            for (int i = 1; i < points.length; ++i) {
                x += Math.cos(points[i].getRadLat()) * Math.cos(points[i].getRadLon());
                y += Math.cos(points[i].getRadLat()) * Math.sin(points[i].getRadLon());
                z += Math.sin(points[i].getRadLat());
            }
            double lon = Math.atan2(y, x);
            double hyp = Math.sqrt(x * x + y * y);
            double lat = Math.atan2(z, hyp);
            ret = new Double(Math.toDegrees(lat), Math.toDegrees(lon));
        }
        return ret;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LatLonPoint2D) {
            LatLonPoint2D pt = (LatLonPoint2D)obj;
            return AsaMath.almostEqual(this.getY(), pt.getY(), 1.0E-9) && AsaMath.almostEqual(this.getX(), pt.getX(), 1.0E-9);
        }
        return false;
    }

    public static class Float
    extends LatLonPoint2D {
        private static final long serialVersionUID = -2447464428275551182L;
        protected float lat;
        protected float lon;
        protected transient float radLat;
        protected transient float radLon;

        public Float() {
        }

        public Float(float lat, float lon) {
            this.setLatLon(lat, lon, false);
        }

        public Float(float lat, float lon, boolean isRadian) {
            this.setLatLon(lat, lon, isRadian);
        }

        public Float(LatLonPoint2D llp) {
            this.setLatLon(llp.getLatitude(), llp.getLongitude(), false);
        }

        public Float(Point2D pt2D) {
            this.setLatLon(pt2D.getY(), pt2D.getX(), false);
        }

        public void setLocation(float x, float y) {
            this.setLatLon(y, x, false);
        }

        @Override
        public void setLocation(double x, double y) {
            this.setLatLon((float)y, (float)x, false);
        }

        public void setLatLon(float lat, float lon) {
            this.setLatLon(lat, lon, false);
        }

        @Override
        public void setLatLon(double lat, double lon) {
            this.setLatLon((float)lat, (float)lon, false);
        }

        @Override
        public void setLatLon(double lat, double lon, boolean isRadians) {
            if (isRadians) {
                this.radLat = (float)lat;
                this.radLon = (float)lon;
                this.lat = (float)(Math.PI / 180 * lat);
                this.lon = (float)(Math.PI / 180 * lon);
            } else {
                this.lat = (float)Double.normLat(lat);
                this.lon = (float)Double.normLon(lon);
                this.radLat = (float)(Math.PI / 180 * lat);
                this.radLon = (float)(Math.PI / 180 * lon);
            }
        }

        public void setLatLon(float lat, float lon, boolean isRadians) {
            if (isRadians) {
                this.radLat = lat;
                this.radLon = lon;
                this.lat = (float)(Math.PI / 180 * (double)lat);
                this.lon = (float)(Math.PI / 180 * (double)lon);
            } else {
                this.lat = (float)Float.normLat(lat);
                this.lon = (float)Float.normLon(lon);
                this.radLat = (float)(Math.PI / 180 * (double)lat);
                this.radLon = (float)(Math.PI / 180 * (double)lon);
            }
        }

        @Override
        public double getX() {
            return this.lon;
        }

        @Override
        public double getY() {
            return this.lat;
        }

        @Override
        public double getLongitude() {
            return this.lon;
        }

        @Override
        public double getLatitude() {
            return this.lat;
        }

        @Override
        public double getRadLon() {
            return this.radLon;
        }

        @Override
        public double getRadLat() {
            return this.radLat;
        }

        public void setLatitude(float lat) {
            this.lat = (float)Float.normLat(lat);
            this.radLat = (float)(Math.PI / 180 * (double)lat);
        }

        @Override
        public void setLatitude(double lat) {
            this.setLatitude((float)lat);
        }

        public void setLongitude(float lon) {
            this.lon = (float)Float.normLon(lon);
            this.radLon = (float)(Math.PI / 180 * (double)lon);
        }

        @Override
        public void setLongitude(double lon) {
            this.setLongitude((float)lon);
        }

        public String toString() {
            return "LatLonPoint2D.Float[lat=" + this.lat + ",lon=" + this.lon + "]";
        }
    }

    public static class Double
    extends LatLonPoint2D {
        private static final long serialVersionUID = -7463055211717523471L;
        protected double lat;
        protected double lon;
        protected transient double radLat;
        protected transient double radLon;

        public Double() {
        }

        public Double(double lat, double lon) {
            this.setLatLon(lat, lon, false);
        }

        public Double(double lat, double lon, boolean isRadian) {
            this.setLatLon(lat, lon, isRadian);
        }

        public Double(LatLonPoint2D llp) {
            this.setLatLon(llp.getLatitude(), llp.getLongitude(), false);
        }

        public Double(Point2D pt2D) {
            this.setLatLon(pt2D.getY(), pt2D.getX(), false);
        }

        @Override
        public void setLocation(double x, double y) {
            this.setLatLon(y, x, false);
        }

        @Override
        public void setLatLon(double lat, double lon) {
            this.setLatLon(lat, lon, false);
        }

        @Override
        public void setLatLon(double lat, double lon, boolean isRadians) {
            if (isRadians) {
                this.radLat = lat;
                this.radLon = lon;
                this.lat = Math.PI / 180 * lat;
                this.lon = Math.PI / 180 * lon;
            } else {
                this.lat = Double.normLat(lat);
                this.lon = Double.normLon(lon);
                this.radLat = Math.PI / 180 * lat;
                this.radLon = Math.PI / 180 * lon;
            }
        }

        @Override
        public double getX() {
            return this.lon;
        }

        @Override
        public double getY() {
            return this.lat;
        }

        @Override
        public double getLatitude() {
            return this.lat;
        }

        @Override
        public double getLongitude() {
            return this.lon;
        }

        @Override
        public double getRadLon() {
            return this.radLon;
        }

        @Override
        public double getRadLat() {
            return this.radLat;
        }

        @Override
        public void setLatitude(double lat) {
            this.lat = Double.normLat(lat);
            this.radLat = Math.PI / 180 * lat;
        }

        @Override
        public void setLongitude(double lon) {
            this.lon = Double.normLon(lon);
            this.radLon = Math.PI / 180 * lon;
        }

        public String toString() {
            return "LatLonPoint2D.Double[lat=" + this.lat + ",lon=" + this.lon + "]";
        }
    }
}

