/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.geom;

import ucar.nc2.dt.ugrid.geom.Point3D;

public class Vector3D {
    private Point3D origin;
    private double u;
    private double v;
    private double w;

    public Vector3D() {
        this.origin = new Point3D.Double();
    }

    public Vector3D(double u, double v, double w) {
        this.u = u;
        this.v = v;
        this.w = w;
    }

    public Vector3D(Point3D origin, double u, double v, double w) {
        this.origin = origin;
        this.u = u;
        this.v = v;
        this.w = w;
    }

    public Point3D getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point3D origin) {
        this.origin = origin;
    }

    public double getU() {
        return this.u;
    }

    public void setU(double u) {
        this.u = u;
    }

    public double getV() {
        return this.v;
    }

    public void setV(double v) {
        this.v = v;
    }

    public double getW() {
        return this.w;
    }

    public void setW(double w) {
        this.w = w;
    }

    public String toString2() {
        return "Vector3D[u,v,w]: [" + this.getU() + "," + this.getV() + "," + this.getW() + "]";
    }

    public double getMagnitude() {
        return Math.sqrt(this.u * this.u + this.v * this.v + this.w * this.w);
    }

    public Point3D getEndPoint() {
        Point3D ret = (Point3D)this.origin.clone();
        ret.moveBy(this.u, this.v, this.w);
        return ret;
    }

    public static Vector3D add(Vector3D v1, Vector3D v2) {
        return new Vector3D(v1.getU() + v2.getU(), v1.getV() + v2.getV(), v1.getW() + v2.getW());
    }

    public static Vector3D sub(Vector3D v1, Vector3D v2) {
        return new Vector3D(v1.getU() - v2.getU(), v1.getV() - v2.getV(), v1.getW() - v2.getW());
    }

    public static Vector3D mult(Vector3D v, double d) {
        return new Vector3D(v.getU() * d, v.getV() * d, v.getW() * d);
    }

    public static Vector3D div(Vector3D v, double d) {
        return new Vector3D(v.getU() / d, v.getV() / d, v.getW() / d);
    }

    public static Vector3D cross(Vector3D v1, Vector3D v2) {
        return new Vector3D(v1.getV() * v2.getW() - v1.getW() * v2.getV(), v1.getW() * v2.getU() - v1.getU() * v2.getW(), v1.getU() * v2.getV() - v1.getV() * v2.getU());
    }

    public Vector3D cross(Vector3D other) {
        return Vector3D.cross(this, other);
    }

    public static double dot(Vector3D v1, Vector3D v2) {
        return v1.getU() * v2.getU() + v1.getV() * v2.getV() + v1.getW() * v2.getW();
    }

    public double dot(Vector3D other) {
        return Vector3D.dot(this, other);
    }
}

