/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.rtree;

import java.util.ArrayList;
import java.util.List;
import ucar.nc2.dt.ugrid.rtree.IntProcedure;

public class IntProcedureEntriesStack
implements IntProcedure {
    private List<Integer> indices = new ArrayList<Integer>();

    @Override
    public boolean execute(int id) {
        return this.indices.add(id);
    }

    public Integer pop() {
        if (this.indices.size() <= 0) {
            return null;
        }
        return this.indices.remove(this.indices.size() - 1);
    }

    public List<Integer> popAll() {
        List result = (List)((ArrayList)this.indices).clone();
        this.clear();
        return result;
    }

    public void push(int value) {
        this.indices.add(value);
    }

    public Integer peek() {
        Integer retval;
        try {
            retval = this.indices.get(this.indices.size() - 1);
        }
        catch (IndexOutOfBoundsException e) {
            retval = null;
        }
        return retval;
    }

    public Integer peek(int index) throws IndexOutOfBoundsException {
        return this.indices.get(index);
    }

    public List<Integer> peekAll() {
        return (List)((ArrayList)this.indices).clone();
    }

    public int size() {
        return this.indices.size();
    }

    public boolean clear() {
        boolean result = true;
        try {
            this.indices.clear();
        }
        catch (UnsupportedOperationException e) {
            result = false;
        }
        return result;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data within this stack includes:\n");
        sb.append("-------------------------------------------------------------\n");
        sb.append("Item Count = " + this.size());
        for (int ctr = 0; ctr < this.indices.size(); ++ctr) {
            sb.append("\n  - Index (" + ctr + "), Value (" + String.valueOf(this.indices.get(ctr)) + ")");
        }
        sb.append("\n-------------------------------------------------------------");
        return sb.toString();
    }
}

