/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.rtree;

import cern.colt.list.AbstractIntList;
import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntObjectHashMap;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dt.ugrid.geom.LatLonPoint2D;
import ucar.nc2.dt.ugrid.geom.LatLonPolygon2D;
import ucar.nc2.dt.ugrid.geom.LatLonRectangle2D;
import ucar.nc2.dt.ugrid.rtree.IntProcedure;
import ucar.nc2.dt.ugrid.rtree.IntProcedureEntriesList;
import ucar.nc2.dt.ugrid.rtree.Node;
import ucar.nc2.dt.ugrid.rtree.SpatialIndex;

public class RTree
implements SpatialIndex,
Serializable {
    private static final long serialVersionUID = 4027952803059081589L;
    private static final String VERSION = "1.0";
    private static final Logger logger = LoggerFactory.getLogger(RTree.class);
    private static final int DEFAULT_MAX_NODE_ENTRIES = 10;
    private static final boolean INTERNAL_CONSISTENCY_CHECKING = false;
    private static final int ENTRY_STATUS_ASSIGNED = 0;
    private static final int ENTRY_STATUS_UNASSIGNED = 1;
    int maxNodeEntries;
    int minNodeEntries;
    private OpenIntObjectHashMap nodeMap = new OpenIntObjectHashMap();
    private byte[] entryStatus = null;
    private byte[] initialEntryStatus = null;
    private Stack<Integer> parents = new Stack();
    private Stack<Integer> parentsEntry = new Stack();
    private int treeHeight = 1;
    private int rootNodeId = 0;
    private int size = 0;
    private int highestUsedNodeId = this.rootNodeId;
    private Stack<Integer> deletedNodeIds = new Stack();
    private IntArrayList nearestIds = new IntArrayList();
    private OpenIntObjectHashMap nearestEntriesMap = new OpenIntObjectHashMap();
    private TIntProcedureVisit visitProc = new TIntProcedureVisit();
    public static long addTime = 0L;
    public static long splitTime = 0L;
    public static long pickSeedsTime = 0L;
    public static long pickNextTime = 0L;
    private LatLonPolygon2D oldRectangle = new LatLonPolygon2D.Double(0.0, 0.0);
    public static long chooseTime = 0L;
    public static long adjustTime = 0L;

    public RTree() {
        Properties props = new Properties();
        props.setProperty("MaxNodeEntries", "12");
        props.setProperty("MinNodeEntries", "6");
        this.init(props);
    }

    public RTree(Properties props) {
        this.init(props);
    }

    @Override
    public void init(Properties props) {
        this.maxNodeEntries = Integer.parseInt(props.getProperty("MaxNodeEntries", "0"));
        this.minNodeEntries = Integer.parseInt(props.getProperty("MinNodeEntries", "0"));
        if (this.maxNodeEntries < 2) {
            this.maxNodeEntries = 10;
        }
        if (this.minNodeEntries < 1 || this.minNodeEntries > this.maxNodeEntries / 2) {
            this.minNodeEntries = this.maxNodeEntries / 2;
        }
        this.entryStatus = new byte[this.maxNodeEntries];
        this.initialEntryStatus = new byte[this.maxNodeEntries];
        for (int i = 0; i < this.maxNodeEntries; ++i) {
            this.initialEntryStatus[i] = 1;
        }
        Node root = new Node(this.rootNodeId, 1, this.maxNodeEntries);
        this.nodeMap.put(this.rootNodeId, (Object)root);
    }

    @Override
    public void add(LatLonPolygon2D r, int id) {
        this.add(r.copy(), id, 1);
        ++this.size;
    }

    private void add(LatLonPolygon2D r, int id, int level) {
        long curTime = System.currentTimeMillis();
        Node leaf = this.chooseNode(r, level);
        Node newLeaf = null;
        if (leaf.entryCount < this.maxNodeEntries) {
            leaf.addEntryNoCopy(r, id);
        } else {
            newLeaf = this.splitNode(leaf, r, id);
        }
        Node newNode = this.adjustTree(leaf, newLeaf);
        if (newNode != null) {
            Node oldRoot = this.getNode(this.rootNodeId);
            this.rootNodeId = this.getNextNodeId();
            ++this.treeHeight;
            Node root = new Node(this.rootNodeId, this.treeHeight, this.maxNodeEntries);
            root.addEntryCopy(newNode.mbr, newNode.nodeId);
            root.addEntryCopy(oldRoot.mbr, oldRoot.nodeId);
            this.nodeMap.put(this.rootNodeId, (Object)root);
        }
        addTime += System.currentTimeMillis() - curTime;
    }

    @Override
    public boolean delete(LatLonPolygon2D r, int id) {
        this.parents.clear();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.clear();
        this.parentsEntry.push(-1);
        Node n = null;
        int foundIndex = -1;
        while (foundIndex == -1 && this.parents.size() > 0) {
            n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                boolean contains = false;
                for (int i = startIndex; i < n.entryCount; ++i) {
                    if (!n.entries[i].getBouningLatLonRectangle2D().contains(r)) continue;
                    this.parents.push(n.ids[i]);
                    this.parentsEntry.pop();
                    this.parentsEntry.push(i);
                    this.parentsEntry.push(-1);
                    contains = true;
                    break;
                }
                if (contains) {
                    continue;
                }
            } else {
                foundIndex = n.findEntry(r, id);
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
        if (foundIndex != -1) {
            n.deleteEntry(foundIndex, this.minNodeEntries);
            this.condenseTree(n);
            --this.size;
        }
        Node root = this.getNode(this.rootNodeId);
        while (root.entryCount == 1 && this.treeHeight > 1) {
            root.entryCount = 0;
            this.rootNodeId = root.ids[0];
            --this.treeHeight;
            root = this.getNode(this.rootNodeId);
        }
        return foundIndex != -1;
    }

    public int nearest(Point2D p, double searchRadius) {
        return this.nearest((LatLonPoint2D)new LatLonPoint2D.Double(p), searchRadius);
    }

    public int nearest(LatLonPoint2D p, double searchRadius) {
        IntProcedureEntriesList ip = new IntProcedureEntriesList();
        this.nearest(p, ip, searchRadius);
        AbstractIntList res = ip.getValues();
        res.trimToSize();
        if (res.isEmpty()) {
            return -1;
        }
        return res.elements()[0];
    }

    public int nearest(Point2D p) {
        return this.nearest(new LatLonPoint2D.Double(p));
    }

    public int nearest(LatLonPoint2D p) {
        IntProcedureEntriesList ip = new IntProcedureEntriesList();
        this.nearest(p, ip);
        AbstractIntList res = ip.getValues();
        res.trimToSize();
        if (res.isEmpty()) {
            return -1;
        }
        return res.elements()[0];
    }

    public void nearest(final LatLonPoint2D p, IntProcedure v, double searchRadius) {
        this.nearestNeighborsExclusive(p, this.getNode(this.rootNodeId), searchRadius);
        if (this.nearestEntriesMap.size() > 1) {
            class FindClosestEntryProc
            implements cern.colt.function.IntProcedure,
            Serializable {
                private static final long serialVersionUID = -3036812482409644397L;
                private double distanceSquared = Double.POSITIVE_INFINITY;
                private int closestIndex = -1;

                FindClosestEntryProc() {
                }

                public boolean apply(int key) {
                    LatLonPoint2D tempPoint = ((LatLonPolygon2D)RTree.this.nearestEntriesMap.get(key)).getCentroid();
                    double tempDist = tempPoint.distanceSq(p);
                    if (tempDist < this.distanceSquared) {
                        this.distanceSquared = tempDist;
                        this.closestIndex = key;
                    }
                    return true;
                }

                public int getClosestIndex() {
                    return this.closestIndex;
                }
            }
            FindClosestEntryProc proc = new FindClosestEntryProc();
            this.nearestEntriesMap.forEachKey((cern.colt.function.IntProcedure)proc);
            this.nearestIds.clear();
            this.nearestIds.add(proc.getClosestIndex());
        }
        this.visitProc.setProcedure(v);
        this.nearestIds.forEach((cern.colt.function.IntProcedure)this.visitProc);
        this.nearestIds.clear();
    }

    public void nearest(LatLonPoint2D p, IntProcedure v) {
        this.nearest(p, v, 0.5);
    }

    public IntArrayList intersects(LatLonPolygon2D r) {
        IntProcedureEntriesList ip = new IntProcedureEntriesList();
        this.intersects(r, ip);
        AbstractIntList res = ip.getValues();
        res.trimToSize();
        if (res.isEmpty()) {
            return new IntArrayList();
        }
        return (IntArrayList)res;
    }

    @Override
    public void intersects(LatLonPolygon2D r, IntProcedure v) {
        Node rootNode = this.getNode(this.rootNodeId);
        this.intersects(r, v, rootNode);
    }

    public IntArrayList contains(LatLonPolygon2D r) {
        IntProcedureEntriesList ip = new IntProcedureEntriesList();
        this.contains(r, ip);
        AbstractIntList res = ip.getValues();
        res.trimToSize();
        if (res.isEmpty()) {
            return new IntArrayList();
        }
        return (IntArrayList)res;
    }

    @Override
    public void contains(LatLonPolygon2D r, IntProcedure v) {
        this.parents.clear();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.clear();
        this.parentsEntry.push(-1);
        while (this.parents.size() > 0) {
            Node n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                boolean intersects = false;
                for (int i = startIndex; i < n.entryCount; ++i) {
                    if (!r.intersects(n.entries[i])) continue;
                    this.parents.push(n.ids[i]);
                    this.parentsEntry.pop();
                    this.parentsEntry.push(i);
                    this.parentsEntry.push(-1);
                    intersects = true;
                    break;
                }
                if (intersects) {
                    continue;
                }
            } else {
                for (int i = 0; i < n.entryCount; ++i) {
                    if (!r.contains(n.entries[i])) continue;
                    v.execute(n.ids[i]);
                }
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public LatLonRectangle2D getBounds() {
        LatLonRectangle2D bounds = null;
        Node n = this.getNode(this.getRootNodeId());
        if (n != null && n.getMBR() != null) {
            bounds = n.getMBR().copy();
        }
        return bounds;
    }

    @Override
    public String getVersion() {
        return "RTree-1.0";
    }

    public int getTreeHeight() {
        return this.treeHeight;
    }

    private int getNextNodeId() {
        int nextNodeId = 0;
        nextNodeId = this.deletedNodeIds.size() > 0 ? this.deletedNodeIds.pop() : ++this.highestUsedNodeId;
        return nextNodeId;
    }

    public Node getNode(int index) {
        return (Node)this.nodeMap.get(index);
    }

    public int getNodeCount() {
        return this.nodeMap.size();
    }

    public int getHighestUsedNodeId() {
        return this.highestUsedNodeId;
    }

    public int getRootNodeId() {
        return this.rootNodeId;
    }

    private Node splitNode(Node n, LatLonPolygon2D newRect, int newId) {
        long curTime = System.currentTimeMillis();
        System.arraycopy(this.initialEntryStatus, 0, this.entryStatus, 0, this.maxNodeEntries);
        Node newNode = new Node(this.getNextNodeId(), n.level, this.maxNodeEntries);
        this.nodeMap.put(newNode.nodeId, (Object)newNode);
        this.pickSeeds(n, newRect, newId, newNode);
        while (n.entryCount + newNode.entryCount < this.maxNodeEntries + 1) {
            if (this.maxNodeEntries + 1 - newNode.entryCount == this.minNodeEntries) {
                for (int i = 0; i < this.maxNodeEntries; ++i) {
                    if (this.entryStatus[i] != 1) continue;
                    this.entryStatus[i] = 0;
                    n.mbr = Node.expandMBR(n.mbr, n.entries[i].getBoundingLatLonValues());
                    ++n.entryCount;
                }
                break;
            }
            if (this.maxNodeEntries + 1 - n.entryCount == this.minNodeEntries) {
                for (int i = 0; i < this.maxNodeEntries; ++i) {
                    if (this.entryStatus[i] != 1) continue;
                    this.entryStatus[i] = 0;
                    newNode.addEntryNoCopy(n.entries[i], n.ids[i]);
                    n.entries[i] = null;
                }
                break;
            }
            this.pickNextAndAssign(n, newNode);
        }
        n.reorganize(this);
        splitTime += System.currentTimeMillis() - curTime;
        return newNode;
    }

    private void pickSeeds(Node n, LatLonPolygon2D newRect, int newId, Node newNode) {
        long curTime = System.currentTimeMillis();
        int NUM_DIMENSIONS = 2;
        double[] maxSeparation = new double[2];
        int[] highestLowIndex = new int[2];
        int[] lowestHighIndex = new int[2];
        double[] newRectLatLons = newRect.getBoundingLatLonValues();
        n.mbr = Node.expandMBR(n.mbr, newRect.getBoundingLatLonValues());
        double[] mbrWidths = new double[]{n.mbr.getHeight(), n.mbr.getWidth()};
        for (int d = 0; d < 2; ++d) {
            int tempHighestLowIndex = -1;
            int tempLowestHighIndex = -1;
            double tempHighestLowValue = newRectLatLons[0 + d];
            double tempLowestHighValue = newRectLatLons[2 + d];
            for (int i = 0; i < n.entryCount; ++i) {
                double[] entryLatLons = n.entries[i].getBoundingLatLonValues();
                double tempLow = entryLatLons[0 + d];
                if (tempLow >= tempHighestLowValue) {
                    tempHighestLowValue = tempLow;
                    tempHighestLowIndex = i;
                } else {
                    double tempHigh = entryLatLons[2 + d];
                    if (tempHigh <= tempLowestHighValue) {
                        tempLowestHighValue = tempHigh;
                        tempLowestHighIndex = i;
                    }
                }
                double separation = Math.abs(tempHighestLowValue - tempLowestHighValue);
                if (!(separation > maxSeparation[d])) continue;
                maxSeparation[d] = separation;
                highestLowIndex[d] = tempHighestLowIndex >= 0 ? tempHighestLowIndex : highestLowIndex[d];
                lowestHighIndex[d] = tempLowestHighIndex >= 0 ? tempLowestHighIndex : lowestHighIndex[d];
            }
        }
        int mostExtremeDim = 0;
        double maxNormalizedSeparation = -1.0;
        for (int ctr = 0; ctr < 2; ++ctr) {
            double tempNormalizedSeparation = maxSeparation[ctr] / mbrWidths[ctr];
            if (!(tempNormalizedSeparation > maxNormalizedSeparation)) continue;
            maxNormalizedSeparation = tempNormalizedSeparation;
            mostExtremeDim = ctr;
        }
        if (highestLowIndex[mostExtremeDim] == -1) {
            newNode.addEntryCopy(newRect, newId);
        } else {
            newNode.addEntryNoCopy(n.entries[highestLowIndex[mostExtremeDim]], n.ids[highestLowIndex[mostExtremeDim]]);
            n.entries[highestLowIndex[mostExtremeDim]] = null;
            n.entries[highestLowIndex[mostExtremeDim]] = newRect;
            n.ids[highestLowIndex[mostExtremeDim]] = newId;
        }
        if (lowestHighIndex[mostExtremeDim] == -1) {
            lowestHighIndex[mostExtremeDim] = highestLowIndex[mostExtremeDim];
        }
        this.entryStatus[lowestHighIndex[mostExtremeDim]] = 0;
        n.entryCount = 1;
        n.mbr = n.entries[lowestHighIndex[mostExtremeDim]].getBouningLatLonRectangle2D();
        pickSeedsTime += System.currentTimeMillis() - curTime;
    }

    private int pickNextAndAssign(Node oldNode, Node newNode) {
        long curTime = System.currentTimeMillis();
        int nextEntry = -1;
        for (int i = 0; i < this.maxNodeEntries; ++i) {
            if (this.entryStatus[i] != 1) continue;
            nextEntry = i;
            break;
        }
        if (-1 == nextEntry) {
            return -1;
        }
        double[] node1Values = oldNode.mbr.getBoundingLatLonValues();
        double[] node2Values = newNode.mbr.getBoundingLatLonValues();
        double node1EnlargeArea = RTree.getEnlargementArea(node1Values, oldNode.entries[nextEntry].getBoundingLatLonValues());
        double node2EnlargeArea = RTree.getEnlargementArea(node2Values, oldNode.entries[nextEntry].getBoundingLatLonValues());
        boolean addEntryToOldNode = false;
        if (node1EnlargeArea < node2EnlargeArea) {
            addEntryToOldNode = true;
        } else if (node2EnlargeArea < node1EnlargeArea) {
            addEntryToOldNode = false;
        } else {
            double node2Area;
            double node1Area = LatLonPolygon2D.Double.calculateLLArrayArea(node1Values);
            if (node1Area < (node2Area = LatLonPolygon2D.Double.calculateLLArrayArea(node2Values))) {
                addEntryToOldNode = true;
            } else if (node2Area < node1Area) {
                addEntryToOldNode = false;
            } else if (oldNode.entryCount < newNode.entryCount) {
                addEntryToOldNode = true;
            }
        }
        this.entryStatus[nextEntry] = 0;
        if (addEntryToOldNode) {
            oldNode.mbr = Node.expandMBR(oldNode.mbr, oldNode.entries[nextEntry].getBoundingLatLonValues());
            ++oldNode.entryCount;
        } else {
            newNode.addEntryNoCopy(oldNode.entries[nextEntry], oldNode.ids[nextEntry]);
            oldNode.entries[nextEntry] = null;
        }
        pickNextTime += System.currentTimeMillis() - curTime;
        return nextEntry;
    }

    @Override
    public void nearestNeighbors(LatLonPoint2D p, IntProcedure v, double searchRadius) {
        Node rootNode = this.getNode(this.rootNodeId);
        this.nearestIds.clear();
        this.nearestNeighbors(p, rootNode, searchRadius * searchRadius);
        this.visitProc.setProcedure(v);
        this.nearestIds.forEach((cern.colt.function.IntProcedure)this.visitProc);
        this.nearestIds.clear();
    }

    private void nearestNeighbors(LatLonPoint2D p, Node n, double searchRadiusSquared) {
        for (int i = 0; i < n.entryCount; ++i) {
            double tempDistance = n.entries[i].distanceSq(p);
            if (!(tempDistance <= searchRadiusSquared)) continue;
            if (n.isLeaf()) {
                this.nearestIds.add(n.ids[i]);
                continue;
            }
            this.nearestNeighbors(p, this.getNode(n.ids[i]), searchRadiusSquared);
        }
    }

    private double nearestNeighborsExclusive(LatLonPoint2D p, Node n, double searchRadius) {
        for (int i = 0; i < n.entryCount; ++i) {
            double tempDistance = n.entries[i].distance(p);
            if (n.isLeaf()) {
                if (tempDistance < searchRadius) {
                    searchRadius = tempDistance;
                    this.nearestEntriesMap.clear();
                    this.nearestIds.clear();
                }
                if (!(tempDistance <= searchRadius)) continue;
                this.nearestEntriesMap.put(n.ids[i], (Object)n.entries[i]);
                this.nearestIds.add(n.ids[i]);
                continue;
            }
            if (!(tempDistance <= searchRadius)) continue;
            searchRadius = this.nearestNeighborsExclusive(p, this.getNode(n.ids[i]), searchRadius);
        }
        return searchRadius;
    }

    private void intersects(LatLonPolygon2D r, IntProcedure v, Node n) {
        for (int i = 0; i < n.entryCount; ++i) {
            if (!r.intersects(n.entries[i])) continue;
            if (n.isLeaf()) {
                v.execute(n.ids[i]);
                continue;
            }
            this.intersects(r, v, this.getNode(n.ids[i]));
        }
    }

    private void condenseTree(Node l) {
        Node n = l;
        Node parent = null;
        int parentEntry = 0;
        Stack<Integer> eliminatedNodeIds = new Stack<Integer>();
        while (n.level != this.treeHeight) {
            parent = this.getNode(this.parents.pop());
            parentEntry = this.parentsEntry.pop();
            if (n.entryCount < this.minNodeEntries) {
                parent.deleteEntry(parentEntry, this.minNodeEntries);
                eliminatedNodeIds.push(n.nodeId);
            } else if (!n.mbr.equals(parent.entries[parentEntry])) {
                this.oldRectangle = parent.entries[parentEntry].copy();
                parent.entries[parentEntry] = new LatLonPolygon2D.Double(n.mbr);
                parent.recalculateMBR(this.oldRectangle);
            }
            n = parent;
        }
        while (eliminatedNodeIds.size() > 0) {
            Node e = this.getNode((Integer)eliminatedNodeIds.pop());
            for (int j = 0; j < e.entryCount; ++j) {
                this.add(e.entries[j], e.ids[j], e.level);
                e.entries[j] = null;
            }
            e.entryCount = 0;
            this.deletedNodeIds.push(e.nodeId);
        }
    }

    private Node chooseNode(LatLonPolygon2D r, int level) {
        long curTime = System.currentTimeMillis();
        Node n = this.getNode(this.rootNodeId);
        this.parents.clear();
        this.parentsEntry.clear();
        while (n.level != level) {
            int index = 0;
            double[] rectBounds = r.getBoundingLatLonValues();
            double leastEnlargement = RTree.getEnlargementArea(n.getEntry(0).getBoundingLatLonValues(), rectBounds);
            LatLonPolygon2D tempPoly = null;
            double tempEnlargement = 0.0;
            for (int i = 1; i < n.entryCount; ++i) {
                tempPoly = n.getEntry(i);
                tempEnlargement = RTree.getEnlargementArea(tempPoly.getBoundingLatLonValues(), rectBounds);
                if (!(tempEnlargement < leastEnlargement) && (tempEnlargement != leastEnlargement || !(tempPoly.getBouningLatLonRectangle2D().getArea() < n.getEntry(index).getBouningLatLonRectangle2D().getArea()))) continue;
                index = i;
                leastEnlargement = tempEnlargement;
            }
            this.parents.push(n.nodeId);
            this.parentsEntry.push(index);
            n = this.getNode(n.ids[index]);
        }
        chooseTime += System.currentTimeMillis() - curTime;
        return n;
    }

    private Node adjustTree(Node n, Node nn) {
        long curtime = System.currentTimeMillis();
        while (n.level != this.treeHeight) {
            Node parent = this.getNode(this.parents.pop());
            int entry = this.parentsEntry.pop();
            if (!parent.entries[entry].getBouningLatLonRectangle2D().equals(n.mbr)) {
                parent.entries[entry] = new LatLonPolygon2D.Double(n.mbr);
                Node.expandMBR(parent.mbr, parent.entries[entry].getBoundingLatLonValues());
            }
            Node newNode = null;
            if (nn != null) {
                if (parent.entryCount < this.maxNodeEntries) {
                    parent.addEntryCopy(nn.mbr, nn.nodeId);
                } else {
                    newNode = this.splitNode(parent, new LatLonPolygon2D.Double(nn.mbr), nn.nodeId);
                }
            }
            n = parent;
            nn = newNode;
        }
        adjustTime += System.currentTimeMillis() - curtime;
        return nn;
    }

    private void checkConsistency(int nodeId, int expectedLevel, LatLonPolygon2D expectedMBR) {
        LatLonRectangle2D calculatedMBR;
        Node n = this.getNode(nodeId);
        if (n == null) {
            logger.error("Error: Could not read node " + nodeId + " of " + this.getNodeCount() + " at level: " + expectedLevel);
        }
        if (n.level != expectedLevel) {
            logger.error("Error: Node " + nodeId + " of " + this.getNodeCount() + ", expected level " + expectedLevel + ", actual level " + n.level);
        }
        if (!n.mbr.equals(calculatedMBR = this.calculateMBR(n))) {
            logger.error("Error: Node: " + nodeId + " of " + this.getNodeCount() + " at level: " + expectedLevel + ", calculated MBR does not equal stored MBR");
        }
        if (expectedMBR != null && !n.mbr.equals(expectedMBR.getBouningLatLonRectangle2D())) {
            logger.error("Error: Node " + nodeId + " of " + this.getNodeCount() + " at level: " + expectedLevel + ", expected MBR (from parent) does not equal stored MBR");
        }
        if (expectedMBR != null && n.mbr == expectedMBR) {
            logger.error("Error: Node " + nodeId + " of " + this.getNodeCount() + " at level: " + expectedLevel + " MBR using same rectangle object as parent's entry");
        }
        for (int i = 0; i < n.entryCount; ++i) {
            if (n.entries[i] == null) {
                logger.error("Error: Node " + nodeId + " of " + this.getNodeCount() + " at level: " + expectedLevel + ", Entry " + i + " is null");
            }
            if (n.level <= 1) continue;
            this.checkConsistency(n.ids[i], n.level - 1, n.entries[i]);
        }
    }

    private LatLonRectangle2D calculateMBR(Node n) {
        LatLonRectangle2D mbr = n.entries[0].getBouningLatLonRectangle2D();
        for (int i = 1; i < n.entryCount; ++i) {
            mbr = Node.expandMBR(mbr, n.entries[i].getBoundingLatLonValues());
        }
        return mbr;
    }

    public static double[] getRectMin(LatLonRectangle2D rect) {
        double[] result = new double[]{rect.getLonMin(), rect.getLatMin()};
        return result;
    }

    public static double[] getRectMax(LatLonRectangle2D rect) {
        double[] result = new double[]{rect.getLonMax(), rect.getLatMax()};
        return result;
    }

    public static double getEnlargementArea(LatLonRectangle2D src, LatLonRectangle2D addition) {
        double result = 0.0;
        if (!src.contains(addition)) {
            LatLonRectangle2D union = src.copy();
            union.extend(addition);
            double srcArea = src.getArea();
            double unionArea = union.getArea();
            result = unionArea - srcArea;
        }
        if (result < 0.0) {
            result = 0.0;
        }
        return result;
    }

    public static double getEnlargementArea(double[] src, double[] addition) {
        return RTree.getEnlargementArea(new LatLonRectangle2D(src[0], src[1], src[2], src[3]), new LatLonRectangle2D(addition[0], addition[1], addition[2], addition[3]));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {entries:" + this.size + ", nodes:" + this.nodeMap.size() + ", tree-height:" + this.treeHeight + ", max-node-entries:" + this.maxNodeEntries + ", min-node-entries:" + this.minNodeEntries + "}";
    }

    public static StringBuilder getNodeMap(RTree rtree, int nodeId) {
        StringBuilder result = new StringBuilder();
        Node n = rtree.getNode(nodeId);
        int numIndents = rtree.getNode(rtree.getRootNodeId()).getLevel() - n.getLevel();
        if (n.getLevel() > 1) {
            result.append(RTree.repeatString("    ", numIndents));
            result.append("Node: ").append(nodeId).append("\n");
            for (int ctr = 0; ctr < n.getEntryCount(); ++ctr) {
                result.append((CharSequence)RTree.getNodeMap(rtree, n.getId(ctr)));
            }
        } else {
            result.append(RTree.repeatString("    ", numIndents));
            result.append("Leaf: ").append(nodeId).append("\n");
            for (int ctr = 0; ctr < n.getEntryCount(); ++ctr) {
                result.append(RTree.repeatString("    ", numIndents + 1));
                result.append("Entry: ").append(n.getId(ctr)).append("\n");
            }
        }
        return result;
    }

    public static void writeFullNodeMap(BufferedWriter writer, RTree rtree, int nodeId) {
        if (writer != null) {
            try {
                Node n = rtree.getNode(nodeId);
                int numIndents = rtree.getNode(rtree.getRootNodeId()).getLevel() - n.getLevel();
                if (n.getLevel() > 1) {
                    writer.write(RTree.repeatString("    ", numIndents));
                    writer.write("Node {" + nodeId + "}: " + String.valueOf(n.getMBR()));
                    writer.newLine();
                    for (int ctr = 0; ctr < n.getEntryCount(); ++ctr) {
                        RTree.writeFullNodeMap(writer, rtree, n.getId(ctr));
                    }
                } else {
                    writer.write(RTree.repeatString("    ", numIndents));
                    writer.write("Leaf {" + nodeId + "}: " + String.valueOf(n.getMBR()));
                    writer.newLine();
                    for (int ctr = 0; ctr < n.getEntryCount(); ++ctr) {
                        writer.write(RTree.repeatString("    ", numIndents + 1));
                        writer.write("Entry {" + n.getId(ctr) + "}: " + String.valueOf(n.getEntry(ctr)));
                        writer.newLine();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String repeatString(String s, int n) {
        StringBuilder result = new StringBuilder();
        for (int ctr = 0; ctr < n; ++ctr) {
            result.append(s);
        }
        return result.toString();
    }

    private static class TIntProcedureVisit
    implements cern.colt.function.IntProcedure,
    Serializable {
        private static final long serialVersionUID = 3278783388762254894L;
        public IntProcedure m_intProcedure = null;

        private TIntProcedureVisit() {
        }

        public void setProcedure(IntProcedure ip) {
            this.m_intProcedure = ip;
        }

        public boolean apply(int index) {
            this.m_intProcedure.execute(index);
            return true;
        }
    }
}

