/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid;

import java.util.ArrayList;
import ucar.nc2.dt.ugrid.Edge;
import ucar.nc2.dt.ugrid.Entity;
import ucar.nc2.dt.ugrid.Face;
import ucar.nc2.dt.ugrid.Node;
import ucar.nc2.dt.ugrid.geom.LatLonPolygon2D;

public class Cell {
    private LatLonPolygon2D polygon;
    private ArrayList<Entity> entities = new ArrayList(3);
    private ArrayList<Node> nodes;
    private ArrayList<Edge> edges;
    private ArrayList<Face> faces;
    private int connectivity_index;

    private void setEntities(Entity e) {
        if (!this.entities.contains(e)) {
            this.entities.add(e);
        }
    }

    private void setEntities(ArrayList<? extends Entity> ets) {
        for (Entity entity : ets) {
            this.setEntities(entity);
        }
    }

    public ArrayList<Entity> getEntities() {
        return this.entities;
    }

    public int[] getEntityIndexes() {
        int[] r = new int[this.entities.size()];
        for (int i = 0; i < this.entities.size(); ++i) {
            r[i] = this.entities.get(i).getDataIndex();
        }
        return r;
    }

    public LatLonPolygon2D getPolygon() {
        return this.polygon;
    }

    public void setPolygon(LatLonPolygon2D poly) {
        this.polygon = poly;
    }

    public void setPolygon() {
        this.polygon = new LatLonPolygon2D.Double();
        for (Node n : this.getNodes()) {
            this.polygon.lineTo(n.getGeoPoint());
        }
    }

    public boolean hasNodes() {
        return this.nodes != null;
    }

    public ArrayList<Node> getNodes() {
        return this.nodes;
    }

    public int[] getNodeIndexes() {
        int[] r = new int[this.nodes.size()];
        for (int i = 0; i < this.nodes.size(); ++i) {
            r[i] = this.nodes.get(i).getDataIndex();
        }
        return r;
    }

    public void setNodes(ArrayList<Node> nodes) {
        this.nodes = nodes;
        this.setPolygon();
        this.setEntities(nodes);
    }

    public boolean hasEdges() {
        return this.edges != null;
    }

    public ArrayList<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(ArrayList<Edge> edges) {
        this.edges = edges;
        this.setEntities(edges);
    }

    public boolean hasFaces() {
        return this.faces != null;
    }

    public ArrayList<Face> getFaces() {
        return this.faces;
    }

    public void setFaces(ArrayList<Face> faces) {
        this.faces = faces;
        this.setEntities(faces);
    }

    public void setConnectivityIndex(int connectivity_index) {
        this.connectivity_index = connectivity_index;
    }
}

