/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import ucar.nc2.dt.ugrid.geom.Polygon2D;

@Deprecated
public abstract class GeoRectangle
implements Shape,
Serializable {
    private static final long serialVersionUID = -3499332575290254914L;
    protected Polygon2D polygon;

    public abstract void add(Polygon2D var1);

    public abstract void add(GeoRectangle var1);

    public abstract boolean equals(Object var1);

    public abstract Point2D getLowerLeft();

    public abstract Point2D getUpperRight();

    public abstract double getMinX();

    public abstract double getMinY();

    public abstract double getMaxX();

    public abstract double getMaxY();

    public double[] getXCoords() {
        return this.polygon.getXCoords();
    }

    public double[] getYCoords() {
        return this.polygon.getYCoords();
    }

    public double getHeight() {
        return this.getMaxY() - this.getMinY();
    }

    public double getWidth() {
        return this.getMaxX() - this.getMinX();
    }

    public double getArea() {
        return this.getWidth() * this.getHeight();
    }

    public Point2D getCentroid() {
        return this.polygon.getCentroid();
    }

    @Override
    public boolean contains(Point2D p) {
        if (this.isEmpty()) {
            return false;
        }
        return this.polygon.contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        if (this.isEmpty()) {
            return false;
        }
        return this.polygon.contains(r);
    }

    public boolean contains(GeoRectangle r) {
        if (this.isEmpty()) {
            return false;
        }
        return r.getMinX() >= this.getMinX() && r.getMinY() >= this.getMinY() && r.getMaxX() <= this.getMaxX() && r.getMaxY() <= this.getMaxY();
    }

    public boolean contains(Polygon2D p) {
        return this.contains(p.getBoundsGeo());
    }

    @Override
    public boolean contains(double x, double y) {
        return this.polygon.contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public abstract GeoRectangle copy();

    public abstract Polygon2D getBackingPolygon();

    @Override
    public Rectangle getBounds() {
        return null;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return null;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return null;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return null;
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return false;
    }

    public boolean intersects(GeoRectangle r) {
        if (this.isEmpty()) {
            return false;
        }
        return r.getMaxX() > this.getMinX() && r.getMaxY() > this.getMinY() && r.getMinX() < this.getMaxX() && r.getMinY() < this.getMaxY();
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return false;
    }

    public boolean isEmpty() {
        return this.polygon.getBounds2D().isEmpty();
    }

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public void setRect(Point2D corner1, Point2D corner2) {
        this.setRect(corner1.getX(), corner1.getY(), corner2.getX(), corner2.getY());
    }

    public void setRect(GeoRectangle rect) {
        this.setRect(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY());
    }

    public String toString() {
        return super.toString();
    }

    public static void union(GeoRectangle src1, GeoRectangle src2, GeoRectangle dest) {
        dest.setRect(src1);
        dest.add(src2);
    }

    public static class Double
    extends GeoRectangle {
        public Double() {
            this(0.0, 0.0, 0.0, 0.0);
        }

        public Double(double x, double y) {
            this(x, y, x, y);
        }

        public Double(Point2D loc) {
            this(loc.getX(), loc.getY(), loc.getX(), loc.getY());
        }

        public Double(Point2D corner1, Point2D corner2) {
            this(corner1.getX(), corner1.getY(), corner2.getX(), corner2.getY());
        }

        public Double(double[] xVals, double[] yVals) {
            this(xVals[0], yVals[0], xVals[1], yVals[1]);
        }

        public Double(double xCorner1, double yCorner1, double xCorner2, double yCorner2) {
            this.polygon = new Polygon2D.Double(4);
            this.setRect(xCorner1, yCorner1, xCorner2, yCorner2);
        }

        @Override
        public void add(Polygon2D polygon) {
            if (polygon.getVertexCount() <= 0) {
                return;
            }
            double xMin = Math.min(this.getMinX(), polygon.getMinX());
            double xMax = Math.max(this.getMaxX(), polygon.getMaxX());
            double yMin = Math.min(this.getMinY(), polygon.getMinY());
            double yMax = Math.max(this.getMaxY(), polygon.getMaxY());
            this.setRect(xMin, yMin, xMax, yMax);
        }

        @Override
        public void add(GeoRectangle r) {
            this.add(r.getBackingPolygon());
        }

        @Override
        public Double copy() {
            return new Double(this.getLowerLeft(), this.getUpperRight());
        }

        @Override
        public void setRect(double xCorner1, double yCorner1, double xCorner2, double yCorner2) {
            if (null == this.polygon) {
                throw new IllegalStateException("The backing polygon of this rectangle has not been initialized");
            }
            this.polygon.reset();
            this.polygon.moveTo(xCorner1, yCorner1);
            this.polygon.lineTo(xCorner1, yCorner2);
            this.polygon.lineTo(xCorner2, yCorner2);
            this.polygon.lineTo(xCorner2, yCorner1);
            this.polygon.closePath();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof GeoRectangle) {
                GeoRectangle rect = (GeoRectangle)obj;
                return this.getMinX() == rect.getMinX() && this.getMinY() == rect.getMinY() && this.getMaxX() == rect.getMaxX() && this.getMaxY() == rect.getMaxY();
            }
            return false;
        }

        @Override
        public Polygon2D.Double getBackingPolygon() {
            return ((Polygon2D.Double)this.polygon).copy();
        }

        @Override
        public Point2D getLowerLeft() {
            return new Point2D.Double(this.getMinX(), this.getMinY());
        }

        @Override
        public Point2D getUpperRight() {
            return new Point2D.Double(this.getMaxX(), this.getMaxY());
        }

        @Override
        public double getMinX() {
            double min = java.lang.Double.POSITIVE_INFINITY;
            for (int ctr = 0; ctr < this.polygon.getVertexCount(); ++ctr) {
                min = Math.min(min, this.polygon.getX(ctr));
            }
            return min;
        }

        @Override
        public double getMinY() {
            double min = java.lang.Double.POSITIVE_INFINITY;
            for (int ctr = 0; ctr < this.polygon.getVertexCount(); ++ctr) {
                min = Math.min(min, this.polygon.getY(ctr));
            }
            return min;
        }

        @Override
        public double getMaxX() {
            double max = java.lang.Double.NEGATIVE_INFINITY;
            for (int ctr = 0; ctr < this.polygon.getVertexCount(); ++ctr) {
                max = Math.max(max, this.polygon.getX(ctr));
            }
            return max;
        }

        @Override
        public double getMaxY() {
            double max = java.lang.Double.NEGATIVE_INFINITY;
            for (int ctr = 0; ctr < this.polygon.getVertexCount(); ++ctr) {
                max = Math.max(max, this.polygon.getY(ctr));
            }
            return max;
        }
    }
}

