/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.geom;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ucar.nc2.dt.ugrid.geom.LatLonPoint2D;
import ucar.nc2.dt.ugrid.geom.LatLonRectangle2D;
import ucar.nc2.dt.ugrid.geom.Polygon2D;

public abstract class LatLonPolygon2D
implements Serializable {
    private static final long serialVersionUID = -832292217494381300L;
    protected boolean crossesDateline = false;

    public void lineTo(LatLonPoint2D point) {
        this.lineTo(point.getLatitude(), point.getLongitude());
    }

    public void lineTo(Point2D point) {
        this.lineTo(point.getY(), point.getX());
    }

    public abstract double getArea();

    public abstract void lineTo(double var1, double var3);

    public abstract LatLonPoint2D getCentroid();

    public boolean contains(LatLonPoint2D point) {
        return this.contains(point.getLatitude(), point.getLongitude());
    }

    public abstract boolean contains(double var1, double var3);

    public boolean contains(LatLonRectangle2D rect) {
        return this.contains(rect.getUpperLeftPoint()) && this.contains(rect.getUpperRightPoint()) && this.contains(rect.getLowerRightPoint()) && rect.contains(rect.getLowerLeftPoint());
    }

    public boolean contains(LatLonPolygon2D poly) {
        for (LatLonPoint2D p : poly.getVertices()) {
            if (this.contains(p.getLatitude(), p.getLongitude())) continue;
            return false;
        }
        return true;
    }

    public abstract boolean intersects(LatLonPolygon2D var1);

    public boolean intersects(LatLonPoint2D point) {
        return this.intersects(point, this.crossesDateline());
    }

    public abstract boolean intersects(LatLonPoint2D var1, boolean var2);

    public abstract boolean intersects(LatLonPoint2D var1, LatLonPoint2D var2, boolean var3);

    public abstract double distanceSq(LatLonPoint2D var1);

    public double distance(LatLonPoint2D p) {
        return Math.sqrt(this.distanceSq(p));
    }

    public abstract List<LatLonPoint2D> getVertices();

    public abstract int getVertexCount();

    public abstract double[] getLonCoords();

    public abstract double[] getLatCoords();

    public abstract LatLonRectangle2D getBouningLatLonRectangle2D();

    public abstract double[] getBoundingLatLonValues();

    public boolean crossesDateline() {
        return this.crossesDateline;
    }

    public LatLonPolygon2D copy() {
        return new Double(this.getVertices());
    }

    public String toString() {
        StringBuilder out = new StringBuilder(this.getClass().getName() + "[\n");
        List<LatLonPoint2D> pts = this.getVertices();
        for (LatLonPoint2D p : pts) {
            out.append("\t");
            out.append(p);
            out.append("\n");
        }
        out.append("]");
        return out.toString();
    }

    public static double calculateLLArrayArea(double[] latLonValues) {
        double height = latLonValues[2] - latLonValues[0];
        double width = latLonValues[3] - latLonValues[1];
        if (latLonValues[3] < latLonValues[1]) {
            width = LatLonPoint2D.normLon360(width);
        }
        return width * height;
    }

    public static boolean linesIntersect(double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double p3x, double p3y) {
        boolean result = false;
        double a1 = (p0x * p2y - p0x * p3y - p2x * p0y + p2x * p3y + p3x * p0y - p3x * p2y) / (p1x * p2y - p1x * p3y - p2x * p1y + p2x * p3y + p3x * p1y - p3x * p2y);
        double a2 = (p1x * p0y - p1x * p3y - p0x * p1y + p0x * p3y + p3x * p1y - p3x * p0y) / (p1x * p2y - p1x * p3y - p2x * p1y + p2x * p3y + p3x * p1y - p3x * p2y);
        if (a1 <= 0.0 && a2 >= 0.0 && a1 + a2 <= 1.0) {
            result = true;
        }
        return result;
    }

    public static boolean lineIntersectsPoint(double e0x, double e0y, double e1x, double e1y, double p1x, double p1y) {
        if ((e1x - e0x) / (p1x - e0x) * (p1y - e0y) + e0y == e1y) {
            if (p1x > e0x && p1x > e1x) {
                return false;
            }
            if (p1x < e0x && p1x < e1x) {
                return false;
            }
            if (p1y > e0y && p1y > e1y) {
                return false;
            }
            return !(p1y < e0y) || !(p1y < e1y);
        }
        return false;
    }

    public static class Double
    extends LatLonPolygon2D {
        List<LatLonPoint2D> vertices = new ArrayList<LatLonPoint2D>();
        private LatLonPoint2D last = null;
        public double westLon = 0.0;
        public double eastLon = 0.0;
        public double northLat = 0.0;
        public double southLat = 0.0;

        public Double() {
        }

        public Double(LatLonPoint2D point) {
            this();
            this.northLat = point.getY();
            this.southLat = point.getY();
            this.westLon = point.getX();
            this.eastLon = point.getX();
            this.last = point;
            this.vertices.add(point);
        }

        public Double(double lat, double lon) {
            this();
            this.northLat = lat;
            this.southLat = lat;
            this.westLon = lon;
            this.eastLon = lon;
            this.last = new LatLonPoint2D.Double(lat, lon);
            this.vertices.add(new LatLonPoint2D.Double(lat, lon));
        }

        public Double(List<LatLonPoint2D> vertices) {
            this();
            for (LatLonPoint2D p : vertices) {
                this.lineTo(p);
            }
        }

        public Double(LatLonPoint2D[] vertices) {
            this(Arrays.asList(vertices));
        }

        public Double(double[] lats, double[] lons) {
            this();
            if (lats.length != lons.length) {
                return;
            }
            for (int i = 0; i < lats.length; ++i) {
                this.lineTo(lats[i], lons[i]);
            }
        }

        public Double(LatLonRectangle2D rect) {
            this();
            LatLonPoint2D lowerLeft = rect.getLowerLeftPoint();
            LatLonPoint2D upperRight = rect.getUpperRightPoint();
            this.westLon = lowerLeft.getLongitude();
            this.eastLon = upperRight.getLongitude();
            this.southLat = lowerLeft.getLatitude();
            this.northLat = upperRight.getLatitude();
            this.vertices.add(lowerLeft);
            this.vertices.add(rect.getLowerRightPoint());
            this.vertices.add(upperRight);
            this.vertices.add(rect.getUpperLeftPoint());
            this.last = rect.getUpperLeftPoint();
            this.crossesDateline = rect.crossesDateline();
        }

        public Double(Polygon2D poly) {
            this();
            for (Point2D p : poly.getVertices()) {
                this.lineTo(p.getY(), p.getX());
            }
        }

        @Override
        public double getArea() {
            if (this.getVertexCount() < 3) {
                return 0.0;
            }
            double result = 0.0;
            int lastNodeIndex = this.getVertexCount() - 1;
            if (this.crossesDateline) {
                double yx;
                double xy;
                for (int i = 0; i < lastNodeIndex; ++i) {
                    xy = LatLonPoint2D.normLon360(this.vertices.get(i).getLongitude()) * this.vertices.get(i + 1).getLatitude();
                    yx = this.vertices.get(i).getLatitude() * LatLonPoint2D.normLon360(this.vertices.get(i + 1).getLongitude());
                    result += xy - yx;
                }
                xy = LatLonPoint2D.normLon360(this.vertices.get(lastNodeIndex).getLongitude()) * this.vertices.get(0).getLatitude();
                yx = this.vertices.get(lastNodeIndex).getLatitude() * LatLonPoint2D.normLon360(this.vertices.get(0).getLongitude());
                result += xy - yx;
            } else {
                double yx;
                double xy;
                for (int i = 0; i < lastNodeIndex; ++i) {
                    xy = this.vertices.get(i).getLongitude() * this.vertices.get(i + 1).getLatitude();
                    yx = this.vertices.get(i).getLatitude() * this.vertices.get(i + 1).getLongitude();
                    result += xy - yx;
                }
                xy = this.vertices.get(lastNodeIndex).getLongitude() * this.vertices.get(0).getLatitude();
                yx = this.vertices.get(lastNodeIndex).getLatitude() * this.vertices.get(0).getLongitude();
                result += xy - yx;
            }
            return Math.abs(result * 0.5);
        }

        @Override
        public void lineTo(double lat, double lon) {
            if (java.lang.Double.isNaN(lat) || java.lang.Double.isNaN(lon)) {
                return;
            }
            LatLonPoint2D.Double n = new LatLonPoint2D.Double(lat, lon);
            this.lineTo(n);
        }

        @Override
        public void lineTo(LatLonPoint2D point) {
            if (this.vertices.isEmpty()) {
                this.northLat = point.getY();
                this.southLat = point.getY();
                this.westLon = point.getX();
                this.eastLon = point.getX();
                this.last = point;
                this.vertices.add(point);
                return;
            }
            if (!this.last.equals(point)) {
                double lon = point.getLongitude();
                double llon = this.last.getLongitude();
                if (llon > 90.0 & lon < 0.0 || llon < -90.0 & lon > 0.0 || lon > 90.0 & llon < 0.0 || lon < -90.0 & llon > 0.0) {
                    this.crossesDateline = true;
                }
                if (this.crossesDateline) {
                    double normPointX = LatLonPoint2D.normLon360(point.getX());
                    this.westLon = LatLonPoint2D.normLon(Math.min(LatLonPoint2D.normLon360(this.westLon), normPointX));
                    this.eastLon = LatLonPoint2D.normLon(Math.max(LatLonPoint2D.normLon360(this.eastLon), normPointX));
                } else {
                    this.westLon = Math.min(this.westLon, point.getX());
                    this.eastLon = Math.max(this.eastLon, point.getX());
                }
                this.northLat = Math.max(this.northLat, point.getY());
                this.southLat = Math.min(this.southLat, point.getY());
                this.last = point;
                this.vertices.add(point);
            }
        }

        @Override
        public List<LatLonPoint2D> getVertices() {
            return this.vertices;
        }

        @Override
        public int getVertexCount() {
            return this.vertices.size();
        }

        @Override
        public double[] getLonCoords() {
            double[] ret = new double[this.vertices.size()];
            int i = 0;
            for (LatLonPoint2D p : this.vertices) {
                ret[i++] = p.getLongitude();
            }
            return ret;
        }

        @Override
        public double[] getLatCoords() {
            double[] ret = new double[this.vertices.size()];
            int i = 0;
            for (LatLonPoint2D p : this.vertices) {
                ret[i++] = p.getLatitude();
            }
            return ret;
        }

        @Override
        public LatLonPoint2D getCentroid() {
            double px = 0.0;
            double py = 0.0;
            if (this.crossesDateline) {
                for (LatLonPoint2D v : this.vertices) {
                    px += LatLonPoint2D.normLon360(v.getLongitude());
                    py += v.getLatitude();
                }
                px /= (double)this.vertices.size();
                py /= (double)this.vertices.size();
                px = LatLonPoint2D.normLon(px);
            } else {
                for (LatLonPoint2D v : this.vertices) {
                    px += v.getLongitude();
                    py += v.getLatitude();
                }
                px /= (double)this.vertices.size();
                py /= (double)this.vertices.size();
            }
            return new LatLonPoint2D.Double(py, px);
        }

        @Override
        public boolean contains(double lat, double lon) {
            double y2;
            double y1;
            double x2;
            int crossings = 0;
            int count = this.vertices.size();
            if (count < 3) {
                return false;
            }
            double[] xs = new double[count];
            double[] ys = new double[count];
            int c = 0;
            if (this.crossesDateline) {
                lon = LatLonPoint2D.normLon360(lon);
                for (LatLonPoint2D v : this.vertices) {
                    xs[c] = LatLonPoint2D.normLon360(v.getLongitude());
                    ys[c] = v.getLatitude();
                    ++c;
                }
            } else {
                for (LatLonPoint2D v : this.vertices) {
                    xs[c] = v.getLongitude();
                    ys[c] = v.getLatitude();
                    ++c;
                }
            }
            for (int i = 1; i < count; ++i) {
                double x1 = xs[i - 1];
                x2 = xs[i];
                y1 = ys[i - 1];
                y2 = ys[i];
                if (!(lon < x1) && !(lon < x2)) continue;
                if (lat == y2) {
                    ++crossings;
                    continue;
                }
                if (lat == y1 || !Line2D.linesIntersect(lon, lat, Math.max(x1, x2), lat, x1, y1, x2, y2)) continue;
                ++crossings;
            }
            double x1 = xs[count - 1];
            x2 = xs[0];
            y1 = ys[count - 1];
            y2 = ys[0];
            if ((lon < x1 || lon < x2) && Line2D.linesIntersect(lon, lat, Math.max(x1, x2), lat, x1, y1, x2, y2) && lat != y1) {
                ++crossings;
            }
            return crossings % 2 == 1;
        }

        @Override
        public double[] getBoundingLatLonValues() {
            return new double[]{this.southLat, this.westLon, this.northLat, this.eastLon};
        }

        @Override
        public LatLonRectangle2D getBouningLatLonRectangle2D() {
            double[] v = this.getBoundingLatLonValues();
            return new LatLonRectangle2D(v[0], v[1], v[2], v[3]);
        }

        @Override
        public boolean intersects(LatLonPolygon2D poly) {
            if (this.equals(poly)) {
                return true;
            }
            boolean dateline = this.crossesDateline() || poly.crossesDateline();
            int countPoly1 = this.getVertexCount();
            int countPoly2 = poly.getVertexCount();
            if (countPoly1 == 0 || countPoly2 == 0) {
                return false;
            }
            List<LatLonPoint2D> v1 = this.getVertices();
            List<LatLonPoint2D> v2 = poly.getVertices();
            if (countPoly1 == 1) {
                return poly.intersects(v1.get(0), dateline);
            }
            if (countPoly2 == 1) {
                return this.intersects(v2.get(0), dateline);
            }
            LatLonRectangle2D b1 = this.getBouningLatLonRectangle2D();
            LatLonRectangle2D b2 = poly.getBouningLatLonRectangle2D();
            LatLonPoint2D c1 = b1.getCentroid();
            LatLonPoint2D c2 = b2.getCentroid();
            double r1 = c1.distance(b1.getLonMin(), b1.getLatMin());
            double r2 = c2.distance(b2.getLonMin(), b2.getLatMin());
            if (this.contains(c2)) {
                return true;
            }
            if (poly.contains(c1)) {
                return true;
            }
            for (int i = 1; i < countPoly2; ++i) {
                if (!this.intersects(v2.get(i - 1), v2.get(i), dateline)) continue;
                return true;
            }
            return countPoly2 > 2 && this.intersects(v2.get(countPoly2 - 1), v2.get(0), dateline);
        }

        @Override
        public boolean intersects(LatLonPoint2D point, boolean crossesDateline) {
            double vlon1;
            double vlon0;
            if (this.contains(point)) {
                return true;
            }
            int count = this.getVertexCount();
            double px = crossesDateline ? LatLonPoint2D.normLon360(point.getLongitude()) : point.getLongitude();
            double py = point.getLatitude();
            for (int i = 1; i < count; ++i) {
                vlon0 = crossesDateline ? LatLonPoint2D.normLon360(this.vertices.get(i - 1).getLongitude()) : this.vertices.get(i - 1).getLongitude();
                double d = vlon1 = crossesDateline ? LatLonPoint2D.normLon360(this.vertices.get(i).getLongitude()) : this.vertices.get(i).getLongitude();
                if (!Double.lineIntersectsPoint(vlon0, this.vertices.get(i - 1).getLatitude(), vlon1, this.vertices.get(i).getLatitude(), px, py)) continue;
                return true;
            }
            if (count > 2) {
                vlon0 = crossesDateline ? LatLonPoint2D.normLon360(this.vertices.get(count - 1).getLongitude()) : this.vertices.get(count - 1).getLongitude();
                double d = vlon1 = crossesDateline ? LatLonPoint2D.normLon360(this.vertices.get(0).getLongitude()) : this.vertices.get(0).getLongitude();
                if (Double.lineIntersectsPoint(vlon0, this.vertices.get(count - 1).getLatitude(), vlon1, this.vertices.get(0).getLatitude(), px, py)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean intersects(LatLonPoint2D e0, LatLonPoint2D e1, boolean crossesDateline) {
            double p3y;
            double p3x;
            double p2y;
            double p2x;
            int count = this.getVertexCount();
            if (count == 0) {
                return false;
            }
            if (count == 1) {
                if (crossesDateline) {
                    return Double.lineIntersectsPoint(LatLonPoint2D.normLon360(e0.getX()), e0.getY(), LatLonPoint2D.normLon360(e1.getX()), e1.getY(), LatLonPoint2D.normLon360(this.vertices.get(0).getLongitude()), this.vertices.get(0).getLatitude());
                }
                return Double.lineIntersectsPoint(e0.getX(), e0.getY(), e1.getX(), e1.getY(), this.vertices.get(0).getLongitude(), this.vertices.get(0).getLatitude());
            }
            double p0x = crossesDateline ? LatLonPoint2D.normLon360(e0.getLongitude()) : e0.getLongitude();
            double p0y = e0.getY();
            double p1x = crossesDateline ? LatLonPoint2D.normLon360(e1.getLongitude()) : e1.getLongitude();
            double p1y = e1.getY();
            for (int i = 1; i < count; ++i) {
                p2x = crossesDateline ? LatLonPoint2D.normLon360(this.vertices.get(i - 1).getLongitude()) : this.vertices.get(i - 1).getLongitude();
                if (!Line2D.linesIntersect(p0x, p0y, p1x, p1y, p2x, p2y = this.vertices.get(i - 1).getLatitude(), p3x = crossesDateline ? LatLonPoint2D.normLon360(this.vertices.get(i).getLongitude()) : this.vertices.get(i).getLongitude(), p3y = this.vertices.get(i).getLatitude())) continue;
                return true;
            }
            return count > 2 && Line2D.linesIntersect(p0x, p0y, p1x, p1y, p2x = crossesDateline ? LatLonPoint2D.normLon360(this.vertices.get(0).getLongitude()) : this.vertices.get(0).getLongitude(), p2y = this.vertices.get(0).getLatitude(), p3x = crossesDateline ? LatLonPoint2D.normLon360(this.vertices.get(count - 1).getLongitude()) : this.vertices.get(count - 1).getLongitude(), p3y = this.vertices.get(count - 1).getLatitude());
        }

        @Override
        public double distanceSq(LatLonPoint2D p) {
            double resultSq = java.lang.Double.POSITIVE_INFINITY;
            double tempDistSq = 0.0;
            if (this.getVertexCount() <= 0) {
                throw new IllegalStateException("No vertices set");
            }
            if (this.getVertexCount() == 1) {
                resultSq = p.distanceSq(this.vertices.get(0).getLongitude(), this.vertices.get(0).getLatitude());
            } else {
                double v1y;
                double v1x;
                double v0y;
                double v0x;
                if (this.contains(p)) {
                    return 0.0;
                }
                int count = this.getVertexCount();
                double px = this.crossesDateline ? LatLonPoint2D.normLon360(p.getLongitude()) : p.getLongitude();
                double py = p.getLatitude();
                for (int i = 0; i < count - 1; ++i) {
                    v0x = this.crossesDateline ? LatLonPoint2D.normLon360(this.vertices.get(i).getLongitude()) : this.vertices.get(i).getLongitude();
                    v0y = this.vertices.get(i).getLatitude();
                    v1x = this.crossesDateline ? LatLonPoint2D.normLon360(this.vertices.get(i + 1).getLongitude()) : this.vertices.get(i + 1).getLongitude();
                    v1y = this.vertices.get(i + 1).getLatitude();
                    tempDistSq = Line2D.ptSegDistSq(v0x, v0y, v1x, v1y, px, py);
                    tempDistSq = Math.min(tempDistSq, resultSq);
                }
                v0x = this.crossesDateline ? LatLonPoint2D.normLon360(this.vertices.get(0).getLongitude()) : this.vertices.get(0).getLongitude();
                v0y = this.vertices.get(0).getLatitude();
                v1x = this.crossesDateline ? LatLonPoint2D.normLon360(this.vertices.get(count - 1).getLongitude()) : this.vertices.get(count - 1).getLongitude();
                v1y = this.vertices.get(count - 1).getLatitude();
                tempDistSq = Line2D.ptSegDistSq(v0x, v0y, v1x, v1y, px, py);
                resultSq = Math.min(tempDistSq, resultSq);
            }
            return resultSq;
        }
    }
}

