/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.geom;

import cern.colt.list.DoubleArrayList;
import cern.colt.list.FloatArrayList;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ucar.nc2.dt.ugrid.geom.GeoRectangle;
import ucar.nc2.dt.ugrid.geom.PolygonIterator;
import ucar.nc2.dt.ugrid.utils.AsaArrayUtils;

public abstract class Polygon2D
implements Shape,
Serializable {
    private static final long serialVersionUID = 6512233111784242139L;
    protected int _coordCount = 0;
    protected boolean _closed = false;

    public static double area(Polygon2D poly) {
        double yx;
        double xy;
        if (poly.getVertexCount() < 3) {
            return 0.0;
        }
        double result = 0.0;
        int lastNodeIndex = poly.getVertexCount() - 1;
        for (int i = 0; i < lastNodeIndex; ++i) {
            xy = poly.getX(i) * poly.getY(i + 1);
            yx = poly.getY(i) * poly.getX(i + 1);
            result += xy - yx;
        }
        xy = poly.getX(lastNodeIndex) * poly.getY(0);
        yx = poly.getY(lastNodeIndex) * poly.getX(0);
        return Math.abs((result += xy - yx) * 0.5);
    }

    public static boolean linesIntersect(double p0x, double p0y, double p1x, double p1y, double p2x, double p2y, double p3x, double p3y) {
        boolean result = false;
        double a1 = (p0x * p2y - p0x * p3y - p2x * p0y + p2x * p3y + p3x * p0y - p3x * p2y) / (p1x * p2y - p1x * p3y - p2x * p1y + p2x * p3y + p3x * p1y - p3x * p2y);
        double a2 = (p1x * p0y - p1x * p3y - p0x * p1y + p0x * p3y + p3x * p1y - p3x * p0y) / (p1x * p2y - p1x * p3y - p2x * p1y + p2x * p3y + p3x * p1y - p3x * p2y);
        if (a1 <= 0.0 && a2 >= 0.0 && a1 + a2 <= 1.0) {
            result = true;
        }
        return result;
    }

    public static boolean lineIntersectsPoint(double e0x, double e0y, double e1x, double e1y, double p1x, double p1y) {
        if ((e1x - e0x) / (p1x - e0x) * (p1y - e0y) + e0y == e1y) {
            if (p1x > e0x && p1x > e1x) {
                return false;
            }
            if (p1x < e0x && p1x < e1x) {
                return false;
            }
            if (p1y > e0y && p1y > e1y) {
                return false;
            }
            return !(p1y < e0y) || !(p1y < e1y);
        }
        return false;
    }

    public void closePath() {
        if (this.getX(this.getVertexCount() - 1) == this.getX(0) && this.getY(this.getVertexCount() - 1) == this.getY(0)) {
            this._coordCount -= 2;
        }
        this._closed = true;
    }

    @Override
    public boolean contains(double x, double y) {
        double y2;
        double y1;
        double x2;
        double x1;
        int crossings = 0;
        int count = this.getVertexCount();
        if (count < 3) {
            return false;
        }
        for (int i = 1; i < count; ++i) {
            x1 = this.getX(i - 1);
            x2 = this.getX(i);
            y1 = this.getY(i - 1);
            y2 = this.getY(i);
            if (!(x < x1) && !(x < x2)) continue;
            if (y == y2) {
                ++crossings;
                continue;
            }
            if (y == y1 || !Line2D.linesIntersect(x, y, Math.max(x1, x2), y, x1, y1, x2, y2)) continue;
            ++crossings;
        }
        x1 = this.getX(count - 1);
        x2 = this.getX(0);
        y1 = this.getY(count - 1);
        y2 = this.getY(0);
        if ((x < x1 || x < x2) && Line2D.linesIntersect(x, y, Math.max(x1, x2), y, x1, y1, x2, y2) && y != y1) {
            ++crossings;
        }
        return crossings % 2 == 1;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(GeoRectangle r) {
        double x1 = r.getMinX();
        double x2 = r.getMaxX();
        double y1 = r.getMinY();
        double y2 = r.getMaxY();
        return this.contains(x1, y1) && this.contains(x1, y2) && this.contains(x2, y1) && this.contains(x2, y2);
    }

    public boolean contains(Polygon2D p) {
        boolean result = true;
        for (int ctr = 0; ctr < p.getVertexCount(); ++ctr) {
            if (this.contains(p.getX(ctr), p.getY(ctr))) continue;
            result = false;
            break;
        }
        return result;
    }

    public abstract Polygon2D copy();

    @Override
    public boolean contains(double x1, double y1, double w, double h) {
        double x2 = x1 + w;
        double y2 = y1 + h;
        return this.contains(x1, y1) && this.contains(x1, y2) && this.contains(x2, y1) && this.contains(x2, y2);
    }

    public double getArea() {
        return Polygon2D.area(this);
    }

    @Override
    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    @Override
    public abstract Rectangle2D getBounds2D();

    public abstract GeoRectangle getBoundsGeo();

    public abstract Point2D getCentroid();

    public double distanceSq(Point2D p) {
        double resultSq = java.lang.Double.POSITIVE_INFINITY;
        double tempDistSq = 0.0;
        if (this.getVertexCount() <= 0) {
            throw new IllegalStateException("No vertices set");
        }
        if (this.getVertexCount() == 1) {
            resultSq = p.distanceSq(this.getX(0), this.getY(0));
        } else {
            if (this.contains(p)) {
                return 0.0;
            }
            for (int ctr = 0; ctr < this.getVertexCount() - 1; ++ctr) {
                tempDistSq = Line2D.ptSegDistSq(this.getX(ctr), this.getY(ctr), this.getX(ctr + 1), this.getY(ctr + 1), p.getX(), p.getY());
                if (!(tempDistSq < resultSq)) continue;
                resultSq = tempDistSq;
            }
            tempDistSq = Line2D.ptSegDistSq(this.getX(0), this.getY(0), this.getX(this.getVertexCount() - 1), this.getY(this.getVertexCount() - 1), p.getX(), p.getY());
            if (tempDistSq < resultSq) {
                resultSq = tempDistSq;
            }
        }
        return resultSq;
    }

    public double distance(Point2D p) {
        return Math.sqrt(this.distanceSq(p));
    }

    public abstract double[] getXCoords();

    public abstract double[] getYCoords();

    public abstract List<Point2D> getVertices();

    public double getMinX() {
        double min = java.lang.Double.POSITIVE_INFINITY;
        int count = this.getVertexCount();
        for (int ctr = 0; ctr < count; ++ctr) {
            min = Math.min(min, this.getX(ctr));
        }
        return min;
    }

    public double getMinY() {
        double min = java.lang.Double.POSITIVE_INFINITY;
        int count = this.getVertexCount();
        for (int ctr = 0; ctr < count; ++ctr) {
            min = Math.min(min, this.getY(ctr));
        }
        return min;
    }

    public double getMaxX() {
        double max = java.lang.Double.NEGATIVE_INFINITY;
        int count = this.getVertexCount();
        for (int ctr = 0; ctr < count; ++ctr) {
            max = Math.max(max, this.getX(ctr));
        }
        return max;
    }

    public double getMaxY() {
        double max = java.lang.Double.NEGATIVE_INFINITY;
        int count = this.getVertexCount();
        for (int ctr = 0; ctr < count; ++ctr) {
            max = Math.max(max, this.getY(ctr));
        }
        return max;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new PolygonIterator(this, at);
    }

    public int getVertexCount() {
        return (int)((double)this._coordCount * 0.5);
    }

    public abstract double getX(int var1);

    public abstract double getY(int var1);

    public boolean intersects(Point2D e0, Point2D e1) {
        double p3y;
        double p3x;
        double p2y;
        double p2x;
        int count = this.getVertexCount();
        if (count == 0) {
            return false;
        }
        if (count == 1) {
            return Polygon2D.lineIntersectsPoint(e0.getX(), e0.getY(), e1.getX(), e1.getY(), this.getX(0), this.getY(0));
        }
        double p0x = e0.getX();
        double p0y = e0.getY();
        double p1x = e1.getX();
        double p1y = e1.getY();
        for (int i = 1; i < count; ++i) {
            p2x = this.getX(i - 1);
            if (!Line2D.linesIntersect(p0x, p0y, p1x, p1y, p2x, p2y = this.getY(i - 1), p3x = this.getX(i), p3y = this.getY(i))) continue;
            return true;
        }
        return count > 2 && Line2D.linesIntersect(p0x, p0y, p1x, p1y, p2x = this.getX(0), p2y = this.getY(0), p3x = this.getX(count - 1), p3y = this.getY(count - 1));
    }

    public boolean intersects(Polygon2D poly) {
        Point2D.Double p2;
        Point2D.Double p1;
        if (this == poly) {
            return true;
        }
        int countPoly1 = this.getVertexCount();
        int countPoly2 = poly.getVertexCount();
        if (countPoly1 == 0 || countPoly2 == 0) {
            return false;
        }
        if (countPoly1 == 1) {
            return poly.intersects(new Point2D.Double(this.getX(0), this.getY(0)));
        }
        if (countPoly2 == 1) {
            return this.intersects(new Point2D.Double(poly.getX(0), poly.getY(0)));
        }
        Point2D c1 = this.getBoundsGeo().getBackingPolygon().getCentroid();
        Point2D c2 = poly.getBoundsGeo().getBackingPolygon().getCentroid();
        double r1 = c1.distance(this.getMinX(), this.getMinY());
        double r2 = c2.distance(poly.getMinX(), poly.getMinY());
        if (c1.distance(c2) > r1 + r2) {
            return false;
        }
        if (this.intersects(c2)) {
            return true;
        }
        if (poly.intersects(c1)) {
            return true;
        }
        for (int i = 1; i < countPoly2; ++i) {
            p1 = new Point2D.Double(poly.getX(i - 1), poly.getY(i - 1));
            if (!this.intersects(p1, p2 = new Point2D.Double(poly.getX(i), poly.getY(i)))) continue;
            return true;
        }
        return countPoly2 > 2 && this.intersects(p1 = new Point2D.Double(poly.getX(countPoly2 - 1), poly.getY(countPoly2 - 1)), p2 = new Point2D.Double(poly.getX(0), poly.getY(0)));
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean intersects(GeoRectangle r) {
        return this.intersects(r.getBackingPolygon());
    }

    @Override
    public boolean intersects(double x1, double y1, double w, double h) {
        int i;
        double x2 = x1 + w;
        double y2 = y1 + h;
        int count = this.getVertexCount();
        if (count == 0) {
            return false;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(x1, y1, w, h);
        if (!this.getBounds().intersects(rect)) {
            return false;
        }
        if (this.contains(x1, y1) || this.contains(x1, y2) || this.contains(x2, y1) || this.contains(x2, y2)) {
            return true;
        }
        for (i = 0; i < this.getVertexCount(); ++i) {
            if (!rect.contains(this.getX(i), this.getY(i))) continue;
            return true;
        }
        for (i = 1; i < count; ++i) {
            double vy2;
            double vx1 = this.getX(i - 1);
            double vx2 = this.getX(i);
            double vy1 = this.getY(i - 1);
            if (Line2D.linesIntersect(x1, y1, x1, y2, vx1, vy1, vx2, vy2 = this.getY(i))) {
                return true;
            }
            if (Line2D.linesIntersect(x1, y2, x2, y2, vx1, vy1, vx2, vy2)) {
                return true;
            }
            if (Line2D.linesIntersect(x2, y2, x2, y1, vx1, vy1, vx2, vy2)) {
                return true;
            }
            if (!Line2D.linesIntersect(x2, y1, x1, y1, vx1, vy1, vx2, vy2)) continue;
            return true;
        }
        if (count > 2) {
            double vy2;
            double vx1 = this.getX(count - 1);
            double vx2 = this.getX(0);
            double vy1 = this.getY(count - 1);
            if (Line2D.linesIntersect(x1, y1, x1, y2, vx1, vy1, vx2, vy2 = this.getY(0))) {
                return true;
            }
            if (Line2D.linesIntersect(x1, y2, x2, y2, vx1, vy1, vx2, vy2)) {
                return true;
            }
            if (Line2D.linesIntersect(x2, y2, x2, y1, vx1, vy1, vx2, vy2)) {
                return true;
            }
            if (Line2D.linesIntersect(x2, y1, x1, y1, vx1, vy1, vx2, vy2)) {
                return true;
            }
        }
        return false;
    }

    public boolean intersects(Point2D p) {
        if (this.contains(p)) {
            return true;
        }
        int count = this.getVertexCount();
        double p1x = p.getX();
        double p1y = p.getY();
        for (int i = 1; i < count; ++i) {
            if (!Polygon2D.lineIntersectsPoint(this.getX(i - 1), this.getY(i - 1), this.getX(i), this.getY(i), p1x, p1y)) continue;
            return true;
        }
        return count > 2 && Polygon2D.lineIntersectsPoint(this.getX(count - 1), this.getY(count - 1), this.getX(0), this.getY(0), p1x, p1y);
    }

    public void lineTo(Point2D p) {
        this.lineTo(p.getX(), p.getY());
    }

    public abstract void lineTo(double var1, double var3);

    public void moveTo(Point2D p) {
        this.moveTo(p.getX(), p.getY());
    }

    public abstract void moveTo(double var1, double var3);

    public void reset() {
        this._coordCount = 0;
        this._closed = false;
    }

    public abstract void setX(int var1, double var2);

    public abstract void setY(int var1, double var2);

    public abstract void transform(AffineTransform var1);

    public abstract void translate(double var1, double var3);

    public String toString() {
        String out = this.getClass().getName() + "[\n";
        for (int i = 0; i < this.getVertexCount(); ++i) {
            out = out + "\t" + this.getX(i) + ", " + this.getY(i) + "\n";
        }
        out = out + "]";
        return out;
    }

    public static class Double
    extends Polygon2D {
        double[] _coords;

        public Double() {
            this(1);
        }

        public Double(int size) {
            this._coords = new double[2 * size];
        }

        public Double(double[] coords) {
            this._coords = coords;
            this._coordCount = coords.length;
        }

        public Double(Point2D p) {
            this(p.getX(), p.getY());
        }

        public Double(double x, double y) {
            this(1);
            this._coords[0] = x;
            this._coords[1] = y;
            this._coordCount = 2;
        }

        public Double(double[] xlocs, double[] ylocs) {
            this();
            if (xlocs.length != ylocs.length) {
                return;
            }
            DoubleArrayList coords = new DoubleArrayList();
            for (int i = 0; i < xlocs.length; ++i) {
                if (!(!java.lang.Double.isNaN(xlocs[i]) & !java.lang.Double.isNaN(ylocs[i]))) continue;
                coords.add(xlocs[i]);
                coords.add(ylocs[i]);
            }
            coords.trimToSize();
            this._coords = coords.elements();
            this._coordCount = this._coords.length;
        }

        @Override
        public Double copy() {
            return new Double(this.getXCoords(), this.getYCoords());
        }

        @Override
        public Rectangle2D getBounds2D() {
            if (this._coordCount <= 0) {
                return new Rectangle2D.Double();
            }
            double x1 = this._coords[0];
            double y1 = this._coords[1];
            double x2 = x1;
            double y2 = y1;
            for (int i = 2; i < this._coordCount; ++i) {
                if (this._coords[i] < x1) {
                    x1 = this._coords[i];
                } else if (this._coords[i] > x2) {
                    x2 = this._coords[i];
                }
                ++i;
                if (this._coords[i] < y1) {
                    y1 = this._coords[i];
                    continue;
                }
                if (!(this._coords[i] > y2)) continue;
                y2 = this._coords[i];
            }
            return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
        }

        @Override
        public GeoRectangle.Double getBoundsGeo() {
            return new GeoRectangle.Double(this.getMinX(), this.getMinY(), this.getMaxX(), this.getMaxY());
        }

        @Override
        public Point2D getCentroid() {
            double px = 0.0;
            double py = 0.0;
            int vertexCount = this.getVertexCount();
            if (vertexCount >= 1) {
                for (int ctr = 0; ctr < vertexCount; ++ctr) {
                    px += this.getX(ctr);
                    py += this.getY(ctr);
                }
                px /= (double)vertexCount;
                py /= (double)vertexCount;
            }
            return new Point2D.Double(px, py);
        }

        @Override
        public List<Point2D> getVertices() {
            ArrayList<Point2D> ret = new ArrayList<Point2D>();
            for (int i = 0; i < this._coords.length; ++i) {
                ret.add(new Point2D.Double(this._coords[i++], this._coords[i]));
            }
            return ret;
        }

        @Override
        public double[] getXCoords() {
            DoubleArrayList ret = new DoubleArrayList();
            for (int i = 0; i < this._coords.length; i += 2) {
                ret.add(this._coords[i]);
            }
            ret.trimToSize();
            return ret.elements();
        }

        @Override
        public double[] getYCoords() {
            DoubleArrayList ret = new DoubleArrayList();
            for (int i = 1; i < this._coords.length; i += 2) {
                ret.add(this._coords[i]);
            }
            ret.trimToSize();
            return ret.elements();
        }

        @Override
        public double getX(int index) {
            return this._coords[index * 2];
        }

        @Override
        public double getY(int index) {
            return this._coords[index * 2 + 1];
        }

        @Override
        public void lineTo(double x, double y) {
            if (this._closed) {
                throw new UnsupportedOperationException("This polygon has already been closed");
            }
            if (this._coordCount == this._coords.length) {
                double[] temp = new double[this._coordCount + 2];
                System.arraycopy(this._coords, 0, temp, 0, this._coordCount);
                this._coords = temp;
            }
            this._coords[this._coordCount++] = x;
            this._coords[this._coordCount++] = y;
        }

        @Override
        public void moveTo(double x, double y) {
            if (this._coordCount > 0) {
                throw new UnsupportedOperationException("This polygon already has vertices");
            }
            this._coords[0] = x;
            this._coords[1] = y;
            this._coordCount = 2;
        }

        @Override
        public void setX(int index, double x) {
            this._coords[index * 2] = x;
        }

        @Override
        public void setY(int index, double y) {
            this._coords[index * 2 + 1] = y;
        }

        @Override
        public void transform(AffineTransform at) {
            at.transform(this._coords, 0, this._coords, 0, this._coordCount / 2);
        }

        @Override
        public void translate(double x, double y) {
            int i = 0;
            while (i < this._coordCount) {
                int n = i++;
                this._coords[n] = this._coords[n] + x;
                int n2 = i++;
                this._coords[n2] = this._coords[n2] + y;
            }
        }
    }

    public static class Float
    extends Polygon2D {
        float[] _coords;

        public Float() {
            this(1);
        }

        public Float(int size) {
            this._coords = new float[2 * size];
        }

        public Float(float[] coords) {
            this._coords = coords;
            this._coordCount = coords.length;
        }

        public Float(Point2D p) {
            this((float)p.getX(), (float)p.getY());
        }

        public Float(float x, float y) {
            this(1);
            this._coords[0] = x;
            this._coords[1] = y;
            this._coordCount = 2;
        }

        public Float(float[] xlocs, float[] ylocs) {
            this();
            if (xlocs.length != ylocs.length) {
                return;
            }
            FloatArrayList coords = new FloatArrayList();
            for (int i = 0; i < xlocs.length; ++i) {
                if (!(!java.lang.Float.isNaN(xlocs[i]) & !java.lang.Float.isNaN(ylocs[i]))) continue;
                coords.add(xlocs[i]);
                coords.add(ylocs[i]);
            }
            coords.trimToSize();
            this._coords = coords.elements();
            this._coordCount = this._coords.length;
        }

        @Override
        public Float copy() {
            return new Float(AsaArrayUtils.doubleArrayToFloatArray(this.getXCoords()), AsaArrayUtils.doubleArrayToFloatArray(this.getYCoords()));
        }

        @Override
        public Rectangle2D getBounds2D() {
            if (this._coordCount <= 1) {
                return new Rectangle2D.Float();
            }
            float x1 = this._coords[0];
            float y1 = this._coords[1];
            float x2 = x1;
            float y2 = y1;
            for (int i = 2; i < this._coordCount; ++i) {
                if (this._coords[i] < x1) {
                    x1 = this._coords[i];
                } else if (this._coords[i] > x2) {
                    x2 = this._coords[i];
                }
                ++i;
                if (this._coords[i] < y1) {
                    y1 = this._coords[i];
                    continue;
                }
                if (!(this._coords[i] > y2)) continue;
                y2 = this._coords[i];
            }
            return new Rectangle2D.Float(x1, y1, x2 - x1, y2 - y1);
        }

        @Override
        public GeoRectangle.Double getBoundsGeo() {
            return null;
        }

        @Override
        public Point2D getCentroid() {
            float px = 0.0f;
            float py = 0.0f;
            int vertexCount = this.getVertexCount();
            if (vertexCount >= 1) {
                for (int ctr = 0; ctr < vertexCount; ++ctr) {
                    px = (float)((double)px + this.getX(ctr));
                    py = (float)((double)py + this.getY(ctr));
                }
                px /= (float)vertexCount;
                py /= (float)vertexCount;
            }
            return new Point2D.Float(px, py);
        }

        @Override
        public List<Point2D> getVertices() {
            ArrayList<Point2D> ret = new ArrayList<Point2D>();
            for (int i = 0; i < this._coords.length; ++i) {
                ret.add(new Point2D.Float(this._coords[i++], this._coords[i]));
            }
            return ret;
        }

        @Override
        public double[] getXCoords() {
            DoubleArrayList ret = new DoubleArrayList();
            for (int i = 0; i < this._coords.length; i += 2) {
                ret.add((double)this._coords[i]);
            }
            ret.trimToSize();
            return ret.elements();
        }

        @Override
        public double[] getYCoords() {
            DoubleArrayList ret = new DoubleArrayList();
            for (int i = 1; i < this._coords.length; i += 2) {
                ret.add((double)this._coords[i]);
            }
            ret.trimToSize();
            return ret.elements();
        }

        @Override
        public double getX(int index) {
            return this._coords[index * 2];
        }

        @Override
        public double getY(int index) {
            return this._coords[index * 2 + 1];
        }

        @Override
        public void lineTo(double x, double y) {
            if (this._closed) {
                throw new UnsupportedOperationException("This polygon has already been closed");
            }
            if (this._coordCount == this._coords.length) {
                float[] temp = new float[this._coordCount + 2];
                System.arraycopy(this._coords, 0, temp, 0, this._coordCount);
                this._coords = temp;
            }
            this._coords[this._coordCount++] = (float)x;
            this._coords[this._coordCount++] = (float)y;
        }

        @Override
        public void moveTo(double x, double y) {
            if (this._coordCount > 0) {
                throw new UnsupportedOperationException("This polygon already has vertices");
            }
            this._coords[0] = (float)x;
            this._coords[1] = (float)y;
            this._coordCount = 2;
        }

        @Override
        public void setX(int index, double x) {
            this._coords[index * 2] = (float)x;
        }

        @Override
        public void setY(int index, double y) {
            this._coords[index * 2 + 1] = (float)y;
        }

        @Override
        public void transform(AffineTransform at) {
            at.transform(this._coords, 0, this._coords, 0, this._coordCount / 2);
        }

        @Override
        public void translate(double x, double y) {
            float fx = (float)x;
            float fy = (float)y;
            int i = 0;
            while (i < this._coordCount) {
                int n = i++;
                this._coords[n] = this._coords[n] + fx;
                int n2 = i++;
                this._coords[n2] = this._coords[n2] + fy;
            }
        }
    }
}

