/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.rtree;

import java.io.Serializable;
import ucar.nc2.dt.ugrid.geom.LatLonPolygon2D;
import ucar.nc2.dt.ugrid.geom.LatLonRectangle2D;
import ucar.nc2.dt.ugrid.rtree.RTree;

public class Node
implements Serializable {
    private static final long serialVersionUID = -8760796047443657871L;
    int nodeId = 0;
    LatLonRectangle2D mbr = null;
    LatLonPolygon2D[] entries = null;
    int[] ids = null;
    int level;
    int entryCount;
    public static long reorgTime = 0L;

    Node(int nodeId, int level, int maxNodeEntries) {
        this.nodeId = nodeId;
        this.level = level;
        this.entries = new LatLonPolygon2D[maxNodeEntries];
        this.ids = new int[maxNodeEntries];
    }

    void addEntryCopy(LatLonRectangle2D r, int id) {
        LatLonPolygon2D.Double p = new LatLonPolygon2D.Double(r);
        this.ids[this.entryCount] = id;
        this.entries[this.entryCount] = p;
        ++this.entryCount;
        this.mbr = this.mbr == null ? r.copy() : Node.expandMBR(this.mbr, r);
    }

    void addEntryCopy(LatLonPolygon2D p, int id) {
        this.ids[this.entryCount] = id;
        this.entries[this.entryCount] = p.copy();
        ++this.entryCount;
        this.mbr = this.mbr == null ? p.getBouningLatLonRectangle2D() : Node.expandMBR(this.mbr, p.getBoundingLatLonValues());
    }

    @Deprecated
    void addEntryNoCopy(LatLonRectangle2D r, int id) {
        LatLonPolygon2D.Double p = new LatLonPolygon2D.Double(r);
        this.ids[this.entryCount] = id;
        this.entries[this.entryCount] = p;
        ++this.entryCount;
        this.mbr = this.mbr == null ? r.copy() : Node.expandMBR(this.mbr, r);
    }

    void addEntryNoCopy(LatLonPolygon2D p, int id) {
        this.ids[this.entryCount] = id;
        this.entries[this.entryCount] = p;
        ++this.entryCount;
        this.mbr = this.mbr == null ? p.getBouningLatLonRectangle2D() : Node.expandMBR(this.mbr, p.getBoundingLatLonValues());
    }

    int findEntry(LatLonPolygon2D r, int id) {
        return -1;
    }

    void deleteEntry(int i, int minNodeEntries) {
        int lastIndex = this.entryCount - 1;
        LatLonPolygon2D deletedRectangle = this.entries[i];
        this.entries[i] = null;
        if (i != lastIndex) {
            this.entries[i] = this.entries[lastIndex];
            this.ids[i] = this.ids[lastIndex];
            this.entries[lastIndex] = null;
        }
        --this.entryCount;
        if (this.entryCount >= minNodeEntries) {
            this.recalculateMBR(deletedRectangle);
        }
    }

    void recalculateMBR(LatLonPolygon2D deletedRectangle) {
        throw new UnsupportedOperationException("Recalculate method not implemented");
    }

    public static LatLonRectangle2D expandMBR(LatLonRectangle2D mbr, LatLonPolygon2D poly) {
        mbr.extend(poly);
        return mbr;
    }

    public static LatLonRectangle2D expandMBR(LatLonRectangle2D mbr, LatLonRectangle2D rect) {
        mbr.extend(rect);
        return mbr;
    }

    public static LatLonRectangle2D expandMBR(LatLonRectangle2D mbr, double[] latLons) {
        mbr.extend(latLons);
        return mbr;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public LatLonPolygon2D getEntry(int index) {
        if (index < this.entryCount) {
            return this.entries[index];
        }
        return null;
    }

    public int getId(int index) {
        if (index < this.entryCount) {
            return this.ids[index];
        }
        return -1;
    }

    void reorganize(RTree rtree) {
        long curTime = System.currentTimeMillis();
        int countdownIndex = rtree.maxNodeEntries - 1;
        for (int index = 0; index < this.entryCount; ++index) {
            if (this.entries[index] != null) continue;
            while (this.entries[countdownIndex] == null && countdownIndex > index) {
                --countdownIndex;
            }
            this.entries[index] = this.entries[countdownIndex];
            this.ids[index] = this.ids[countdownIndex];
            this.entries[countdownIndex] = null;
        }
        reorgTime += System.currentTimeMillis() - curTime;
    }

    boolean isLeaf() {
        return this.level == 1;
    }

    public int getLevel() {
        return this.level;
    }

    public LatLonRectangle2D getMBR() {
        return this.mbr;
    }
}

