/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.ugrid.utils;

import cern.colt.list.FloatArrayList;
import cern.colt.map.OpenDoubleIntHashMap;

public class AsaArrayUtils {
    public static int[] lonQuadrantCounts(double[] array) {
        int one = 0;
        int two = 0;
        int three = 0;
        int four = 0;
        block6: for (int i = 0; i < array.length; ++i) {
            switch (AsaArrayUtils.lonQuadrant(array[i])) {
                case 1: {
                    ++one;
                    continue block6;
                }
                case 2: {
                    ++two;
                    continue block6;
                }
                case 3: {
                    ++three;
                    continue block6;
                }
                case 4: {
                    ++four;
                }
            }
        }
        return new int[]{one, two, three, four};
    }

    public static int lonQuadrant(double lon) {
        int ret = 1;
        if (lon >= 0.0 & lon < 90.0) {
            ret = 1;
        } else if (lon >= 90.0 & lon <= 180.0) {
            ret = 2;
        } else if (lon > -180.0 & lon <= -90.0) {
            ret = 3;
        } else if (lon > -90.0 & lon < 0.0) {
            ret = 4;
        }
        return ret;
    }

    public static double[] minMaxSigned(double[] array, boolean positive) {
        double max;
        double min;
        if (positive) {
            min = Double.POSITIVE_INFINITY;
            max = 0.0;
            for (int i = 0; i < array.length; ++i) {
                double val = array[i];
                if (!(val >= 0.0)) continue;
                min = val < min ? val : min;
                max = val > max ? val : max;
            }
        } else {
            min = 0.0;
            max = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < array.length; ++i) {
                double val = array[i];
                if (!(val <= 0.0)) continue;
                min = val < min ? val : min;
                max = val > max ? val : max;
            }
        }
        return new double[]{min, max};
    }

    public static double findNextLower(double[] array, double val) {
        double ret = array[0];
        double delta = Double.POSITIVE_INFINITY;
        val = Math.abs(val);
        for (int i = 0; i < array.length; ++i) {
            double d;
            double nv = array[i];
            if (!(nv < val) || !((d = Math.abs(nv) - val) > 0.0) || !(d < delta)) continue;
            delta = d;
            ret = nv;
        }
        return ret;
    }

    public static double findNextHigher(double[] array, double val) {
        double ret = array[0];
        double delta = Double.POSITIVE_INFINITY;
        val = Math.abs(val);
        for (int i = 0; i < array.length; ++i) {
            double d;
            double nv = array[i];
            if (!(nv > val) || !((d = Math.abs(nv) - val) > 0.0) || !(d < delta)) continue;
            delta = d;
            ret = nv;
        }
        return ret;
    }

    public static double[] leftRightLongitude(double[] array) {
        double right;
        double[] ret = null;
        double[] mm = AsaArrayUtils.minMax(array);
        double left = mm[0];
        if (left >= 0.0 & (right = mm[1]) >= 0.0 || left < 0.0 & right < 0.0) {
            ret = mm;
        } else {
            int four;
            int three;
            int two;
            int[] counts = AsaArrayUtils.lonQuadrantCounts(array);
            double[] pmm = AsaArrayUtils.minMaxSigned(array, true);
            double[] nmm = AsaArrayUtils.minMaxSigned(array, false);
            int one = counts[0];
            if (one > 0 & (two = counts[1]) > 0 & (three = counts[2]) > 0 & (four = counts[3]) > 0) {
                if (two > one & three > four) {
                    left = pmm[0];
                    right = nmm[1];
                } else if (!(two < one & three < four)) {
                    if (four < one & four < two & four < three) {
                        left = nmm[1];
                        right = AsaArrayUtils.findNextLower(array, left);
                    } else {
                        left = -180.0;
                        right = 180.0;
                    }
                }
            } else if (two > 0 & three > 0) {
                left = pmm[0];
                right = nmm[1];
            }
            ret = new double[]{left, right};
        }
        return ret;
    }

    public static double[] minMax(double[] array) {
        return AsaArrayUtils.minMax(array, Double.NaN);
    }

    public static double[] minMax(double[] array, double noDataValue) {
        double[] ret = null;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            double val = array[i];
            if (val == noDataValue) continue;
            min = val < min ? val : min;
            max = val > max ? val : max;
        }
        if (!Double.isInfinite(min) & !Double.isInfinite(max)) {
            ret = new double[]{min, max};
        }
        return ret;
    }

    public static double[] minMax(double[][] multi) {
        return AsaArrayUtils.minMax(multi, Double.NaN);
    }

    public static double[] minMax(double[][] multi, double noDataValue) {
        double[] ret = null;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < multi.length; ++i) {
            for (int j = 0; j < multi[i].length; ++j) {
                double val = multi[i][j];
                if (val == noDataValue) continue;
                min = val < min ? val : min;
                max = val > max ? val : max;
            }
        }
        if (!Double.isInfinite(min) & !Double.isInfinite(max)) {
            ret = new double[]{min, max};
        }
        return ret;
    }

    public static float[] minMax(float[] array) {
        return AsaArrayUtils.minMax(array, Float.NaN);
    }

    public static float[] minMax(float[] array, float noDataValue) {
        float[] ret = null;
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < array.length; ++i) {
            float val = array[i];
            if (val == noDataValue) continue;
            min = val < min ? val : min;
            max = val > max ? val : max;
        }
        if (!Float.isInfinite(min) & !Float.isInfinite(max)) {
            ret = new float[]{min, max};
        }
        return ret;
    }

    public static float[] minMax(float[][] multi) {
        return AsaArrayUtils.minMax(multi, Float.NaN);
    }

    public static float[] minMax(float[][] multi, float noDataValue) {
        float[] ret = null;
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < multi.length; ++i) {
            for (int j = 0; j < multi[i].length; ++j) {
                float val = multi[i][j];
                if (val == noDataValue) continue;
                min = val < min ? val : min;
                max = val > max ? val : max;
            }
        }
        if (!Float.isInfinite(min) & !Float.isInfinite(max)) {
            ret = new float[]{min, max};
        }
        return ret;
    }

    public static boolean isUniformInterval(int[] array) {
        boolean ret = true;
        if (array.length > 1) {
            int d0 = array[1] - array[0];
            for (int i = 2; i < array.length; ++i) {
                int d1 = array[i] - array[i - 1];
                if (d0 == d1) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static boolean isUniformInterval(long[] array) {
        boolean ret = true;
        if (array.length > 1) {
            long d0 = array[1] - array[0];
            for (int i = 2; i < array.length; ++i) {
                long d1 = array[i] - array[i - 1];
                if (d0 == d1) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static boolean isUniformInterval(float[] array) {
        boolean ret = true;
        if (array.length > 1) {
            float d0 = array[1] - array[0];
            for (int i = 2; i < array.length; ++i) {
                float d1 = array[i] - array[i - 1];
                if (d0 == d1) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static boolean isUniformInterval(double[] array) {
        boolean ret = true;
        if (array.length > 1) {
            double d0 = array[1] - array[0];
            for (int i = 2; i < array.length; ++i) {
                double d1 = array[i] - array[i - 1];
                if (d0 == d1) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    public static float[] swapDimensions(float[] original, int dim1, int dim2) {
        int d1;
        float[] orig = (float[])original.clone();
        float[] swap = new float[orig.length];
        float[][] temp = new float[dim2][dim1];
        int oi = 0;
        for (int d2 = 0; d2 < dim2; ++d2) {
            for (d1 = 0; d1 < dim1; ++d1) {
                temp[d2][d1] = orig[oi++];
            }
        }
        int si = 0;
        for (d1 = 0; d1 < dim1; ++d1) {
            for (int d2 = 0; d2 < dim2; ++d2) {
                swap[si++] = temp[d2][d1];
            }
        }
        return swap;
    }

    public static float[] calculateModes(float[] numbers, float fillVal) {
        OpenDoubleIntHashMap table = new OpenDoubleIntHashMap();
        FloatArrayList modes = new FloatArrayList();
        int max = 0;
        for (float n : numbers) {
            if (Float.isNaN(fillVal) ? Float.isNaN(n) : n == fillVal) continue;
            int frequency = 0;
            frequency = table.get((double)n);
            table.put((double)n, ++frequency);
            if (frequency > max) {
                max = frequency;
                modes.clear();
            }
            if (frequency < max) continue;
            modes.add(n);
        }
        modes.trimToSize();
        return modes.elements();
    }

    public static int closestPrevious(Long[] myArray, long checkVal, long tolerance) {
        for (int index = 0; index < myArray.length; ++index) {
            if (!(checkVal >= myArray[index] & checkVal < myArray[index] + tolerance)) continue;
            return index;
        }
        return -1;
    }

    public static float[] doubleArrayToFloatArray(double[] in) {
        float[] out = new float[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = Double.isNaN(in[i]) ? Float.NaN : (float)in[i];
        }
        return out;
    }

    public static float[][] doubleArrayToFloatArray(double[][] in) {
        float[][] out = new float[in.length][];
        for (int i = 0; i < in.length; ++i) {
            out[i] = AsaArrayUtils.doubleArrayToFloatArray(in[i]);
        }
        return out;
    }

    public static double[] floatArrayToDoubleArray(float[] in) {
        double[] out = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = Float.isNaN(in[i]) ? Double.NaN : (double)in[i];
        }
        return out;
    }

    public static double[][] floatArrayToDoubleArray(float[][] in) {
        double[][] out = new double[in.length][];
        for (int i = 0; i < in.length; ++i) {
            out[i] = AsaArrayUtils.floatArrayToDoubleArray(in[i]);
        }
        return out;
    }

    public static float[] getSubsetArrayFloat(float[] in, int start, int skip) {
        FloatArrayList out = new FloatArrayList();
        for (int i = start; i < in.length; i += skip) {
            out.add(in[i]);
        }
        return out.elements();
    }
}

