/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.cdmremote;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Formatter;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractCommandController;
import org.springframework.web.servlet.mvc.LastModified;
import thredds.server.cdmremote.CdmRemoteQueryBean;
import thredds.server.config.TdsContext;
import thredds.servlet.DataRootHandler;
import thredds.servlet.DatasetHandler;
import thredds.servlet.ServletUtil;
import thredds.servlet.UsageLog;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.remote.PointStream;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamWriter;

public class PointStreamControllerOld
extends AbstractCommandController
implements LastModified {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private boolean debug = false;
    private String prefix = "/point";
    private TdsContext tdsContext;
    private boolean allow = true;

    public PointStreamControllerOld() {
        this.setCommandClass(CdmRemoteQueryBean.class);
        this.setCommandName("PointQueryBean");
    }

    public void setTdsContext(TdsContext tdsContext) {
        this.tdsContext = tdsContext;
    }

    public void setAllow(boolean allow) {
        this.allow = allow;
    }

    public long getLastModified(HttpServletRequest req) {
        File file = DataRootHandler.getInstance().getCrawlableDatasetAsFile(req.getPathInfo());
        if (file != null && file.exists()) {
            return file.lastModified();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handle(HttpServletRequest req, HttpServletResponse res, Object command, BindException errors) throws Exception {
        ModelAndView modelAndView;
        this.log.info(UsageLog.setupRequestContext(req));
        if (!this.allow) {
            res.sendError(403, "Service not supported");
            this.log.info(UsageLog.closingMessageForRequestContext(403, -1L));
            return null;
        }
        String pathInfo = req.getPathInfo();
        String path = pathInfo.substring(0, pathInfo.length() - this.prefix.length());
        if (this.debug) {
            System.out.printf("PointStreamController path= %s query= %s %n", path, req.getQueryString());
        }
        CdmRemoteQueryBean query = (CdmRemoteQueryBean)command;
        if (this.debug) {
            System.out.printf(" query= %s %n", query);
        }
        if (!query.validate()) {
            res.sendError(400, query.getErrorMessage());
            if (this.debug) {
                System.out.printf(" query error= %s %n", query.getErrorMessage());
            }
            this.log.info(UsageLog.closingMessageForRequestContext(400, -1L));
            return null;
        }
        String queryS = req.getQueryString();
        NetcdfDataset ncd = null;
        try {
            Formatter errlog;
            NetcdfFile ncfile = DatasetHandler.getNetcdfFile(req, res, path);
            if (ncfile == null) {
                res.setStatus(404);
                this.log.info(UsageLog.closingMessageForRequestContext(404, -1L));
                ModelAndView modelAndView2 = null;
                return modelAndView2;
            }
            ncd = NetcdfDataset.wrap((NetcdfFile)ncfile, (Set)NetcdfDataset.getEnhanceAll());
            FeatureDatasetPoint fd = (FeatureDatasetPoint)FeatureDatasetFactoryManager.wrap((FeatureType)FeatureType.POINT, (NetcdfDataset)ncd, null, (Formatter)(errlog = new Formatter()));
            if (fd == null) {
                res.sendError(400, errlog.toString());
                this.log.info(UsageLog.closingMessageForRequestContext(400, -1L));
                ModelAndView ioe = null;
                return ioe;
            }
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)res.getOutputStream(), 10000);
            if (queryS == null) {
                res.setContentType("text/plain");
                Formatter f = new Formatter(out);
                fd.getDetailInfo(f);
                f.flush();
                ((OutputStream)out).flush();
            } else if (queryS.equalsIgnoreCase("getCapabilities")) {
                res.flushBuffer();
                ((OutputStream)out).flush();
            } else {
                res.setContentType("application/octet-stream");
                res.setHeader("Content-Description", "ncstream");
                NcStreamWriter ncWriter = new NcStreamWriter((NetcdfFile)ncd, ServletUtil.getRequestBase(req));
                WritableByteChannel wbc = Channels.newChannel(out);
                ncWriter.sendHeader(wbc);
                NcStream.writeVInt((OutputStream)out, (int)0);
                ((OutputStream)out).flush();
                res.flushBuffer();
            }
        }
        catch (FileNotFoundException e) {
            this.log.info(UsageLog.closingMessageForRequestContext(404, 0L));
            res.sendError(404, e.getMessage());
            modelAndView = null;
            return modelAndView;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.info(UsageLog.closingMessageForRequestContext(500, 0L));
            res.sendError(500, e.getMessage());
            modelAndView = null;
            return modelAndView;
        }
        finally {
            if (null != ncd) {
                try {
                    ncd.close();
                }
                catch (IOException ioe) {
                    this.log.error("Failed to close = " + path);
                }
            }
        }
        this.log.info(UsageLog.closingMessageForRequestContext(200, -1L));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendData(String location, PointFeatureCollection pfc, OutputStream out) throws IOException {
        int count = 0;
        PointFeatureIterator pfIter = pfc.getPointFeatureIterator(-1);
        try {
            while (pfIter.hasNext()) {
                byte[] b;
                PointFeature pf = pfIter.next();
                if (count == 0) {
                    PointStreamProto.PointFeatureCollection proto = PointStream.encodePointFeatureCollection((String)location, (PointFeature)pf);
                    b = proto.toByteArray();
                    NcStream.writeVInt((OutputStream)out, (int)b.length);
                    out.write(b);
                }
                PointStreamProto.PointFeature pfp = PointStream.encodePointFeature((PointFeature)pf);
                b = pfp.toByteArray();
                NcStream.writeVInt((OutputStream)out, (int)b.length);
                out.write(b);
                ++count;
            }
        }
        finally {
            pfIter.finish();
        }
        if (this.debug) {
            System.out.printf(" sent %d features to %s %n ", count, location);
        }
    }
}

