/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.controller;

import java.io.File;
import thredds.servlet.ServletUtil;
import thredds.servlet.ThreddsConfig;
import thredds.servlet.UsageLog;
import ucar.nc2.util.DiskCache2;

public final class NcssDiskCache {
    private DiskCache2 diskCache = null;
    private static NcssDiskCache INSTANCE;

    private NcssDiskCache() {
        String cache = ThreddsConfig.get("NetcdfSubsetService.dir", ServletUtil.getContentPath() + "/cache/ncss");
        File cacheDir = new File(cache);
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            ServletUtil.logServerStartup.error("Cant make cache directory " + cache);
            throw new IllegalArgumentException("Cant make cache directory " + cache);
        }
        int scourSecs = ThreddsConfig.getSeconds("NetcdfSubsetService.scour", 600);
        int maxAgeSecs = ThreddsConfig.getSeconds("NetcdfSubsetService.maxAge", -1);
        maxAgeSecs = Math.max(maxAgeSecs, 300);
        scourSecs = Math.max(scourSecs, 300);
        this.diskCache = new DiskCache2(cache, false, maxAgeSecs / 60, scourSecs / 60);
        ServletUtil.logServerStartup.info(this.getClass().getName() + "Ncss.Cache= " + cache + " scour = " + scourSecs + " maxAgeSecs = " + maxAgeSecs);
        ServletUtil.logServerStartup.info(this.getClass().getName() + " initialization done -  " + UsageLog.closingMessageNonRequestContext());
    }

    public DiskCache2 getDiskCache() {
        return this.diskCache;
    }

    public static NcssDiskCache getInstance() {
        if (INSTANCE == null) {
            return new NcssDiskCache();
        }
        return INSTANCE;
    }
}

