/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.dataservice;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextResource;
import thredds.server.ncSubset.dataservice.NcssShowDatasetInfo;
import thredds.servlet.UsageLog;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.grid.GridDatasetInfo;

@Service
public class NcssShowDatasetInfoImpl
implements NcssShowDatasetInfo,
ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(NcssShowDatasetInfoImpl.class);
    private ServletContext servletContext;

    @Override
    public String showForm(GridDataset gds, String datsetUrlPath, boolean wantXml, boolean isPoint) {
        String infoString = null;
        GridDatasetInfo writer = new GridDatasetInfo(gds, "path");
        if (wantXml) {
            infoString = writer.writeXML(writer.makeDatasetDescription());
        } else {
            try {
                InputStream xslt = this.getXSLT(isPoint ? "/WEB-INF/xsl/ncssGridAsPoint.xsl" : "/WEB-INF/xsl/ncssGrid.xsl");
                Document doc = writer.makeGridForm();
                Element root = doc.getRootElement();
                root.setAttribute("location", datsetUrlPath);
                XSLTransformer transformer = new XSLTransformer(xslt);
                Document html = transformer.transform(doc);
                XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
                infoString = fmt.outputString(html);
            }
            catch (IOException ioe) {
                log.error("IO error opening xsl", (Throwable)ioe);
                log.info(UsageLog.closingMessageForRequestContext(500, 0L));
            }
            catch (Throwable e) {
                log.error("ForecastModelRunServlet internal error", e);
                log.info(UsageLog.closingMessageForRequestContext(500, 0L));
            }
        }
        return infoString;
    }

    private InputStream getXSLT(String xslName) throws IOException {
        ServletContextResource r = new ServletContextResource(this.servletContext, xslName);
        return r.getInputStream();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

