/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.util;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import thredds.server.config.TdsContext;
import thredds.server.ncSubset.exception.OutOfBoundariesException;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridAsPointDataset;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;

@Component
public final class NcssRequestUtils
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    private NcssRequestUtils() {
    }

    public static GridAsPointDataset buildGridAsPointDataset(GridDataset gds, List<String> vars) {
        ArrayList<GridDatatype> grids = new ArrayList<GridDatatype>();
        for (String gridName : vars) {
            GridDatatype grid = gds.findGridDatatype(gridName);
            if (grid == null) continue;
            grids.add(grid);
        }
        return new GridAsPointDataset(grids);
    }

    public static List<String> getAllVarsAsList(GridDataset gds) {
        ArrayList<String> vars = new ArrayList<String>();
        List allVars = gds.getDataVariables();
        for (VariableSimpleIF var : allVars) {
            vars.add(var.getShortName());
        }
        return vars;
    }

    public static List<CalendarDate> wantedDates(GridAsPointDataset gap, CalendarDateRange dates) throws OutOfBoundariesException {
        CalendarDate start = dates.getStart();
        CalendarDate end = dates.getEnd();
        List gdsDates = gap.getDates();
        if (start.isAfter((CalendarDate)gdsDates.get(gdsDates.size() - 1)) || end.isBefore((CalendarDate)gdsDates.get(0))) {
            throw new OutOfBoundariesException("Requested time range does not intersect the Data Time Range = " + gdsDates.get(0) + " to " + gdsDates.get(gdsDates.size() - 1));
        }
        ArrayList<CalendarDate> wantDates = new ArrayList<CalendarDate>();
        if (dates.isPoint()) {
            int best_index = 0;
            long best_diff = Long.MAX_VALUE;
            for (int i = 0; i < gdsDates.size(); ++i) {
                CalendarDate date = (CalendarDate)gdsDates.get(i);
                long diff = Math.abs(date.getDifferenceInMsecs(start));
                if (diff >= best_diff) continue;
                best_index = i;
                best_diff = diff;
            }
            wantDates.add((CalendarDate)gdsDates.get(best_index));
        } else {
            for (CalendarDate date : gdsDates) {
                if (date.isBefore(start) || date.isAfter(end)) continue;
                wantDates.add(date);
            }
        }
        return wantDates;
    }

    public static List<VariableSimpleIF> wantedVars2VariableSimple(List<String> wantedVars, GridDataset gds, NetcdfDataset ncfile) {
        ArrayList<VariableSimpleIF> varList = new ArrayList<VariableSimpleIF>(wantedVars.size());
        for (String var : wantedVars) {
            VariableDS ve = gds.findGridDatatype(var).getVariable();
            String dims = "";
            VariableDS want = new VariableDS(ncfile, null, null, ve.getShortName(), ve.getDataType(), dims, ve.getUnitsString(), ve.getDescription());
            varList.add((VariableSimpleIF)want);
        }
        return varList;
    }

    public static Double getTimeCoordValue(GridDatatype grid, CalendarDate date) {
        CoordinateAxis1DTime tAxis = grid.getCoordinateSystem().getTimeAxis1D();
        Integer wIndex = tAxis.findTimeIndexFromCalendarDate(date);
        Double coordVal = tAxis.getCoordValue(wIndex.intValue());
        return coordVal;
    }

    public static Double getTargetLevelForVertCoord(CoordinateAxis1D zAxis, Double vertLevel) {
        Double targetLevel = vertLevel;
        int coordLevel = 0;
        if (zAxis.getSize() == 1L) {
            targetLevel = 0.0;
        } else {
            coordLevel = zAxis.findCoordElement(vertLevel.doubleValue());
            if (coordLevel > 0) {
                targetLevel = zAxis.getCoordValue(coordLevel);
            }
        }
        return targetLevel;
    }

    public static TdsContext getTdsContext() {
        return (TdsContext)applicationContext.getBean(TdsContext.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        NcssRequestUtils.applicationContext = applicationContext;
    }
}

