/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.ncSubset.view;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import thredds.server.ncSubset.controller.SupportedFormat;
import thredds.server.ncSubset.exception.DateUnitException;
import thredds.server.ncSubset.exception.UnsupportedOperationException;
import thredds.server.ncSubset.view.AbstractPointDataWriterFactory;
import thredds.server.ncSubset.view.PointDataWriter;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPoint;

public final class PointDataStream {
    private static Logger log = LoggerFactory.getLogger(PointDataStream.class);
    private final PointDataWriter pointDataWriter;

    private PointDataStream(SupportedFormat supportedFormat, OutputStream outputStream) {
        this.pointDataWriter = AbstractPointDataWriterFactory.createPointDataWriterFactory(supportedFormat).createPointDataWriter(outputStream);
    }

    public final boolean stream(GridDataset gds, LatLonPoint point, List<CalendarDate> wDates, Map<String, List<String>> groupedVars, Double vertCoord) throws DateUnitException, UnsupportedOperationException {
        boolean allDone = false;
        ArrayList vars = new ArrayList();
        ArrayList<String> keys = new ArrayList<String>(groupedVars.keySet());
        for (String key : keys) {
            vars.addAll(groupedVars.get(key));
        }
        if (groupedVars.size() > 1) {
            throw new UnsupportedOperationException("The variables requested: " + vars + " have different vertical levels. Only requests on variables with same vertical levels are supported.");
        }
        GridDatatype gridForTimeUnits = gds.findGridDatatype((String)vars.get(0));
        if (this.pointDataWriter.header(groupedVars, gds, wDates, this.getDateUnit(gridForTimeUnits), point)) {
            Iterator<CalendarDate> it = wDates.iterator();
            boolean pointRead = true;
            while (pointRead && it.hasNext()) {
                CalendarDate date = it.next();
                pointRead = this.pointDataWriter.write(groupedVars, gds, date, point, vertCoord);
            }
            allDone = this.pointDataWriter.trailer() && pointRead;
        }
        return allDone;
    }

    private DateUnit getDateUnit(GridDatatype grid) throws DateUnitException {
        String timeUnitString = grid.getCoordinateSystem().getTimeAxis().getUnitsString();
        DateUnit du = null;
        try {
            du = new DateUnit(timeUnitString);
        }
        catch (Exception e) {
            throw new DateUnitException("Error creating DateUnits for station", e);
        }
        return du;
    }

    public final HttpHeaders getHttpHeaders() {
        return this.pointDataWriter.getResponseHeaders();
    }

    public static final PointDataStream createPointDataStream(SupportedFormat supportedFormat, OutputStream outputStream) {
        return new PointDataStream(supportedFormat, outputStream);
    }
}

